/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class RunNetBeansMojo
extends AbstractMojo {
    protected File clusterBuildDir;
    protected File netbeansInstallation;
    protected File netbeansUserdir;
    protected String additionalArguments;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File exec;
        this.netbeansUserdir.mkdirs();
        ArrayList<File> clusters = new ArrayList<File>();
        if (!this.clusterBuildDir.exists() || this.clusterBuildDir.listFiles() == null) {
            throw new MojoExecutionException("No clusters to include in execution found. Please run the nbm:cluster or nbm:cluster-app goals before this one.");
        }
        File[] fls = this.clusterBuildDir.listFiles();
        for (int i = 0; i < fls.length; ++i) {
            if (!fls[i].isDirectory()) continue;
            clusters.add(fls[i]);
        }
        StringBuffer buff = new StringBuffer();
        buff.append("netbeans_extraclusters=\"");
        for (File cluster : clusters) {
            buff.append(cluster.getAbsolutePath());
            buff.append(":");
        }
        if (buff.lastIndexOf(":") > -1) {
            buff.deleteCharAt(buff.lastIndexOf(":"));
        }
        buff.append("\"");
        StringReader sr = new StringReader(buff.toString());
        File etc = new File(this.netbeansUserdir, "etc");
        etc.mkdirs();
        File confFile = new File(etc, "netbeans.conf");
        FileOutputStream conf = null;
        try {
            conf = new FileOutputStream(confFile);
            IOUtil.copy((Reader)sr, (OutputStream)conf);
        }
        catch (IOException ex) {
            try {
                throw new MojoExecutionException("Error writing " + confFile, (Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(conf);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)conf);
        boolean windows = Os.isFamily((String)"windows");
        Commandline cmdLine = new Commandline();
        if (windows) {
            exec = new File(this.netbeansInstallation, "bin\\nb.exe");
            if (!exec.exists()) {
                exec = new File(this.netbeansInstallation, "bin\\netbeans.exe");
            }
        } else {
            exec = new File(this.netbeansInstallation, "bin/netbeans");
        }
        cmdLine.setExecutable(exec.getAbsolutePath());
        try {
            String[] args = new String[]{"--userdir", Commandline.quoteArgument((String)this.netbeansUserdir.getAbsolutePath()), "-J-Dnetbeans.logger.console=true", "-J-ea"};
            cmdLine.addArguments(args);
            this.getLog().info((CharSequence)("Additional arguments=" + this.additionalArguments));
            cmdLine.addArguments(Commandline.translateCommandline((String)this.additionalArguments));
            for (int i = 0; i < cmdLine.getArguments().length; ++i) {
                this.getLog().info((CharSequence)("      " + cmdLine.getArguments()[i]));
            }
            this.getLog().info((CharSequence)("Executing: " + cmdLine.toString()));
            StreamConsumer out = new StreamConsumer(){

                public void consumeLine(String line) {
                    RunNetBeansMojo.this.getLog().info((CharSequence)line);
                }
            };
            CommandLineUtils.executeCommandLine((Commandline)cmdLine, (StreamConsumer)out, (StreamConsumer)out);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed executing NetBeans", e);
        }
    }
}

