/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.mojo.nbm.AbstractNbmMojo;

public class CreateClusterMojo
extends AbstractNbmMojo {
    protected File nbmBuildDir;
    private MavenProject project;
    private List reactorProjects;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Project antProject = this.registerNbmAntTasks();
        if (!this.nbmBuildDir.exists()) {
            this.nbmBuildDir.mkdirs();
        }
        if (this.reactorProjects != null && this.reactorProjects.size() > 0) {
            for (MavenProject proj : this.reactorProjects) {
                File nbmDir = new File(proj.getBasedir(), "target" + File.separator + "nbm" + File.separator + "netbeans");
                if (nbmDir.exists()) {
                    Copy copyTask = (Copy)antProject.createTask("copy");
                    copyTask.setTodir(this.nbmBuildDir);
                    copyTask.setOverwrite(true);
                    FileSet set = new FileSet();
                    set.setDir(nbmDir);
                    set.createInclude().setName("**");
                    copyTask.addFileset(set);
                    try {
                        copyTask.execute();
                        continue;
                    }
                    catch (BuildException ex) {
                        this.getLog().error((CharSequence)"Cannot merge modules into cluster");
                        throw new MojoExecutionException("Cannot merge modules into cluster", (Exception)((Object)ex));
                    }
                }
                if (!"nbm".equals(proj.getPackaging())) continue;
                String error = "The NetBeans binary directory structure for " + proj.getId() + " is not created yet." + "\n Please execute 'mvn install nbm:cluster' to build all relevant projects in the reactor.";
                throw new MojoFailureException(error);
            }
            File[] files = this.nbmBuildDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                File stamp = new File(files[i], ".lastModified");
                if (!stamp.exists()) {
                    try {
                        stamp.createNewFile();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                stamp.setLastModified(new Date().getTime());
            }
        } else {
            throw new MojoExecutionException("This goal only makes sense on reactor projects.");
        }
        this.getLog().info((CharSequence)("Created NetBeans module cluster(s) at " + this.nbmBuildDir));
    }
}

