/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.mojo.nbm.AbstractNbmMojo;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class CreateClusterAppMojo
extends AbstractNbmMojo {
    private File outputDirectory;
    private MavenProject project;
    protected String brandingToken;
    private File etcConfFile;
    private File etcClustersFile;
    private File binDirectory;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    protected ArtifactRepository localRepository;
    private static final Pattern patt = Pattern.compile(".*targetcluster=\"([a-zA-Z0-9_\\.\\-]+)\".*", 32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        File nbmBuildDirFile = new File(this.outputDirectory, this.brandingToken);
        if (!nbmBuildDirFile.exists()) {
            nbmBuildDirFile.mkdirs();
        }
        if ("nbm-application".equals(this.project.getPackaging())) {
            HashSet<String> knownClusters = new HashSet<String>();
            Set artifacts = this.project.getArtifacts();
            for (Artifact art : artifacts) {
                Artifact nbmArt = this.turnJarToNbmFile(art, this.artifactFactory, this.artifactResolver, this.project, this.localRepository);
                if (nbmArt != null) {
                    art = nbmArt;
                }
                if (!art.getType().equals("nbm-file")) continue;
                ZipFile jf = null;
                try {
                    jf = new JarFile(art.getFile());
                    String cluster = this.findCluster((JarFile)jf);
                    if (!knownClusters.contains(cluster)) {
                        this.getLog().info((CharSequence)("Processing cluster '" + cluster + "'"));
                        knownClusters.add(cluster);
                    }
                    File clusterFile = new File(nbmBuildDirFile, cluster);
                    boolean newer = false;
                    if (!clusterFile.exists()) {
                        clusterFile.mkdir();
                        newer = true;
                    } else {
                        File stamp = new File(clusterFile, ".lastModified");
                        if (stamp.lastModified() < art.getFile().lastModified()) {
                            newer = true;
                        }
                    }
                    if (!newer) continue;
                    this.getLog().debug((CharSequence)("Copying " + art.getId() + " to cluster " + cluster));
                    Enumeration<JarEntry> enu = ((JarFile)jf).entries();
                    while (enu.hasMoreElements()) {
                        ZipEntry ent = enu.nextElement();
                        String name = ent.getName();
                        if (!name.startsWith("netbeans/")) continue;
                        String path = name.replace("netbeans/", cluster + "/");
                        File fl = new File(nbmBuildDirFile, path.replace("/", File.separator));
                        if (ent.isDirectory()) {
                            fl.mkdirs();
                            continue;
                        }
                        fl.getParentFile().mkdirs();
                        fl.createNewFile();
                        BufferedOutputStream outstream = null;
                        try {
                            outstream = new BufferedOutputStream(new FileOutputStream(fl));
                            InputStream instream = ((JarFile)jf).getInputStream(ent);
                            IOUtil.copy((InputStream)instream, (OutputStream)outstream);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(outstream);
                            throw throwable;
                        }
                        IOUtil.close((OutputStream)outstream);
                    }
                }
                catch (IOException ex) {
                    this.getLog().error((Throwable)ex);
                }
                finally {
                    try {
                        jf.close();
                    }
                    catch (IOException ex) {
                        this.getLog().error((Throwable)ex);
                    }
                }
            }
        } else {
            throw new MojoExecutionException("This goal only makes sense on project with nbm-application packaging");
        }
        this.getLog().info((CharSequence)("Created NetBeans module cluster(s) at " + nbmBuildDirFile.getAbsoluteFile()));
        File[] files = nbmBuildDirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            File stamp = new File(files[i], ".lastModified");
            if (!stamp.exists()) {
                try {
                    stamp.createNewFile();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            stamp.setLastModified(new Date().getTime());
        }
        try {
            this.createBinEtcDir(nbmBuildDirFile, this.brandingToken);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot process etc folder content creation.", (Exception)ex);
        }
    }

    private String findCluster(JarFile jf) throws MojoFailureException, IOException {
        ZipEntry entry = jf.getEntry("Info/info.xml");
        InputStream ins = jf.getInputStream(entry);
        String str = IOUtil.toString((InputStream)ins, (String)"UTF8");
        Matcher m = patt.matcher(str);
        if (m.matches()) {
            return m.group(1);
        }
        this.getLog().error((CharSequence)("Cannot find cluster for " + jf.getName()));
        return "extra";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBinEtcDir(File buildDir, String brandingToken) throws IOException, MojoExecutionException {
        String str;
        File etcDir;
        block19: {
            File confFile;
            block17: {
                File harnessDir;
                block18: {
                    String clustersString;
                    etcDir = new File(buildDir + File.separator + "etc");
                    etcDir.mkdir();
                    File clusterConf = new File(etcDir + File.separator + brandingToken + ".clusters");
                    if (this.etcClustersFile != null) {
                        clustersString = FileUtils.fileRead((File)this.etcClustersFile, (String)"UTF-8");
                    } else {
                        File[] clusters;
                        clusterConf.createNewFile();
                        StringBuffer buffer = new StringBuffer();
                        for (File cluster : clusters = buildDir.listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                return new File(pathname, ".lastModified").exists();
                            }
                        })) {
                            buffer.append(cluster.getName());
                            buffer.append("\n");
                        }
                        clustersString = buffer.toString();
                    }
                    FileUtils.fileWrite((String)clusterConf.getAbsolutePath(), (String)clustersString);
                    confFile = this.etcConfFile;
                    if (confFile != null) break block17;
                    harnessDir = new File(buildDir, "harness");
                    if (harnessDir.exists()) break block18;
                    this.getLog().debug((CharSequence)"Using fallback app.conf shipping with the nbm-maven-plugin.");
                    InputStream instream = null;
                    try {
                        instream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/app.conf");
                        str = IOUtil.toString((InputStream)instream, (String)"UTF-8");
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(instream);
                        throw throwable;
                    }
                    IOUtil.close((InputStream)instream);
                    break block19;
                }
                confFile = new File(harnessDir.getAbsolutePath() + File.separator + "etc" + File.separator + "app.conf");
                str = FileUtils.fileRead((File)confFile, (String)"UTF-8");
                break block19;
            }
            str = FileUtils.fileRead((File)confFile, (String)"UTF-8");
        }
        File confDestFile = new File(etcDir.getAbsolutePath() + File.separator + brandingToken + ".conf");
        str = str.replace("${APPNAME}", brandingToken);
        FileUtils.fileWrite((String)confDestFile.getAbsolutePath(), (String)"UTF-8", (String)str);
        File destBinDir = new File(buildDir + File.separator + "bin");
        destBinDir.mkdir();
        File destExeW = new File(destBinDir, brandingToken + "_w.exe");
        File destExe = new File(destBinDir, brandingToken + ".exe");
        File destSh = new File(destBinDir, brandingToken);
        if (this.binDirectory != null) {
            File binDir = this.binDirectory;
            File[] fls = binDir.listFiles();
            if (fls == null) {
                throw new MojoExecutionException("Parameter 'binDirectory' has to point to an existing folder.");
            }
            for (File fl : fls) {
                String name = fl.getName();
                File dest = null;
                if (name.endsWith("_w.exe")) {
                    dest = destExeW;
                } else if (name.endsWith(".exe")) {
                    dest = destExe;
                } else if (!name.contains(".") || name.endsWith(".sh")) {
                    dest = destSh;
                }
                if (dest == null || !fl.exists()) continue;
                FileUtils.copyFile((File)fl, (File)dest);
            }
        } else {
            File harnessDir = new File(buildDir, "harness");
            if (harnessDir.exists()) {
                File binDir = new File(harnessDir.getAbsolutePath() + File.separator + "launchers");
                File exe = new File(binDir, "app.exe");
                FileUtils.copyFile((File)exe, (File)destExe);
                File exew = new File(binDir, "app_w.exe");
                if (exew.exists()) {
                    FileUtils.copyFile((File)exew, (File)destExeW);
                }
                File sh = new File(binDir, "app.sh");
                FileUtils.copyFile((File)sh, (File)destSh);
            } else {
                this.getLog().debug((CharSequence)"Using fallback executables shipping with the nbm-maven-plugin. (from 6.5 NetBeans Platform)");
                this.writeFile("/launchers/app.sh", destSh);
                this.writeFile("/launchers/app.exe", destExe);
                this.writeFile("/launchers/app_w.exe", destExeW);
            }
        }
        Project antProject = new Project();
        antProject.init();
        Chmod chmod = (Chmod)antProject.createTask("chmod");
        FileSet fs = new FileSet();
        fs.setDir(destBinDir);
        fs.setIncludes("*");
        chmod.addFileset(fs);
        chmod.setPerm("755");
        chmod.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String path, File destSh) throws IOException {
        InputStream instream = null;
        BufferedOutputStream output = null;
        try {
            instream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
            destSh.createNewFile();
            output = new BufferedOutputStream(new FileOutputStream(destSh));
            IOUtil.copy((InputStream)instream, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtil.close(instream);
            IOUtil.close(output);
            throw throwable;
        }
        IOUtil.close((InputStream)instream);
        IOUtil.close((OutputStream)output);
    }
}

