/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.mojo.nbm.AbstractNbmMojo;
import org.codehaus.mojo.nbm.ExamineManifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectModuleLibrariesNodeVisitor
implements DependencyNodeVisitor {
    private final Map<String, List<Artifact>> directNodes;
    private final Map<String, List<Artifact>> transitiveNodes;
    private Map<String, Artifact> artifacts;
    private Map<Artifact, ExamineManifest> examinerCache;
    private final Log log;
    private MojoExecutionException throwable;
    private DependencyNode root;
    private Stack<String> currentModule = new Stack();

    public CollectModuleLibrariesNodeVisitor(List<Artifact> runtimeArtifacts, Map<Artifact, ExamineManifest> examinerCache, Log log, DependencyNode root) {
        this.directNodes = new HashMap<String, List<Artifact>>();
        this.transitiveNodes = new HashMap<String, List<Artifact>>();
        this.artifacts = new HashMap<String, Artifact>();
        for (Artifact a : runtimeArtifacts) {
            this.artifacts.put(a.getDependencyConflictId(), a);
        }
        this.examinerCache = examinerCache;
        this.log = log;
        this.root = root;
    }

    public boolean visit(DependencyNode node) {
        if (this.throwable != null) {
            return false;
        }
        if (this.root == node) {
            return true;
        }
        try {
            Artifact artifact = node.getArtifact();
            if (!this.artifacts.containsKey(artifact.getDependencyConflictId())) {
                return false;
            }
            if (node.getState() != 0) {
                return true;
            }
            ExamineManifest depExaminator = this.examinerCache.get(artifact = this.artifacts.get(artifact.getDependencyConflictId()));
            if (depExaminator == null) {
                depExaminator = new ExamineManifest(this.log);
                depExaminator.setJarFile(artifact.getFile());
                depExaminator.checkFile();
                this.examinerCache.put(artifact, depExaminator);
            }
            if (depExaminator.isNetbeansModule()) {
                this.currentModule.push(artifact.getDependencyConflictId());
                ArrayList<Artifact> arts = new ArrayList<Artifact>();
                arts.add(artifact);
                if (this.currentModule.size() == 1) {
                    this.directNodes.put(this.currentModule.peek(), arts);
                } else {
                    this.transitiveNodes.put(this.currentModule.peek(), arts);
                }
                return true;
            }
            if (this.currentModule.size() > 0 && AbstractNbmMojo.matchesLibrary(artifact, Collections.<String>emptyList(), depExaminator, this.log)) {
                if (this.currentModule.size() == 1) {
                    this.directNodes.get(this.currentModule.peek()).add(artifact);
                } else {
                    this.transitiveNodes.get(this.currentModule.peek()).add(artifact);
                }
                return true;
            }
        }
        catch (MojoExecutionException mojoExecutionException) {
            this.throwable = mojoExecutionException;
        }
        return false;
    }

    public boolean endVisit(DependencyNode node) {
        if (this.throwable != null) {
            return false;
        }
        if (!this.currentModule.empty() && this.currentModule.peek().equals(node.getArtifact().getDependencyConflictId())) {
            this.currentModule.pop();
        }
        return true;
    }

    public Map<String, List<Artifact>> getDeclaredArtifacts() throws MojoExecutionException {
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.directNodes;
    }

    public Map<String, List<Artifact>> getTransitiveArtifacts() throws MojoExecutionException {
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.transitiveNodes;
    }
}

