/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugins.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.Version;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlClassMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlModelHelpers {
    XmlModelHelpers() {
    }

    static String resolveTagName(ModelClass modelClass) {
        XmlClassMetadata xmlClassMetadata = (XmlClassMetadata)modelClass.getMetadata(XmlClassMetadata.ID);
        String tagName = xmlClassMetadata == null || xmlClassMetadata.getTagName() == null ? AbstractModelloGenerator.uncapitalise((String)modelClass.getName()) : xmlClassMetadata.getTagName();
        return tagName;
    }

    static String resolveTagName(ModelField modelField, XmlFieldMetadata xmlFieldMetadata) {
        String tagName = xmlFieldMetadata == null || xmlFieldMetadata.getTagName() == null ? modelField.getName() : xmlFieldMetadata.getTagName();
        return tagName;
    }

    static String resolveTagName(String fieldTagName, XmlAssociationMetadata xmlAssociationMetadata) {
        String tagName = xmlAssociationMetadata == null || xmlAssociationMetadata.getTagName() == null ? AbstractModelloGenerator.singular((String)fieldTagName) : xmlAssociationMetadata.getTagName();
        return tagName;
    }

    static ModelField getContentField(List<ModelField> modelFields) {
        if (modelFields == null) {
            return null;
        }
        for (ModelField field : modelFields) {
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (!xmlFieldMetadata.isContent()) continue;
            return field;
        }
        return null;
    }

    static List<ModelField> getXmlAttributeFields(List<ModelField> modelFields) {
        ArrayList<ModelField> xmlAttributeFields = new ArrayList<ModelField>();
        for (ModelField field : modelFields) {
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (!xmlFieldMetadata.isAttribute()) continue;
            xmlAttributeFields.add(field);
        }
        return xmlAttributeFields;
    }

    static List<ModelField> getFieldsForXml(ModelClass modelClass, Version version) {
        ArrayList<ModelClass> classes = new ArrayList<ModelClass>();
        while (modelClass != null) {
            classes.add(modelClass);
            String superClass = modelClass.getSuperClass();
            if (superClass != null) {
                modelClass = modelClass.getModel().getClass(superClass, version);
                continue;
            }
            modelClass = null;
        }
        ArrayList<Object> fields = new ArrayList<ModelField>();
        for (int i = classes.size() - 1; i >= 0; --i) {
            modelClass = (ModelClass)classes.get(i);
            Iterator parentIter = fields.iterator();
            fields = new ArrayList();
            for (ModelField field : modelClass.getFields(version)) {
                XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
                if (xmlFieldMetadata.isTransient()) continue;
                if (xmlFieldMetadata.getInsertParentFieldsUpTo() != null) {
                    boolean found = false;
                    while (!found && parentIter.hasNext()) {
                        ModelField parentField = (ModelField)parentIter.next();
                        fields.add(parentField);
                        found = parentField.getName().equals(xmlFieldMetadata.getInsertParentFieldsUpTo());
                    }
                    if (!found) {
                        throw new ModelloRuntimeException("parent field not found: class " + modelClass.getName() + " xml.insertParentFieldUpTo='" + xmlFieldMetadata.getInsertParentFieldsUpTo() + "'");
                    }
                }
                fields.add(field);
            }
            while (parentIter.hasNext()) {
                fields.add(parentIter.next());
            }
        }
        return fields;
    }
}

