/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.client.solrj.io.eval.RecursiveEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluatorException;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class RecursiveNumericEvaluator
extends RecursiveEvaluator {
    protected static final long serialVersionUID = 1L;

    public RecursiveNumericEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object normalizeInputType(Object value) throws StreamEvaluatorException {
        if (null == value) {
            return null;
        }
        if (value instanceof Double) {
            if (Double.isNaN((Double)value)) {
                return Double.NaN;
            }
            return new BigDecimal(value.toString());
        }
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(innerValue -> this.normalizeInputType(innerValue)).collect(Collectors.toList());
        }
        if (value.getClass().isArray()) {
            Stream<Object> stream = Stream.empty();
            if (value instanceof double[]) {
                stream = Arrays.stream((double[])value).boxed();
            } else if (value instanceof int[]) {
                stream = Arrays.stream((int[])value).boxed();
            } else if (value instanceof long[]) {
                stream = Arrays.stream((long[])value).boxed();
            } else if (value instanceof String[]) {
                stream = Arrays.stream((String[])value);
            }
            return stream.map(innerValue -> this.normalizeInputType(innerValue)).collect(Collectors.toList());
        }
        throw new StreamEvaluatorException("Numeric value expected but found type %s for value %s", value.getClass().getName(), value.toString());
    }
}

