/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.RegressionEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PredictEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public PredictEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (null == second) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (!(first instanceof RegressionEvaluator.RegressionTuple)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a RegressionTuple", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        if (!(second instanceof Number) && !(second instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a Number", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        RegressionEvaluator.RegressionTuple regressedTuple = (RegressionEvaluator.RegressionTuple)first;
        if (second instanceof Number) {
            return regressedTuple.predict(((Number)second).doubleValue());
        }
        return ((List)second).stream().map(value -> regressedTuple.predict(((Number)value).doubleValue())).collect(Collectors.toList());
    }
}

