/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CosineSimilarityEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public CosineSimilarityEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (null == second) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (!(first instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        if (!(second instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        double[] d1 = ((List)first).stream().mapToDouble(value -> ((BigDecimal)value).doubleValue()).toArray();
        double[] d2 = ((List)second).stream().mapToDouble(value -> ((BigDecimal)value).doubleValue()).toArray();
        return this.cosineSimilarity(d1, d2);
    }

    private double cosineSimilarity(double[] vectorA, double[] vectorB) {
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        for (int i = 0; i < vectorA.length; ++i) {
            dotProduct += vectorA[i] * vectorB[i];
            normA += Math.pow(vectorA[i], 2.0);
            normB += Math.pow(vectorB[i], 2.0);
        }
        return dotProduct / (Math.sqrt(normA) * Math.sqrt(normB));
    }
}

