/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;

public class ReplicaInfo
implements MapWriter {
    final String name;
    String core;
    String collection;
    String shard;
    Replica.Type type;
    Map<String, Object> variables;

    public ReplicaInfo(String name, String coll, String shard, Replica.Type type, Map<String, Object> vals) {
        this.name = name;
        this.variables = vals;
        this.collection = coll;
        this.shard = shard;
        this.type = type;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put(this.name, ew1 -> {
            if (this.variables != null) {
                for (Map.Entry<String, Object> e : this.variables.entrySet()) {
                    ew1.put(e.getKey(), e.getValue());
                }
            }
            if (this.type != null) {
                ew1.put("type", this.type.toString());
            }
        });
    }

    public String getCore() {
        return this.core;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getShard() {
        return this.shard;
    }
}

