/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.List;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;

class ReplicaCount
extends Number
implements MapWriter {
    long nrt;
    long tlog;
    long pull;

    ReplicaCount() {
    }

    public long total() {
        return this.nrt + this.tlog + this.pull;
    }

    @Override
    public int intValue() {
        return (int)this.total();
    }

    @Override
    public long longValue() {
        return this.total();
    }

    @Override
    public float floatValue() {
        return this.total();
    }

    @Override
    public double doubleValue() {
        return this.total();
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put(Replica.Type.NRT.name(), this.nrt);
        ew.put(Replica.Type.PULL.name(), this.pull);
        ew.put(Replica.Type.TLOG.name(), this.tlog);
        ew.put("count", this.total());
    }

    public Long getVal(Replica.Type type) {
        if (type == null) {
            return this.total();
        }
        switch (type) {
            case NRT: {
                return this.nrt;
            }
            case PULL: {
                return this.pull;
            }
            case TLOG: {
                return this.tlog;
            }
        }
        return this.total();
    }

    public void increment(List<ReplicaInfo> infos) {
        if (infos == null) {
            return;
        }
        block5: for (ReplicaInfo info : infos) {
            switch (info.type) {
                case NRT: {
                    ++this.nrt;
                    continue block5;
                }
                case PULL: {
                    ++this.pull;
                    continue block5;
                }
                case TLOG: {
                    ++this.tlog;
                    continue block5;
                }
            }
            ++this.nrt;
        }
    }
}

