/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.Objects;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;

public enum Operand {
    WILDCARD("#ANY", Integer.MAX_VALUE){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            return testVal == null ? Clause.TestStatus.NOT_APPLICABLE : Clause.TestStatus.PASS;
        }
    }
    ,
    EQUAL("", 0){

        @Override
        public long _delta(long expected, long actual) {
            return expected - actual;
        }
    }
    ,
    NOT_EQUAL("!", 2){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            return super.match(ruleVal, testVal) == Clause.TestStatus.PASS ? Clause.TestStatus.FAIL : Clause.TestStatus.PASS;
        }

        @Override
        public long _delta(long expected, long actual) {
            return expected - actual;
        }
    }
    ,
    GREATER_THAN(">", 1){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            if (testVal == null) {
                return Clause.TestStatus.NOT_APPLICABLE;
            }
            if (ruleVal instanceof String) {
                ruleVal = Clause.parseDouble("", ruleVal);
            }
            if (ruleVal instanceof Double) {
                return Double.compare(Clause.parseDouble("", testVal), (Double)ruleVal) == 1 ? Clause.TestStatus.PASS : Clause.TestStatus.FAIL;
            }
            return this.getLong(testVal) > this.getLong(ruleVal) ? Clause.TestStatus.PASS : Clause.TestStatus.FAIL;
        }

        @Override
        protected long _delta(long expected, long actual) {
            return actual > expected ? 0L : expected + 1L - actual;
        }
    }
    ,
    LESS_THAN("<", 2){

        @Override
        public Clause.TestStatus match(Object ruleVal, Object testVal) {
            if (testVal == null) {
                return Clause.TestStatus.NOT_APPLICABLE;
            }
            if (ruleVal instanceof String) {
                ruleVal = Clause.parseDouble("", ruleVal);
            }
            if (ruleVal instanceof Double) {
                return Double.compare(Clause.parseDouble("", testVal), (Double)ruleVal) == -1 ? Clause.TestStatus.PASS : Clause.TestStatus.FAIL;
            }
            return this.getLong(testVal) < this.getLong(ruleVal) ? Clause.TestStatus.PASS : Clause.TestStatus.FAIL;
        }

        @Override
        protected long _delta(long expected, long actual) {
            return actual < expected ? 0L : expected - actual;
        }
    };

    public final String operand;
    final int priority;

    private Operand(String val, int priority) {
        this.operand = val;
        this.priority = priority;
    }

    public Clause.TestStatus match(Object ruleVal, Object testVal) {
        return Objects.equals(ruleVal, testVal) ? Clause.TestStatus.PASS : Clause.TestStatus.FAIL;
    }

    Long getLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.parseLong(String.valueOf(o));
    }

    public Long delta(Object expected, Object actual) {
        try {
            Long expectedInt = (Long)Clause.validate("replica", expected, false);
            Long actualInt = (Long)Clause.validate("replica", actual, false);
            return this._delta(expectedInt, actualInt);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected long _delta(long expected, long actual) {
        return 0L;
    }
}

