/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.common.util.Pair;

public class MoveReplicaSuggester
extends Policy.Suggester {
    @Override
    SolrRequest init() {
        SolrRequest operation = this.tryEachNode(true);
        if (operation == null) {
            operation = this.tryEachNode(false);
        }
        return operation;
    }

    SolrRequest tryEachNode(boolean strict) {
        List<Clause.Violation> leastSeriousViolation = null;
        Integer targetNodeIndex = null;
        Integer sourceNodeIndex = null;
        ReplicaInfo sourceReplicaInfo = null;
        for (Pair<ReplicaInfo, Row> fromReplica : this.getValidReplicas(true, true, -1)) {
            Row fromRow = fromReplica.second();
            ReplicaInfo replicaInfo = fromReplica.first();
            String coll = replicaInfo.collection;
            String shard = replicaInfo.shard;
            Pair<Row, ReplicaInfo> pair = fromRow.removeReplica(coll, shard, replicaInfo.type);
            Row srcTmpRow = pair.first();
            if (srcTmpRow == null) continue;
            int i = this.getMatrix().indexOf(fromRow);
            for (int j = this.getMatrix().size() - 1; j > i; --j) {
                Row targetRow = this.getMatrix().get(j);
                if (!targetRow.isLive || !this.isAllowed(targetRow.node, Policy.Suggester.Hint.TARGET_NODE)) continue;
                targetRow = targetRow.addReplica(coll, shard, replicaInfo.type);
                List<Clause.Violation> errs = this.testChangedMatrix(strict, this.getModifiedMatrix(this.getModifiedMatrix(this.getMatrix(), srcTmpRow, i), targetRow, j));
                if (this.containsNewErrors(errs) || !this.isLessSerious(errs, leastSeriousViolation) || Policy.compareRows(srcTmpRow, targetRow, this.session.getPolicy()) >= 1) continue;
                leastSeriousViolation = errs;
                targetNodeIndex = j;
                sourceNodeIndex = i;
                sourceReplicaInfo = replicaInfo;
            }
        }
        if (targetNodeIndex != null && sourceNodeIndex != null) {
            this.getMatrix().set(sourceNodeIndex, this.getMatrix().get(sourceNodeIndex).removeReplica(sourceReplicaInfo.collection, sourceReplicaInfo.shard, sourceReplicaInfo.type).first());
            this.getMatrix().set(targetNodeIndex, this.getMatrix().get(targetNodeIndex).addReplica(sourceReplicaInfo.collection, sourceReplicaInfo.shard, sourceReplicaInfo.type));
            return new CollectionAdminRequest.MoveReplica(sourceReplicaInfo.collection, sourceReplicaInfo.name, this.getMatrix().get((int)targetNodeIndex.intValue()).node);
        }
        return null;
    }
}

