/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.api;

import java.text.ParseException;
import org.apache.maven.mercury.repository.api.RepositoryUpdatePolicy;
import org.apache.maven.mercury.util.TimeUtil;
import org.apache.maven.mercury.util.Util;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class RepositoryUpdateIntervalPolicy
implements RepositoryUpdatePolicy {
    private static final Language _lang = new DefaultLanguage(RepositoryUpdateIntervalPolicy.class);
    public static final String UPDATE_POLICY_NAME_NEVER = "never";
    public static final String UPDATE_POLICY_NAME_ALWAYS = "always";
    public static final String UPDATE_POLICY_NAME_DAILY = "daily";
    public static final String UPDATE_POLICY_NAME_INTERVAL = "interval";
    private static final int UPDATE_POLICY_INTERVAL_LENGTH = "interval".length();
    public static final String DEFAULT_UPDATE_POLICY = "daily";
    public static final RepositoryUpdateIntervalPolicy UPDATE_POLICY_NEVER = new RepositoryUpdateIntervalPolicy("never");
    public static final RepositoryUpdateIntervalPolicy UPDATE_POLICY_ALWAYS = new RepositoryUpdateIntervalPolicy("always");
    private static final long NEVER = -1L;
    private static final long DAYLY = 86400000L;
    protected long interval = 86400000L;

    public RepositoryUpdateIntervalPolicy() {
    }

    public RepositoryUpdateIntervalPolicy(String policy) {
        this.init(policy);
    }

    public RepositoryUpdateIntervalPolicy setInterval(long interval) {
        this.interval = interval;
        return this;
    }

    public void init(String policy) {
        if (Util.isEmpty((String)policy)) {
            throw new IllegalArgumentException(_lang.getMessage("empty.policy", new String[]{policy}));
        }
        if (policy.startsWith(UPDATE_POLICY_NAME_ALWAYS)) {
            this.interval = 0L;
        } else if (policy.startsWith("daily")) {
            this.interval = 86400000L;
        } else if (policy.startsWith(UPDATE_POLICY_NAME_NEVER)) {
            this.interval = -1L;
        } else if (policy.startsWith(UPDATE_POLICY_NAME_INTERVAL)) {
            int len = policy.length();
            if (len <= UPDATE_POLICY_INTERVAL_LENGTH) {
                throw new IllegalArgumentException(_lang.getMessage("bad.interval.policy", new String[]{policy}));
            }
            this.interval = (long)Integer.parseInt(policy.substring(len - 1)) * 60000L;
        } else {
            throw new IllegalArgumentException(_lang.getMessage("bad.policy", new String[]{policy}));
        }
    }

    public boolean timestampExpired(long lastUpdateMillis) {
        long now;
        if (this.interval == -1L) {
            return false;
        }
        try {
            now = TimeUtil.toMillis((String)TimeUtil.getUTCTimestamp());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        boolean res = now - lastUpdateMillis > this.interval;
        return res;
    }

    public static void main(String[] args) {
        RepositoryUpdateIntervalPolicy up = new RepositoryUpdateIntervalPolicy("interval2");
        System.out.println("Interval is " + up.interval);
    }
}

