/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.collections;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.facet.collections.FloatIterator;
import org.apache.lucene.facet.collections.IntIterator;

public class FloatToObjectMap<T>
implements Iterable<T> {
    private static int defaultCapacity = 16;
    int[] baseHash;
    private int capacity = 16;
    private int firstEmpty;
    private int hashFactor;
    float[] keys;
    int[] next;
    private int prev;
    private int size;
    Object[] values;

    public FloatToObjectMap() {
        this(defaultCapacity);
    }

    public FloatToObjectMap(int capacity) {
        while (this.capacity < capacity) {
            this.capacity <<= 1;
        }
        int arrayLength = this.capacity + 1;
        this.values = new Object[arrayLength];
        this.keys = new float[arrayLength];
        this.next = new int[arrayLength];
        int baseHashSize = this.capacity << 1;
        this.baseHash = new int[baseHashSize];
        this.hashFactor = baseHashSize - 1;
        this.size = 0;
        this.clear();
    }

    private void prvt_put(float key, T e) {
        int hashIndex = this.calcBaseHashIndex(key);
        int objectIndex = this.firstEmpty;
        this.firstEmpty = this.next[this.firstEmpty];
        this.values[objectIndex] = e;
        this.keys[objectIndex] = key;
        this.next[objectIndex] = this.baseHash[hashIndex];
        this.baseHash[hashIndex] = objectIndex;
        ++this.size;
    }

    protected int calcBaseHashIndex(float key) {
        return Float.floatToIntBits(key) & this.hashFactor;
    }

    public void clear() {
        Arrays.fill(this.baseHash, 0);
        this.size = 0;
        this.firstEmpty = 1;
        int i = 1;
        while (i < this.capacity) {
            this.next[i++] = i;
        }
        this.next[this.capacity] = 0;
    }

    public boolean containsKey(float key) {
        return this.find(key) != 0;
    }

    public boolean containsValue(Object o) {
        for (T object : this) {
            if (!object.equals(o)) continue;
            return true;
        }
        return false;
    }

    protected int find(float key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int localIndex = this.baseHash[baseHashIndex];
        while (localIndex != 0) {
            if (this.keys[localIndex] == key) {
                return localIndex;
            }
            localIndex = this.next[localIndex];
        }
        return 0;
    }

    private int findForRemove(float key, int baseHashIndex) {
        this.prev = 0;
        int index = this.baseHash[baseHashIndex];
        while (index != 0) {
            if (this.keys[index] == key) {
                return index;
            }
            this.prev = index;
            index = this.next[index];
        }
        this.prev = 0;
        return 0;
    }

    public T get(float key) {
        return (T)this.values[this.find(key)];
    }

    protected void grow() {
        FloatToObjectMap<T> that = new FloatToObjectMap<T>(this.capacity * 2);
        IndexIterator iterator = new IndexIterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            super.prvt_put(this.keys[index], this.values[index]);
        }
        this.capacity = that.capacity;
        this.size = that.size;
        this.firstEmpty = that.firstEmpty;
        this.values = that.values;
        this.keys = that.keys;
        this.next = that.next;
        this.baseHash = that.baseHash;
        this.hashFactor = that.hashFactor;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ValueIterator();
    }

    public FloatIterator keyIterator() {
        return new KeyIterator();
    }

    private String getBaseHashAsString() {
        return Arrays.toString(this.baseHash);
    }

    public T put(float key, T e) {
        int index = this.find(key);
        if (index != 0) {
            Object old = this.values[index];
            this.values[index] = e;
            return (T)old;
        }
        if (this.size == this.capacity) {
            this.grow();
        }
        this.prvt_put(key, e);
        return null;
    }

    public T remove(float key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int index = this.findForRemove(key, baseHashIndex);
        if (index != 0) {
            if (this.prev == 0) {
                this.baseHash[baseHashIndex] = this.next[index];
            }
            this.next[this.prev] = this.next[index];
            this.next[index] = this.firstEmpty;
            this.firstEmpty = index;
            --this.size;
            return (T)this.values[index];
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        int j = -1;
        Object[] array = new Object[this.size];
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            array[++j] = iterator.next();
        }
        return array;
    }

    public T[] toArray(T[] a) {
        int j;
        Iterator<T> iterator = this.iterator();
        for (j = 0; j < a.length && iterator.hasNext(); ++j) {
            a[j] = iterator.next();
        }
        if (j < a.length) {
            a[j] = null;
        }
        return a;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        FloatIterator keyIterator = this.keyIterator();
        while (keyIterator.hasNext()) {
            float key = keyIterator.next();
            sb.append(key);
            sb.append('=');
            sb.append(this.get(key));
            if (!keyIterator.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.size();
    }

    public boolean equals(Object o) {
        FloatToObjectMap that = (FloatToObjectMap)o;
        if (that.size() != this.size()) {
            return false;
        }
        FloatIterator it = this.keyIterator();
        while (it.hasNext()) {
            float key = it.next();
            if (!that.containsKey(key)) {
                return false;
            }
            T v1 = this.get(key);
            T v2 = that.get(key);
            if (!(v1 == null && v2 != null || v1 != null && v2 == null) && v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    private final class ValueIterator
    implements Iterator<T> {
        private IntIterator iterator;

        ValueIterator() {
            this.iterator = new IndexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return FloatToObjectMap.this.values[this.iterator.next()];
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class KeyIterator
    implements FloatIterator {
        private IntIterator iterator;

        KeyIterator() {
            this.iterator = new IndexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public float next() {
            return FloatToObjectMap.this.keys[this.iterator.next()];
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class IndexIterator
    implements IntIterator {
        private int baseHashIndex = 0;
        private int index = 0;
        private int lastIndex = 0;

        public IndexIterator() {
            while (this.baseHashIndex < FloatToObjectMap.this.baseHash.length) {
                this.index = FloatToObjectMap.this.baseHash[this.baseHashIndex];
                if (this.index != 0) break;
                ++this.baseHashIndex;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index != 0;
        }

        @Override
        public int next() {
            this.lastIndex = this.index;
            this.index = FloatToObjectMap.this.next[this.index];
            while (this.index == 0 && ++this.baseHashIndex < FloatToObjectMap.this.baseHash.length) {
                this.index = FloatToObjectMap.this.baseHash[this.baseHashIndex];
            }
            return this.lastIndex;
        }

        @Override
        public void remove() {
            FloatToObjectMap.this.remove(FloatToObjectMap.this.keys[this.lastIndex]);
        }
    }
}

