/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class FairSchedulerAppsBlock
extends HtmlBlock {
    final ConcurrentMap<ApplicationId, RMApp> apps;
    final FairSchedulerInfo fsinfo;
    final Configuration conf;
    final ResourceManager rm;

    @Inject
    public FairSchedulerAppsBlock(ResourceManager rm, View.ViewContext ctx, Configuration conf) {
        super(ctx);
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        this.fsinfo = new FairSchedulerInfo(scheduler);
        this.apps = new ConcurrentHashMap<ApplicationId, RMApp>();
        for (Map.Entry entry : rm.getRMContext().getRMApps().entrySet()) {
            if (RMAppState.NEW.equals((Object)((RMApp)entry.getValue()).getState()) || RMAppState.NEW_SAVING.equals((Object)((RMApp)entry.getValue()).getState()) || RMAppState.SUBMITTED.equals((Object)((RMApp)entry.getValue()).getState())) continue;
            this.apps.put((ApplicationId)entry.getKey(), (RMApp)entry.getValue());
        }
        this.conf = conf;
        this.rm = rm;
    }

    public void render(HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#apps").thead().tr().th(".id", "ID").th(".user", "User").th(".name", "Name").th(".type", "Application Type").th(".queue", "Queue").th(".fairshare", "Fair Share").th(".starttime", "StartTime").th(".finishtime", "FinishTime").th(".state", "State").th(".finalstatus", "FinalStatus").th(".runningcontainer", "Running Containers").th(".allocatedCpu", "Allocated CPU VCores").th(".allocatedMemory", "Allocated Memory MB").th(".reservedCpu", "Reserved CPU VCores").th(".reservedMemory", "Reserved Memory MB").th(".progress", "Progress").th(".ui", "Tracking UI")._())._()).tbody();
        HashSet<YarnApplicationState> reqAppStates = null;
        String reqStateString = this.$("app.state");
        if (reqStateString != null && !reqStateString.isEmpty()) {
            String[] appStateStrings = reqStateString.split(",");
            reqAppStates = new HashSet<YarnApplicationState>(appStateStrings.length);
            for (String stateString : appStateStrings) {
                reqAppStates.add(YarnApplicationState.valueOf((String)stateString));
            }
        }
        StringBuilder appsTableData = new StringBuilder("[\n");
        for (RMApp app : this.apps.values()) {
            if (reqAppStates != null && !reqAppStates.contains(app.createApplicationState())) continue;
            AppInfo appInfo = new AppInfo(this.rm, app, true, WebAppUtils.getHttpSchemePrefix((Configuration)this.conf));
            String percent = StringUtils.format((String)"%.1f", (Object[])new Object[]{Float.valueOf(appInfo.getProgress())});
            ApplicationAttemptId attemptId = app.getCurrentAppAttempt().getAppAttemptId();
            long fairShare = this.fsinfo.getAppFairShare(attemptId);
            if (fairShare == -1L) continue;
            appsTableData.append("[\"<a href='").append(this.url(new String[]{"app", appInfo.getAppId()})).append("'>").append(appInfo.getAppId()).append("</a>\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)appInfo.getUser()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)appInfo.getName()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)appInfo.getApplicationType()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)appInfo.getQueue()))).append("\",\"").append(fairShare).append("\",\"").append(appInfo.getStartTime()).append("\",\"").append(appInfo.getFinishTime()).append("\",\"").append(appInfo.getState()).append("\",\"").append(appInfo.getFinalStatus()).append("\",\"").append(appInfo.getRunningContainers() == -1 ? "N/A" : String.valueOf(appInfo.getRunningContainers())).append("\",\"").append(appInfo.getAllocatedVCores() == -1L ? "N/A" : String.valueOf(appInfo.getAllocatedVCores())).append("\",\"").append(appInfo.getAllocatedMB() == -1L ? "N/A" : String.valueOf(appInfo.getAllocatedMB())).append("\",\"").append(appInfo.getReservedVCores() == -1L ? "N/A" : String.valueOf(appInfo.getReservedVCores())).append("\",\"").append(appInfo.getReservedMB() == -1L ? "N/A" : String.valueOf(appInfo.getReservedMB())).append("\",\"").append("<br title='").append(percent).append("'> <div class='").append(JQueryUI.C_PROGRESSBAR).append("' title='").append(StringHelper.join((Object[])new Object[]{percent, Character.valueOf('%')})).append("'> ").append("<div class='").append(JQueryUI.C_PROGRESSBAR_VALUE).append("' style='").append(StringHelper.join((Object[])new Object[]{"width:", percent, Character.valueOf('%')})).append("'> </div> </div>").append("\",\"<a href='");
            String trackingURL = !appInfo.isTrackingUrlReady() ? "#" : appInfo.getTrackingUrlPretty();
            appsTableData.append(trackingURL).append("'>").append(appInfo.getTrackingUI()).append("</a>\"],\n");
        }
        if (appsTableData.charAt(appsTableData.length() - 2) == ',') {
            appsTableData.delete(appsTableData.length() - 2, appsTableData.length() - 1);
        }
        appsTableData.append("]");
        html.script().$type("text/javascript")._(new Object[]{"var appsTableData=" + appsTableData})._();
        ((Hamlet.TABLE)tbody._())._();
    }
}

