/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesLogger;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityDiagnosticConstant;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.QueueOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.PlacementSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.PlacementSetUtils;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ParentQueue
extends AbstractCSQueue {
    private static final Log LOG = LogFactory.getLog(ParentQueue.class);
    protected final List<CSQueue> childQueues;
    private final boolean rootQueue;
    private volatile int numApplications;
    private final CapacitySchedulerContext scheduler;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private QueueOrderingPolicy queueOrderingPolicy;
    private static float PRECISION = 5.0E-4f;

    public ParentQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
        this.scheduler = cs;
        this.rootQueue = parent == null;
        float rawCapacity = cs.getConfiguration().getNonLabeledQueueCapacity(this.getQueuePath());
        if (this.rootQueue && rawCapacity != 100.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + rawCapacity + " for queue " + queueName + ". Must be " + 100.0f);
        }
        this.childQueues = new ArrayList<CSQueue>();
        this.setupQueueConfigs(cs.getClusterResource());
        LOG.info((Object)("Initialized parent-queue " + queueName + " name=" + queueName + ", fullname=" + this.getQueuePath()));
    }

    private String getQueueOrderingPolicyConfigName() {
        return this.queueOrderingPolicy == null ? null : this.queueOrderingPolicy.getConfigName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupQueueConfigs(Resource clusterResource) throws IOException {
        try {
            this.writeLock.lock();
            super.setupQueueConfigs(clusterResource);
            StringBuilder aclsString = new StringBuilder();
            for (Map.Entry e : this.acls.entrySet()) {
                aclsString.append(e.getKey() + ":" + ((AccessControlList)e.getValue()).getAclString());
            }
            StringBuilder labelStrBuilder = new StringBuilder();
            if (this.accessibleLabels != null) {
                for (String s : this.accessibleLabels) {
                    labelStrBuilder.append(s);
                    labelStrBuilder.append(",");
                }
            }
            this.queueOrderingPolicy = this.csContext.getConfiguration().getQueueOrderingPolicy(this.getQueuePath(), this.parent == null ? null : ((ParentQueue)this.parent).getQueueOrderingPolicyConfigName());
            this.queueOrderingPolicy.setQueues(this.childQueues);
            LOG.info((Object)(this.queueName + ", capacity=" + this.queueCapacities.getCapacity() + ", absoluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", maxCapacity=" + this.queueCapacities.getMaximumCapacity() + ", absoluteMaxCapacity=" + this.queueCapacities.getAbsoluteMaximumCapacity() + ", state=" + this.getState() + ", acls=" + aclsString + ", labels=" + labelStrBuilder.toString() + "\n, reservationsContinueLooking=" + this.reservationsContinueLooking + ", orderingPolicy=" + this.getQueueOrderingPolicyConfigName() + ", priority=" + this.priority));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChildQueues(Collection<CSQueue> childQueues) {
        try {
            this.writeLock.lock();
            float childCapacities = 0.0f;
            for (CSQueue queue : childQueues) {
                childCapacities += queue.getCapacity();
            }
            float delta = Math.abs(1.0f - childCapacities);
            if (this.queueCapacities.getCapacity() > 0.0f && delta > PRECISION || this.queueCapacities.getCapacity() == 0.0f && childCapacities > 0.0f) {
                throw new IllegalArgumentException("Illegal capacity of " + childCapacities + " for children of queue " + this.queueName);
            }
            for (String nodeLabel : this.queueCapacities.getExistingNodeLabels()) {
                float capacityByLabel = this.queueCapacities.getCapacity(nodeLabel);
                float sum = 0.0f;
                for (CSQueue queue : childQueues) {
                    sum += queue.getQueueCapacities().getCapacity(nodeLabel);
                }
                if (!(capacityByLabel > 0.0f && Math.abs(1.0f - sum) > PRECISION) && (capacityByLabel != 0.0f || !(sum > 0.0f))) continue;
                throw new IllegalArgumentException("Illegal capacity of " + sum + " for children of queue " + this.queueName + " for label=" + nodeLabel);
            }
            this.childQueues.clear();
            this.childQueues.addAll(childQueues);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("setChildQueues: " + this.getChildQueuesToPrint()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        try {
            this.readLock.lock();
            QueueInfo queueInfo = this.getQueueInfo();
            ArrayList<QueueInfo> childQueuesInfo = new ArrayList<QueueInfo>();
            if (includeChildQueues) {
                for (CSQueue child : this.childQueues) {
                    childQueuesInfo.add(child.getQueueInfo(recursive, recursive));
                }
            }
            queueInfo.setChildQueues(childQueuesInfo);
            QueueInfo queueInfo2 = queueInfo;
            return queueInfo2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueUserACLInfo getUserAclInfo(UserGroupInformation user) {
        try {
            this.readLock.lock();
            QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
            ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
            for (QueueACL operation : QueueACL.values()) {
                if (!this.hasAccess(operation, user)) continue;
                operations.add(operation);
            }
            userAclInfo.setQueueName(this.getQueueName());
            userAclInfo.setUserAcls(operations);
            QueueUserACLInfo queueUserACLInfo = userAclInfo;
            return queueUserACLInfo;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        try {
            this.readLock.lock();
            ArrayList<QueueUserACLInfo> userAcls = new ArrayList<QueueUserACLInfo>();
            userAcls.add(this.getUserAclInfo(user));
            for (CSQueue child : this.childQueues) {
                userAcls.addAll(child.getQueueUserAclInfo(user));
            }
            ArrayList<QueueUserACLInfo> arrayList = userAcls;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        return this.queueName + ": numChildQueue= " + this.childQueues.size() + ", capacity=" + this.queueCapacities.getCapacity() + ", absoluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", usedResources=" + this.queueUsage.getUsed() + "usedCapacity=" + this.getUsedCapacity() + ", numApps=" + this.getNumApplications() + ", numContainers=" + this.getNumContainers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        try {
            this.writeLock.lock();
            if (!(newlyParsedQueue instanceof ParentQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
                throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
            }
            ParentQueue newlyParsedParentQueue = (ParentQueue)newlyParsedQueue;
            this.setupQueueConfigs(clusterResource);
            Map<String, CSQueue> currentChildQueues = this.getQueuesMap(this.childQueues);
            Map<String, CSQueue> newChildQueues = this.getQueuesMap(newlyParsedParentQueue.childQueues);
            for (Map.Entry<String, CSQueue> e : newChildQueues.entrySet()) {
                String newChildQueueName = e.getKey();
                CSQueue newChildQueue = e.getValue();
                CSQueue childQueue = currentChildQueues.get(newChildQueueName);
                if (childQueue != null) {
                    if (childQueue instanceof LeafQueue && newChildQueue instanceof ParentQueue || childQueue instanceof ParentQueue && newChildQueue instanceof LeafQueue) {
                        newChildQueue.setParent(this);
                        currentChildQueues.put(newChildQueueName, newChildQueue);
                        CapacitySchedulerQueueManager queueManager = this.csContext.getCapacitySchedulerQueueManager();
                        queueManager.addQueue(newChildQueueName, newChildQueue);
                        continue;
                    }
                    childQueue.reinitialize(newChildQueue, clusterResource);
                    LOG.info((Object)(this.getQueueName() + ": re-configured queue: " + childQueue));
                    continue;
                }
                newChildQueue.setParent(this);
                currentChildQueues.put(newChildQueueName, newChildQueue);
                LOG.info((Object)(this.getQueueName() + ": added new child queue: " + newChildQueue));
            }
            Iterator<Map.Entry<String, CSQueue>> itr = currentChildQueues.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, CSQueue> e;
                e = itr.next();
                String queueName = e.getKey();
                if (newChildQueues.containsKey(queueName)) continue;
                itr.remove();
            }
            this.childQueues.clear();
            this.childQueues.addAll(currentChildQueues.values());
            this.queueOrderingPolicy.setQueues(this.childQueues);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map<String, CSQueue> getQueuesMap(List<CSQueue> queues) {
        HashMap<String, CSQueue> queuesMap = new HashMap<String, CSQueue>();
        for (CSQueue queue : queues) {
            queuesMap.put(queue.getQueueName(), queue);
        }
        return queuesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(ApplicationId applicationId, String user, String queue) throws AccessControlException {
        try {
            this.writeLock.lock();
            this.validateSubmitApplication(applicationId, user, queue);
            this.addApplication(applicationId, user);
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.parent != null) {
            try {
                this.parent.submitApplication(applicationId, user, queue);
            }
            catch (AccessControlException ace) {
                LOG.info((Object)("Failed to submit application to parent-queue: " + this.parent.getQueuePath()), (Throwable)ace);
                this.removeApplication(applicationId, user);
                throw ace;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateSubmitApplication(ApplicationId applicationId, String userName, String queue) throws AccessControlException {
        try {
            this.writeLock.lock();
            if (queue.equals(this.queueName)) {
                throw new AccessControlException("Cannot submit application to non-leaf queue: " + this.queueName);
            }
            if (this.getState() != QueueState.RUNNING) {
                throw new AccessControlException("Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + applicationId);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName) {
    }

    @Override
    public void finishApplicationAttempt(FiCaSchedulerApp application, String queue) {
    }

    private void addApplication(ApplicationId applicationId, String user) {
        try {
            this.writeLock.lock();
            ++this.numApplications;
            LOG.info((Object)("Application added - appId: " + applicationId + " user: " + user + " leaf-queue of parent: " + this.getQueueName() + " #applications: " + this.getNumApplications()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void finishApplication(ApplicationId application, String user) {
        this.removeApplication(application, user);
        this.appFinished();
        if (this.parent != null) {
            this.parent.finishApplication(application, user);
        }
    }

    private void removeApplication(ApplicationId applicationId, String user) {
        try {
            this.writeLock.lock();
            --this.numApplications;
            LOG.info((Object)("Application removed - appId: " + applicationId + " user: " + user + " leaf-queue of parent: " + this.getQueueName() + " #applications: " + this.getNumApplications()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String getParentName() {
        return this.getParent() != null ? this.getParent().getQueueName() : "";
    }

    @Override
    public CSAssignment assignContainers(Resource clusterResource, PlacementSet<FiCaSchedulerNode> ps, ResourceLimits resourceLimits, SchedulingMode schedulingMode) {
        CSAssignment assignment;
        block11: {
            CSAssignment assignedToChild;
            FiCaSchedulerNode node;
            block13: {
                boolean isReserved;
                block12: {
                    node = PlacementSetUtils.getSingleNode(ps);
                    if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY && !this.accessibleToPartition(ps.getPartition())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Skip this queue=" + this.getQueuePath() + ", because it is not able to access partition=" + ps.getPartition()));
                        }
                        ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParentName(), this.getQueueName(), ActivityState.REJECTED, "Not able to access partition" + node.getPartition());
                        if (this.rootQueue) {
                            ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
                        }
                        return CSAssignment.NULL_ASSIGNMENT;
                    }
                    if (!super.hasPendingResourceRequest(ps.getPartition(), clusterResource, schedulingMode)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Skip this queue=" + this.getQueuePath() + ", because it doesn't need more resource, schedulingMode=" + schedulingMode.name() + " node-partition=" + ps.getPartition()));
                        }
                        ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParentName(), this.getQueueName(), ActivityState.SKIPPED, "Queue does not need more resource");
                        if (this.rootQueue) {
                            ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
                        }
                        return CSAssignment.NULL_ASSIGNMENT;
                    }
                    assignment = new CSAssignment(Resources.createResource((int)0, (int)0), NodeType.NODE_LOCAL);
                    if (!this.canAssign(clusterResource, node)) break block11;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Trying to assign containers to child-queue of " + this.getQueueName()));
                    }
                    if (super.canAssignToThisQueue(clusterResource, ps.getPartition(), resourceLimits, Resources.createResource((long)this.getMetrics().getReservedMB(), (int)this.getMetrics().getReservedVirtualCores()), schedulingMode)) break block12;
                    ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParentName(), this.getQueueName(), ActivityState.SKIPPED, "Hit queue max-capacity limit");
                    if (!this.rootQueue) break block11;
                    ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
                    break block11;
                }
                assignedToChild = this.assignContainersToChildQueues(clusterResource, ps, resourceLimits, schedulingMode);
                assignment.setType(assignedToChild.getType());
                assignment.setRequestLocalityType(assignedToChild.getRequestLocalityType());
                assignment.setExcessReservation(assignedToChild.getExcessReservation());
                assignment.setContainersToKill(assignedToChild.getContainersToKill());
                if (!Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)assignedToChild.getResource(), (Resource)Resources.none())) break block13;
                ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParentName(), this.getQueueName(), ActivityState.ACCEPTED, ActivityDiagnosticConstant.EMPTY);
                boolean bl = isReserved = assignedToChild.getAssignmentInformation().getReservationDetails() != null && !assignedToChild.getAssignmentInformation().getReservationDetails().isEmpty();
                if (node != null && !isReserved) {
                    if (this.rootQueue) {
                        ActivitiesLogger.NODE.finishAllocatedNodeAllocation(this.activitiesManager, node, assignedToChild.getAssignmentInformation().getFirstAllocatedOrReservedContainerId(), AllocationState.ALLOCATED);
                    }
                } else if (this.rootQueue) {
                    ActivitiesLogger.NODE.finishAllocatedNodeAllocation(this.activitiesManager, node, assignedToChild.getAssignmentInformation().getFirstAllocatedOrReservedContainerId(), AllocationState.RESERVED);
                }
                Resources.addTo((Resource)assignment.getResource(), (Resource)assignedToChild.getResource());
                Resources.addTo((Resource)assignment.getAssignmentInformation().getAllocated(), (Resource)assignedToChild.getAssignmentInformation().getAllocated());
                Resources.addTo((Resource)assignment.getAssignmentInformation().getReserved(), (Resource)assignedToChild.getAssignmentInformation().getReserved());
                assignment.getAssignmentInformation().incrAllocations(assignedToChild.getAssignmentInformation().getNumAllocations());
                assignment.getAssignmentInformation().incrReservations(assignedToChild.getAssignmentInformation().getNumReservations());
                assignment.getAssignmentInformation().getAllocationDetails().addAll(assignedToChild.getAssignmentInformation().getAllocationDetails());
                assignment.getAssignmentInformation().getReservationDetails().addAll(assignedToChild.getAssignmentInformation().getReservationDetails());
                assignment.setIncreasedAllocation(assignedToChild.isIncreasedAllocation());
                LOG.info((Object)("assignedContainer queue=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
                if (!LOG.isDebugEnabled()) break block11;
                LOG.debug((Object)("ParentQ=" + this.getQueueName() + " assignedSoFarInThisIteration=" + assignment.getResource() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity()));
                break block11;
            }
            assignment.setSkippedType(assignedToChild.getSkippedType());
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParentName(), this.getQueueName(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY);
            if (!this.rootQueue) break block11;
            ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
        }
        return assignment;
    }

    private boolean canAssign(Resource clusterResource, FiCaSchedulerNode node) {
        if (null == node) {
            return true;
        }
        return node.getReservedContainer() == null && Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.add((Resource)node.getUnallocatedResource(), (Resource)node.getTotalKillableResources()), (Resource)this.minimumAllocation);
    }

    private ResourceLimits getResourceLimitsOfChild(CSQueue child, Resource clusterResource, Resource parentLimits, String nodePartition) {
        Resource parentMaxAvailableResource = Resources.subtract((Resource)parentLimits, (Resource)this.queueUsage.getUsed(nodePartition));
        Resources.addTo((Resource)parentMaxAvailableResource, (Resource)this.getTotalKillableResource(nodePartition));
        Resource childLimit = Resources.add((Resource)parentMaxAvailableResource, (Resource)child.getQueueResourceUsage().getUsed(nodePartition));
        Resource childConfiguredMaxResource = Resources.multiplyAndNormalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel(nodePartition, clusterResource), (double)child.getQueueCapacities().getAbsoluteMaximumCapacity(nodePartition), (Resource)this.minimumAllocation);
        childLimit = Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)childLimit, (Resource)childConfiguredMaxResource);
        childLimit = Resources.roundDown((ResourceCalculator)this.resourceCalculator, (Resource)childLimit, (Resource)this.minimumAllocation);
        return new ResourceLimits(childLimit);
    }

    private Iterator<CSQueue> sortAndGetChildrenAllocationIterator(String partition) {
        return this.queueOrderingPolicy.getAssignmentIterator(partition);
    }

    private CSAssignment assignContainersToChildQueues(Resource cluster, PlacementSet<FiCaSchedulerNode> ps, ResourceLimits limits, SchedulingMode schedulingMode) {
        CSAssignment assignment = CSAssignment.NULL_ASSIGNMENT;
        Resource parentLimits = limits.getLimit();
        this.printChildQueues();
        Iterator<CSQueue> iter = this.sortAndGetChildrenAllocationIterator(ps.getPartition());
        while (iter.hasNext()) {
            CSQueue childQueue = iter.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to assign to queue: " + childQueue.getQueuePath() + " stats: " + childQueue));
            }
            ResourceLimits childLimits = this.getResourceLimitsOfChild(childQueue, cluster, parentLimits, ps.getPartition());
            CSAssignment childAssignment = childQueue.assignContainers(cluster, ps, childLimits, schedulingMode);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Assigned to queue: " + childQueue.getQueuePath() + " stats: " + childQueue + " --> " + childAssignment.getResource() + ", " + (Object)((Object)childAssignment.getType())));
            }
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)childAssignment.getResource(), (Resource)Resources.none())) {
                assignment = childAssignment;
                break;
            }
            if (childAssignment.getSkippedType() != CSAssignment.SkippedType.QUEUE_LIMIT) continue;
            if (assignment.getSkippedType() != CSAssignment.SkippedType.QUEUE_LIMIT) {
                assignment = childAssignment;
            }
            Resource resourceToSubtract = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)childLimits.getHeadroom(), (Resource)Resources.none());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Decrease parentLimits " + parentLimits + " for " + this.getQueueName() + " by " + resourceToSubtract + " as childQueue=" + childQueue.getQueueName() + " is blocked"));
            }
            parentLimits = Resources.subtract((Resource)parentLimits, (Resource)resourceToSubtract);
        }
        return assignment;
    }

    String getChildQueuesToPrint() {
        StringBuilder sb = new StringBuilder();
        for (CSQueue q : this.childQueues) {
            sb.append(q.getQueuePath() + "usedCapacity=(" + q.getUsedCapacity() + "),  label=(" + StringUtils.join(q.getAccessibleNodeLabels().iterator(), (String)",") + ")");
        }
        return sb.toString();
    }

    private void printChildQueues() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("printChildQueues - queue: " + this.getQueuePath() + " child-queues: " + this.getChildQueuesToPrint()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalReleaseResource(Resource clusterResource, FiCaSchedulerNode node, Resource releasedResource) {
        try {
            this.writeLock.lock();
            super.releaseResource(clusterResource, releasedResource, node.getPartition());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("completedContainer " + this + ", cluster=" + clusterResource));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void completedContainer(Resource clusterResource, FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, CSQueue completedChildQueue, boolean sortQueues) {
        if (application != null) {
            this.internalReleaseResource(clusterResource, node, rmContainer.getContainer().getResource());
            if (this.parent != null) {
                this.parent.completedContainer(clusterResource, application, node, rmContainer, null, event, this, sortQueues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterResource(Resource clusterResource, ResourceLimits resourceLimits) {
        try {
            this.writeLock.lock();
            for (CSQueue childQueue : this.childQueues) {
                ResourceLimits childLimits = this.getResourceLimitsOfChild(childQueue, clusterResource, resourceLimits.getLimit(), "");
                childQueue.updateClusterResource(clusterResource, childLimits);
            }
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, null);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean hasChildQueues() {
        return true;
    }

    @Override
    public List<CSQueue> getChildQueues() {
        try {
            this.readLock.lock();
            ArrayList<CSQueue> arrayList = new ArrayList<CSQueue>(this.childQueues);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt attempt, RMContainer rmContainer) {
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        if (rmContainer.getExecutionType() != ExecutionType.GUARANTEED) {
            return;
        }
        try {
            this.writeLock.lock();
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, rmContainer.getContainer().getResource(), node.getPartition());
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.parent != null) {
            this.parent.recoverContainer(clusterResource, attempt, rmContainer);
        }
    }

    @Override
    public ActiveUsersManager getAbstractUsersManager() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        try {
            this.readLock.lock();
            for (CSQueue queue : this.childQueues) {
                queue.collectSchedulerApplications(apps);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void attachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, rmContainer.getContainer().getResource(), node.getPartition());
            LOG.info((Object)("movedContainer queueMoveIn=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            if (this.parent != null) {
                this.parent.attachContainer(clusterResource, application, rmContainer);
            }
        }
    }

    @Override
    public void detachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            super.releaseResource(clusterResource, rmContainer.getContainer().getResource(), node.getPartition());
            LOG.info((Object)("movedContainer queueMoveOut=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            if (this.parent != null) {
                this.parent.detachContainer(clusterResource, application, rmContainer);
            }
        }
    }

    @Override
    public int getNumApplications() {
        return this.numApplications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void allocateResource(Resource clusterResource, Resource resource, String nodePartition) {
        try {
            this.writeLock.lock();
            super.allocateResource(clusterResource, resource, nodePartition);
            if (this.getQueueCapacities().getAbsoluteMaximumCapacity(nodePartition) < this.getQueueCapacities().getAbsoluteUsedCapacity(nodePartition)) {
                this.killContainersToEnforceMaxQueueCapacity(nodePartition, clusterResource);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void killContainersToEnforceMaxQueueCapacity(String partition, Resource clusterResource) {
        Iterator<RMContainer> killableContainerIter = this.getKillableContainers(partition);
        if (!killableContainerIter.hasNext()) {
            return;
        }
        Resource partitionResource = this.labelManager.getResourceByLabel(partition, null);
        Resource maxResource = Resources.multiply((Resource)partitionResource, (double)this.getQueueCapacities().getAbsoluteMaximumCapacity(partition));
        while (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)this.queueUsage.getUsed(partition), (Resource)maxResource)) {
            RMContainer toKillContainer = killableContainerIter.next();
            FiCaSchedulerApp attempt = this.csContext.getApplicationAttempt(toKillContainer.getContainerId().getApplicationAttemptId());
            FiCaSchedulerNode node = this.csContext.getNode(toKillContainer.getAllocatedNode());
            if (null != attempt && null != node) {
                LeafQueue lq = attempt.getCSLeafQueue();
                lq.completedContainer(clusterResource, attempt, node, toKillContainer, SchedulerUtils.createPreemptedContainerStatus(toKillContainer.getContainerId(), "Container preempted by scheduler"), RMContainerEventType.KILL, null, false);
                LOG.info((Object)("Killed container=" + toKillContainer.getContainerId() + " from queue=" + lq.getQueueName() + " to make queue=" + this.getQueueName() + "'s max-capacity enforced"));
            }
            if (killableContainerIter.hasNext()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        if (request.anythingAllocatedOrReserved()) {
            ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
            SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
            if (allocation.getAllocateFromReservedContainer() == null) {
                try {
                    this.writeLock.lock();
                    this.allocateResource(cluster, allocation.getAllocatedOrReservedResource(), schedulerContainer.getNodePartition());
                    LOG.info((Object)("assignedContainer queue=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + cluster));
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
        if (this.parent != null) {
            this.parent.apply(cluster, request);
        }
    }

    @Override
    public void stopQueue() {
        try {
            this.writeLock.lock();
            if (this.getNumApplications() > 0) {
                this.updateQueueState(QueueState.DRAINING);
            } else {
                this.updateQueueState(QueueState.STOPPED);
            }
            if (this.getChildQueues() != null) {
                for (CSQueue child : this.getChildQueues()) {
                    child.stopQueue();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public QueueOrderingPolicy getQueueOrderingPolicy() {
        return this.queueOrderingPolicy;
    }
}

