/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesLogger;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityDiagnosticConstant;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AppPriorityACLGroup;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityHeadroomProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.KillableContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.PlacementSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.PlacementSetUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicyForPendingApps;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LeafQueue
extends AbstractCSQueue {
    private static final Log LOG = LogFactory.getLog(LeafQueue.class);
    private float absoluteUsedCapacity = 0.0f;
    protected int maxApplications;
    protected volatile int maxApplicationsPerUser;
    private float maxAMResourcePerQueuePercent;
    private volatile int nodeLocalityDelay;
    private volatile int rackLocalityAdditionalDelay;
    private volatile boolean rackLocalityFullReset;
    Map<ApplicationAttemptId, FiCaSchedulerApp> applicationAttemptMap = new ConcurrentHashMap<ApplicationAttemptId, FiCaSchedulerApp>();
    private Priority defaultAppPriorityPerQueue;
    private final OrderingPolicy<FiCaSchedulerApp> pendingOrderingPolicy;
    private volatile float minimumAllocationFactor;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private CapacitySchedulerContext scheduler;
    private final UsersManager usersManager;
    private Resource lastClusterResource = Resources.none();
    private final QueueResourceLimitsInfo queueResourceLimitsInfo = new QueueResourceLimitsInfo();
    private volatile ResourceLimits cachedResourceLimitsForHeadroom = null;
    private volatile OrderingPolicy<FiCaSchedulerApp> orderingPolicy = null;
    private Map<String, TreeSet<RMContainer>> ignorePartitionExclusivityRMContainers = new ConcurrentHashMap<String, TreeSet<RMContainer>>();
    List<AppPriorityACLGroup> priorityAcls = new ArrayList<AppPriorityACLGroup>();
    private volatile long maxApplicationLifetime = -1L;
    private volatile long defaultApplicationLifetime = -1L;

    public LeafQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
        this.scheduler = cs;
        this.usersManager = new UsersManager(this.metrics, this, this.labelManager, this.scheduler, this.resourceCalculator);
        this.pendingOrderingPolicy = new FifoOrderingPolicyForPendingApps<FiCaSchedulerApp>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LeafQueue: name=" + queueName + ", fullname=" + this.getQueuePath()));
        }
        this.setupQueueConfigs(cs.getClusterResource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupQueueConfigs(Resource clusterResource) throws IOException {
        try {
            this.writeLock.lock();
            super.setupQueueConfigs(clusterResource);
            this.lastClusterResource = clusterResource;
            this.cachedResourceLimitsForHeadroom = new ResourceLimits(clusterResource);
            this.setQueueResourceLimitsInfo(clusterResource);
            CapacitySchedulerConfiguration conf = this.csContext.getConfiguration();
            this.setOrderingPolicy(conf.getAppOrderingPolicy(this.getQueuePath()));
            this.usersManager.setUserLimit(conf.getUserLimit(this.getQueuePath()));
            this.usersManager.setUserLimitFactor(conf.getUserLimitFactor(this.getQueuePath()));
            this.maxApplications = conf.getMaximumApplicationsPerQueue(this.getQueuePath());
            if (this.maxApplications < 0) {
                int maxGlobalPerQueueApps = conf.getGlobalMaximumApplicationsPerQueue();
                if (maxGlobalPerQueueApps > 0) {
                    this.maxApplications = maxGlobalPerQueueApps;
                } else {
                    int maxSystemApps = conf.getMaximumSystemApplications();
                    this.maxApplications = (int)((float)maxSystemApps * this.queueCapacities.getAbsoluteCapacity());
                }
            }
            this.maxApplicationsPerUser = Math.min(this.maxApplications, (int)((float)this.maxApplications * ((float)this.usersManager.getUserLimit() / 100.0f) * this.usersManager.getUserLimitFactor()));
            this.maxAMResourcePerQueuePercent = conf.getMaximumApplicationMasterResourcePerQueuePercent(this.getQueuePath());
            this.priorityAcls = conf.getPriorityAcls(this.getQueuePath(), this.scheduler.getMaxClusterLevelAppPriority());
            if (!SchedulerUtils.checkQueueLabelExpression(this.accessibleLabels, this.defaultLabelExpression, null)) {
                throw new IOException("Invalid default label expression of  queue=" + this.getQueueName() + " doesn't have permission to access all labels in default label expression. labelExpression of resource request=" + (this.defaultLabelExpression == null ? "" : this.defaultLabelExpression) + ". Queue labels=" + (this.getAccessibleNodeLabels() == null ? "" : StringUtils.join(this.getAccessibleNodeLabels().iterator(), (char)',')));
            }
            this.nodeLocalityDelay = conf.getNodeLocalityDelay();
            this.rackLocalityAdditionalDelay = conf.getRackLocalityAdditionalDelay();
            this.rackLocalityFullReset = conf.getRackLocalityFullReset();
            this.minimumAllocationFactor = Resources.ratio((ResourceCalculator)this.resourceCalculator, (Resource)Resources.subtract((Resource)this.maximumAllocation, (Resource)this.minimumAllocation), (Resource)this.maximumAllocation);
            StringBuilder aclsString = new StringBuilder();
            for (Map.Entry entry : this.acls.entrySet()) {
                aclsString.append(entry.getKey() + ":" + ((AccessControlList)entry.getValue()).getAclString());
            }
            StringBuilder labelStrBuilder = new StringBuilder();
            if (this.accessibleLabels != null) {
                for (String s : this.accessibleLabels) {
                    labelStrBuilder.append(s);
                    labelStrBuilder.append(",");
                }
            }
            this.defaultAppPriorityPerQueue = Priority.newInstance((int)conf.getDefaultApplicationPriorityConfPerQueue(this.getQueuePath()));
            this.maxApplicationLifetime = conf.getMaximumLifetimePerQueue(this.getQueuePath());
            this.defaultApplicationLifetime = conf.getDefaultLifetimePerQueue(this.getQueuePath());
            if (this.defaultApplicationLifetime > this.maxApplicationLifetime) {
                throw new YarnRuntimeException("Default lifetime" + this.defaultApplicationLifetime + " can't exceed maximum lifetime " + this.maxApplicationLifetime);
            }
            this.defaultApplicationLifetime = this.defaultApplicationLifetime > 0L ? this.defaultApplicationLifetime : this.maxApplicationLifetime;
            int n = Math.min(100, conf.getUserLimit(this.getQueuePath()));
            for (Map.Entry<String, Float> e : this.getUserWeights().entrySet()) {
                float val = e.getValue().floatValue();
                if (!(val < 0.0f) && !(val > 100.0f / (float)n)) continue;
                throw new IOException("Weight (" + val + ") for user \"" + e.getKey() + "\" must be between 0 and 100 / " + n + " (= " + 100.0f / (float)n + ", the number of concurrent active users in " + this.getQueuePath() + ")");
            }
            this.usersManager.updateUserWeights();
            LOG.info((Object)("Initializing " + this.queueName + "\ncapacity = " + this.queueCapacities.getCapacity() + " [= (float) configuredCapacity / 100 ]\nabsoluteCapacity = " + this.queueCapacities.getAbsoluteCapacity() + " [= parentAbsoluteCapacity * capacity ]\nmaxCapacity = " + this.queueCapacities.getMaximumCapacity() + " [= configuredMaxCapacity ]\nabsoluteMaxCapacity = " + this.queueCapacities.getAbsoluteMaximumCapacity() + " [= 1.0 maximumCapacity undefined, (parentAbsoluteMaxCapacity * maximumCapacity) / 100 otherwise ]\nuserLimit = " + this.usersManager.getUserLimit() + " [= configuredUserLimit ]\nuserLimitFactor = " + this.usersManager.getUserLimitFactor() + " [= configuredUserLimitFactor ]\nmaxApplications = " + this.maxApplications + " [= configuredMaximumSystemApplicationsPerQueue or (int)(configuredMaximumSystemApplications * absoluteCapacity)]\nmaxApplicationsPerUser = " + this.maxApplicationsPerUser + " [= (int)(maxApplications * (userLimit / 100.0f) * userLimitFactor) ]\nusedCapacity = " + this.queueCapacities.getUsedCapacity() + " [= usedResourcesMemory / (clusterResourceMemory * absoluteCapacity)]\nabsoluteUsedCapacity = " + this.absoluteUsedCapacity + " [= usedResourcesMemory / clusterResourceMemory]\nmaxAMResourcePerQueuePercent = " + this.maxAMResourcePerQueuePercent + " [= configuredMaximumAMResourcePercent ]\nminimumAllocationFactor = " + this.minimumAllocationFactor + " [= (float)(maximumAllocationMemory - minimumAllocationMemory) / maximumAllocationMemory ]\nmaximumAllocation = " + this.maximumAllocation + " [= configuredMaxAllocation ]\nnumContainers = " + this.numContainers + " [= currentNumContainers ]\nstate = " + this.getState() + " [= configuredState ]\nacls = " + aclsString + " [= configuredAcls ]\nnodeLocalityDelay = " + this.nodeLocalityDelay + "\nrackLocalityAdditionalDelay = " + this.rackLocalityAdditionalDelay + "\nlabels=" + labelStrBuilder.toString() + "\nreservationsContinueLooking = " + this.reservationsContinueLooking + "\npreemptionDisabled = " + this.getPreemptionDisabled() + "\ndefaultAppPriorityPerQueue = " + this.defaultAppPriorityPerQueue + "\npriority = " + this.priority + "\nmaxLifetime = " + this.maxApplicationLifetime + " seconds\ndefaultLifetime = " + this.defaultApplicationLifetime + " seconds"));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public float getMinimumAllocationFactor() {
        return this.minimumAllocationFactor;
    }

    @InterfaceAudience.Private
    public float getMaxAMResourcePerQueuePercent() {
        return this.maxAMResourcePerQueuePercent;
    }

    public int getMaxApplications() {
        return this.maxApplications;
    }

    public int getMaxApplicationsPerUser() {
        return this.maxApplicationsPerUser;
    }

    public UsersManager getUsersManager() {
        return this.usersManager;
    }

    @Override
    public AbstractUsersManager getAbstractUsersManager() {
        return this.usersManager;
    }

    @Override
    public List<CSQueue> getChildQueues() {
        return null;
    }

    @VisibleForTesting
    void setUserLimit(int userLimit) {
        this.usersManager.setUserLimit(userLimit);
        this.usersManager.userLimitNeedsRecompute();
    }

    @VisibleForTesting
    void setUserLimitFactor(float userLimitFactor) {
        this.usersManager.setUserLimitFactor(userLimitFactor);
        this.usersManager.userLimitNeedsRecompute();
    }

    @Override
    public int getNumApplications() {
        try {
            this.readLock.lock();
            int n = this.getNumPendingApplications() + this.getNumActiveApplications();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getNumPendingApplications() {
        try {
            this.readLock.lock();
            int n = this.pendingOrderingPolicy.getNumSchedulableEntities();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getNumActiveApplications() {
        try {
            this.readLock.lock();
            int n = this.orderingPolicy.getNumSchedulableEntities();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public int getNumPendingApplications(String user) {
        try {
            this.readLock.lock();
            UsersManager.User u = this.getUser(user);
            if (null == u) {
                int n = 0;
                return n;
            }
            int n = u.getPendingApplications();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public int getNumActiveApplications(String user) {
        try {
            this.readLock.lock();
            UsersManager.User u = this.getUser(user);
            if (null == u) {
                int n = 0;
                return n;
            }
            int n = u.getActiveApplications();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public int getUserLimit() {
        return this.usersManager.getUserLimit();
    }

    @InterfaceAudience.Private
    public float getUserLimitFactor() {
        return this.usersManager.getUserLimitFactor();
    }

    @Override
    public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        QueueInfo queueInfo = this.getQueueInfo();
        return queueInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        try {
            this.readLock.lock();
            QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
            ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
            for (QueueACL operation : QueueACL.values()) {
                if (!this.hasAccess(operation, user)) continue;
                operations.add(operation);
            }
            userAclInfo.setQueueName(this.getQueueName());
            userAclInfo.setUserAcls(operations);
            List<QueueUserACLInfo> list = Collections.singletonList(userAclInfo);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        try {
            this.readLock.lock();
            String string = this.queueName + ": capacity=" + this.queueCapacities.getCapacity() + ", absoluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", usedResources=" + this.queueUsage.getUsed() + ", usedCapacity=" + this.getUsedCapacity() + ", absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + ", numApps=" + this.getNumApplications() + ", numContainers=" + this.getNumContainers();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    public UsersManager.User getUser(String userName) {
        return this.usersManager.getUser(userName);
    }

    @InterfaceAudience.Private
    public List<AppPriorityACLGroup> getPriorityACLs() {
        try {
            this.readLock.lock();
            ArrayList<AppPriorityACLGroup> arrayList = new ArrayList<AppPriorityACLGroup>(this.priorityAcls);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        try {
            this.writeLock.lock();
            if (!(newlyParsedQueue instanceof LeafQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
                throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
            }
            LeafQueue newlyParsedLeafQueue = (LeafQueue)newlyParsedQueue;
            Resource oldMax = this.getMaximumAllocation();
            Resource newMax = newlyParsedLeafQueue.getMaximumAllocation();
            if (newMax.getMemorySize() < oldMax.getMemorySize() || newMax.getVirtualCores() < oldMax.getVirtualCores()) {
                throw new IOException("Trying to reinitialize " + this.getQueuePath() + " the maximum allocation size can not be decreased! Current setting: " + oldMax + ", trying to set it to: " + newMax);
            }
            this.setupQueueConfigs(clusterResource);
            this.activateApplications();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName) {
        try {
            this.writeLock.lock();
            UsersManager.User user = this.usersManager.getUserAndAddIfAbsent(userName);
            this.addApplicationAttempt(application, user);
        }
        finally {
            this.writeLock.unlock();
        }
        if (application.isPending()) {
            this.metrics.submitAppAttempt(userName);
        }
        this.getParent().submitApplicationAttempt(application, userName);
    }

    @Override
    public void submitApplication(ApplicationId applicationId, String userName, String queue) throws AccessControlException {
        this.validateSubmitApplication(applicationId, userName, queue);
        try {
            this.getParent().submitApplication(applicationId, userName, queue);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application to parent-queue: " + this.getParent().getQueuePath()), (Throwable)ace);
            throw ace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateSubmitApplication(ApplicationId applicationId, String userName, String queue) throws AccessControlException {
        try {
            this.writeLock.lock();
            if (this.getState() != QueueState.RUNNING) {
                String msg = "Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + applicationId;
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            if (this.getNumApplications() >= this.getMaxApplications()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + this.getNumApplications() + " applications, cannot accept submission of application: " + applicationId;
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            UsersManager.User user = this.usersManager.getUserAndAddIfAbsent(userName);
            if (user.getTotalApplications() >= this.getMaxApplicationsPerUser()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + user.getTotalApplications() + " applications from user " + userName + " cannot accept submission of application: " + applicationId;
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            this.getParent().validateSubmitApplication(applicationId, userName, queue);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application to parent-queue: " + this.getParent().getQueuePath()), (Throwable)ace);
            throw ace;
        }
    }

    public Resource getAMResourceLimit() {
        return this.queueUsage.getAMLimit();
    }

    public Resource getAMResourceLimitPerPartition(String nodePartition) {
        return this.queueUsage.getAMLimit(nodePartition);
    }

    @VisibleForTesting
    public Resource calculateAndGetAMResourceLimit() {
        return this.calculateAndGetAMResourceLimitPerPartition("");
    }

    @VisibleForTesting
    public Resource getUserAMResourceLimit() {
        return this.getUserAMResourceLimitPerPartition("", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getUserAMResourceLimitPerPartition(String nodePartition, String userName) {
        float userWeight = 1.0f;
        if (userName != null && this.getUser(userName) != null) {
            userWeight = this.getUser(userName).getWeight();
        }
        try {
            float effectiveUserLimit;
            this.readLock.lock();
            float preWeightedUserLimit = effectiveUserLimit = Math.max((float)this.usersManager.getUserLimit() / 100.0f, 1.0f / (float)Math.max(this.getAbstractUsersManager().getNumActiveUsers(), 1));
            effectiveUserLimit = Math.min(effectiveUserLimit * userWeight, 1.0f);
            Resource queuePartitionResource = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel(nodePartition, this.lastClusterResource), (double)this.queueCapacities.getAbsoluteCapacity(nodePartition), (Resource)this.minimumAllocation);
            Resource userAMLimit = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionResource, (double)(this.queueCapacities.getMaxAMResourcePercentage(nodePartition) * effectiveUserLimit * this.usersManager.getUserLimitFactor()), (Resource)this.minimumAllocation);
            userAMLimit = Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)userAMLimit, (Resource)Resources.clone((Resource)this.getAMResourceLimitPerPartition(nodePartition)));
            Resource preWeighteduserAMLimit = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionResource, (double)(this.queueCapacities.getMaxAMResourcePercentage(nodePartition) * preWeightedUserLimit * this.usersManager.getUserLimitFactor()), (Resource)this.minimumAllocation);
            preWeighteduserAMLimit = Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)preWeighteduserAMLimit, (Resource)Resources.clone((Resource)this.getAMResourceLimitPerPartition(nodePartition)));
            this.queueUsage.setUserAMLimit(nodePartition, preWeighteduserAMLimit);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Effective user AM limit for \"" + userName + "\":" + preWeighteduserAMLimit + ". Effective weighted user AM limit: " + userAMLimit + ". User weight: " + userWeight));
            }
            Resource resource = userAMLimit;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource calculateAndGetAMResourceLimitPerPartition(String nodePartition) {
        try {
            this.writeLock.lock();
            Resource queuePartitionResource = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel(nodePartition, this.lastClusterResource), (double)this.queueCapacities.getAbsoluteCapacity(nodePartition), (Resource)this.minimumAllocation);
            Resource queueCurrentLimit = Resources.none();
            if (nodePartition.equals("")) {
                QueueResourceLimitsInfo queueResourceLimitsInfo = this.queueResourceLimitsInfo;
                synchronized (queueResourceLimitsInfo) {
                    queueCurrentLimit = this.queueResourceLimitsInfo.getQueueCurrentLimit();
                }
            }
            float amResourcePercent = this.queueCapacities.getMaxAMResourcePercentage(nodePartition);
            Resource queuePartitionUsableResource = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)queueCurrentLimit, (Resource)queuePartitionResource);
            Resource amResouceLimit = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionUsableResource, (double)amResourcePercent, (Resource)this.minimumAllocation);
            this.metrics.setAMResouceLimit(nodePartition, amResouceLimit);
            this.queueUsage.setAMLimit(nodePartition, amResouceLimit);
            Resource resource = amResouceLimit;
            return resource;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateApplications() {
        try {
            this.writeLock.lock();
            HashMap<String, Resource> userAmPartitionLimit = new HashMap<String, Resource>();
            for (String nodePartition : this.getNodeLabelsForQueue()) {
                this.calculateAndGetAMResourceLimitPerPartition(nodePartition);
            }
            Iterator<FiCaSchedulerApp> fsApp = this.getPendingAppsOrderingPolicy().getAssignmentIterator();
            while (fsApp.hasNext()) {
                Resource userAmIfStarted;
                FiCaSchedulerApp application = fsApp.next();
                ApplicationId applicationId = application.getApplicationId();
                String partitionName = application.getAppAMNodePartitionName();
                Resource amLimit = this.getAMResourceLimitPerPartition(partitionName);
                if (amLimit == null) {
                    amLimit = this.calculateAndGetAMResourceLimitPerPartition(partitionName);
                }
                Resource amIfStarted = Resources.add((Resource)application.getAMResource(partitionName), (Resource)this.queueUsage.getAMUsed(partitionName));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("application " + application.getId() + " AMResource " + application.getAMResource(partitionName) + " maxAMResourcePerQueuePercent " + this.maxAMResourcePerQueuePercent + " amLimit " + amLimit + " lastClusterResource " + this.lastClusterResource + " amIfStarted " + amIfStarted + " AM node-partition name " + partitionName));
                }
                if (!Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)amIfStarted, (Resource)amLimit)) {
                    if (this.getNumActiveApplications() < 1 || Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)this.queueUsage.getAMUsed(partitionName), (Resource)Resources.none())) {
                        LOG.warn((Object)"maximum-am-resource-percent is insufficient to start a single application in queue, it is likely set too low. skipping enforcement to allow at least one application to start");
                    } else {
                        application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "Queue's AM resource limit exceeded. ");
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Not activating application " + applicationId + " as  amIfStarted: " + amIfStarted + " exceeds amLimit: " + amLimit));
                        continue;
                    }
                }
                UsersManager.User user = this.getUser(application.getUser());
                Resource userAMLimit = (Resource)userAmPartitionLimit.get(partitionName);
                if (userAMLimit == null) {
                    userAMLimit = this.getUserAMResourceLimitPerPartition(partitionName, application.getUser());
                    userAmPartitionLimit.put(partitionName, userAMLimit);
                }
                if (!Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)(userAmIfStarted = Resources.add((Resource)application.getAMResource(partitionName), (Resource)user.getConsumedAMResources(partitionName))), (Resource)userAMLimit)) {
                    if (this.getNumActiveApplications() < 1 || Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)this.queueUsage.getAMUsed(partitionName), (Resource)Resources.none())) {
                        LOG.warn((Object)"maximum-am-resource-percent is insufficient to start a single application in queue for user, it is likely set too low. skipping enforcement to allow at least one application to start");
                    } else {
                        application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "User's AM resource limit exceeded. ");
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Not activating application " + applicationId + " for user: " + user + " as userAmIfStarted: " + userAmIfStarted + " exceeds userAmLimit: " + userAMLimit));
                        continue;
                    }
                }
                user.activateApplication();
                this.orderingPolicy.addSchedulableEntity(application);
                application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ACTIVATED, null);
                this.queueUsage.incAMUsed(partitionName, application.getAMResource(partitionName));
                user.getResourceUsage().incAMUsed(partitionName, application.getAMResource(partitionName));
                user.getResourceUsage().setAMLimit(partitionName, userAMLimit);
                this.metrics.incAMUsed(partitionName, application.getUser(), application.getAMResource(partitionName));
                this.metrics.setAMResouceLimitForUser(partitionName, application.getUser(), userAMLimit);
                fsApp.remove();
                LOG.info((Object)("Application " + applicationId + " from user: " + application.getUser() + " activated in queue: " + this.getQueueName()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void addApplicationAttempt(FiCaSchedulerApp application, UsersManager.User user) {
        try {
            this.writeLock.lock();
            user.submitApplication();
            this.getPendingAppsOrderingPolicy().addSchedulableEntity(application);
            this.applicationAttemptMap.put(application.getApplicationAttemptId(), application);
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)this.lastClusterResource, (Resource)Resources.none())) {
                this.activateApplications();
            } else {
                application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "Skipping AM assignment as cluster resource is empty. ");
                LOG.info((Object)("Skipping activateApplications for " + application.getApplicationAttemptId() + " since cluster resource is " + Resources.none()));
            }
            LOG.info((Object)("Application added - appId: " + application.getApplicationId() + " user: " + application.getUser() + ", leaf-queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void finishApplication(ApplicationId application, String user) {
        this.usersManager.deactivateApplication(user, application);
        this.appFinished();
        this.getParent().finishApplication(application, user);
    }

    @Override
    public void finishApplicationAttempt(FiCaSchedulerApp application, String queue) {
        this.removeApplicationAttempt(application, application.getUser());
        this.getParent().finishApplicationAttempt(application, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplicationAttempt(FiCaSchedulerApp application, String userName) {
        try {
            this.writeLock.lock();
            UsersManager.User user = this.usersManager.getUserAndAddIfAbsent(userName);
            String partitionName = application.getAppAMNodePartitionName();
            boolean wasActive = this.orderingPolicy.removeSchedulableEntity(application);
            if (!wasActive) {
                this.pendingOrderingPolicy.removeSchedulableEntity(application);
            } else {
                this.queueUsage.decAMUsed(partitionName, application.getAMResource(partitionName));
                user.getResourceUsage().decAMUsed(partitionName, application.getAMResource(partitionName));
                this.metrics.decAMUsed(partitionName, application.getUser(), application.getAMResource(partitionName));
            }
            this.applicationAttemptMap.remove(application.getApplicationAttemptId());
            user.finishApplication(wasActive);
            if (user.getTotalApplications() == 0) {
                this.usersManager.removeUser(application.getUser());
            }
            this.activateApplications();
            LOG.info((Object)("Application removed - appId: " + application.getApplicationId() + " user: " + application.getUser() + " queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private FiCaSchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return this.applicationAttemptMap.get(applicationAttemptId);
    }

    private void setPreemptionAllowed(ResourceLimits limits, String nodePartition) {
        float guaranteedCapacity;
        float usedCapacity = this.queueCapacities.getAbsoluteUsedCapacity(nodePartition);
        limits.setIsAllowPreemption(usedCapacity < (guaranteedCapacity = this.queueCapacities.getAbsoluteCapacity(nodePartition)));
    }

    private CSAssignment allocateFromReservedContainer(Resource clusterResource, PlacementSet<FiCaSchedulerNode> ps, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode) {
        FiCaSchedulerApp application;
        FiCaSchedulerNode node = PlacementSetUtils.getSingleNode(ps);
        if (null == node) {
            return null;
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null && null != (application = this.getApplication(reservedContainer.getApplicationAttemptId()))) {
            ActivitiesLogger.APP.startAppAllocationRecording(this.activitiesManager, node.getNodeID(), SystemClock.getInstance().getTime(), application);
            CSAssignment assignment = application.assignContainers(clusterResource, ps, currentResourceLimits, schedulingMode, reservedContainer);
            return assignment;
        }
        return null;
    }

    @Override
    public CSAssignment assignContainers(Resource clusterResource, PlacementSet<FiCaSchedulerNode> ps, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode) {
        this.updateCurrentResourceLimits(currentResourceLimits, clusterResource);
        FiCaSchedulerNode node = PlacementSetUtils.getSingleNode(ps);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: partition=" + ps.getPartition() + " #applications=" + this.orderingPolicy.getNumSchedulableEntities()));
        }
        this.setPreemptionAllowed(currentResourceLimits, ps.getPartition());
        CSAssignment assignment = this.allocateFromReservedContainer(clusterResource, ps, currentResourceLimits, schedulingMode);
        if (null != assignment) {
            return assignment;
        }
        if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY && !this.accessibleToPartition(ps.getPartition())) {
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParent().getQueueName(), this.getQueueName(), ActivityState.REJECTED, "Not able to access partition" + ps.getPartition());
            return CSAssignment.NULL_ASSIGNMENT;
        }
        if (!this.hasPendingResourceRequest(ps.getPartition(), clusterResource, schedulingMode)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skip this queue=" + this.getQueuePath() + ", because it doesn't need more resource, schedulingMode=" + schedulingMode.name() + " node-partition=" + ps.getPartition()));
            }
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParent().getQueueName(), this.getQueueName(), ActivityState.SKIPPED, "Queue does not need more resource");
            return CSAssignment.NULL_ASSIGNMENT;
        }
        HashMap<String, CachedUserLimit> userLimits = new HashMap<String, CachedUserLimit>();
        boolean needAssignToQueueCheck = true;
        Iterator<FiCaSchedulerApp> assignmentIterator = this.orderingPolicy.getAssignmentIterator();
        while (assignmentIterator.hasNext()) {
            Resource assigned;
            FiCaSchedulerApp application = assignmentIterator.next();
            ActivitiesLogger.APP.startAppAllocationRecording(this.activitiesManager, node.getNodeID(), SystemClock.getInstance().getTime(), application);
            Resource appReserved = application.getCurrentReservation();
            if (needAssignToQueueCheck) {
                if (!super.canAssignToThisQueue(clusterResource, node.getPartition(), currentResourceLimits, appReserved, schedulingMode)) {
                    ActivitiesLogger.APP.recordRejectedAppActivityFromLeafQueue(this.activitiesManager, node, application, application.getPriority(), "Hit queue max-capacity limit");
                    ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParent().getQueueName(), this.getQueueName(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY);
                    return CSAssignment.NULL_ASSIGNMENT;
                }
                if (!this.reservationsContinueLooking || appReserved.equals((Object)Resources.none())) {
                    needAssignToQueueCheck = false;
                }
            }
            CachedUserLimit cul = (CachedUserLimit)userLimits.get(application.getUser());
            Resource cachedUserLimit = null;
            if (cul != null) {
                cachedUserLimit = cul.userLimit;
            }
            Resource userLimit = this.computeUserLimitAndSetHeadroom(application, clusterResource, ps.getPartition(), schedulingMode, cachedUserLimit);
            if (cul == null) {
                cul = new CachedUserLimit(userLimit);
                userLimits.put(application.getUser(), cul);
            }
            boolean userAssignable = true;
            if (!cul.canAssign && Resources.fitsIn((Resource)appReserved, (Resource)cul.reservation)) {
                userAssignable = false;
            } else {
                userAssignable = this.canAssignToUser(clusterResource, application.getUser(), userLimit, application, node.getPartition(), currentResourceLimits);
                if (!userAssignable && Resources.fitsIn((Resource)cul.reservation, (Resource)appReserved)) {
                    cul.canAssign = false;
                    cul.reservation = appReserved;
                }
            }
            if (!userAssignable) {
                application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ACTIVATED, "User capacity has reached its maximum limit.");
                ActivitiesLogger.APP.recordRejectedAppActivityFromLeafQueue(this.activitiesManager, node, application, application.getPriority(), "Hit user capacity maximum limit");
                continue;
            }
            assignment = application.assignContainers(clusterResource, ps, currentResourceLimits, schedulingMode, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("post-assignContainers for application " + application.getApplicationId()));
                application.showRequests();
            }
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)(assigned = assignment.getResource()), (Resource)Resources.none())) {
                ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParent().getQueueName(), this.getQueueName(), ActivityState.ACCEPTED, ActivityDiagnosticConstant.EMPTY);
                return assignment;
            }
            if (assignment.getSkippedType() == CSAssignment.SkippedType.OTHER) {
                ActivitiesLogger.APP.finishSkippedAppAllocationRecording(this.activitiesManager, application.getApplicationId(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY);
                application.updateNodeInfoForAMDiagnostics(node);
                continue;
            }
            if (assignment.getSkippedType() == CSAssignment.SkippedType.QUEUE_LIMIT) {
                return assignment;
            }
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParent().getQueueName(), this.getQueueName(), ActivityState.SKIPPED, "To respect FIFO of applications, skipped following applications in the queue");
            ActivitiesLogger.APP.finishSkippedAppAllocationRecording(this.activitiesManager, application.getApplicationId(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY);
            return CSAssignment.NULL_ASSIGNMENT;
        }
        ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, this.getParent().getQueueName(), this.getQueueName(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY);
        return CSAssignment.NULL_ASSIGNMENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
        SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
        if (allocation.getAllocateFromReservedContainer() == null) {
            try {
                this.readLock.lock();
                FiCaSchedulerApp app = schedulerContainer.getSchedulerApplicationAttempt();
                String username = app.getUser();
                String p = schedulerContainer.getNodePartition();
                Resource userLimit = this.computeUserLimitAndSetHeadroom(app, cluster, p, allocation.getSchedulingMode(), null);
                UsersManager.User user = this.getUser(username);
                if (user == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("User " + username + " has been removed!"));
                    }
                    boolean bl = false;
                    return bl;
                }
                Resource usedResource = Resources.clone((Resource)user.getUsed(p));
                Resources.subtractFrom((Resource)usedResource, (Resource)request.getTotalReleasedResource());
                if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)usedResource, (Resource)userLimit)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Used resource=" + usedResource + " exceeded user-limit=" + userLimit));
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        return super.accept(cluster, request);
    }

    private void internalReleaseContainer(Resource clusterResource, SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer) {
        RMContainer rmContainer = schedulerContainer.getRmContainer();
        LeafQueue targetLeafQueue = schedulerContainer.getSchedulerApplicationAttempt().getCSLeafQueue();
        if (targetLeafQueue == this) {
            if (rmContainer.getState() == RMContainerState.RESERVED) {
                this.completedContainer(clusterResource, schedulerContainer.getSchedulerApplicationAttempt(), schedulerContainer.getSchedulerNode(), rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container reservation no longer required."), RMContainerEventType.RELEASED, null, false);
            }
        } else {
            targetLeafQueue.completedContainer(clusterResource, schedulerContainer.getSchedulerApplicationAttempt(), schedulerContainer.getSchedulerNode(), schedulerContainer.getRmContainer(), SchedulerUtils.createPreemptedContainerStatus(rmContainer.getContainerId(), "Container preempted by scheduler"), RMContainerEventType.KILL, null, false);
        }
    }

    private void releaseContainers(Resource clusterResource, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        for (SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer : request.getContainersToRelease()) {
            this.internalReleaseContainer(clusterResource, schedulerContainer);
        }
        if (null != request.getContainersToAllocate() && !request.getContainersToAllocate().isEmpty()) {
            for (ContainerAllocationProposal containerAllocationProposal : request.getContainersToAllocate()) {
                if (null == containerAllocationProposal.getToRelease()) continue;
                for (SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer : containerAllocationProposal.getToRelease()) {
                    this.internalReleaseContainer(clusterResource, schedulerContainer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        boolean applyToParentQueue = false;
        this.releaseContainers(cluster, request);
        try {
            this.writeLock.lock();
            if (request.anythingAllocatedOrReserved()) {
                ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
                SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
                if (allocation.getAllocateFromReservedContainer() == null) {
                    applyToParentQueue = true;
                    this.allocateResource(cluster, schedulerContainer.getSchedulerApplicationAttempt(), allocation.getAllocatedOrReservedResource(), schedulerContainer.getNodePartition(), schedulerContainer.getRmContainer());
                    this.orderingPolicy.containerAllocated(schedulerContainer.getSchedulerApplicationAttempt(), schedulerContainer.getRmContainer());
                }
                if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)request.getTotalReservedResource(), (Resource)Resources.none())) {
                    this.incReservedResource(schedulerContainer.getNodePartition(), request.getTotalReservedResource());
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.parent != null && applyToParentQueue) {
            this.parent.apply(cluster, request);
        }
    }

    protected Resource getHeadroom(UsersManager.User user, Resource queueCurrentLimit, Resource clusterResource, FiCaSchedulerApp application) {
        return this.getHeadroom(user, queueCurrentLimit, clusterResource, application, "");
    }

    protected Resource getHeadroom(UsersManager.User user, Resource queueCurrentLimit, Resource clusterResource, FiCaSchedulerApp application, String partition) {
        return this.getHeadroom(user, queueCurrentLimit, clusterResource, this.getResourceLimitForActiveUsers(application.getUser(), clusterResource, partition, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), partition);
    }

    private Resource getHeadroom(UsersManager.User user, Resource currentPartitionResourceLimit, Resource clusterResource, Resource userLimitResource, String partition) {
        currentPartitionResourceLimit = partition.equals("") ? currentPartitionResourceLimit : this.getQueueMaxResource(partition, clusterResource);
        Resource headroom = Resources.componentwiseMin((Resource)Resources.subtract((Resource)userLimitResource, (Resource)user.getUsed(partition)), (Resource)Resources.subtract((Resource)currentPartitionResourceLimit, (Resource)this.queueUsage.getUsed(partition)));
        headroom = Resources.roundDown((ResourceCalculator)this.resourceCalculator, (Resource)headroom, (Resource)this.minimumAllocation);
        Resource clusterPartitionResource = this.labelManager.getResourceByLabel(partition, clusterResource);
        Resource clusterFreePartitionResource = Resources.subtract((Resource)clusterPartitionResource, (Resource)this.csContext.getClusterResourceUsage().getUsed(partition));
        headroom = Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterPartitionResource, (Resource)clusterFreePartitionResource, (Resource)headroom);
        return headroom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setQueueResourceLimitsInfo(Resource clusterResource) {
        QueueResourceLimitsInfo queueResourceLimitsInfo = this.queueResourceLimitsInfo;
        synchronized (queueResourceLimitsInfo) {
            this.queueResourceLimitsInfo.setQueueCurrentLimit(this.cachedResourceLimitsForHeadroom.getLimit());
            this.queueResourceLimitsInfo.setClusterResource(clusterResource);
        }
    }

    @Lock(value={LeafQueue.class})
    Resource computeUserLimitAndSetHeadroom(FiCaSchedulerApp application, Resource clusterResource, String nodePartition, SchedulingMode schedulingMode, Resource userLimit) {
        Resource headroom;
        String user = application.getUser();
        UsersManager.User queueUser = this.getUser(user);
        if (queueUser == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User " + user + " has been removed!"));
            }
            return Resources.none();
        }
        if (userLimit == null) {
            userLimit = this.getResourceLimitForActiveUsers(application.getUser(), clusterResource, nodePartition, schedulingMode);
        }
        this.setQueueResourceLimitsInfo(clusterResource);
        Resource resource = headroom = this.metrics.getUserMetrics(user) == null ? Resources.none() : this.getHeadroom(queueUser, this.cachedResourceLimitsForHeadroom.getLimit(), clusterResource, userLimit, nodePartition);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Headroom calculation for user " + user + ":  userLimit=" + userLimit + " queueMaxAvailRes=" + this.cachedResourceLimitsForHeadroom.getLimit() + " consumed=" + queueUser.getUsed() + " partition=" + nodePartition));
        }
        CapacityHeadroomProvider headroomProvider = new CapacityHeadroomProvider(queueUser, this, application, this.queueResourceLimitsInfo);
        application.setHeadroomProvider(headroomProvider);
        this.metrics.setAvailableResourcesToUser(nodePartition, user, headroom);
        return userLimit;
    }

    @Lock(value={Lock.NoLock.class})
    public int getNodeLocalityDelay() {
        return this.nodeLocalityDelay;
    }

    @Lock(value={Lock.NoLock.class})
    public int getRackLocalityAdditionalDelay() {
        return this.rackLocalityAdditionalDelay;
    }

    @Lock(value={Lock.NoLock.class})
    public boolean getRackLocalityFullReset() {
        return this.rackLocalityFullReset;
    }

    public Resource getResourceLimitForActiveUsers(String userName, Resource clusterResource, String nodePartition, SchedulingMode schedulingMode) {
        return this.usersManager.getComputedResourceLimitForActiveUsers(userName, clusterResource, nodePartition, schedulingMode);
    }

    public Resource getResourceLimitForAllUsers(String userName, Resource clusterResource, String nodePartition, SchedulingMode schedulingMode) {
        return this.usersManager.getComputedResourceLimitForAllUsers(userName, clusterResource, nodePartition, schedulingMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    protected boolean canAssignToUser(Resource clusterResource, String userName, Resource limit, FiCaSchedulerApp application, String nodePartition, ResourceLimits currentResourceLimits) {
        try {
            this.readLock.lock();
            UsersManager.User user = this.getUser(userName);
            if (user == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User " + userName + " has been removed!"));
                }
                boolean bl = false;
                return bl;
            }
            currentResourceLimits.setAmountNeededUnreserve(Resources.none());
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)user.getUsed(nodePartition), (Resource)limit)) {
                if (this.reservationsContinueLooking && nodePartition.equals("") && Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.subtract((Resource)user.getUsed(), (Resource)application.getCurrentReservation()), (Resource)limit)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("User " + userName + " in queue " + this.getQueueName() + " will exceed limit based on reservations -  consumed: " + user.getUsed() + " reserved: " + application.getCurrentReservation() + " limit: " + limit));
                    }
                    Resource amountNeededToUnreserve = Resources.subtract((Resource)user.getUsed(nodePartition), (Resource)limit);
                    currentResourceLimits.setAmountNeededUnreserve(amountNeededToUnreserve);
                    boolean bl = true;
                    return bl;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User " + userName + " in queue " + this.getQueueName() + " will exceed limit -  consumed: " + user.getUsed(nodePartition) + " limit: " + limit));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void updateSchedulerHealthForCompletedContainer(RMContainer rmContainer, ContainerStatus containerStatus) {
        SchedulerHealth schedulerHealth = this.csContext.getSchedulerHealth();
        if (null == schedulerHealth) {
            return;
        }
        if (containerStatus.getExitStatus() == -102) {
            schedulerHealth.updatePreemption(Time.now(), rmContainer.getAllocatedNode(), rmContainer.getContainerId(), this.getQueuePath());
            schedulerHealth.updateSchedulerPreemptionCounts(1L);
        } else {
            schedulerHealth.updateRelease(this.csContext.getLastNodeUpdateTime(), rmContainer.getAllocatedNode(), rmContainer.getContainerId(), this.getQueuePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculateQueueUsageRatio(Resource clusterResource, String nodePartition) {
        try {
            this.writeLock.lock();
            ResourceUsage queueResourceUsage = this.getQueueResourceUsage();
            if (nodePartition == null) {
                for (String partition : Sets.union(this.getQueueCapacities().getNodePartitionsSet(), queueResourceUsage.getNodePartitionsSet())) {
                    this.usersManager.updateUsageRatio(partition, clusterResource);
                }
            } else {
                this.usersManager.updateUsageRatio(nodePartition, clusterResource);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedContainer(Resource clusterResource, FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, CSQueue childQueue, boolean sortQueues) {
        this.updateSchedulerHealthForCompletedContainer(rmContainer, containerStatus);
        if (application != null) {
            boolean removed = false;
            try {
                this.writeLock.lock();
                Container container = rmContainer.getContainer();
                if (rmContainer.getState() == RMContainerState.RESERVED) {
                    removed = application.unreserve(rmContainer.getReservedSchedulerKey(), node, rmContainer);
                } else {
                    removed = application.containerCompleted(rmContainer, containerStatus, event, node.getPartition());
                    node.releaseContainer(rmContainer.getContainerId(), false);
                }
                if (removed) {
                    this.orderingPolicy.containerReleased(application, rmContainer);
                    this.releaseResource(clusterResource, application, container.getResource(), node.getPartition(), rmContainer);
                }
            }
            finally {
                this.writeLock.unlock();
            }
            if (removed) {
                this.getParent().completedContainer(clusterResource, application, node, rmContainer, null, event, this, sortQueues);
            }
        }
        this.csContext.getPreemptionManager().removeKillableContainer(new KillableContainer(rmContainer, node.getPartition(), this.queueName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateResource(Resource clusterResource, SchedulerApplicationAttempt application, Resource resource, String nodePartition, RMContainer rmContainer) {
        try {
            this.writeLock.lock();
            super.allocateResource(clusterResource, resource, nodePartition);
            if (null != rmContainer && rmContainer.getNodeLabelExpression().equals("") && !nodePartition.equals("")) {
                TreeSet<RMContainer> rmContainers = null;
                rmContainers = this.ignorePartitionExclusivityRMContainers.get(nodePartition);
                if (null == rmContainers) {
                    rmContainers = new TreeSet();
                    this.ignorePartitionExclusivityRMContainers.put(nodePartition, rmContainers);
                }
                rmContainers.add(rmContainer);
            }
            String userName = application.getUser();
            UsersManager.User user = this.usersManager.updateUserResourceUsage(userName, resource, nodePartition, true);
            Resources.subtractFrom((Resource)application.getHeadroom(), (Resource)resource);
            this.metrics.setAvailableResourcesToUser(nodePartition, userName, application.getHeadroom());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getQueueName() + " user=" + userName + " used=" + this.queueUsage.getUsed(nodePartition) + " numContainers=" + this.numContainers + " headroom = " + application.getHeadroom() + " user-resources=" + user.getUsed()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseResource(Resource clusterResource, FiCaSchedulerApp application, Resource resource, String nodePartition, RMContainer rmContainer) {
        try {
            this.writeLock.lock();
            super.releaseResource(clusterResource, resource, nodePartition);
            if (null != rmContainer && rmContainer.getNodeLabelExpression().equals("") && !nodePartition.equals("") && this.ignorePartitionExclusivityRMContainers.containsKey(nodePartition)) {
                Set rmContainers = this.ignorePartitionExclusivityRMContainers.get(nodePartition);
                rmContainers.remove(rmContainer);
                if (rmContainers.isEmpty()) {
                    this.ignorePartitionExclusivityRMContainers.remove(nodePartition);
                }
            }
            String userName = application.getUser();
            UsersManager.User user = this.usersManager.updateUserResourceUsage(userName, resource, nodePartition, false);
            this.metrics.setAvailableResourcesToUser(nodePartition, userName, application.getHeadroom());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getQueueName() + " used=" + this.queueUsage.getUsed() + " numContainers=" + this.numContainers + " user=" + userName + " user-resources=" + user.getUsed()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateCurrentResourceLimits(ResourceLimits currentResourceLimits, Resource clusterResource) {
        this.cachedResourceLimitsForHeadroom = new ResourceLimits(currentResourceLimits.getLimit());
        Resource queueMaxResource = Resources.multiplyAndNormalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel("", clusterResource), (double)this.queueCapacities.getAbsoluteMaximumCapacity(""), (Resource)this.minimumAllocation);
        this.cachedResourceLimitsForHeadroom.setLimit(Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)queueMaxResource, (Resource)currentResourceLimits.getLimit()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterResource(Resource clusterResource, ResourceLimits currentResourceLimits) {
        try {
            this.writeLock.lock();
            this.updateCurrentResourceLimits(currentResourceLimits, clusterResource);
            this.lastClusterResource = clusterResource;
            this.setQueueResourceLimitsInfo(clusterResource);
            this.recalculateQueueUsageRatio(clusterResource, null);
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, null);
            this.activateApplications();
            this.usersManager.userLimitNeedsRecompute();
            for (FiCaSchedulerApp application : this.orderingPolicy.getSchedulableEntities()) {
                this.computeUserLimitAndSetHeadroom(application, clusterResource, "", SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, null);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void incUsedResource(String nodeLabel, Resource resourceToInc, SchedulerApplicationAttempt application) {
        this.usersManager.updateUserResourceUsage(application.getUser(), resourceToInc, nodeLabel, true);
        super.incUsedResource(nodeLabel, resourceToInc, application);
    }

    @Override
    public void decUsedResource(String nodeLabel, Resource resourceToDec, SchedulerApplicationAttempt application) {
        this.usersManager.updateUserResourceUsage(application.getUser(), resourceToDec, nodeLabel, false);
        super.decUsedResource(nodeLabel, resourceToDec, application);
    }

    public void incAMUsedResource(String nodeLabel, Resource resourceToInc, SchedulerApplicationAttempt application) {
        this.getUser(application.getUser()).getResourceUsage().incAMUsed(nodeLabel, resourceToInc);
        this.queueUsage.incAMUsed(nodeLabel, resourceToInc);
    }

    public void decAMUsedResource(String nodeLabel, Resource resourceToDec, SchedulerApplicationAttempt application) {
        this.getUser(application.getUser()).getResourceUsage().decAMUsed(nodeLabel, resourceToDec);
        this.queueUsage.decAMUsed(nodeLabel, resourceToDec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt attempt, RMContainer rmContainer) {
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        if (rmContainer.getExecutionType() != ExecutionType.GUARANTEED) {
            return;
        }
        try {
            this.writeLock.lock();
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, attempt, rmContainer.getContainer().getResource(), node.getPartition(), rmContainer);
        }
        finally {
            this.writeLock.unlock();
        }
        this.getParent().recoverContainer(clusterResource, attempt, rmContainer);
    }

    public Collection<FiCaSchedulerApp> getPendingApplications() {
        return Collections.unmodifiableCollection(this.pendingOrderingPolicy.getSchedulableEntities());
    }

    public Collection<FiCaSchedulerApp> getApplications() {
        return Collections.unmodifiableCollection(this.orderingPolicy.getSchedulableEntities());
    }

    public Collection<FiCaSchedulerApp> getAllApplications() {
        HashSet<FiCaSchedulerApp> apps = new HashSet<FiCaSchedulerApp>(this.pendingOrderingPolicy.getSchedulableEntities());
        apps.addAll(this.orderingPolicy.getSchedulableEntities());
        return Collections.unmodifiableCollection(apps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getTotalPendingResourcesConsideringUserLimit(Resource clusterResources, String partition, boolean deductReservedFromPending) {
        try {
            this.readLock.lock();
            HashMap<String, Resource> userNameToHeadroom = new HashMap<String, Resource>();
            Resource totalPendingConsideringUserLimit = Resource.newInstance((int)0, (int)0);
            for (FiCaSchedulerApp app : this.getApplications()) {
                String userName = app.getUser();
                if (!userNameToHeadroom.containsKey(userName)) {
                    UsersManager.User user = this.getUser(userName);
                    Resource headroom = Resources.subtract((Resource)this.getResourceLimitForActiveUsers(app.getUser(), clusterResources, partition, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Resource)user.getUsed(partition));
                    headroom = Resources.componentwiseMax((Resource)headroom, (Resource)Resources.none());
                    userNameToHeadroom.put(userName, headroom);
                }
                Resource pending = app.getAppAttemptResourceUsage().getPending(partition);
                if (deductReservedFromPending) {
                    pending = Resources.subtract((Resource)pending, (Resource)app.getAppAttemptResourceUsage().getReserved(partition));
                }
                pending = Resources.componentwiseMax((Resource)pending, (Resource)Resources.none());
                Resource minpendingConsideringUserLimit = Resources.componentwiseMin((Resource)((Resource)userNameToHeadroom.get(userName)), (Resource)pending);
                Resources.addTo((Resource)totalPendingConsideringUserLimit, (Resource)minpendingConsideringUserLimit);
                Resources.subtractFrom((Resource)((Resource)userNameToHeadroom.get(userName)), (Resource)minpendingConsideringUserLimit);
            }
            Resource resource = totalPendingConsideringUserLimit;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        try {
            this.readLock.lock();
            for (FiCaSchedulerApp pendingApp : this.pendingOrderingPolicy.getSchedulableEntities()) {
                apps.add(pendingApp.getApplicationAttemptId());
            }
            for (FiCaSchedulerApp app : this.orderingPolicy.getSchedulableEntities()) {
                apps.add(app.getApplicationAttemptId());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void attachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null && rmContainer != null && rmContainer.getExecutionType() == ExecutionType.GUARANTEED) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, application, rmContainer.getContainer().getResource(), node.getPartition(), rmContainer);
            LOG.info((Object)("movedContainer container=" + rmContainer.getContainer() + " resource=" + rmContainer.getContainer().getResource() + " queueMoveIn=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            this.getParent().attachContainer(clusterResource, application, rmContainer);
        }
    }

    @Override
    public void detachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null && rmContainer != null && rmContainer.getExecutionType() == ExecutionType.GUARANTEED) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.releaseResource(clusterResource, application, rmContainer.getContainer().getResource(), node.getPartition(), rmContainer);
            LOG.info((Object)("movedContainer container=" + rmContainer.getContainer() + " resource=" + rmContainer.getContainer().getResource() + " queueMoveOut=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            this.getParent().detachContainer(clusterResource, application, rmContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TreeSet<RMContainer>> getIgnoreExclusivityRMContainers() {
        HashMap clonedMap = new HashMap();
        try {
            this.readLock.lock();
            for (Map.Entry<String, TreeSet<RMContainer>> entry : this.ignorePartitionExclusivityRMContainers.entrySet()) {
                clonedMap.put(entry.getKey(), new TreeSet(entry.getValue()));
            }
            HashMap hashMap = clonedMap;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setCapacity(float capacity) {
        this.queueCapacities.setCapacity(capacity);
    }

    public void setAbsoluteCapacity(float absoluteCapacity) {
        this.queueCapacities.setAbsoluteCapacity(absoluteCapacity);
    }

    public void setMaxApplications(int maxApplications) {
        this.maxApplications = maxApplications;
    }

    public OrderingPolicy<FiCaSchedulerApp> getOrderingPolicy() {
        return this.orderingPolicy;
    }

    void setOrderingPolicy(OrderingPolicy<FiCaSchedulerApp> orderingPolicy) {
        try {
            this.writeLock.lock();
            if (null != this.orderingPolicy) {
                orderingPolicy.addAllSchedulableEntities(this.orderingPolicy.getSchedulableEntities());
            }
            this.orderingPolicy = orderingPolicy;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Priority getDefaultApplicationPriority() {
        return this.defaultAppPriorityPerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplicationPriority(SchedulerApplication<FiCaSchedulerApp> app, Priority newAppPriority) {
        try {
            this.writeLock.lock();
            FiCaSchedulerApp attempt = app.getCurrentAppAttempt();
            boolean isActive = this.orderingPolicy.removeSchedulableEntity(attempt);
            if (!isActive) {
                this.pendingOrderingPolicy.removeSchedulableEntity(attempt);
            }
            attempt.setPriority(newAppPriority);
            if (isActive) {
                this.orderingPolicy.addSchedulableEntity(attempt);
            } else {
                this.pendingOrderingPolicy.addSchedulableEntity(attempt);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OrderingPolicy<FiCaSchedulerApp> getPendingAppsOrderingPolicy() {
        return this.pendingOrderingPolicy;
    }

    @Override
    public void stopQueue() {
        try {
            this.writeLock.lock();
            if (this.getNumApplications() > 0) {
                this.updateQueueState(QueueState.DRAINING);
            } else {
                this.updateQueueState(QueueState.STOPPED);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> getAllUsers() {
        return this.getUsersManager().getUsers().keySet();
    }

    public long getMaximumApplicationLifetime() {
        return this.maxApplicationLifetime;
    }

    public long getDefaultApplicationLifetime() {
        return this.defaultApplicationLifetime;
    }

    static class CachedUserLimit {
        final Resource userLimit;
        boolean canAssign = true;
        Resource reservation = Resources.none();

        CachedUserLimit(Resource userLimit) {
            this.userLimit = userLimit;
        }
    }

    static class QueueResourceLimitsInfo {
        private Resource queueCurrentLimit;
        private Resource clusterResource;

        QueueResourceLimitsInfo() {
        }

        public void setQueueCurrentLimit(Resource currentLimit) {
            this.queueCurrentLimit = currentLimit;
        }

        public Resource getQueueCurrentLimit() {
            return this.queueCurrentLimit;
        }

        public void setClusterResource(Resource clusterResource) {
            this.clusterResource = clusterResource;
        }

        public Resource getClusterResource() {
            return this.clusterResource;
        }
    }
}

