/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.ReservationACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AppPriorityACLConfigurationParser;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AppPriorityACLGroup;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.PriorityUtilizationQueueOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.QueueOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FairOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class CapacitySchedulerConfiguration
extends ReservationSchedulerConfiguration {
    private static final Log LOG = LogFactory.getLog(CapacitySchedulerConfiguration.class);
    private static final String CS_CONFIGURATION_FILE = "capacity-scheduler.xml";
    @InterfaceAudience.Private
    public static final String PREFIX = "yarn.scheduler.capacity.";
    @InterfaceAudience.Private
    public static final String DOT = ".";
    @InterfaceAudience.Private
    public static final String MAXIMUM_APPLICATIONS_SUFFIX = "maximum-applications";
    @InterfaceAudience.Private
    public static final String MAXIMUM_SYSTEM_APPLICATIONS = "yarn.scheduler.capacity.maximum-applications";
    @InterfaceAudience.Private
    public static final String MAXIMUM_AM_RESOURCE_SUFFIX = "maximum-am-resource-percent";
    @InterfaceAudience.Private
    public static final String MAXIMUM_APPLICATION_MASTERS_RESOURCE_PERCENT = "yarn.scheduler.capacity.maximum-am-resource-percent";
    @InterfaceAudience.Private
    public static final String QUEUES = "queues";
    @InterfaceAudience.Private
    public static final String CAPACITY = "capacity";
    @InterfaceAudience.Private
    public static final String MAXIMUM_CAPACITY = "maximum-capacity";
    @InterfaceAudience.Private
    public static final String USER_LIMIT = "minimum-user-limit-percent";
    @InterfaceAudience.Private
    public static final String USER_LIMIT_FACTOR = "user-limit-factor";
    @InterfaceAudience.Private
    public static final String USER_WEIGHT = "weight";
    @InterfaceAudience.Private
    public static final String USER_SETTINGS = "user-settings";
    @InterfaceAudience.Private
    public static final float DEFAULT_USER_WEIGHT = 1.0f;
    @InterfaceAudience.Private
    public static final String STATE = "state";
    @InterfaceAudience.Private
    public static final String ACCESSIBLE_NODE_LABELS = "accessible-node-labels";
    @InterfaceAudience.Private
    public static final String DEFAULT_NODE_LABEL_EXPRESSION = "default-node-label-expression";
    public static final String RESERVE_CONT_LOOK_ALL_NODES = "yarn.scheduler.capacity.reservations-continue-look-all-nodes";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_RESERVE_CONT_LOOK_ALL_NODES = true;
    @InterfaceAudience.Private
    public static final String MAXIMUM_ALLOCATION_MB = "maximum-allocation-mb";
    @InterfaceAudience.Private
    public static final String MAXIMUM_ALLOCATION_VCORES = "maximum-allocation-vcores";
    public static final String ORDERING_POLICY = "ordering-policy";
    public static final String FIFO_APP_ORDERING_POLICY = "fifo";
    public static final String FAIR_APP_ORDERING_POLICY = "fair";
    public static final String DEFAULT_APP_ORDERING_POLICY = "fifo";
    @InterfaceAudience.Private
    public static final int DEFAULT_MAXIMUM_SYSTEM_APPLICATIIONS = 10000;
    @InterfaceAudience.Private
    public static final float DEFAULT_MAXIMUM_APPLICATIONMASTERS_RESOURCE_PERCENT = 0.1f;
    @InterfaceAudience.Private
    public static final float UNDEFINED = -1.0f;
    @InterfaceAudience.Private
    public static final float MINIMUM_CAPACITY_VALUE = 0.0f;
    @InterfaceAudience.Private
    public static final float MAXIMUM_CAPACITY_VALUE = 100.0f;
    @InterfaceAudience.Private
    public static final float DEFAULT_MAXIMUM_CAPACITY_VALUE = -1.0f;
    @InterfaceAudience.Private
    public static final int DEFAULT_USER_LIMIT = 100;
    @InterfaceAudience.Private
    public static final float DEFAULT_USER_LIMIT_FACTOR = 1.0f;
    @InterfaceAudience.Private
    public static final String ALL_ACL = "*";
    @InterfaceAudience.Private
    public static final String NONE_ACL = " ";
    @InterfaceAudience.Private
    public static final String ENABLE_USER_METRICS = "yarn.scheduler.capacity.user-metrics.enable";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_ENABLE_USER_METRICS = false;
    @InterfaceAudience.Private
    public static final String RESOURCE_CALCULATOR_CLASS = "yarn.scheduler.capacity.resource-calculator";
    @InterfaceAudience.Private
    public static final Class<? extends ResourceCalculator> DEFAULT_RESOURCE_CALCULATOR_CLASS = DefaultResourceCalculator.class;
    @InterfaceAudience.Private
    public static final String ROOT = "root";
    @InterfaceAudience.Private
    public static final String NODE_LOCALITY_DELAY = "yarn.scheduler.capacity.node-locality-delay";
    @InterfaceAudience.Private
    public static final int DEFAULT_NODE_LOCALITY_DELAY = 40;
    @InterfaceAudience.Private
    public static final String RACK_LOCALITY_ADDITIONAL_DELAY = "yarn.scheduler.capacity.rack-locality-additional-delay";
    @InterfaceAudience.Private
    public static final int DEFAULT_RACK_LOCALITY_ADDITIONAL_DELAY = -1;
    @InterfaceAudience.Private
    public static final String RACK_LOCALITY_FULL_RESET = "yarn.scheduler.capacity.rack-locality-full-reset";
    @InterfaceAudience.Private
    public static final int DEFAULT_OFFSWITCH_PER_HEARTBEAT_LIMIT = 1;
    @InterfaceAudience.Private
    public static final String OFFSWITCH_PER_HEARTBEAT_LIMIT = "yarn.scheduler.capacity.per-node-heartbeat.maximum-offswitch-assignments";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_RACK_LOCALITY_FULL_RESET = true;
    @InterfaceAudience.Private
    public static final String SCHEDULE_ASYNCHRONOUSLY_PREFIX = "yarn.scheduler.capacity.schedule-asynchronously";
    @InterfaceAudience.Private
    public static final String SCHEDULE_ASYNCHRONOUSLY_ENABLE = "yarn.scheduler.capacity.schedule-asynchronously.enable";
    @InterfaceAudience.Private
    public static final String SCHEDULE_ASYNCHRONOUSLY_MAXIMUM_THREAD = "yarn.scheduler.capacity.schedule-asynchronously.maximum-threads";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_SCHEDULE_ASYNCHRONOUSLY_ENABLE = false;
    @InterfaceAudience.Private
    public static final String QUEUE_MAPPING = "yarn.scheduler.capacity.queue-mappings";
    @InterfaceAudience.Private
    public static final String ENABLE_QUEUE_MAPPING_OVERRIDE = "yarn.scheduler.capacity.queue-mappings-override.enable";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_ENABLE_QUEUE_MAPPING_OVERRIDE = false;
    @InterfaceAudience.Private
    public static final String QUEUE_PREEMPTION_DISABLED = "disable_preemption";
    @InterfaceAudience.Private
    public static final String DEFAULT_APPLICATION_PRIORITY = "default-application-priority";
    @InterfaceAudience.Private
    public static final Integer DEFAULT_CONFIGURATION_APPLICATION_PRIORITY = 0;
    @InterfaceAudience.Private
    public static final String AVERAGE_CAPACITY = "average-capacity";
    @InterfaceAudience.Private
    public static final String IS_RESERVABLE = "reservable";
    @InterfaceAudience.Private
    public static final String RESERVATION_WINDOW = "reservation-window";
    @InterfaceAudience.Private
    public static final String INSTANTANEOUS_MAX_CAPACITY = "instantaneous-max-capacity";
    @InterfaceAudience.Private
    public static final String RESERVATION_ADMISSION_POLICY = "reservation-policy";
    @InterfaceAudience.Private
    public static final String RESERVATION_AGENT_NAME = "reservation-agent";
    @InterfaceAudience.Private
    public static final String RESERVATION_SHOW_RESERVATION_AS_QUEUE = "show-reservations-as-queues";
    @InterfaceAudience.Private
    public static final String RESERVATION_PLANNER_NAME = "reservation-planner";
    @InterfaceAudience.Private
    public static final String RESERVATION_MOVE_ON_EXPIRY = "reservation-move-on-expiry";
    @InterfaceAudience.Private
    public static final String RESERVATION_ENFORCEMENT_WINDOW = "reservation-enforcement-window";
    @InterfaceAudience.Private
    public static final String LAZY_PREEMPTION_ENABLED = "yarn.scheduler.capacity.lazy-preemption-enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_LAZY_PREEMPTION_ENABLED = false;
    @InterfaceAudience.Private
    public static final String ASSIGN_MULTIPLE_ENABLED = "yarn.scheduler.capacity.per-node-heartbeat.multiple-assignments-enabled";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_ASSIGN_MULTIPLE_ENABLED = true;
    @InterfaceAudience.Private
    public static final String MAX_ASSIGN_PER_HEARTBEAT = "yarn.scheduler.capacity.per-node-heartbeat.maximum-container-assignments";
    @InterfaceAudience.Private
    public static final int DEFAULT_MAX_ASSIGN_PER_HEARTBEAT = -1;
    AppPriorityACLConfigurationParser priorityACLConfig = new AppPriorityACLConfigurationParser();
    private static final String PREEMPTION_CONFIG_PREFIX = "yarn.resourcemanager.monitor.capacity.preemption.";
    private static final String INTRA_QUEUE_PREEMPTION_CONFIG_PREFIX = "intra-queue-preemption.";
    public static final String PREEMPTION_OBSERVE_ONLY = "yarn.resourcemanager.monitor.capacity.preemption.observe_only";
    public static final boolean DEFAULT_PREEMPTION_OBSERVE_ONLY = false;
    public static final String PREEMPTION_MONITORING_INTERVAL = "yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval";
    public static final long DEFAULT_PREEMPTION_MONITORING_INTERVAL = 3000L;
    public static final String PREEMPTION_WAIT_TIME_BEFORE_KILL = "yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill";
    public static final long DEFAULT_PREEMPTION_WAIT_TIME_BEFORE_KILL = 15000L;
    public static final String TOTAL_PREEMPTION_PER_ROUND = "yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round";
    public static final float DEFAULT_TOTAL_PREEMPTION_PER_ROUND = 0.1f;
    public static final String PREEMPTION_MAX_IGNORED_OVER_CAPACITY = "yarn.resourcemanager.monitor.capacity.preemption.max_ignored_over_capacity";
    public static final double DEFAULT_PREEMPTION_MAX_IGNORED_OVER_CAPACITY = 0.1;
    public static final String PREEMPTION_NATURAL_TERMINATION_FACTOR = "yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor";
    public static final double DEFAULT_PREEMPTION_NATURAL_TERMINATION_FACTOR = 0.2;
    public static final String ADDITIONAL_RESOURCE_BALANCE_BASED_ON_RESERVED_CONTAINERS = "yarn.resourcemanager.monitor.capacity.preemption.additional_res_balance_based_on_reserved_containers";
    public static final boolean DEFAULT_ADDITIONAL_RESOURCE_BALANCE_BASED_ON_RESERVED_CONTAINERS = false;
    public static final String PREEMPTION_SELECT_CANDIDATES_FOR_RESERVED_CONTAINERS = "yarn.resourcemanager.monitor.capacity.preemption.select_based_on_reserved_containers";
    public static final boolean DEFAULT_PREEMPTION_SELECT_CANDIDATES_FOR_RESERVED_CONTAINERS = false;
    public static final String INTRAQUEUE_PREEMPTION_ENABLED = "yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled";
    public static final boolean DEFAULT_INTRAQUEUE_PREEMPTION_ENABLED = false;
    public static final String INTRAQUEUE_PREEMPTION_MINIMUM_THRESHOLD = "yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.minimum-threshold";
    public static final float DEFAULT_INTRAQUEUE_PREEMPTION_MINIMUM_THRESHOLD = 0.5f;
    public static final String INTRAQUEUE_PREEMPTION_MAX_ALLOWABLE_LIMIT = "yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit";
    public static final float DEFAULT_INTRAQUEUE_PREEMPTION_MAX_ALLOWABLE_LIMIT = 0.2f;
    public static final String INTRAQUEUE_PREEMPTION_ORDER_POLICY = "yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy";
    public static final String DEFAULT_INTRAQUEUE_PREEMPTION_ORDER_POLICY = "userlimit_first";
    @InterfaceAudience.Private
    public static final String QUEUE_GLOBAL_MAX_APPLICATION = "yarn.scheduler.capacity.global-queue-max-application";
    public static final String QUEUE_UTILIZATION_ORDERING_POLICY = "utilization";
    public static final String QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY = "priority-utilization";
    public static final String DEFAULT_QUEUE_ORDERING_POLICY = "utilization";
    private static final String UNDER_UTILIZED_PREEMPTION_ENABLED = "underutilized-preemption.enabled";
    private static final String UNDER_UTILIZED_PREEMPTION_DELAY = "underutilized-preemption.reserved-container-delay-ms";
    private static final String UNDER_UTILIZED_PREEMPTION_MOVE_RESERVATION = "underutilized-preemption.allow-move-reservation";
    public static final String MAXIMUM_LIFETIME_SUFFIX = "maximum-application-lifetime";
    public static final String DEFAULT_LIFETIME_SUFFIX = "default-application-lifetime";

    public CapacitySchedulerConfiguration() {
        this(new Configuration());
    }

    public CapacitySchedulerConfiguration(Configuration configuration) {
        this(configuration, true);
    }

    public CapacitySchedulerConfiguration(Configuration configuration, boolean useLocalConfigurationProvider) {
        super(configuration);
        if (useLocalConfigurationProvider) {
            this.addResource(CS_CONFIGURATION_FILE);
        }
    }

    static String getQueuePrefix(String queue) {
        String queueName = PREFIX + queue + DOT;
        return queueName;
    }

    static String getQueueOrderingPolicyPrefix(String queue) {
        String queueName = PREFIX + queue + DOT + ORDERING_POLICY + DOT;
        return queueName;
    }

    private String getNodeLabelPrefix(String queue, String label) {
        if (label.equals("")) {
            return CapacitySchedulerConfiguration.getQueuePrefix(queue);
        }
        return CapacitySchedulerConfiguration.getQueuePrefix(queue) + ACCESSIBLE_NODE_LABELS + DOT + label + DOT;
    }

    public int getMaximumSystemApplications() {
        int maxApplications = this.getInt(MAXIMUM_SYSTEM_APPLICATIONS, 10000);
        return maxApplications;
    }

    public float getMaximumApplicationMasterResourcePercent() {
        return this.getFloat(MAXIMUM_APPLICATION_MASTERS_RESOURCE_PERCENT, 0.1f);
    }

    public int getMaximumApplicationsPerQueue(String queue) {
        int maxApplicationsPerQueue = this.getInt(CapacitySchedulerConfiguration.getQueuePrefix(queue) + MAXIMUM_APPLICATIONS_SUFFIX, -1);
        return maxApplicationsPerQueue;
    }

    public float getMaximumApplicationMasterResourcePerQueuePercent(String queue) {
        return this.getFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + MAXIMUM_AM_RESOURCE_SUFFIX, this.getMaximumApplicationMasterResourcePercent());
    }

    public void setMaximumApplicationMasterResourcePerQueuePercent(String queue, float percent) {
        this.setFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + MAXIMUM_AM_RESOURCE_SUFFIX, percent);
    }

    public float getNonLabeledQueueCapacity(String queue) {
        float capacity;
        float f = capacity = queue.equals(ROOT) ? 100.0f : this.getFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + CAPACITY, -1.0f);
        if (capacity < 0.0f || capacity > 100.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + capacity + " for queue " + queue);
        }
        LOG.debug((Object)("CSConf - getCapacity: queuePrefix=" + CapacitySchedulerConfiguration.getQueuePrefix(queue) + ", capacity=" + capacity));
        return capacity;
    }

    public void setCapacity(String queue, float capacity) {
        if (queue.equals(ROOT)) {
            throw new IllegalArgumentException("Cannot set capacity, root queue has a fixed capacity of 100.0f");
        }
        this.setFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + CAPACITY, capacity);
        LOG.debug((Object)("CSConf - setCapacity: queuePrefix=" + CapacitySchedulerConfiguration.getQueuePrefix(queue) + ", capacity=" + capacity));
    }

    public float getNonLabeledQueueMaximumCapacity(String queue) {
        float maxCapacity = this.getFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + MAXIMUM_CAPACITY, 100.0f);
        maxCapacity = maxCapacity == -1.0f ? 100.0f : maxCapacity;
        return maxCapacity;
    }

    public void setMaximumCapacity(String queue, float maxCapacity) {
        if (maxCapacity > 100.0f) {
            throw new IllegalArgumentException("Illegal maximum-capacity of " + maxCapacity + " for queue " + queue);
        }
        this.setFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + MAXIMUM_CAPACITY, maxCapacity);
        LOG.debug((Object)("CSConf - setMaxCapacity: queuePrefix=" + CapacitySchedulerConfiguration.getQueuePrefix(queue) + ", maxCapacity=" + maxCapacity));
    }

    public void setCapacityByLabel(String queue, String label, float capacity) {
        this.setFloat(this.getNodeLabelPrefix(queue, label) + CAPACITY, capacity);
    }

    public void setMaximumCapacityByLabel(String queue, String label, float capacity) {
        this.setFloat(this.getNodeLabelPrefix(queue, label) + MAXIMUM_CAPACITY, capacity);
    }

    public int getUserLimit(String queue) {
        int userLimit = this.getInt(CapacitySchedulerConfiguration.getQueuePrefix(queue) + USER_LIMIT, 100);
        return userLimit;
    }

    public <S extends SchedulableEntity> OrderingPolicy<S> getAppOrderingPolicy(String queue) {
        OrderingPolicy orderingPolicy;
        String policyType = this.get(CapacitySchedulerConfiguration.getQueuePrefix(queue) + ORDERING_POLICY, "fifo");
        if (policyType.trim().equals("fifo")) {
            policyType = FifoOrderingPolicy.class.getName();
        }
        if (policyType.trim().equals(FAIR_APP_ORDERING_POLICY)) {
            policyType = FairOrderingPolicy.class.getName();
        }
        try {
            orderingPolicy = (OrderingPolicy)Class.forName(policyType).newInstance();
        }
        catch (Exception e) {
            String message = "Unable to construct ordering policy for: " + policyType + ", " + e.getMessage();
            throw new RuntimeException(message, e);
        }
        HashMap<String, String> config = new HashMap<String, String>();
        String confPrefix = CapacitySchedulerConfiguration.getQueuePrefix(queue) + ORDERING_POLICY + DOT;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry kv = (Map.Entry)iterator.next();
            if (!((String)kv.getKey()).startsWith(confPrefix)) continue;
            config.put(((String)kv.getKey()).substring(confPrefix.length()), (String)kv.getValue());
        }
        orderingPolicy.configure(config);
        return orderingPolicy;
    }

    public void setUserLimit(String queue, int userLimit) {
        this.setInt(CapacitySchedulerConfiguration.getQueuePrefix(queue) + USER_LIMIT, userLimit);
        LOG.debug((Object)("here setUserLimit: queuePrefix=" + CapacitySchedulerConfiguration.getQueuePrefix(queue) + ", userLimit=" + this.getUserLimit(queue)));
    }

    public float getUserLimitFactor(String queue) {
        float userLimitFactor = this.getFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + USER_LIMIT_FACTOR, 1.0f);
        return userLimitFactor;
    }

    public void setUserLimitFactor(String queue, float userLimitFactor) {
        this.setFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + USER_LIMIT_FACTOR, userLimitFactor);
    }

    public QueueState getConfiguredState(String queue) {
        String state = this.get(CapacitySchedulerConfiguration.getQueuePrefix(queue) + STATE);
        if (state == null) {
            return null;
        }
        return QueueState.valueOf((String)StringUtils.toUpperCase((String)state));
    }

    public QueueState getState(String queue) {
        QueueState state = this.getConfiguredState(queue);
        return state == null ? QueueState.RUNNING : state;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setState(String queue, QueueState state) {
        this.set(CapacitySchedulerConfiguration.getQueuePrefix(queue) + STATE, state.name());
    }

    public void setAccessibleNodeLabels(String queue, Set<String> labels) {
        if (labels == null) {
            return;
        }
        String str = StringUtils.join((CharSequence)",", labels);
        this.set(CapacitySchedulerConfiguration.getQueuePrefix(queue) + ACCESSIBLE_NODE_LABELS, str);
    }

    public Set<String> getAccessibleNodeLabels(String queue) {
        String accessibleLabelStr = this.get(CapacitySchedulerConfiguration.getQueuePrefix(queue) + ACCESSIBLE_NODE_LABELS);
        if (accessibleLabelStr == null) {
            if (!queue.equals(ROOT)) {
                return null;
            }
        } else if (queue.equals(ROOT)) {
            LOG.warn((Object)"Accessible node labels for root queue will be ignored, it will be automatically set to \"*\".");
        }
        if (queue.equals(ROOT)) {
            return ImmutableSet.of((Object)ALL_ACL);
        }
        HashSet<String> set = new HashSet<String>();
        for (String str : accessibleLabelStr.split(",")) {
            if (str.trim().isEmpty()) continue;
            set.add(str.trim());
        }
        if (set.contains(ALL_ACL)) {
            set.clear();
            set.add(ALL_ACL);
        }
        return Collections.unmodifiableSet(set);
    }

    private float internalGetLabeledQueueCapacity(String queue, String label, String suffix, float defaultValue) {
        String capacityPropertyName = this.getNodeLabelPrefix(queue, label) + suffix;
        float capacity = this.getFloat(capacityPropertyName, defaultValue);
        if (capacity < 0.0f || capacity > 100.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + capacity + " for node-label=" + label + " in queue=" + queue + ", valid capacity should in range of [0, 100].");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CSConf - getCapacityOfLabel: prefix=" + this.getNodeLabelPrefix(queue, label) + ", capacity=" + capacity));
        }
        return capacity;
    }

    public float getLabeledQueueCapacity(String queue, String label) {
        return this.internalGetLabeledQueueCapacity(queue, label, CAPACITY, 0.0f);
    }

    public float getLabeledQueueMaximumCapacity(String queue, String label) {
        return this.internalGetLabeledQueueCapacity(queue, label, MAXIMUM_CAPACITY, 100.0f);
    }

    public String getDefaultNodeLabelExpression(String queue) {
        String defaultLabelExpression = this.get(CapacitySchedulerConfiguration.getQueuePrefix(queue) + DEFAULT_NODE_LABEL_EXPRESSION);
        if (defaultLabelExpression == null) {
            return null;
        }
        return defaultLabelExpression.trim();
    }

    public void setDefaultNodeLabelExpression(String queue, String exp) {
        this.set(CapacitySchedulerConfiguration.getQueuePrefix(queue) + DEFAULT_NODE_LABEL_EXPRESSION, exp);
    }

    public float getMaximumAMResourcePercentPerPartition(String queue, String label) {
        return this.getFloat(this.getNodeLabelPrefix(queue, label) + MAXIMUM_AM_RESOURCE_SUFFIX, this.getMaximumApplicationMasterResourcePerQueuePercent(queue));
    }

    public void setMaximumAMResourcePercentPerPartition(String queue, String label, float percent) {
        this.setFloat(this.getNodeLabelPrefix(queue, label) + MAXIMUM_AM_RESOURCE_SUFFIX, percent);
    }

    public boolean getReservationContinueLook() {
        return this.getBoolean(RESERVE_CONT_LOOK_ALL_NODES, true);
    }

    private static String getAclKey(QueueACL acl) {
        return "acl_" + StringUtils.toLowerCase((String)acl.toString());
    }

    public AccessControlList getAcl(String queue, QueueACL acl) {
        String queuePrefix = CapacitySchedulerConfiguration.getQueuePrefix(queue);
        String defaultAcl = queue.equals(ROOT) ? ALL_ACL : NONE_ACL;
        String aclString = this.get(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), defaultAcl);
        return new AccessControlList(aclString);
    }

    public void setAcl(String queue, QueueACL acl, String aclString) {
        String queuePrefix = CapacitySchedulerConfiguration.getQueuePrefix(queue);
        this.set(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), aclString);
    }

    private static String getAclKey(ReservationACL acl) {
        return "acl_" + StringUtils.toLowerCase((String)acl.toString());
    }

    private static String getAclKey(AccessType acl) {
        return "acl_" + StringUtils.toLowerCase((String)acl.toString());
    }

    @Override
    public Map<ReservationACL, AccessControlList> getReservationAcls(String queue) {
        HashMap<ReservationACL, AccessControlList> resAcls = new HashMap<ReservationACL, AccessControlList>();
        for (ReservationACL acl : ReservationACL.values()) {
            resAcls.put(acl, this.getReservationAcl(queue, acl));
        }
        return resAcls;
    }

    private AccessControlList getReservationAcl(String queue, ReservationACL acl) {
        String queuePrefix = CapacitySchedulerConfiguration.getQueuePrefix(queue);
        String defaultAcl = ALL_ACL;
        String aclString = this.get(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), defaultAcl);
        return new AccessControlList(aclString);
    }

    private void setAcl(String queue, ReservationACL acl, String aclString) {
        String queuePrefix = CapacitySchedulerConfiguration.getQueuePrefix(queue);
        this.set(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), aclString);
    }

    private void setAcl(String queue, AccessType acl, String aclString) {
        String queuePrefix = CapacitySchedulerConfiguration.getQueuePrefix(queue);
        this.set(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), aclString);
    }

    public Map<AccessType, AccessControlList> getAcls(String queue) {
        HashMap<AccessType, AccessControlList> acls = new HashMap<AccessType, AccessControlList>();
        for (QueueACL acl : QueueACL.values()) {
            acls.put(SchedulerUtils.toAccessType(acl), this.getAcl(queue, acl));
        }
        return acls;
    }

    public void setAcls(String queue, Map<QueueACL, AccessControlList> acls) {
        for (Map.Entry<QueueACL, AccessControlList> e : acls.entrySet()) {
            this.setAcl(queue, e.getKey(), e.getValue().getAclString());
        }
    }

    @VisibleForTesting
    public void setReservationAcls(String queue, Map<ReservationACL, AccessControlList> acls) {
        for (Map.Entry<ReservationACL, AccessControlList> e : acls.entrySet()) {
            this.setAcl(queue, e.getKey(), e.getValue().getAclString());
        }
    }

    @VisibleForTesting
    public void setPriorityAcls(String queue, Priority priority, Priority defaultPriority, String[] acls) {
        StringBuilder aclString = new StringBuilder();
        StringBuilder userAndGroup = new StringBuilder();
        for (int i = 0; i < acls.length; ++i) {
            userAndGroup.append((Object)((Object)AppPriorityACLConfigurationParser.AppPriorityACLKeyType.values()[i]) + "=" + acls[i].trim()).append(NONE_ACL);
        }
        aclString.append("[" + userAndGroup.toString().trim() + " max_priority=" + priority.getPriority() + " default_priority=" + defaultPriority.getPriority() + "]");
        this.setAcl(queue, AccessType.APPLICATION_MAX_PRIORITY, aclString.toString());
    }

    public List<AppPriorityACLGroup> getPriorityAcls(String queue, Priority clusterMaxPriority) {
        String queuePrefix = CapacitySchedulerConfiguration.getQueuePrefix(queue);
        String defaultAcl = ALL_ACL;
        String aclString = this.get(queuePrefix + CapacitySchedulerConfiguration.getAclKey(AccessType.APPLICATION_MAX_PRIORITY), defaultAcl);
        return this.priorityACLConfig.getPriorityAcl(clusterMaxPriority, aclString);
    }

    public String[] getQueues(String queue) {
        LOG.debug((Object)("CSConf - getQueues called for: queuePrefix=" + CapacitySchedulerConfiguration.getQueuePrefix(queue)));
        String[] queues = this.getStrings(CapacitySchedulerConfiguration.getQueuePrefix(queue) + QUEUES);
        ArrayList<String> trimmedQueueNames = new ArrayList<String>();
        if (null != queues) {
            for (String s : queues) {
                trimmedQueueNames.add(s.trim());
            }
            queues = trimmedQueueNames.toArray(new String[0]);
        }
        LOG.debug((Object)("CSConf - getQueues: queuePrefix=" + CapacitySchedulerConfiguration.getQueuePrefix(queue) + ", queues=" + (queues == null ? "" : StringUtils.arrayToString((String[])queues))));
        return queues;
    }

    public void setQueues(String queue, String[] subQueues) {
        this.set(CapacitySchedulerConfiguration.getQueuePrefix(queue) + QUEUES, StringUtils.arrayToString((String[])subQueues));
        LOG.debug((Object)("CSConf - setQueues: qPrefix=" + CapacitySchedulerConfiguration.getQueuePrefix(queue) + ", queues=" + StringUtils.arrayToString((String[])subQueues)));
    }

    public Resource getMinimumAllocation() {
        int minimumMemory = this.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int minimumCores = this.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        return Resources.createResource((int)minimumMemory, (int)minimumCores);
    }

    public Resource getMaximumAllocation() {
        int maximumMemory = this.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        int maximumCores = this.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        return Resources.createResource((int)maximumMemory, (int)maximumCores);
    }

    @InterfaceAudience.Private
    public Priority getQueuePriority(String queue) {
        String queuePolicyPrefix = CapacitySchedulerConfiguration.getQueuePrefix(queue);
        Priority pri = Priority.newInstance((int)this.getInt(queuePolicyPrefix + "priority", 0));
        return pri;
    }

    @InterfaceAudience.Private
    public void setQueuePriority(String queue, int priority) {
        String queuePolicyPrefix = CapacitySchedulerConfiguration.getQueuePrefix(queue);
        this.setInt(queuePolicyPrefix + "priority", priority);
    }

    public Resource getMaximumAllocationPerQueue(String queue) {
        String queuePrefix = CapacitySchedulerConfiguration.getQueuePrefix(queue);
        long maxAllocationMbPerQueue = this.getInt(queuePrefix + MAXIMUM_ALLOCATION_MB, -1);
        int maxAllocationVcoresPerQueue = this.getInt(queuePrefix + MAXIMUM_ALLOCATION_VCORES, -1);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("max alloc mb per queue for " + queue + " is " + maxAllocationMbPerQueue));
            LOG.debug((Object)("max alloc vcores per queue for " + queue + " is " + maxAllocationVcoresPerQueue));
        }
        Resource clusterMax = this.getMaximumAllocation();
        if (maxAllocationMbPerQueue == -1L) {
            LOG.info((Object)("max alloc mb per queue for " + queue + " is undefined"));
            maxAllocationMbPerQueue = clusterMax.getMemorySize();
        }
        if (maxAllocationVcoresPerQueue == -1) {
            LOG.info((Object)("max alloc vcore per queue for " + queue + " is undefined"));
            maxAllocationVcoresPerQueue = clusterMax.getVirtualCores();
        }
        Resource result = Resources.createResource((long)maxAllocationMbPerQueue, (int)maxAllocationVcoresPerQueue);
        if (maxAllocationMbPerQueue > clusterMax.getMemorySize() || maxAllocationVcoresPerQueue > clusterMax.getVirtualCores()) {
            throw new IllegalArgumentException("Queue maximum allocation cannot be larger than the cluster setting for queue " + queue + " max allocation per queue: " + result + " cluster setting: " + clusterMax);
        }
        return result;
    }

    public boolean getEnableUserMetrics() {
        return this.getBoolean(ENABLE_USER_METRICS, false);
    }

    public int getOffSwitchPerHeartbeatLimit() {
        int limit = this.getInt(OFFSWITCH_PER_HEARTBEAT_LIMIT, 1);
        if (limit < 1) {
            LOG.warn((Object)("yarn.scheduler.capacity.per-node-heartbeat.maximum-offswitch-assignments(" + limit + ") < 1. Using 1."));
            limit = 1;
        }
        return limit;
    }

    public void setOffSwitchPerHeartbeatLimit(int limit) {
        this.setInt(OFFSWITCH_PER_HEARTBEAT_LIMIT, limit);
    }

    public int getNodeLocalityDelay() {
        return this.getInt(NODE_LOCALITY_DELAY, 40);
    }

    public int getRackLocalityAdditionalDelay() {
        return this.getInt(RACK_LOCALITY_ADDITIONAL_DELAY, -1);
    }

    public boolean getRackLocalityFullReset() {
        return this.getBoolean(RACK_LOCALITY_FULL_RESET, true);
    }

    public ResourceCalculator getResourceCalculator() {
        return (ResourceCalculator)ReflectionUtils.newInstance((Class)this.getClass(RESOURCE_CALCULATOR_CLASS, DEFAULT_RESOURCE_CALCULATOR_CLASS, ResourceCalculator.class), (Configuration)this);
    }

    public boolean getUsePortForNodeName() {
        return this.getBoolean("yarn.scheduler.include-port-in-node-name", false);
    }

    public void setResourceComparator(Class<? extends ResourceCalculator> resourceCalculatorClass) {
        this.setClass(RESOURCE_CALCULATOR_CLASS, resourceCalculatorClass, ResourceCalculator.class);
    }

    public boolean getScheduleAynschronously() {
        return this.getBoolean(SCHEDULE_ASYNCHRONOUSLY_ENABLE, false);
    }

    public void setScheduleAynschronously(boolean async) {
        this.setBoolean(SCHEDULE_ASYNCHRONOUSLY_ENABLE, async);
    }

    public boolean getOverrideWithQueueMappings() {
        return this.getBoolean(ENABLE_QUEUE_MAPPING_OVERRIDE, false);
    }

    private static Collection<String> getTrimmedStringCollection(String str, String delim) {
        ArrayList<String> values = new ArrayList<String>();
        if (str == null) {
            return values;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            if (next == null || next.trim().isEmpty()) continue;
            values.add(next.trim());
        }
        return values;
    }

    public List<UserGroupMappingPlacementRule.QueueMapping> getQueueMappings() {
        ArrayList<UserGroupMappingPlacementRule.QueueMapping> mappings = new ArrayList<UserGroupMappingPlacementRule.QueueMapping>();
        Collection mappingsString = this.getTrimmedStringCollection(QUEUE_MAPPING);
        for (String mappingValue : mappingsString) {
            UserGroupMappingPlacementRule.QueueMapping m;
            String[] mapping = CapacitySchedulerConfiguration.getTrimmedStringCollection(mappingValue, ":").toArray(new String[0]);
            if (mapping.length != 3 || mapping[1].length() == 0 || mapping[2].length() == 0) {
                throw new IllegalArgumentException("Illegal queue mapping " + mappingValue);
            }
            try {
                UserGroupMappingPlacementRule.QueueMapping.MappingType mappingType;
                if (mapping[0].equals("u")) {
                    mappingType = UserGroupMappingPlacementRule.QueueMapping.MappingType.USER;
                } else if (mapping[0].equals("g")) {
                    mappingType = UserGroupMappingPlacementRule.QueueMapping.MappingType.GROUP;
                } else {
                    throw new IllegalArgumentException("unknown mapping prefix " + mapping[0]);
                }
                m = new UserGroupMappingPlacementRule.QueueMapping(mappingType, mapping[1], mapping[2]);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Illegal queue mapping " + mappingValue);
            }
            if (m == null) continue;
            mappings.add(m);
        }
        return mappings;
    }

    @Override
    public boolean isReservable(String queue) {
        boolean isReservable = this.getBoolean(CapacitySchedulerConfiguration.getQueuePrefix(queue) + IS_RESERVABLE, false);
        return isReservable;
    }

    public void setReservable(String queue, boolean isReservable) {
        this.setBoolean(CapacitySchedulerConfiguration.getQueuePrefix(queue) + IS_RESERVABLE, isReservable);
        LOG.debug((Object)("here setReservableQueue: queuePrefix=" + CapacitySchedulerConfiguration.getQueuePrefix(queue) + ", isReservableQueue=" + this.isReservable(queue)));
    }

    @Override
    public long getReservationWindow(String queue) {
        long reservationWindow = this.getLong(CapacitySchedulerConfiguration.getQueuePrefix(queue) + RESERVATION_WINDOW, 86400000L);
        return reservationWindow;
    }

    @Override
    public float getAverageCapacity(String queue) {
        float avgCapacity = this.getFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + AVERAGE_CAPACITY, 100.0f);
        return avgCapacity;
    }

    @Override
    public float getInstantaneousMaxCapacity(String queue) {
        float instMaxCapacity = this.getFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + INSTANTANEOUS_MAX_CAPACITY, 100.0f);
        return instMaxCapacity;
    }

    public void setInstantaneousMaxCapacity(String queue, float instMaxCapacity) {
        this.setFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + INSTANTANEOUS_MAX_CAPACITY, instMaxCapacity);
    }

    public void setReservationWindow(String queue, long reservationWindow) {
        this.setLong(CapacitySchedulerConfiguration.getQueuePrefix(queue) + RESERVATION_WINDOW, reservationWindow);
    }

    public void setAverageCapacity(String queue, float avgCapacity) {
        this.setFloat(CapacitySchedulerConfiguration.getQueuePrefix(queue) + AVERAGE_CAPACITY, avgCapacity);
    }

    @Override
    public String getReservationAdmissionPolicy(String queue) {
        String reservationPolicy = this.get(CapacitySchedulerConfiguration.getQueuePrefix(queue) + RESERVATION_ADMISSION_POLICY, "org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy");
        return reservationPolicy;
    }

    public void setReservationAdmissionPolicy(String queue, String reservationPolicy) {
        this.set(CapacitySchedulerConfiguration.getQueuePrefix(queue) + RESERVATION_ADMISSION_POLICY, reservationPolicy);
    }

    @Override
    public String getReservationAgent(String queue) {
        String reservationAgent = this.get(CapacitySchedulerConfiguration.getQueuePrefix(queue) + RESERVATION_AGENT_NAME, "org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.AlignedPlannerWithGreedy");
        return reservationAgent;
    }

    public void setReservationAgent(String queue, String reservationPolicy) {
        this.set(CapacitySchedulerConfiguration.getQueuePrefix(queue) + RESERVATION_AGENT_NAME, reservationPolicy);
    }

    @Override
    public boolean getShowReservationAsQueues(String queuePath) {
        boolean showReservationAsQueues = this.getBoolean(CapacitySchedulerConfiguration.getQueuePrefix(queuePath) + RESERVATION_SHOW_RESERVATION_AS_QUEUE, false);
        return showReservationAsQueues;
    }

    @Override
    public String getReplanner(String queue) {
        String replanner = this.get(CapacitySchedulerConfiguration.getQueuePrefix(queue) + RESERVATION_PLANNER_NAME, "org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.SimpleCapacityReplanner");
        return replanner;
    }

    @Override
    public boolean getMoveOnExpiry(String queue) {
        boolean killOnExpiry = this.getBoolean(CapacitySchedulerConfiguration.getQueuePrefix(queue) + RESERVATION_MOVE_ON_EXPIRY, true);
        return killOnExpiry;
    }

    @Override
    public long getEnforcementWindow(String queue) {
        long enforcementWindow = this.getLong(CapacitySchedulerConfiguration.getQueuePrefix(queue) + RESERVATION_ENFORCEMENT_WINDOW, 3600000L);
        return enforcementWindow;
    }

    public void setPreemptionDisabled(String queue, boolean preemptionDisabled) {
        this.setBoolean(CapacitySchedulerConfiguration.getQueuePrefix(queue) + QUEUE_PREEMPTION_DISABLED, preemptionDisabled);
    }

    public boolean getPreemptionDisabled(String queue, boolean defaultVal) {
        boolean preemptionDisabled = this.getBoolean(CapacitySchedulerConfiguration.getQueuePrefix(queue) + QUEUE_PREEMPTION_DISABLED, defaultVal);
        return preemptionDisabled;
    }

    public boolean getIntraQueuePreemptionDisabled(String queue, boolean defaultVal) {
        return this.getBoolean(CapacitySchedulerConfiguration.getQueuePrefix(queue) + INTRA_QUEUE_PREEMPTION_CONFIG_PREFIX + QUEUE_PREEMPTION_DISABLED, defaultVal);
    }

    public Set<String> getConfiguredNodeLabels(String queuePath) {
        HashSet<String> configuredNodeLabels = new HashSet<String>();
        Map.Entry e = null;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            e = (Map.Entry)iter.next();
            String key = (String)e.getKey();
            if (!key.startsWith(CapacitySchedulerConfiguration.getQueuePrefix(queuePath) + ACCESSIBLE_NODE_LABELS + DOT)) continue;
            int labelStartIdx = key.indexOf(ACCESSIBLE_NODE_LABELS) + ACCESSIBLE_NODE_LABELS.length() + 1;
            int labelEndIndx = key.indexOf(46, labelStartIdx);
            String labelName = key.substring(labelStartIdx, labelEndIndx);
            configuredNodeLabels.add(labelName);
        }
        configuredNodeLabels.add("");
        return configuredNodeLabels;
    }

    public Integer getDefaultApplicationPriorityConfPerQueue(String queue) {
        Integer defaultPriority = this.getInt(CapacitySchedulerConfiguration.getQueuePrefix(queue) + DEFAULT_APPLICATION_PRIORITY, DEFAULT_CONFIGURATION_APPLICATION_PRIORITY);
        return defaultPriority;
    }

    @VisibleForTesting
    public void setOrderingPolicy(String queue, String policy) {
        this.set(CapacitySchedulerConfiguration.getQueuePrefix(queue) + ORDERING_POLICY, policy);
    }

    @VisibleForTesting
    public void setOrderingPolicyParameter(String queue, String parameterKey, String parameterValue) {
        this.set(CapacitySchedulerConfiguration.getQueuePrefix(queue) + ORDERING_POLICY + DOT + parameterKey, parameterValue);
    }

    public boolean getLazyPreemptionEnabled() {
        return this.getBoolean(LAZY_PREEMPTION_ENABLED, false);
    }

    public int getGlobalMaximumApplicationsPerQueue() {
        int maxApplicationsPerQueue = this.getInt(QUEUE_GLOBAL_MAX_APPLICATION, -1);
        return maxApplicationsPerQueue;
    }

    @InterfaceAudience.Private
    public void setQueueOrderingPolicy(String queue, String policy) {
        this.set(CapacitySchedulerConfiguration.getQueuePrefix(queue) + ORDERING_POLICY, policy);
    }

    @InterfaceAudience.Private
    public QueueOrderingPolicy getQueueOrderingPolicy(String queue, String parentPolicy) {
        PriorityUtilizationQueueOrderingPolicy qop;
        String policyType;
        String defaultPolicy = parentPolicy;
        if (null == defaultPolicy) {
            defaultPolicy = "utilization";
        }
        if ((policyType = this.get(CapacitySchedulerConfiguration.getQueuePrefix(queue) + ORDERING_POLICY, defaultPolicy)).trim().equals("utilization")) {
            qop = new PriorityUtilizationQueueOrderingPolicy(false);
        } else if (policyType.trim().equals(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY)) {
            qop = new PriorityUtilizationQueueOrderingPolicy(true);
        } else {
            String message = "Unable to construct queue ordering policy=" + policyType + " queue=" + queue;
            throw new YarnRuntimeException(message);
        }
        return qop;
    }

    private String getOrderingPolicyGlobalConfigKey(String orderPolicyName, String configKey) {
        return "yarn.scheduler.capacity.ordering-policy." + orderPolicyName + DOT + configKey;
    }

    public boolean getPUOrderingPolicyUnderUtilizedPreemptionEnabled() {
        return this.getBoolean(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_ENABLED), false);
    }

    @VisibleForTesting
    public void setPUOrderingPolicyUnderUtilizedPreemptionEnabled(boolean enabled) {
        this.setBoolean(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_ENABLED), enabled);
    }

    public long getPUOrderingPolicyUnderUtilizedPreemptionDelay() {
        return this.getLong(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_DELAY), 60000L);
    }

    @VisibleForTesting
    public void setPUOrderingPolicyUnderUtilizedPreemptionDelay(long timeout) {
        this.setLong(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_DELAY), timeout);
    }

    public boolean getPUOrderingPolicyUnderUtilizedPreemptionMoveReservation() {
        return this.getBoolean(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_MOVE_RESERVATION), false);
    }

    @VisibleForTesting
    public void setPUOrderingPolicyUnderUtilizedPreemptionMoveReservation(boolean allowMoveReservation) {
        this.setBoolean(this.getOrderingPolicyGlobalConfigKey(QUEUE_PRIORITY_UTILIZATION_ORDERING_POLICY, UNDER_UTILIZED_PREEMPTION_MOVE_RESERVATION), allowMoveReservation);
    }

    public Map<String, Float> getAllUserWeightsForQueue(String queuePath) {
        HashMap<String, Float> userWeights = new HashMap<String, Float>();
        String qPathPlusPrefix = CapacitySchedulerConfiguration.getQueuePrefix(queuePath).replaceAll("\\.", "\\\\.") + USER_SETTINGS + "\\.";
        String weightKeyRegex = qPathPlusPrefix + "\\w+\\." + USER_WEIGHT;
        Map props = this.getValByRegex(weightKeyRegex);
        for (Map.Entry e : props.entrySet()) {
            String userName = ((String)e.getKey()).replaceFirst(qPathPlusPrefix, "").replaceFirst("\\.weight", "");
            if (userName == null || userName.isEmpty()) continue;
            userWeights.put(userName, new Float((String)e.getValue()));
        }
        return userWeights;
    }

    public boolean getAssignMultipleEnabled() {
        return this.getBoolean(ASSIGN_MULTIPLE_ENABLED, true);
    }

    public int getMaxAssignPerHeartbeat() {
        return this.getInt(MAX_ASSIGN_PER_HEARTBEAT, -1);
    }

    public long getMaximumLifetimePerQueue(String queue) {
        long maximumLifetimePerQueue = this.getLong(CapacitySchedulerConfiguration.getQueuePrefix(queue) + MAXIMUM_LIFETIME_SUFFIX, -1L);
        return maximumLifetimePerQueue;
    }

    public void setMaximumLifetimePerQueue(String queue, long maximumLifetime) {
        this.setLong(CapacitySchedulerConfiguration.getQueuePrefix(queue) + MAXIMUM_LIFETIME_SUFFIX, maximumLifetime);
    }

    public long getDefaultLifetimePerQueue(String queue) {
        long maximumLifetimePerQueue = this.getLong(CapacitySchedulerConfiguration.getQueuePrefix(queue) + DEFAULT_LIFETIME_SUFFIX, -1L);
        return maximumLifetimePerQueue;
    }

    public void setDefaultLifetimePerQueue(String queue, long defaultLifetime) {
        this.setLong(CapacitySchedulerConfiguration.getQueuePrefix(queue) + DEFAULT_LIFETIME_SUFFIX, defaultLifetime);
    }
}

