/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RMAppAttemptMetrics {
    private static final Log LOG = LogFactory.getLog(RMAppAttemptMetrics.class);
    private ApplicationAttemptId attemptId = null;
    private Resource resourcePreempted = Resource.newInstance((int)0, (int)0);
    private volatile Resource applicationHeadroom = Resource.newInstance((int)0, (int)0);
    private AtomicInteger numNonAMContainersPreempted = new AtomicInteger(0);
    private AtomicBoolean isPreempted = new AtomicBoolean(false);
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private AtomicLong finishedMemorySeconds = new AtomicLong(0L);
    private AtomicLong finishedVcoreSeconds = new AtomicLong(0L);
    private AtomicLong preemptedMemorySeconds = new AtomicLong(0L);
    private AtomicLong preemptedVcoreSeconds = new AtomicLong(0L);
    private RMContext rmContext;
    private int[][] localityStatistics = new int[NodeType.values().length][NodeType.values().length];
    private volatile int totalAllocatedContainers;

    public RMAppAttemptMetrics(ApplicationAttemptId attemptId, RMContext rmContext) {
        this.attemptId = attemptId;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.rmContext = rmContext;
    }

    public void updatePreemptionInfo(Resource resource, RMContainer container) {
        try {
            this.writeLock.lock();
            this.resourcePreempted = Resources.addTo((Resource)this.resourcePreempted, (Resource)resource);
        }
        finally {
            this.writeLock.unlock();
        }
        if (!container.isAMContainer()) {
            LOG.info((Object)String.format("Non-AM container preempted, current appAttemptId=%s, containerId=%s, resource=%s", this.attemptId, container.getContainerId(), resource));
            this.numNonAMContainersPreempted.incrementAndGet();
        } else {
            LOG.info((Object)String.format("AM container preempted, current appAttemptId=%s, containerId=%s, resource=%s", this.attemptId, container.getContainerId(), resource));
            this.isPreempted.set(true);
        }
    }

    public Resource getResourcePreempted() {
        try {
            this.readLock.lock();
            Resource resource = this.resourcePreempted;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getPreemptedMemory() {
        return this.preemptedMemorySeconds.get();
    }

    public long getPreemptedVcore() {
        return this.preemptedVcoreSeconds.get();
    }

    public int getNumNonAMContainersPreempted() {
        return this.numNonAMContainersPreempted.get();
    }

    public void setIsPreempted() {
        this.isPreempted.set(true);
    }

    public boolean getIsPreempted() {
        return this.isPreempted.get();
    }

    public AggregateAppResourceUsage getAggregateAppResourceUsage() {
        ApplicationResourceUsageReport appResUsageReport;
        RMAppAttempt currentAttempt;
        long memorySeconds = this.finishedMemorySeconds.get();
        long vcoreSeconds = this.finishedVcoreSeconds.get();
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(this.attemptId.getApplicationId());
        if (null != rmApp && (currentAttempt = rmApp.getCurrentAppAttempt()).getAppAttemptId().equals((Object)this.attemptId) && (appResUsageReport = this.rmContext.getScheduler().getAppResourceUsageReport(this.attemptId)) != null) {
            memorySeconds += appResUsageReport.getMemorySeconds();
            vcoreSeconds += appResUsageReport.getVcoreSeconds();
        }
        return new AggregateAppResourceUsage(memorySeconds, vcoreSeconds);
    }

    public void updateAggregateAppResourceUsage(long finishedMemorySeconds, long finishedVcoreSeconds) {
        this.finishedMemorySeconds.addAndGet(finishedMemorySeconds);
        this.finishedVcoreSeconds.addAndGet(finishedVcoreSeconds);
    }

    public void updateAggregatePreemptedAppResourceUsage(long preemptedMemorySeconds, long preemptedVcoreSeconds) {
        this.preemptedMemorySeconds.addAndGet(preemptedMemorySeconds);
        this.preemptedVcoreSeconds.addAndGet(preemptedVcoreSeconds);
    }

    public void incNumAllocatedContainers(NodeType containerType, NodeType requestType) {
        int[] nArray = this.localityStatistics[containerType.getIndex()];
        int n = requestType.getIndex();
        nArray[n] = nArray[n] + 1;
        ++this.totalAllocatedContainers;
    }

    public int[][] getLocalityStatistics() {
        return this.localityStatistics;
    }

    public int getTotalAllocatedContainers() {
        return this.totalAllocatedContainers;
    }

    public Resource getApplicationAttemptHeadroom() {
        return this.applicationHeadroom;
    }

    public void setApplicationAttemptHeadRoom(Resource headRoom) {
        this.applicationHeadroom = headRoom;
    }
}

