/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestRMWithCSRFFilter
extends JerseyTestBase {
    private static MockRM rm;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new ServletModule(){

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            Configuration conf = new Configuration();
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            rm = new MockRM(conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
            RestCsrfPreventionFilter csrfFilter = new RestCsrfPreventionFilter();
            HashMap<String, String> initParams = new HashMap<String, String>();
            initParams.put("methods-to-ignore", "OPTIONS,HEAD,TRACE");
            this.filter("/*", new String[0]).through((Filter)csrfFilter, initParams);
        }
    }});

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestRMWithCSRFFilter() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testNoCustomHeaderFromBrowser() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("info").accept(new String[]{"application/xml"}).header("User-Agent", (Object)"Mozilla/5.0")).get(ClientResponse.class);
        Assert.assertTrue((String)"Should have been rejected", (response.getStatus() == ClientResponse.Status.BAD_REQUEST.getStatusCode() ? 1 : 0) != 0);
    }

    @Test
    public void testIncludeCustomHeaderFromBrowser() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("info").accept(new String[]{"application/xml"}).header("User-Agent", (Object)"Mozilla/5.0")).header("X-XSRF-HEADER", (Object)"")).get(ClientResponse.class);
        Assert.assertTrue((String)"Should have been accepted", (response.getStatus() == ClientResponse.Status.OK.getStatusCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        this.verifyClusterInfoXML(xml);
    }

    @Test
    public void testAllowedMethod() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = ((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("info").accept(new String[]{"application/xml"}).header("User-Agent", (Object)"Mozilla/5.0")).head();
        Assert.assertTrue((String)"Should have been allowed", (response.getStatus() == ClientResponse.Status.OK.getStatusCode() ? 1 : 0) != 0);
    }

    @Test
    public void testAllowNonBrowserInteractionWithoutHeader() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("info").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertTrue((String)"Should have been accepted", (response.getStatus() == ClientResponse.Status.OK.getStatusCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        this.verifyClusterInfoXML(xml);
    }

    public void verifyClusterInfoXML(String xml) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("clusterInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyClusterGeneric(WebServicesTestUtils.getXmlLong((Element)element, (String)"id"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startedOn"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"haState"), WebServicesTestUtils.getXmlString((Element)element, (String)"haZooKeeperConnectionState"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopVersionBuiltOn"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopBuildVersion"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopVersion"), WebServicesTestUtils.getXmlString((Element)element, (String)"resourceManagerVersionBuiltOn"), WebServicesTestUtils.getXmlString((Element)element, (String)"resourceManagerBuildVersion"), WebServicesTestUtils.getXmlString((Element)element, (String)"resourceManagerVersion"));
        }
    }

    public void verifyClusterGeneric(long clusterid, long startedon, String state, String haState, String haZooKeeperConnectionState, String hadoopVersionBuiltOn, String hadoopBuildVersion, String hadoopVersion, String resourceManagerVersionBuiltOn, String resourceManagerBuildVersion, String resourceManagerVersion) {
        Assert.assertEquals((String)"clusterId doesn't match: ", (long)ResourceManager.getClusterTimeStamp(), (long)clusterid);
        Assert.assertEquals((String)"startedOn doesn't match: ", (long)ResourceManager.getClusterTimeStamp(), (long)startedon);
        Assert.assertTrue((String)("stated doesn't match: " + state), (boolean)state.matches(Service.STATE.INITED.toString()));
        Assert.assertTrue((String)("HA state doesn't match: " + haState), (boolean)haState.matches("INITIALIZING"));
        WebServicesTestUtils.checkStringMatch((String)"hadoopVersionBuiltOn", (String)VersionInfo.getDate(), (String)hadoopVersionBuiltOn);
        WebServicesTestUtils.checkStringEqual((String)"hadoopBuildVersion", (String)VersionInfo.getBuildVersion(), (String)hadoopBuildVersion);
        WebServicesTestUtils.checkStringMatch((String)"hadoopVersion", (String)VersionInfo.getVersion(), (String)hadoopVersion);
        WebServicesTestUtils.checkStringMatch((String)"resourceManagerVersionBuiltOn", (String)YarnVersionInfo.getDate(), (String)resourceManagerVersionBuiltOn);
        WebServicesTestUtils.checkStringEqual((String)"resourceManagerBuildVersion", (String)YarnVersionInfo.getBuildVersion(), (String)resourceManagerBuildVersion);
        WebServicesTestUtils.checkStringMatch((String)"resourceManagerVersion", (String)YarnVersionInfo.getVersion(), (String)resourceManagerVersion);
    }

    public class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return TestRMWithCSRFFilter.this.injector;
        }
    }
}

