/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONUnmarshaller;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationSubmissionRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateRequestInfo;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesReservation
extends JerseyTestBase {
    private String webserviceUserName = "testuser";
    private boolean setAuthFilter = false;
    private boolean enableRecurrence = false;
    private static MockRM rm;
    private static Injector injector;
    private static final int MINIMUM_RESOURCE_DURATION = 100000;
    private static final Clock clock;
    private static final int MAXIMUM_PERIOD = 86400000;
    private static final int DEFAULT_RECURRENCE = 8640000;
    private static final String TEST_DIR;
    private static final String FS_ALLOC_FILE;
    private static final String DEFAULT_QUEUE = "dedicated";
    private static final String LIST_RESERVATION_PATH = "reservation/list";
    private static final String GET_NEW_RESERVATION_PATH = "reservation/new-reservation";

    private Injector getNoAuthInjectorCap() {
        return Guice.createInjector((Module[])new Module[]{new CapTestServletModule(){

            @Override
            protected void configureServlets() {
                TestRMWebServicesReservation.this.setAuthFilter = false;
                super.configureServlets();
            }
        }});
    }

    private Injector getSimpleAuthInjectorCap() {
        return Guice.createInjector((Module[])new Module[]{new CapTestServletModule(){

            @Override
            protected void configureServlets() {
                TestRMWebServicesReservation.this.setAuthFilter = true;
                this.conf.setBoolean("yarn.acl.enable", true);
                this.conf.setStrings("yarn.admin.acl", new String[]{"testuser1"});
                super.configureServlets();
            }
        }});
    }

    private Injector getNoAuthInjectorFair() {
        return Guice.createInjector((Module[])new Module[]{new FairTestServletModule(){

            @Override
            protected void configureServlets() {
                TestRMWebServicesReservation.this.setAuthFilter = false;
                super.configureServlets();
            }
        }});
    }

    private Injector getSimpleAuthInjectorFair() {
        return Guice.createInjector((Module[])new Module[]{new FairTestServletModule(){

            @Override
            protected void configureServlets() {
                TestRMWebServicesReservation.this.setAuthFilter = true;
                this.conf.setBoolean("yarn.acl.enable", true);
                this.conf.setStrings("yarn.admin.acl", new String[]{"testuser1"});
                super.configureServlets();
            }
        }});
    }

    @Parameterized.Parameters
    public static Collection<Object[]> guiceConfigs() {
        return Arrays.asList({0, true}, {1, true}, {2, true}, {3, true}, {0, false}, {1, false}, {2, false}, {3, false});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestRMWebServicesReservation(int run, boolean recurrence) {
        super(((WebAppDescriptor.Builder)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).clientConfig((ClientConfig)new DefaultClientConfig(new Class[]{JAXBContextResolver.class}))).contextPath("jersey-guice-filter").servletPath("/").build());
        this.enableRecurrence = recurrence;
        switch (run) {
            default: {
                injector = this.getNoAuthInjectorCap();
                break;
            }
            case 1: {
                injector = this.getSimpleAuthInjectorCap();
                break;
            }
            case 2: {
                injector = this.getNoAuthInjectorFair();
                break;
            }
            case 3: {
                injector = this.getSimpleAuthInjectorFair();
            }
        }
    }

    private boolean isAuthenticationEnabled() {
        return this.setAuthFilter;
    }

    private WebResource constructWebResource(WebResource r, String ... paths) {
        WebResource rt = r;
        for (String path : paths) {
            rt = rt.path(path);
        }
        if (this.isAuthenticationEnabled()) {
            rt = rt.queryParam("user.name", this.webserviceUserName);
        }
        return rt;
    }

    private WebResource constructWebResource(String ... paths) {
        WebResource r = this.resource();
        WebResource ws = r.path("ws").path("v1").path("cluster");
        return this.constructWebResource(ws, paths);
    }

    @After
    public void tearDown() throws Exception {
        if (rm != null) {
            rm.stop();
        }
        super.tearDown();
    }

    @Test
    public void testSubmitReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId rid = this.getReservationIdTestHelper(1);
        ClientResponse response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((boolean)this.isHttpSuccessResponse(response));
            this.verifyReservationCount(1);
        }
        rm.stop();
    }

    @Test
    public void testSubmitDuplicateReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId rid = this.getReservationIdTestHelper(1);
        long currentTimestamp = clock.getTime() + 100000L;
        ClientResponse response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", currentTimestamp, "", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((boolean)this.isHttpSuccessResponse(response));
        }
        response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", currentTimestamp, "", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((boolean)this.isHttpSuccessResponse(response));
            this.verifyReservationCount(1);
        }
        rm.stop();
    }

    @Test
    public void testSubmitDifferentReservationWithSameId() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId rid = this.getReservationIdTestHelper(1);
        long currentTimestamp = clock.getTime() + 100000L;
        ClientResponse response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", currentTimestamp, "res1", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((boolean)this.isHttpSuccessResponse(response));
        }
        response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", currentTimestamp + 100000L, "res1", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((!this.isHttpSuccessResponse(response) ? 1 : 0) != 0);
            this.verifyReservationCount(1);
        }
        rm.stop();
    }

    @Test
    public void testFailedSubmitReservation() throws Exception {
        rm.start();
        this.setupCluster(1);
        ReservationId rid = this.getReservationIdTestHelper(1);
        ClientResponse response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", rid);
        Assert.assertTrue((!this.isHttpSuccessResponse(response) ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testUpdateReservation() throws JSONException, Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId rid = this.getReservationIdTestHelper(1);
        ClientResponse response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((boolean)this.isHttpSuccessResponse(response));
        }
        this.updateReservationTestHelper("reservation/update", rid, "application/json");
        rm.stop();
    }

    @Test
    public void testTimeIntervalRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", Long.toString((long)((double)time * 0.9))).queryParam("end-time", Long.toString(time + 90000L)).queryParam("include-resource-allocations", "true").queryParam("queue", DEFAULT_QUEUE);
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
        Assert.assertEquals((Object)reservationName, (Object)"res_1");
        rm.stop();
    }

    @Test
    public void testSameTimeIntervalRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        if (!this.isAuthenticationEnabled() && id1 == null && id2 == null) {
            return;
        }
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        String timeParam = Long.toString(time + 50000L);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", timeParam).queryParam("end-time", timeParam).queryParam("include-resource-allocations", "true").queryParam("queue", DEFAULT_QUEUE);
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
        Assert.assertEquals((Object)reservationName, (Object)"res_1");
        rm.stop();
    }

    @Test
    public void testInvalidTimeIntervalRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", "-100").queryParam("end-time", "-100").queryParam("include-resource-allocations", "true").queryParam("queue", DEFAULT_QUEUE);
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONArray reservations = json.getJSONArray("reservations");
        Assert.assertEquals((long)2L, (long)reservations.length());
        this.testRDLHelper(reservations.getJSONObject(0));
        this.testRDLHelper(reservations.getJSONObject(1));
        rm.stop();
    }

    @Test
    public void testInvalidEndTimeRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", Long.toString((long)((double)time + 130000.0))).queryParam("end-time", "-1").queryParam("include-resource-allocations", "true").queryParam("queue", DEFAULT_QUEUE);
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        if (!this.enableRecurrence) {
            JSONObject reservations = json.getJSONObject("reservations");
            this.testRDLHelper(reservations);
            String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
            Assert.assertEquals((Object)"res_2", (Object)reservationName);
        } else {
            JSONArray reservations = json.getJSONArray("reservations");
            Assert.assertEquals((long)2L, (long)reservations.length());
        }
        rm.stop();
    }

    @Test
    public void testEmptyEndTimeRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", new Long((long)((double)time + 130000.0)).toString()).queryParam("include-resource-allocations", "true").queryParam("queue", DEFAULT_QUEUE);
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        if (!this.enableRecurrence) {
            JSONObject reservations = json.getJSONObject("reservations");
            this.testRDLHelper(reservations);
            String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
            Assert.assertEquals((Object)"res_2", (Object)reservationName);
        } else {
            JSONArray reservations = json.getJSONArray("reservations");
            Assert.assertEquals((long)2L, (long)reservations.length());
        }
        rm.stop();
    }

    @Test
    public void testInvalidStartTimeRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", "-1").queryParam("end-time", new Long((long)((double)time + 90000.0)).toString()).queryParam("include-resource-allocations", "true").queryParam("queue", DEFAULT_QUEUE);
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
        Assert.assertEquals((Object)reservationName, (Object)"res_1");
        rm.stop();
    }

    @Test
    public void testEmptyStartTimeRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        long time = clock.getTime() + 100000L;
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("end-time", new Long((long)((double)time + 90000.0)).toString()).queryParam("include-resource-allocations", "true").queryParam("queue", DEFAULT_QUEUE);
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
        Assert.assertEquals((Object)reservationName, (Object)"res_1");
        rm.stop();
    }

    @Test
    public void testQueueOnlyRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_2", id2);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("queue", DEFAULT_QUEUE);
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        Assert.assertEquals((long)json.getJSONArray("reservations").length(), (long)2L);
        this.testRDLHelper(json.getJSONArray("reservations").getJSONObject(0));
        this.testRDLHelper(json.getJSONArray("reservations").getJSONObject(1));
        rm.stop();
    }

    @Test
    public void testEmptyQueueRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_2", id2);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH);
        this.testListReservationHelper(resource, ClientResponse.Status.BAD_REQUEST);
        rm.stop();
    }

    @Test
    public void testNonExistentQueueRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_2", id2);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("queue", "dedicated_invalid");
        this.testListReservationHelper(resource, ClientResponse.Status.BAD_REQUEST);
        rm.stop();
    }

    @Test
    public void testReservationIdRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_2", id2);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("include-resource-allocations", "true").queryParam("queue", DEFAULT_QUEUE);
        if (id1 != null) {
            resource = resource.queryParam("reservation-id", id1.toString());
        }
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationId = reservations.getString("reservation-id");
        Assert.assertEquals((Object)id1.toString(), (Object)reservationId);
        rm.stop();
    }

    @Test
    public void testInvalidReservationIdRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("queue", DEFAULT_QUEUE);
        if (id1 != null) {
            resource = resource.queryParam("reservation-id", "invalid" + id1.toString());
        }
        JSONObject response = this.testListReservationHelper(resource, ClientResponse.Status.NOT_FOUND);
        rm.stop();
    }

    @Test
    public void testIncludeResourceAllocations() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("include-resource-allocations", "true").queryParam("queue", DEFAULT_QUEUE);
        if (id1 != null) {
            resource = resource.queryParam("reservation-id", id1.toString());
        }
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationId = reservations.getString("reservation-id");
        Assert.assertEquals((Object)id1.toString(), (Object)reservationId);
        Assert.assertTrue((boolean)reservations.has("resource-allocations"));
        rm.stop();
    }

    @Test
    public void testExcludeResourceAllocations() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("include-resource-allocations", "false").queryParam("queue", DEFAULT_QUEUE);
        if (id1 != null) {
            resource = resource.queryParam("reservation-id", id1.toString());
        }
        JSONObject json = this.testListReservationHelper(resource);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationId = reservations.getString("reservation-id");
        Assert.assertEquals((Object)id1.toString(), (Object)reservationId);
        Assert.assertTrue((!reservations.has("resource-allocations") ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testDeleteReservation() throws JSONException, Exception {
        rm.start();
        for (int i = 0; i < 100; ++i) {
            MockNM amNodeManager = rm.registerNode("127.0.0." + i + ":1234", 102400);
            amNodeManager.nodeHeartbeat(true);
        }
        ReservationId rid = this.getReservationIdTestHelper(1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", rid);
        this.testDeleteReservationHelper("reservation/delete", rid, "application/json");
        rm.stop();
    }

    private ReservationId getReservationIdTestHelper(int fallbackReservationId) throws Exception {
        Thread.sleep(1000L);
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource(GET_NEW_RESERVATION_PATH).type("application/json").accept(new String[]{"application/json"})).post(ClientResponse.class);
        if (!this.isAuthenticationEnabled()) {
            Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
            return ReservationId.newInstance((long)clock.getTime(), (long)fallbackReservationId);
        }
        System.out.println("RESPONSE:" + response);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        ReservationId rid = null;
        try {
            rid = ReservationId.parseReservationId((String)json.getString("reservation-id"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return rid;
    }

    private ClientResponse reservationSubmissionTestHelper(String path, String media, ReservationId reservationId) throws Exception {
        long arrival = clock.getTime() + 100000L;
        return this.reservationSubmissionTestHelper(path, media, arrival, "res_1", reservationId);
    }

    private ClientResponse reservationSubmissionTestHelper(String path, String media, Long arrival, String reservationName, ReservationId reservationId) throws Exception {
        String reservationJson = this.loadJsonFile("submit-reservation.json");
        String recurrenceExpression = "";
        if (this.enableRecurrence) {
            recurrenceExpression = String.format("\"recurrence-expression\" : \"%s\",", 8640000);
        }
        String reservationJsonRequest = String.format(reservationJson, reservationId.toString(), arrival, arrival + 100000L, reservationName, recurrenceExpression);
        return this.submitAndVerifyReservation(path, media, reservationJsonRequest);
    }

    private ClientResponse submitAndVerifyReservation(String path, String media, String reservationJson) throws Exception {
        JSONJAXBContext jc = new JSONJAXBContext(JSONConfiguration.mapped().build(), new Class[]{ReservationSubmissionRequestInfo.class});
        JSONUnmarshaller unmarshaller = jc.createJSONUnmarshaller();
        ReservationSubmissionRequestInfo rsci = (ReservationSubmissionRequestInfo)unmarshaller.unmarshalFromJSON((Reader)new StringReader(reservationJson), ReservationSubmissionRequestInfo.class);
        Thread.sleep(1000L);
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource(path).entity((Object)rsci, "application/json").accept(new String[]{media})).post(ClientResponse.class);
        if (!this.isAuthenticationEnabled()) {
            Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
        }
        return response;
    }

    private void updateReservationTestHelper(String path, ReservationId reservationId, String media) throws Exception {
        String reservationJson = this.loadJsonFile("update-reservation.json");
        JSONJAXBContext jc = new JSONJAXBContext(JSONConfiguration.mapped().build(), new Class[]{ReservationUpdateRequestInfo.class});
        JSONUnmarshaller unmarshaller = jc.createJSONUnmarshaller();
        ReservationUpdateRequestInfo rsci = (ReservationUpdateRequestInfo)unmarshaller.unmarshalFromJSON((Reader)new StringReader(reservationJson), ReservationUpdateRequestInfo.class);
        if (this.isAuthenticationEnabled()) {
            if (rsci.getReservationId() == null) {
                throw new IOException("Incorrectly parsed the reservationId");
            }
            rsci.setReservationId(reservationId.toString());
        }
        Thread.sleep(1000L);
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource(path).entity((Object)rsci, "application/json").accept(new String[]{media})).post(ClientResponse.class);
        if (!this.isAuthenticationEnabled()) {
            Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
            return;
        }
        System.out.println("RESPONSE:" + response);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
    }

    private String loadJsonFile(String filename) throws IOException {
        ClassLoader cL = Thread.currentThread().getContextClassLoader();
        if (cL == null) {
            cL = Configuration.class.getClassLoader();
        }
        URL submitURI = cL.getResource(filename);
        String reservationJson = FileUtils.readFileToString((File)new File(submitURI.getFile()));
        return reservationJson;
    }

    private void testDeleteReservationHelper(String path, ReservationId reservationId, String media) throws JSONException, Exception {
        String reservationJson = this.loadJsonFile("delete-reservation.json");
        JSONJAXBContext jc = new JSONJAXBContext(JSONConfiguration.mapped().build(), new Class[]{ReservationDeleteRequestInfo.class});
        JSONUnmarshaller unmarshaller = jc.createJSONUnmarshaller();
        ReservationDeleteRequestInfo rsci = (ReservationDeleteRequestInfo)unmarshaller.unmarshalFromJSON((Reader)new StringReader(reservationJson), ReservationDeleteRequestInfo.class);
        if (this.isAuthenticationEnabled()) {
            if (rsci.getReservationId() == null) {
                throw new IOException("Incorrectly parsed the reservatinId");
            }
            rsci.setReservationId(reservationId.toString());
        }
        Thread.sleep(1000L);
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource(path).entity((Object)rsci, "application/json").accept(new String[]{media})).post(ClientResponse.class);
        if (!this.isAuthenticationEnabled()) {
            Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
            return;
        }
        System.out.println("RESPONSE:" + response);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
    }

    private void testRDLHelper(JSONObject json) throws JSONException {
        JSONObject requests = json.getJSONObject("reservation-definition").getJSONObject("reservation-requests");
        String type = requests.getString("reservation-request-interpreter");
        Assert.assertEquals((Object)"0", (Object)type);
        Assert.assertEquals((long)60L, (long)requests.getJSONArray("reservation-request").getJSONObject(0).getInt("duration"));
    }

    private JSONObject testListReservationHelper(WebResource resource) throws Exception {
        return this.testListReservationHelper(resource, ClientResponse.Status.OK);
    }

    private JSONObject testListReservationHelper(WebResource resource, ClientResponse.Status status) throws Exception {
        Thread.sleep(1000L);
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (!this.isAuthenticationEnabled()) {
            Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
            return null;
        }
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((Object)status, (Object)response.getClientResponseStatus());
        return (JSONObject)response.getEntity(JSONObject.class);
    }

    private void verifyReservationCount(int count) throws Exception {
        WebResource resource = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("queue", DEFAULT_QUEUE);
        JSONObject json = this.testListReservationHelper(resource);
        if (count == 1) {
            json.getJSONObject("reservations");
        } else {
            JSONArray reservations = json.getJSONArray("reservations");
            Assert.assertTrue((reservations.length() == count ? 1 : 0) != 0);
        }
    }

    private boolean isHttpSuccessResponse(ClientResponse response) {
        return response.getStatus() / 100 == 2;
    }

    private void setupCluster(int nodes) throws Exception {
        for (int i = 0; i < nodes; ++i) {
            MockNM amNodeManager = rm.registerNode("127.0.0." + i + ":1234", 102400);
            amNodeManager.nodeHeartbeat(true);
        }
    }

    static {
        clock = new UTCClock();
        TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        FS_ALLOC_FILE = new File(TEST_DIR, "test-fs-queues.xml").getAbsolutePath();
    }

    private class FairTestServletModule
    extends TestServletModule {
        private FairTestServletModule() {
        }

        @Override
        public void configureScheduler() {
            try {
                PrintWriter out = new PrintWriter(new FileWriter(FS_ALLOC_FILE));
                out.println("<?xml version=\"1.0\"?>");
                out.println("<allocations>");
                out.println("<queue name=\"root\">");
                out.println("  <aclAdministerApps>someuser </aclAdministerApps>");
                out.println("  <queue name=\"default\">");
                out.println("    <aclAdministerApps>someuser </aclAdministerApps>");
                out.println("  </queue>");
                out.println("  <queue name=\"dedicated\">");
                out.println("    <reservation>");
                out.println("    </reservation>");
                out.println("    <aclAdministerApps>someuser </aclAdministerApps>");
                out.println("  </queue>");
                out.println("</queue>");
                out.println("<defaultQueueSchedulingPolicy>drf</defaultQueueSchedulingPolicy>");
                out.println("</allocations>");
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.conf.set("yarn.scheduler.fair.allocation.file", FS_ALLOC_FILE);
            this.conf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
        }
    }

    private class CapTestServletModule
    extends TestServletModule {
        private CapTestServletModule() {
        }

        @Override
        public void configureScheduler() {
            this.conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
            this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
            CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration(this.conf);
            String[] queues = new String[]{"default", TestRMWebServicesReservation.DEFAULT_QUEUE};
            csconf.setQueues("root", queues);
            csconf.setCapacity("root.default", 50.0f);
            csconf.setCapacity("root.dedicated", 50.0f);
            csconf.setReservable("root.dedicated", true);
            this.conf = csconf;
        }
    }

    private abstract class TestServletModule
    extends ServletModule {
        public Configuration conf = new Configuration();

        private TestServletModule() {
        }

        public abstract void configureScheduler();

        protected void configureServlets() {
            this.configureScheduler();
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            this.conf.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
            rm = new MockRM(this.conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            if (TestRMWebServicesReservation.this.setAuthFilter) {
                this.filter("/*", new String[0]).through(TestRMCustomAuthFilter.class);
            }
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }

    @Singleton
    public static class TestRMCustomAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties props = new Properties();
            Enumeration names = filterConfig.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(configPrefix)) continue;
                String value = filterConfig.getInitParameter(name);
                props.put(name.substring(configPrefix.length()), value);
            }
            props.put("type", "simple");
            props.put("simple.anonymous.allowed", "false");
            return props;
        }
    }

    public static class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return injector;
        }
    }
}

