/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.sun.jersey.api.client.ClientResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.codehaus.jettison.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesDelegationTokenAuthentication {
    private static final File testRootDir = new File("target", TestRMWebServicesDelegationTokenAuthentication.class.getName() + "-root");
    private static File httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
    private static String httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    private static boolean miniKDCStarted = false;
    private static MiniKdc testMiniKDC;
    private static MockRM rm;
    String delegationTokenHeader;
    static final String OldDelegationTokenHeader = "Hadoop-YARN-Auth-Delegation-Token";
    static final String NewDelegationTokenHeader = "X-Hadoop-Delegation-Token";

    @BeforeClass
    public static void setUp() {
        try {
            testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
            TestRMWebServicesDelegationTokenAuthentication.setupKDC();
            TestRMWebServicesDelegationTokenAuthentication.setupAndStartRM();
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Couldn't create MiniKDC", (boolean)false);
        }
    }

    @AfterClass
    public static void tearDown() {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
        if (rm != null) {
            rm.stop();
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> headers() {
        return Arrays.asList({OldDelegationTokenHeader}, {NewDelegationTokenHeader});
    }

    public TestRMWebServicesDelegationTokenAuthentication(String header) throws Exception {
        this.delegationTokenHeader = header;
    }

    private static void setupAndStartRM() throws Exception {
        Configuration rmconf = new Configuration();
        rmconf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        rmconf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        rmconf.setBoolean("yarn.acl.enable", true);
        String httpPrefix = "hadoop.http.authentication.";
        rmconf.setStrings(httpPrefix + "type", new String[]{"kerberos"});
        rmconf.set(httpPrefix + "kerberos.principal", httpSpnegoPrincipal);
        rmconf.set(httpPrefix + "kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.set(httpPrefix + "signature.secret" + ".file", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.set("hadoop.security.authentication", "kerberos");
        rmconf.setBoolean("yarn.resourcemanager.webapp.delegation-token-auth-filter.enabled", true);
        rmconf.set("hadoop.http.filter.initializers", AuthenticationFilterInitializer.class.getName());
        rmconf.set("yarn.resourcemanager.webapp.spnego-principal", httpSpnegoPrincipal);
        rmconf.set("yarn.resourcemanager.keytab", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.set("yarn.resourcemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.set("yarn.nodemanager.webapp.spnego-principal", httpSpnegoPrincipal);
        rmconf.set("yarn.nodemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.setBoolean("mockrm.webapp.enabled", true);
        rmconf.set("yarn.resourcemanager.proxyuser.client.hosts", "*");
        rmconf.set("yarn.resourcemanager.proxyuser.client.groups", "*");
        UserGroupInformation.setConfiguration((Configuration)rmconf);
        rm = new MockRM(rmconf);
        rm.start();
    }

    private static void setupKDC() throws Exception {
        if (!miniKDCStarted) {
            testMiniKDC.start();
            TestRMWebServicesDelegationTokenAuthentication.getKdc().createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost", "client", UserGroupInformation.getLoginUser().getShortUserName(), "client2"});
            miniKDCStarted = true;
        }
    }

    private static MiniKdc getKdc() {
        return testMiniKDC;
    }

    @Test
    public void testDelegationTokenAuth() throws Exception {
        String token = this.getDelegationToken("test");
        ApplicationSubmissionContextInfo app = new ApplicationSubmissionContextInfo();
        String appid = "application_123_0";
        app.setApplicationId(appid);
        String requestBody = TestRMWebServicesDelegationTokenAuthentication.getMarshalledAppInfo(app);
        URL url = new URL("http://localhost:8088/ws/v1/cluster/apps");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/xml", requestBody);
        try {
            conn.getInputStream();
            Assert.fail((String)"we should not be here");
        }
        catch (IOException e) {
            Assert.assertEquals((long)ClientResponse.Status.UNAUTHORIZED.getStatusCode(), (long)conn.getResponseCode());
        }
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty(this.delegationTokenHeader, token);
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/xml", requestBody);
        try {
            conn.getInputStream();
        }
        catch (IOException ie) {
            String line;
            InputStream errorStream = conn.getErrorStream();
            String error = "";
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(errorStream, "UTF8"));
            while ((line = reader.readLine()) != null) {
                error = error + line;
            }
            reader.close();
            errorStream.close();
            Assert.fail((String)("Response " + conn.getResponseCode() + "; " + error));
        }
        boolean appExists = rm.getRMContext().getRMApps().containsKey(ApplicationId.fromString((String)appid));
        Assert.assertTrue((boolean)appExists);
        RMApp actualApp = (RMApp)rm.getRMContext().getRMApps().get(ApplicationId.fromString((String)appid));
        String owner = actualApp.getUser();
        Assert.assertEquals((Object)"client", (Object)owner);
    }

    @Test
    public void testCancelledDelegationToken() throws Exception {
        String token = this.getDelegationToken("client");
        this.cancelDelegationToken(token);
        ApplicationSubmissionContextInfo app = new ApplicationSubmissionContextInfo();
        String appid = "application_123_0";
        app.setApplicationId(appid);
        String requestBody = TestRMWebServicesDelegationTokenAuthentication.getMarshalledAppInfo(app);
        URL url = new URL("http://localhost:8088/ws/v1/cluster/apps");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty(this.delegationTokenHeader, token);
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/xml", requestBody);
        try {
            conn.getInputStream();
            Assert.fail((String)"Authentication should fail with expired delegation tokens");
        }
        catch (IOException e) {
            Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
        }
    }

    @Test
    public void testDelegationTokenOps() throws Exception {
        String[] requests;
        String token = this.getDelegationToken("client");
        String createRequest = "{\"renewer\":\"test\"}";
        String renewRequest = "{\"token\": \"" + token + "\"}";
        for (String requestBody : requests = new String[]{createRequest, renewRequest}) {
            URL url = new URL("http://localhost:8088/ws/v1/cluster/delegation-token");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty(this.delegationTokenHeader, token);
            TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/json", requestBody);
            try {
                conn.getInputStream();
                Assert.fail((String)"Creation/Renewing delegation tokens should not be allowed with token auth");
            }
            catch (IOException e) {
                Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
            }
        }
        URL url = new URL("http://localhost:8088/ws/v1/cluster/delegation-token");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty(this.delegationTokenHeader, token);
        conn.setRequestProperty("Hadoop-YARN-RM-Delegation-Token", token);
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "DELETE", null, null);
        try {
            conn.getInputStream();
            Assert.fail((String)"Cancelling delegation tokens should not be allowed with token auth");
        }
        catch (IOException e) {
            Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
        }
    }

    @Test
    public void testDoAs() throws Exception {
        KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                String token = "";
                String owner = "";
                String renewer = "renewer";
                String body = "{\"renewer\":\"" + renewer + "\"}";
                URL url = new URL("http://localhost:8088/ws/v1/cluster/delegation-token?doAs=client2");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/json", body);
                InputStream response = conn.getInputStream();
                Assert.assertEquals((long)ClientResponse.Status.OK.getStatusCode(), (long)conn.getResponseCode());
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(response, "UTF8"));
                    while ((line = reader.readLine()) != null) {
                        JSONObject obj = new JSONObject(line);
                        if (obj.has("token")) {
                            token = obj.getString("token");
                        }
                        if (!obj.has("owner")) continue;
                        owner = obj.getString("owner");
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    IOUtils.closeQuietly((InputStream)response);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((InputStream)response);
                Assert.assertEquals((Object)"client2", (Object)owner);
                Token realToken = new Token();
                realToken.decodeFromUrlString(token);
                Assert.assertEquals((Object)"client2", (Object)((RMDelegationTokenIdentifier)realToken.decodeIdentifier()).getOwner().toString());
                return null;
            }
        });
        String token = this.getDelegationToken("client");
        String renewer = "renewer";
        String body = "{\"renewer\":\"" + renewer + "\"}";
        URL url = new URL("http://localhost:8088/ws/v1/cluster/delegation-token?doAs=client2");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty(this.delegationTokenHeader, token);
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/json", body);
        try {
            conn.getInputStream();
            Assert.fail((String)"Client should not be allowed to impersonate using delegation tokens");
        }
        catch (IOException ie) {
            Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
        }
        KerberosTestUtils.doAs((String)"client2@EXAMPLE.COM", (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String renewer = "renewer";
                String body = "{\"renewer\":\"" + renewer + "\"}";
                URL url = new URL("http://localhost:8088/ws/v1/cluster/delegation-token?doAs=client");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/json", body);
                try {
                    conn.getInputStream();
                    Assert.fail((String)"Non superuser client should not be allowed to carry out doAs");
                }
                catch (IOException ie) {
                    Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
                }
                return null;
            }
        });
    }

    private String getDelegationToken(final String renewer) throws Exception {
        return (String)KerberosTestUtils.doAsClient((Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                String ret = null;
                String body = "{\"renewer\":\"" + renewer + "\"}";
                URL url = new URL("http://localhost:8088/ws/v1/cluster/delegation-token");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/json", body);
                InputStream response = conn.getInputStream();
                Assert.assertEquals((long)ClientResponse.Status.OK.getStatusCode(), (long)conn.getResponseCode());
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(response, "UTF8"));
                    while ((line = reader.readLine()) != null) {
                        JSONObject obj = new JSONObject(line);
                        if (!obj.has("token")) continue;
                        reader.close();
                        response.close();
                        ret = obj.getString("token");
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    IOUtils.closeQuietly((InputStream)response);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((InputStream)response);
                return ret;
            }
        });
    }

    private void cancelDelegationToken(final String tokenString) throws Exception {
        KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = new URL("http://localhost:8088/ws/v1/cluster/delegation-token");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Hadoop-YARN-RM-Delegation-Token", tokenString);
                TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "DELETE", null, null);
                InputStream response = conn.getInputStream();
                Assert.assertEquals((long)ClientResponse.Status.OK.getStatusCode(), (long)conn.getResponseCode());
                response.close();
                return null;
            }
        });
    }

    static String getMarshalledAppInfo(ApplicationSubmissionContextInfo appInfo) throws Exception {
        StringWriter writer = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ApplicationSubmissionContextInfo.class});
        Marshaller m = context.createMarshaller();
        m.marshal((Object)appInfo, (Writer)writer);
        return writer.toString();
    }

    static void setupConn(HttpURLConnection conn, String method, String contentType, String body) throws Exception {
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept-Charset", "UTF8");
        if (contentType != null && !contentType.isEmpty()) {
            conn.setRequestProperty("Content-Type", contentType + ";charset=UTF8");
            if (body != null && !body.isEmpty()) {
                OutputStream stream = conn.getOutputStream();
                stream.write(body.getBytes("UTF8"));
                stream.close();
            }
        }
    }
}

