/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FairSharePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FifoPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSchedulingPolicy {
    private static final Log LOG = LogFactory.getLog(TestSchedulingPolicy.class);
    private static final String ALLOC_FILE = new File(FairSchedulerTestBase.TEST_DIR, "test-queues").getAbsolutePath();
    private FairSchedulerConfiguration conf;
    private FairScheduler scheduler;

    @Before
    public void setUp() throws Exception {
        this.scheduler = new FairScheduler();
        this.conf = new FairSchedulerConfiguration();
    }

    public void testParseSchedulingPolicy() throws AllocationConfigurationException {
        SchedulingPolicy sm = SchedulingPolicy.parse((String)FairSharePolicy.class.getName());
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("fair"));
        sm = SchedulingPolicy.parse((String)FairSharePolicy.class.getCanonicalName());
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("fair"));
        sm = SchedulingPolicy.getInstance(FairSharePolicy.class);
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("fair"));
        sm = SchedulingPolicy.parse((String)"drf");
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("DRF"));
        sm = SchedulingPolicy.parse((String)"fair");
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("fair"));
        sm = SchedulingPolicy.parse((String)"fifo");
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("FIFO"));
    }

    @Test
    public void testFairShareComparatorTransitivity() {
        FairSharePolicy policy = new FairSharePolicy();
        Comparator fairShareComparator = policy.getComparator();
        FairShareComparatorTester tester = new FairShareComparatorTester(fairShareComparator);
        tester.testTransitivity();
    }

    @Test
    public void testSchedulingPolicyViolation() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<schedulingPolicy>fair</schedulingPolicy>");
        out.println("    <queue name=\"child1\">");
        out.println("    <schedulingPolicy>drf</schedulingPolicy>");
        out.println("    </queue>");
        out.println("    <queue name=\"child2\">");
        out.println("    <schedulingPolicy>fair</schedulingPolicy>");
        out.println("    </queue>");
        out.println("</queue>");
        out.println("<defaultQueueSchedulingPolicy>drf</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init((Configuration)this.conf);
        FSQueue child1 = this.scheduler.getQueueManager().getQueue("child1");
        Assert.assertNull((String)"Queue 'child1' should be null since its policy isn't allowed to be 'drf' if its parent policy is 'fair'.", (Object)child1);
        FSLeafQueue dynamicQueue = this.scheduler.getQueueManager().getLeafQueue("dynamicQueue", true);
        Assert.assertNull((String)"Dynamic queue should be null since it isn't allowed to be 'drf' policy if its parent policy is 'fair'.", (Object)dynamicQueue);
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<schedulingPolicy>fair</schedulingPolicy>");
        out.println("    <queue name=\"child1\">");
        out.println("    <schedulingPolicy>fair</schedulingPolicy>");
        out.println("    </queue>");
        out.println("    <queue name=\"child2\">");
        out.println("    <schedulingPolicy>drf</schedulingPolicy>");
        out.println("    </queue>");
        out.println("</queue>");
        out.println("<defaultQueueSchedulingPolicy>drf</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize((Configuration)this.conf, null);
        child1 = this.scheduler.getQueueManager().getQueue("child1");
        Assert.assertNotNull((String)"Queue 'child1' should be not null since its policy is allowed to be 'fair' if its parent policy is 'fair'.", (Object)child1);
        FSQueue child2 = this.scheduler.getQueueManager().getQueue("child2");
        Assert.assertTrue((String)"Queue 'child2' should be 'fair' since its new policy 'drf' is not allowed.", (boolean)(child2.getPolicy() instanceof FairSharePolicy));
    }

    @Test
    public void testSchedulingPolicyViolationInTheMiddleLevel() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<schedulingPolicy>fair</schedulingPolicy>");
        out.println("  <queue name=\"level2\">");
        out.println("    <schedulingPolicy>fair</schedulingPolicy>");
        out.println("    <queue name=\"level3\">");
        out.println("    <schedulingPolicy>drf</schedulingPolicy>");
        out.println("       <queue name=\"leaf\">");
        out.println("       <schedulingPolicy>fair</schedulingPolicy>");
        out.println("       </queue>");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init((Configuration)this.conf);
        FSQueue level2 = this.scheduler.getQueueManager().getQueue("level2");
        Assert.assertNotNull((String)"Queue 'level2' shouldn't be null since its policy is allowed to be 'fair' if its parent policy is 'fair'.", (Object)level2);
        FSQueue level3 = this.scheduler.getQueueManager().getQueue("level2.level3");
        Assert.assertNull((String)"Queue 'level3' should be null since its policy isn't allowed to be 'drf' if its parent policy is 'fair'.", (Object)level3);
        FSQueue leaf = this.scheduler.getQueueManager().getQueue("level2.level3.leaf");
        Assert.assertNull((String)"Queue 'leaf' should be null since its parent failed to create.", (Object)leaf);
    }

    @Test
    public void testFIFOPolicyOnlyForLeafQueues() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <queue name=\"intermediate\">");
        out.println("    <schedulingPolicy>fifo</schedulingPolicy>");
        out.println("    <queue name=\"leaf\">");
        out.println("    <schedulingPolicy>fair</schedulingPolicy>");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init((Configuration)this.conf);
        FSQueue intermediate = this.scheduler.getQueueManager().getQueue("intermediate");
        Assert.assertNull((String)"Queue 'intermediate' should be null since 'fifo' is only for leaf queue.", (Object)intermediate);
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <queue name=\"intermediate\">");
        out.println("    <schedulingPolicy>fair</schedulingPolicy>");
        out.println("    <queue name=\"leaf\">");
        out.println("    <schedulingPolicy>fifo</schedulingPolicy>");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize((Configuration)this.conf, null);
        Assert.assertNotNull((Object)this.scheduler.getQueueManager().getQueue("intermediate"));
        FSQueue leaf = this.scheduler.getQueueManager().getQueue("intermediate.leaf");
        Assert.assertNotNull((String)"Queue 'leaf' should be null since 'fifo' is only for leaf queue.", (Object)leaf);
    }

    @Test
    public void testPolicyReinitilization() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<schedulingPolicy>fair</schedulingPolicy>");
        out.println("    <queue name=\"child1\">");
        out.println("    <schedulingPolicy>fair</schedulingPolicy>");
        out.println("    </queue>");
        out.println("    <queue name=\"child2\">");
        out.println("    <schedulingPolicy>fair</schedulingPolicy>");
        out.println("    </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init((Configuration)this.conf);
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<schedulingPolicy>fair</schedulingPolicy>");
        out.println("    <queue name=\"child1\">");
        out.println("    <schedulingPolicy>drf</schedulingPolicy>");
        out.println("    </queue>");
        out.println("    <queue name=\"child2\">");
        out.println("    <schedulingPolicy>fifo</schedulingPolicy>");
        out.println("    </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize((Configuration)this.conf, null);
        FSQueue child1 = this.scheduler.getQueueManager().getQueue("child1");
        Assert.assertTrue((String)"Queue 'child1' should still be 'fair' since 'drf' isn't allowed if its parent policy is 'fair'.", (boolean)(child1.getPolicy() instanceof FairSharePolicy));
        FSQueue child2 = this.scheduler.getQueueManager().getQueue("child2");
        Assert.assertTrue((String)"Queue 'child2' should still be 'fair' there is a policy violation while reinitialization.", (boolean)(child2.getPolicy() instanceof FairSharePolicy));
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<schedulingPolicy>drf</schedulingPolicy>");
        out.println("    <queue name=\"child1\">");
        out.println("    <schedulingPolicy>drf</schedulingPolicy>");
        out.println("    </queue>");
        out.println("    <queue name=\"child2\">");
        out.println("    <schedulingPolicy>fifo</schedulingPolicy>");
        out.println("    </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize((Configuration)this.conf, null);
        child1 = this.scheduler.getQueueManager().getQueue("child1");
        Assert.assertTrue((String)"Queue 'child1' should be 'drf' since both 'root' and 'child1' are 'drf'.", (boolean)(child1.getPolicy() instanceof DominantResourceFairnessPolicy));
        child2 = this.scheduler.getQueueManager().getQueue("child2");
        Assert.assertTrue((String)"Queue 'child2' should still be 'fifo' there is no policy violation while reinitialization.", (boolean)(child2.getPolicy() instanceof FifoPolicy));
    }

    private class FairShareComparatorTester {
        private Comparator<Schedulable> fairShareComparator;
        private Resource minShare = Resource.newInstance((int)0, (int)1);
        private Resource demand = Resource.newInstance((int)4, (int)1);
        private Resource[] demandCollection = new Resource[]{Resource.newInstance((int)0, (int)0), Resource.newInstance((int)4, (int)1)};
        private String[] nameCollection = new String[]{"A", "B", "C"};
        private long[] startTimeColloection = new long[]{1L, 2L, 3L};
        private Resource[] usageCollection = new Resource[]{Resource.newInstance((int)0, (int)1), Resource.newInstance((int)2, (int)1), Resource.newInstance((int)4, (int)1)};
        private ResourceWeights[] weightsCollection = new ResourceWeights[]{new ResourceWeights(0.0f), new ResourceWeights(1.0f), new ResourceWeights(2.0f)};

        public FairShareComparatorTester(Comparator<Schedulable> fairShareComparator) {
            this.fairShareComparator = fairShareComparator;
        }

        public void testTransitivity() {
            this.generateAndTest(new Stack<Schedulable>());
        }

        private void generateAndTest(Stack<Schedulable> genSchedulable) {
            if (genSchedulable.size() == 3) {
                Assert.assertTrue((String)"The comparator must ensure transitivity", (boolean)this.checkTransitivity(genSchedulable));
                return;
            }
            for (int i = 0; i < this.nameCollection.length; ++i) {
                for (int j = 0; j < this.startTimeColloection.length; ++j) {
                    for (int k = 0; k < this.usageCollection.length; ++k) {
                        for (int t = 0; t < this.weightsCollection.length; ++t) {
                            for (int m = 0; m < this.demandCollection.length; ++m) {
                                genSchedulable.push(this.createSchedulable(m, i, j, k, t));
                                this.generateAndTest(genSchedulable);
                                genSchedulable.pop();
                            }
                        }
                    }
                }
            }
        }

        private Schedulable createSchedulable(int demandId, int nameIdx, int startTimeIdx, int usageIdx, int weightsIdx) {
            return new MockSchedulable(this.minShare, this.demandCollection[demandId], this.nameCollection[nameIdx], this.startTimeColloection[startTimeIdx], this.usageCollection[usageIdx], this.weightsCollection[weightsIdx]);
        }

        private boolean checkTransitivity(Collection<Schedulable> schedulableObjs) {
            Assert.assertEquals((long)3L, (long)schedulableObjs.size());
            Schedulable[] copy = schedulableObjs.toArray(new Schedulable[3]);
            if (this.fairShareComparator.compare(copy[0], copy[1]) > 0) {
                this.swap(copy, 0, 1);
            }
            if (this.fairShareComparator.compare(copy[1], copy[2]) > 0) {
                this.swap(copy, 1, 2);
                if (this.fairShareComparator.compare(copy[0], copy[1]) > 0) {
                    this.swap(copy, 0, 1);
                }
            }
            if (this.fairShareComparator.compare(copy[0], copy[2]) <= 0) {
                return true;
            }
            LOG.fatal((Object)("Failure data: " + copy[0] + " " + copy[1] + " " + copy[2]));
            return false;
        }

        private void swap(Schedulable[] array, int x, int y) {
            Schedulable tmp = array[x];
            array[x] = array[y];
            array[y] = tmp;
        }

        private class MockSchedulable
        implements Schedulable {
            private Resource minShare;
            private Resource demand;
            private String name;
            private long startTime;
            private Resource usage;
            private ResourceWeights weights;

            public MockSchedulable(Resource minShare, Resource demand, String name, long startTime, Resource usage, ResourceWeights weights) {
                this.minShare = minShare;
                this.demand = demand;
                this.name = name;
                this.startTime = startTime;
                this.usage = usage;
                this.weights = weights;
            }

            public String getName() {
                return this.name;
            }

            public Resource getDemand() {
                return this.demand;
            }

            public Resource getResourceUsage() {
                return this.usage;
            }

            public Resource getMinShare() {
                return this.minShare;
            }

            public ResourceWeights getWeights() {
                return this.weights;
            }

            public long getStartTime() {
                return this.startTime;
            }

            public Resource getMaxShare() {
                throw new UnsupportedOperationException();
            }

            public Priority getPriority() {
                throw new UnsupportedOperationException();
            }

            public void updateDemand() {
                throw new UnsupportedOperationException();
            }

            public Resource assignContainer(FSSchedulerNode node) {
                throw new UnsupportedOperationException();
            }

            public Resource getFairShare() {
                throw new UnsupportedOperationException();
            }

            public void setFairShare(Resource fairShare) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "{name:" + this.name + ", start:" + this.startTime + ", usage:" + this.usage + ", weights:" + this.weights + ", demand:" + this.demand + ", minShare:" + this.minShare + "}";
            }

            public boolean isPreemptable() {
                return true;
            }
        }
    }
}

