/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FairSharePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FifoPolicy;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSAppAttempt
extends FairSchedulerTestBase {
    @Before
    public void setup() {
        Configuration conf = this.createConfiguration();
        this.resourceManager = new MockRM(conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
    }

    @Test
    public void testDelayScheduling() {
        int i;
        FSLeafQueue queue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        Priority pri = (Priority)Mockito.mock(Priority.class);
        SchedulerRequestKey prio = TestUtils.toSchedulerKey(pri);
        Mockito.when((Object)pri.getPriority()).thenReturn((Object)1);
        double nodeLocalityThreshold = 0.5;
        double rackLocalityThreshold = 0.6;
        ApplicationAttemptId applicationAttemptId = this.createAppAttemptId(1, 1);
        RMContext rmContext = this.resourceManager.getRMContext();
        FSAppAttempt schedulerApp = new FSAppAttempt(this.scheduler, applicationAttemptId, "user1", queue, null, rmContext);
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        for (i = 0; i < 5; ++i) {
            schedulerApp.addSchedulingOpportunity(prio);
            Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        }
        schedulerApp.addSchedulingOpportunity(prio);
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        schedulerApp.resetAllowedLocalityLevel(prio, NodeType.NODE_LOCAL);
        schedulerApp.resetSchedulingOpportunities(prio);
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        for (i = 0; i < 5; ++i) {
            schedulerApp.addSchedulingOpportunity(prio);
            Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        }
        schedulerApp.addSchedulingOpportunity(prio);
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        for (i = 0; i < 6; ++i) {
            schedulerApp.addSchedulingOpportunity(prio);
            Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        }
        schedulerApp.addSchedulingOpportunity(prio);
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
    }

    @Test
    public void testDelaySchedulingForContinuousScheduling() throws InterruptedException {
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue("queue", true);
        Priority pri = (Priority)Mockito.mock(Priority.class);
        SchedulerRequestKey prio = TestUtils.toSchedulerKey(pri);
        Mockito.when((Object)pri.getPriority()).thenReturn((Object)1);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        long nodeLocalityDelayMs = 5000L;
        long rackLocalityDelayMs = 6000L;
        RMContext rmContext = this.resourceManager.getRMContext();
        ApplicationAttemptId applicationAttemptId = this.createAppAttemptId(1, 1);
        FSAppAttempt schedulerApp = new FSAppAttempt(this.scheduler, applicationAttemptId, "user1", queue, null, rmContext);
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
        clock.tickSec(4);
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
        clock.tickSec(2);
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
        schedulerApp.resetAllowedLocalityLevel(prio, NodeType.NODE_LOCAL);
        schedulerApp.resetSchedulingOpportunities(prio, clock.getTime());
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
        clock.tickSec(6);
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
        clock.tickSec(7);
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)schedulerApp.getAllowedLocalityLevelByTime(prio, nodeLocalityDelayMs, rackLocalityDelayMs, clock.getTime()));
    }

    @Test
    public void testLocalityLevelWithoutDelays() {
        FSLeafQueue queue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        Priority pri = (Priority)Mockito.mock(Priority.class);
        SchedulerRequestKey prio = TestUtils.toSchedulerKey(pri);
        Mockito.when((Object)pri.getPriority()).thenReturn((Object)1);
        RMContext rmContext = this.resourceManager.getRMContext();
        ApplicationAttemptId applicationAttemptId = this.createAppAttemptId(1, 1);
        FSAppAttempt schedulerApp = new FSAppAttempt(this.scheduler, applicationAttemptId, "user1", queue, null, rmContext);
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, -1.0, -1.0));
    }

    @Test
    public void testHeadroom() {
        FairScheduler mockScheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        Mockito.when((Object)mockScheduler.getClock()).thenReturn((Object)this.scheduler.getClock());
        FSLeafQueue mockQueue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        Resource queueMaxResources = Resource.newInstance((int)5120, (int)3);
        Resource queueFairShare = Resources.createResource((int)4096, (int)2);
        Resource queueUsage = Resource.newInstance((int)2048, (int)2);
        Resource queueStarvation = Resources.subtract((Resource)queueFairShare, (Resource)queueUsage);
        Resource queueMaxResourcesAvailable = Resources.subtract((Resource)queueMaxResources, (Resource)queueUsage);
        Resource clusterResource = Resources.createResource((int)8192, (int)8);
        Resource clusterUsage = Resources.createResource((int)2048, (int)2);
        Resource clusterAvailable = Resources.subtract((Resource)clusterResource, (Resource)clusterUsage);
        QueueMetrics fakeRootQueueMetrics = (QueueMetrics)Mockito.mock(QueueMetrics.class);
        Mockito.when((Object)mockQueue.getMaxShare()).thenReturn((Object)queueMaxResources);
        Mockito.when((Object)mockQueue.getFairShare()).thenReturn((Object)queueFairShare);
        Mockito.when((Object)mockQueue.getResourceUsage()).thenReturn((Object)queueUsage);
        Mockito.when((Object)mockScheduler.getClusterResource()).thenReturn((Object)clusterResource);
        Mockito.when((Object)fakeRootQueueMetrics.getAllocatedResources()).thenReturn((Object)clusterUsage);
        Mockito.when((Object)mockScheduler.getRootQueueMetrics()).thenReturn((Object)fakeRootQueueMetrics);
        ApplicationAttemptId applicationAttemptId = this.createAppAttemptId(1, 1);
        RMContext rmContext = this.resourceManager.getRMContext();
        FSAppAttempt schedulerApp = new FSAppAttempt(mockScheduler, applicationAttemptId, "user1", mockQueue, null, rmContext);
        Mockito.when((Object)mockQueue.getPolicy()).thenReturn((Object)SchedulingPolicy.getInstance(DominantResourceFairnessPolicy.class));
        this.verifyHeadroom(schedulerApp, TestFSAppAttempt.min(queueStarvation.getMemorySize(), clusterAvailable.getMemorySize(), queueMaxResourcesAvailable.getMemorySize()), TestFSAppAttempt.min(queueStarvation.getVirtualCores(), clusterAvailable.getVirtualCores(), queueMaxResourcesAvailable.getVirtualCores()));
        Mockito.when((Object)mockQueue.getPolicy()).thenReturn((Object)SchedulingPolicy.getInstance(FairSharePolicy.class));
        this.verifyHeadroom(schedulerApp, TestFSAppAttempt.min(queueStarvation.getMemorySize(), clusterAvailable.getMemorySize(), queueMaxResourcesAvailable.getMemorySize()), Math.min(clusterAvailable.getVirtualCores(), queueMaxResourcesAvailable.getVirtualCores()));
        Mockito.when((Object)mockQueue.getPolicy()).thenReturn((Object)SchedulingPolicy.getInstance(FifoPolicy.class));
        this.verifyHeadroom(schedulerApp, TestFSAppAttempt.min(queueStarvation.getMemorySize(), clusterAvailable.getMemorySize(), queueMaxResourcesAvailable.getMemorySize()), Math.min(clusterAvailable.getVirtualCores(), queueMaxResourcesAvailable.getVirtualCores()));
    }

    @Test
    public void testHeadroomWithBlackListedNodes() {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((String)"We should have two alive nodes.", (long)2L, (long)this.scheduler.getNumClusterNodes());
        Resource clusterResource = this.scheduler.getClusterResource();
        Resource clusterUsage = this.scheduler.getRootQueueMetrics().getAllocatedResources();
        Assert.assertEquals((long)12288L, (long)clusterResource.getMemorySize());
        Assert.assertEquals((long)12L, (long)clusterResource.getVirtualCores());
        Assert.assertEquals((long)0L, (long)clusterUsage.getMemorySize());
        Assert.assertEquals((long)0L, (long)clusterUsage.getVirtualCores());
        ApplicationAttemptId id11 = this.createAppAttemptId(1, 1);
        this.createMockRMApp(id11);
        this.scheduler.addApplication(id11.getApplicationId(), "default", "user1", false);
        this.scheduler.addApplicationAttempt(id11, false, false);
        Assert.assertNotNull(this.scheduler.getSchedulerApplications().get(id11.getApplicationId()));
        FSAppAttempt app = this.scheduler.getSchedulerApp(id11);
        Assert.assertNotNull((Object)app);
        Resource queueUsage = app.getQueue().getResourceUsage();
        Assert.assertEquals((long)0L, (long)queueUsage.getMemorySize());
        Assert.assertEquals((long)0L, (long)queueUsage.getVirtualCores());
        SchedulerNode n1 = this.scheduler.getSchedulerNode(node1.getNodeID());
        SchedulerNode n2 = this.scheduler.getSchedulerNode(node2.getNodeID());
        Assert.assertNotNull((Object)n1);
        Assert.assertNotNull((Object)n2);
        ArrayList<String> blacklistAdditions = new ArrayList<String>(1);
        ArrayList<String> blacklistRemovals = new ArrayList<String>(1);
        blacklistAdditions.add(n1.getNodeName());
        app.updateBlacklist(blacklistAdditions, blacklistRemovals);
        app.getQueue().setFairShare(clusterResource);
        FSAppAttempt spyApp = (FSAppAttempt)Mockito.spy((Object)app);
        ((FSAppAttempt)Mockito.doReturn((Object)false).when((Object)spyApp)).isWaitingForAMContainer();
        Assert.assertTrue((boolean)spyApp.isPlaceBlacklisted(n1.getNodeName()));
        Assert.assertFalse((boolean)spyApp.isPlaceBlacklisted(n2.getNodeName()));
        Assert.assertEquals((Object)n2.getUnallocatedResource(), (Object)spyApp.getHeadroom());
        blacklistAdditions.clear();
        blacklistAdditions.add(n2.getNodeName());
        blacklistRemovals.add(n1.getNodeName());
        app.updateBlacklist(blacklistAdditions, blacklistRemovals);
        Assert.assertFalse((boolean)spyApp.isPlaceBlacklisted(n1.getNodeName()));
        Assert.assertTrue((boolean)spyApp.isPlaceBlacklisted(n2.getNodeName()));
        Assert.assertEquals((Object)n1.getUnallocatedResource(), (Object)spyApp.getHeadroom());
        blacklistAdditions.clear();
        blacklistRemovals.clear();
        blacklistRemovals.add(n2.getNodeName());
        app.updateBlacklist(blacklistAdditions, blacklistRemovals);
        Assert.assertFalse((boolean)spyApp.isPlaceBlacklisted(n1.getNodeName()));
        Assert.assertFalse((boolean)spyApp.isPlaceBlacklisted(n2.getNodeName()));
        Assert.assertEquals((Object)clusterResource, (Object)spyApp.getHeadroom());
    }

    private static long min(long value1, long value2, long value3) {
        return Math.min(Math.min(value1, value2), value3);
    }

    protected void verifyHeadroom(FSAppAttempt schedulerApp, long expectedMemory, long expectedCPU) {
        Resource headroom = schedulerApp.getHeadroom();
        Assert.assertEquals((long)expectedMemory, (long)headroom.getMemorySize());
        Assert.assertEquals((long)expectedCPU, (long)headroom.getVirtualCores());
    }
}

