/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.mockito.Mockito;

public class FairSchedulerTestBase {
    public static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected int APP_ID = 1;
    protected int ATTEMPT_ID = 1;
    protected Configuration conf;
    protected FairScheduler scheduler;
    protected ResourceManager resourceManager;
    public static final float TEST_RESERVATION_THRESHOLD = 0.09f;
    private static final int SLEEP_DURATION = 10;
    private static final int SLEEP_RETRIES = 1000;
    static final ContainerUpdates NULL_UPDATE_REQUESTS = new ContainerUpdates();
    protected final List<RMNode> rmNodes = new ArrayList<RMNode>();

    public Configuration createConfiguration() {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        this.conf.setInt("yarn.scheduler.increment-allocation-mb", 1024);
        this.conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", false);
        this.conf.setLong("yarn.scheduler.fair.update-interval-ms", 10L);
        this.conf.setFloat("yarn.scheduler.fair.preemption.cluster-utilization-threshold", 0.0f);
        this.conf.setFloat("yarn.scheduler.reservation-threshold.increment-multiple", 0.09f);
        return this.conf;
    }

    protected ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        return ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
    }

    protected ResourceRequest createResourceRequest(int memory, String host, int priority2, int numContainers, boolean relaxLocality) {
        return this.createResourceRequest(memory, 1, host, priority2, numContainers, relaxLocality);
    }

    protected ResourceRequest createResourceRequest(int memory, int vcores, String host, int priority2, int numContainers, boolean relaxLocality) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        request.setCapability(BuilderUtils.newResource((long)memory, (int)vcores));
        request.setResourceName(host);
        request.setNumContainers(numContainers);
        Priority prio = (Priority)recordFactory.newRecordInstance(Priority.class);
        prio.setPriority(priority2);
        request.setPriority(prio);
        request.setRelaxLocality(relaxLocality);
        request.setNodeLabelExpression("");
        return request;
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId) {
        return this.createSchedulingRequest(memory, queueId, userId, 1);
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId) {
        return this.createSchedulingRequest(memory, vcores, queueId, userId, 1);
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId, int numContainers) {
        return this.createSchedulingRequest(memory, queueId, userId, numContainers, 1);
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId, int numContainers) {
        return this.createSchedulingRequest(memory, vcores, queueId, userId, numContainers, 1);
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId, int numContainers, int priority2) {
        return this.createSchedulingRequest(memory, 1, queueId, userId, numContainers, priority2);
    }

    protected ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId, int numContainers, int priority2) {
        ApplicationAttemptId id = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.scheduler.addApplication(id.getApplicationId(), queueId, userId, false);
        if (this.scheduler.getSchedulerApplications().containsKey(id.getApplicationId())) {
            this.scheduler.addApplicationAttempt(id, false, false);
        }
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest request = this.createResourceRequest(memory, vcores, "*", priority2, numContainers, true);
        ask.add(request);
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        RMAppAttempt rmAppAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)rmApp.getCurrentAppAttempt()).thenReturn((Object)rmAppAttempt);
        Mockito.when((Object)rmAppAttempt.getRMAppAttemptMetrics()).thenReturn((Object)new RMAppAttemptMetrics(id, this.resourceManager.getRMContext()));
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)submissionContext.getUnmanagedAM()).thenReturn((Object)false);
        Mockito.when((Object)rmAppAttempt.getSubmissionContext()).thenReturn((Object)submissionContext);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)rmAppAttempt.getMasterContainer()).thenReturn((Object)container);
        this.resourceManager.getRMContext().getRMApps().put(id.getApplicationId(), rmApp);
        this.scheduler.allocate(id, ask, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        this.scheduler.update();
        return id;
    }

    protected ApplicationAttemptId createSchedulingRequest(String queueId, String userId, List<ResourceRequest> ask) {
        ApplicationAttemptId id = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.scheduler.addApplication(id.getApplicationId(), queueId, userId, false);
        if (this.scheduler.getSchedulerApplications().containsKey(id.getApplicationId())) {
            this.scheduler.addApplicationAttempt(id, false, false);
        }
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        RMAppAttempt rmAppAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)rmApp.getCurrentAppAttempt()).thenReturn((Object)rmAppAttempt);
        Mockito.when((Object)rmAppAttempt.getRMAppAttemptMetrics()).thenReturn((Object)new RMAppAttemptMetrics(id, this.resourceManager.getRMContext()));
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)submissionContext.getUnmanagedAM()).thenReturn((Object)false);
        Mockito.when((Object)rmAppAttempt.getSubmissionContext()).thenReturn((Object)submissionContext);
        this.resourceManager.getRMContext().getRMApps().put(id.getApplicationId(), rmApp);
        this.scheduler.allocate(id, ask, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        return id;
    }

    protected void createSchedulingRequestExistingApplication(int memory, int priority2, ApplicationAttemptId attId) {
        ResourceRequest request = this.createResourceRequest(memory, "*", priority2, 1, true);
        this.createSchedulingRequestExistingApplication(request, attId);
    }

    protected void createSchedulingRequestExistingApplication(int memory, int vcores, int priority2, ApplicationAttemptId attId) {
        ResourceRequest request = this.createResourceRequest(memory, vcores, "*", priority2, 1, true);
        this.createSchedulingRequestExistingApplication(request, attId);
    }

    protected void createSchedulingRequestExistingApplication(ResourceRequest request, ApplicationAttemptId attId) {
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ask.add(request);
        this.scheduler.allocate(attId, ask, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        this.scheduler.update();
    }

    protected void createApplicationWithAMResource(ApplicationAttemptId attId, String queue, String user, Resource amResource) {
        RMContext rmContext = this.resourceManager.getRMContext();
        ApplicationId appId = attId.getApplicationId();
        RMAppImpl rmApp = new RMAppImpl(appId, rmContext, this.conf, null, user, null, ApplicationSubmissionContext.newInstance((ApplicationId)appId, null, (String)queue, null, (ContainerLaunchContext)((ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class)), (boolean)false, (boolean)false, (int)0, (Resource)amResource, null), (YarnScheduler)this.scheduler, null, 0L, null, null, null);
        rmContext.getRMApps().put(appId, rmApp);
        RMAppEvent event = new RMAppEvent(appId, RMAppEventType.START);
        ((RMApp)this.resourceManager.getRMContext().getRMApps().get(appId)).handle((Event)event);
        event = new RMAppEvent(appId, RMAppEventType.APP_NEW_SAVED);
        ((RMApp)this.resourceManager.getRMContext().getRMApps().get(appId)).handle((Event)event);
        event = new RMAppEvent(appId, RMAppEventType.APP_ACCEPTED);
        ((RMApp)this.resourceManager.getRMContext().getRMApps().get(appId)).handle((Event)event);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(appId, queue, user);
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attempAddedEvent = new AppAttemptAddedSchedulerEvent(attId, false);
        this.scheduler.handle((SchedulerEvent)attempAddedEvent);
    }

    protected RMApp createMockRMApp(ApplicationAttemptId attemptId) {
        RMApp app = (RMApp)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)attemptId.getApplicationId());
        RMAppAttemptImpl attempt = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Mockito.when((Object)attempt.getAppAttemptId()).thenReturn((Object)attemptId);
        RMAppAttemptMetrics attemptMetric = (RMAppAttemptMetrics)Mockito.mock(RMAppAttemptMetrics.class);
        Mockito.when((Object)attempt.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)attempt);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)submissionContext.getUnmanagedAM()).thenReturn((Object)false);
        Mockito.when((Object)attempt.getSubmissionContext()).thenReturn((Object)submissionContext);
        this.resourceManager.getRMContext().getRMApps().put(attemptId.getApplicationId(), app);
        return app;
    }

    protected void checkAppConsumption(FSAppAttempt app, Resource resource) throws InterruptedException {
        for (int i = 0; i < 1000 && !Resources.equals((Resource)resource, (Resource)app.getCurrentConsumption()); ++i) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((long)resource.getMemorySize(), (long)app.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)resource.getVirtualCores(), (long)app.getCurrentConsumption().getVirtualCores());
    }

    protected void addNode(int memory, int cores) {
        int id = this.rmNodes.size() + 1;
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)memory, (int)cores), id, "127.0.0." + id);
        this.scheduler.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        this.rmNodes.add(node);
    }
}

