/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.List;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ClusterNodeTracker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClusterNodeTracker {
    private ClusterNodeTracker<FSSchedulerNode> nodeTracker = new ClusterNodeTracker();

    @Before
    public void setup() {
        List<RMNode> rmNodes = MockNodes.newNodes(2, 4, Resource.newInstance((int)4096, (int)4));
        for (RMNode rmNode : rmNodes) {
            this.nodeTracker.addNode((SchedulerNode)new FSSchedulerNode(rmNode, false));
        }
    }

    @Test
    public void testGetNodeCount() {
        Assert.assertEquals((String)"Incorrect number of nodes in the cluster", (long)8L, (long)this.nodeTracker.nodeCount());
        Assert.assertEquals((String)"Incorrect number of nodes in each rack", (long)4L, (long)this.nodeTracker.nodeCount("rack0"));
    }

    @Test
    public void testGetNodesForResourceName() throws Exception {
        Assert.assertEquals((String)"Incorrect number of nodes matching ANY", (long)8L, (long)this.nodeTracker.getNodesByResourceName("*").size());
        Assert.assertEquals((String)"Incorrect number of nodes matching rack", (long)4L, (long)this.nodeTracker.getNodesByResourceName("rack0").size());
        Assert.assertEquals((String)"Incorrect number of nodes matching node", (long)1L, (long)this.nodeTracker.getNodesByResourceName("host0").size());
    }
}

