/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNodeUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestNodesListManager {
    ArrayList<ApplicationId> applist = new ArrayList();

    @Test(timeout=300000L)
    public void testNodeUsableEvent() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        final Dispatcher dispatcher = this.getDispatcher();
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm = new MockRM((Configuration)conf){

            @Override
            protected Dispatcher createDispatcher() {
                return dispatcher;
            }
        };
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 28000);
        NodesListManager nodesListManager = rm.getNodesListManager();
        Resource clusterResource = Resource.newInstance((int)28000, (int)8);
        RMNode rmnode = MockNodes.newNodeInfo(1, clusterResource);
        RMApp killrmApp = rm.submitApp(200);
        rm.killApp(killrmApp.getApplicationId());
        rm.waitForState(killrmApp.getApplicationId(), RMAppState.KILLED);
        RMApp finshrmApp = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = finshrmApp.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FINISHED);
        RMApp subrmApp = rm.submitApp(200);
        nodesListManager.handle(new NodesListManagerEvent(NodesListManagerEventType.NODE_USABLE, rmnode));
        if (this.applist.size() > 0) {
            Assert.assertTrue((String)("Event based on running app expected " + subrmApp.getApplicationId()), (boolean)this.applist.contains(subrmApp.getApplicationId()));
            Assert.assertFalse((String)("Event based on finish app not expected " + finshrmApp.getApplicationId()), (boolean)this.applist.contains(finshrmApp.getApplicationId()));
            Assert.assertFalse((String)("Event based on killed app not expected " + killrmApp.getApplicationId()), (boolean)this.applist.contains(killrmApp.getApplicationId()));
        } else {
            Assert.fail((String)"Events received should have beeen more than 1");
        }
        this.applist.clear();
        nodesListManager.handle(new NodesListManagerEvent(NodesListManagerEventType.NODE_UNUSABLE, rmnode));
        if (this.applist.size() > 0) {
            Assert.assertTrue((String)("Event based on running app expected " + subrmApp.getApplicationId()), (boolean)this.applist.contains(subrmApp.getApplicationId()));
            Assert.assertFalse((String)("Event based on finish app not expected " + finshrmApp.getApplicationId()), (boolean)this.applist.contains(finshrmApp.getApplicationId()));
            Assert.assertFalse((String)("Event based on killed app not expected " + killrmApp.getApplicationId()), (boolean)this.applist.contains(killrmApp.getApplicationId()));
        } else {
            Assert.fail((String)"Events received should have beeen more than 1");
        }
    }

    @Test
    public void testCachedResolver() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        ControlledClock clock = new ControlledClock();
        clock.setTime(0L);
        int CACHE_EXPIRY_INTERVAL_SECS = 30;
        NodesListManager.CachedResolver resolver = new NodesListManager.CachedResolver((Clock)clock, 30);
        resolver.init((Configuration)new YarnConfiguration());
        resolver.start();
        resolver.addToCache("testCachedResolverHost1", "1.1.1.1");
        Assert.assertEquals((Object)"1.1.1.1", (Object)resolver.resolve("testCachedResolverHost1"));
        resolver.addToCache("testCachedResolverHost2", "1.1.1.2");
        Assert.assertEquals((Object)"1.1.1.1", (Object)resolver.resolve("testCachedResolverHost1"));
        Assert.assertEquals((Object)"1.1.1.2", (Object)resolver.resolve("testCachedResolverHost2"));
        resolver.removeFromCache("testCachedResolverHost1");
        Assert.assertNotEquals((Object)"1.1.1.1", (Object)resolver.resolve("testCachedResolverHost1"));
        Assert.assertEquals((Object)"1.1.1.2", (Object)resolver.resolve("testCachedResolverHost2"));
        clock.tickMsec(30001L);
        resolver.getExpireChecker().run();
        Assert.assertNotEquals((Object)"1.1.1.1", (Object)resolver.resolve("testCachedResolverHost1"));
        Assert.assertNotEquals((Object)"1.1.1.2", (Object)resolver.resolve("testCachedResolverHost2"));
    }

    @Test
    public void testDefaultResolver() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm = new MockRM((Configuration)conf);
        rm.init((Configuration)conf);
        NodesListManager nodesListManager = rm.getNodesListManager();
        NodesListManager.Resolver resolver = nodesListManager.getResolver();
        Assert.assertTrue((String)"default resolver should be DirectResolver", (boolean)(resolver instanceof NodesListManager.DirectResolver));
    }

    @Test
    public void testCachedResolverWithEvent() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.node-ip-cache.expiry-interval-secs", 30);
        MockRM rm = new MockRM((Configuration)conf);
        rm.init((Configuration)conf);
        NodesListManager nodesListManager = rm.getNodesListManager();
        nodesListManager.init((Configuration)conf);
        nodesListManager.start();
        NodesListManager.CachedResolver resolver = (NodesListManager.CachedResolver)nodesListManager.getResolver();
        resolver.addToCache("testCachedResolverHost1", "1.1.1.1");
        resolver.addToCache("testCachedResolverHost2", "1.1.1.2");
        Assert.assertEquals((Object)"1.1.1.1", (Object)resolver.resolve("testCachedResolverHost1"));
        Assert.assertEquals((Object)"1.1.1.2", (Object)resolver.resolve("testCachedResolverHost2"));
        RMNode rmnode1 = MockNodes.newNodeInfo(1, Resource.newInstance((int)28000, (int)8), 1, "testCachedResolverHost1", 1234);
        RMNode rmnode2 = MockNodes.newNodeInfo(1, Resource.newInstance((int)28000, (int)8), 1, "testCachedResolverHost2", 1234);
        nodesListManager.handle(new NodesListManagerEvent(NodesListManagerEventType.NODE_USABLE, rmnode1));
        Assert.assertNotEquals((Object)"1.1.1.1", (Object)resolver.resolve("testCachedResolverHost1"));
        Assert.assertEquals((Object)"1.1.1.2", (Object)resolver.resolve("testCachedResolverHost2"));
        nodesListManager.handle(new NodesListManagerEvent(NodesListManagerEventType.NODE_USABLE, rmnode2));
        Assert.assertNotEquals((Object)"1.1.1.1", (Object)resolver.resolve("testCachedResolverHost1"));
        Assert.assertNotEquals((Object)"1.1.1.2", (Object)resolver.resolve("testCachedResolverHost2"));
    }

    private Dispatcher getDispatcher() {
        DrainDispatcher dispatcher = new DrainDispatcher(){

            public EventHandler getEventHandler() {
                EventHandler handler = (EventHandler)Mockito.spy((Object)super.getEventHandler());
                class EventArgMatcher
                extends ArgumentMatcher<AbstractEvent> {
                    EventArgMatcher() {
                    }

                    public boolean matches(Object argument) {
                        if (argument instanceof RMAppNodeUpdateEvent) {
                            ApplicationId appid = ((RMAppNodeUpdateEvent)argument).getApplicationId();
                            TestNodesListManager.this.applist.add(appid);
                        }
                        return false;
                    }
                }
                ((EventHandler)Mockito.doNothing().when((Object)handler)).handle((Event)Matchers.argThat((Matcher)new EventArgMatcher()));
                return handler;
            }
        };
        return dispatcher;
    }
}

