/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.CollectorInfo;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;

public class MockRMApp
implements RMApp {
    static final int DT = 1000000;
    String user = MockApps.newUserName();
    String name = MockApps.newAppName();
    String queue = MockApps.newQueue();
    long start = System.currentTimeMillis() - (long)((int)(Math.random() * 1000000.0));
    long submit = this.start - (long)((int)(Math.random() * 1000000.0));
    long finish = 0L;
    RMAppState state = RMAppState.NEW;
    int failCount = 0;
    ApplicationId id;
    String url = null;
    String oUrl = null;
    StringBuilder diagnostics = new StringBuilder();
    RMAppAttempt attempt;
    int maxAppAttempts = 1;
    List<ResourceRequest> amReqs;

    public MockRMApp(int newid, long time, RMAppState newState) {
        this.finish = time;
        this.id = MockApps.newAppID((int)newid);
        this.state = newState;
        this.amReqs = Collections.singletonList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"0.0.0.0", (Resource)Resource.newInstance((int)0, (int)0), (int)1));
    }

    public MockRMApp(int newid, long time, RMAppState newState, String userName) {
        this(newid, time, newState);
        this.user = userName;
    }

    public MockRMApp(int newid, long time, RMAppState newState, String userName, String diag) {
        this(newid, time, newState, userName);
        this.diagnostics = new StringBuilder(diag);
    }

    public ApplicationId getApplicationId() {
        return this.id;
    }

    public ApplicationSubmissionContext getApplicationSubmissionContext() {
        return new ApplicationSubmissionContextPBImpl();
    }

    public RMAppState getState() {
        return this.state;
    }

    public void setState(RMAppState state) {
        this.state = state;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public float getProgress() {
        return 0.0f;
    }

    public RMAppAttempt getRMAppAttempt(ApplicationAttemptId appAttemptId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<ApplicationAttemptId, RMAppAttempt> getAppAttempts() {
        LinkedHashMap<ApplicationAttemptId, RMAppAttempt> attempts = new LinkedHashMap<ApplicationAttemptId, RMAppAttempt>();
        if (this.attempt != null) {
            attempts.put(this.attempt.getAppAttemptId(), this.attempt);
        }
        return attempts;
    }

    public RMAppAttempt getCurrentAppAttempt() {
        return this.attempt;
    }

    public void setCurrentAppAttempt(RMAppAttempt attempt) {
        this.attempt = attempt;
    }

    public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getFinishTime() {
        return this.finish;
    }

    public void setFinishTime(long time) {
        this.finish = time;
    }

    public long getStartTime() {
        return this.start;
    }

    public long getSubmitTime() {
        return this.submit;
    }

    public void setStartTime(long time) {
        this.start = time;
    }

    public String getTrackingUrl() {
        return this.url;
    }

    public void setTrackingUrl(String url) {
        this.url = url;
    }

    public String getOriginalTrackingUrl() {
        return this.oUrl;
    }

    public void setOriginalTrackingUrl(String oUrl) {
        this.oUrl = oUrl;
    }

    public StringBuilder getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(String diag) {
        this.diagnostics = new StringBuilder(diag);
    }

    public int getMaxAppAttempts() {
        return this.maxAppAttempts;
    }

    public void setNumMaxRetries(int maxAppAttempts) {
        this.maxAppAttempts = maxAppAttempts;
    }

    public void handle(RMAppEvent event) {
    }

    public FinalApplicationStatus getFinalApplicationStatus() {
        return FinalApplicationStatus.UNDEFINED;
    }

    public int pullRMNodeUpdates(Collection<RMNode> updatedNodes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getApplicationType() {
        return "YARN";
    }

    public Set<String> getApplicationTags() {
        return null;
    }

    public boolean isAppFinalStateStored() {
        return true;
    }

    public YarnApplicationState createApplicationState() {
        return null;
    }

    public Set<NodeId> getRanNodes() {
        return null;
    }

    public Resource getResourcePreempted() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RMAppMetrics getRMAppMetrics() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ReservationId getReservationId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<ResourceRequest> getAMResourceRequests() {
        return this.amReqs;
    }

    public Map<NodeId, LogAggregationReport> getLogAggregationReportsForApp() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LogAggregationStatus getLogAggregationStatusForAppReport() {
        return null;
    }

    public String getAmNodeLabelExpression() {
        return null;
    }

    public String getAppNodeLabelExpression() {
        return null;
    }

    public CallerContext getCallerContext() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<ApplicationTimeoutType, Long> getApplicationTimeouts() {
        return Collections.emptyMap();
    }

    public Priority getApplicationPriority() {
        return null;
    }

    public boolean isAppInCompletedStates() {
        return false;
    }

    public AppCollectorData getCollectorData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CollectorInfo getCollectorInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

