/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import net.jcip.annotations.NotThreadSafe;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.BaseSharingPolicyTest;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningQuotaException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@NotThreadSafe
public class TestCapacityOverTimePolicy
extends BaseSharingPolicyTest {
    static final long ONEDAY = 86400000L;
    static final long ONEHOUR = 3600000L;
    static final long ONEMINUTE = 60000L;
    static final String TWOHOURPERIOD = "7200000";
    static final String ONEDAYPERIOD = "86400000";

    @Parameterized.Parameters(name="Duration {0}, height {1}, numSubmission {2}, periodic {3})")
    public static Collection<Object[]> data() {
        return Arrays.asList({3600000L, 0.25, 1, null, null}, {3600000L, 0.25, 1, TWOHOURPERIOD, null}, {3600000L, 0.25, 1, ONEDAYPERIOD, null}, {60000L, 0.74, 1, null, null}, {60000L, 0.74, 1, TWOHOURPERIOD, null}, {60000L, 0.74, 1, ONEDAYPERIOD, null}, {3600000L, 0.76, 1, null, PlanningQuotaException.class}, {3600000L, 0.76, 1, TWOHOURPERIOD, PlanningQuotaException.class}, {3600000L, 0.76, 1, ONEDAYPERIOD, PlanningQuotaException.class}, {3600000L, 1.1, 1, null, PlanningQuotaException.class}, {3600000L, 1.1, 1, TWOHOURPERIOD, PlanningQuotaException.class}, {3600000L, 1.1, 1, ONEDAYPERIOD, PlanningQuotaException.class}, {60000L, 0.25, 3, null, null}, {60000L, 0.25, 3, TWOHOURPERIOD, null}, {60000L, 0.25, 3, ONEDAYPERIOD, null}, {60000L, 0.25, 4, null, PlanningQuotaException.class}, {60000L, 0.25, 4, TWOHOURPERIOD, PlanningQuotaException.class}, {60000L, 0.25, 4, ONEDAYPERIOD, PlanningQuotaException.class}, {90000000L, 0.25, 1, null, PlanningQuotaException.class}, {90000000L, 0.25, 1, TWOHOURPERIOD, PlanningQuotaException.class}, {90000000L, 0.25, 1, ONEDAYPERIOD, PlanningQuotaException.class}, {90000000L, 0.05, 5, null, PlanningQuotaException.class}, {90000000L, 0.05, 5, TWOHOURPERIOD, PlanningQuotaException.class}, {90000000L, 0.05, 5, ONEDAYPERIOD, PlanningQuotaException.class}, {86400000L, 0.26, 1, null, PlanningQuotaException.class}, {0x6DDD00L, 0.26, 1, TWOHOURPERIOD, PlanningQuotaException.class}, {172800000L, 0.26, 1, ONEDAYPERIOD, PlanningQuotaException.class}, {43200000L, 0.51, 1, null, PlanningQuotaException.class}, {3600000L, 0.51, 1, TWOHOURPERIOD, PlanningQuotaException.class}, {86400000L, 0.51, 1, ONEDAYPERIOD, PlanningQuotaException.class});
    }

    @Override
    public SharingPolicy getInitializedPolicy() {
        long timeWindow = 86400000L;
        long step = 1000L;
        float avgConstraint = 25.0f;
        float instConstraint = 75.0f;
        String reservationQ = ReservationSystemTestUtil.getFullReservationQueueName();
        this.conf = ReservationSystemTestUtil.createConf(reservationQ, timeWindow, instConstraint, avgConstraint);
        CapacityOverTimePolicy policy = new CapacityOverTimePolicy();
        policy.init(reservationQ, this.conf);
        return policy;
    }

    @Test
    public void testAllocation() throws IOException, PlanningException {
        this.runTest();
    }
}

