/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.LeveldbRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLeveldbRMStateStore
extends RMStateStoreTestBase {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), TestLeveldbRMStateStore.class.getName());
    private YarnConfiguration conf;
    private LeveldbRMStateStore stateStore = null;

    @Before
    public void setup() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.resourcemanager.leveldb-state-store.path", TEST_DIR.toString());
    }

    @After
    public void cleanup() throws IOException {
        if (this.stateStore != null) {
            this.stateStore.close();
        }
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    @Test(timeout=60000L)
    public void testApps() throws Exception {
        LeveldbStateStoreTester tester = new LeveldbStateStoreTester();
        this.testRMAppStateStore(tester);
    }

    @Test(timeout=60000L)
    public void testClientTokens() throws Exception {
        LeveldbStateStoreTester tester = new LeveldbStateStoreTester();
        this.testRMDTSecretManagerStateStore(tester);
    }

    @Test(timeout=60000L)
    public void testVersion() throws Exception {
        LeveldbStateStoreTester tester = new LeveldbStateStoreTester();
        this.testCheckVersion(tester);
    }

    @Test(timeout=60000L)
    public void testEpoch() throws Exception {
        this.conf.setLong("yarn.resourcemanager.epoch", 10L);
        LeveldbStateStoreTester tester = new LeveldbStateStoreTester();
        this.testEpoch(tester);
    }

    @Test(timeout=60000L)
    public void testAppDeletion() throws Exception {
        LeveldbStateStoreTester tester = new LeveldbStateStoreTester();
        this.testAppDeletion(tester);
    }

    @Test(timeout=60000L)
    public void testDeleteStore() throws Exception {
        LeveldbStateStoreTester tester = new LeveldbStateStoreTester();
        this.testDeleteStore(tester);
    }

    @Test(timeout=60000L)
    public void testRemoveApplication() throws Exception {
        LeveldbStateStoreTester tester = new LeveldbStateStoreTester();
        this.testRemoveApplication(tester);
    }

    @Test(timeout=60000L)
    public void testRemoveAttempt() throws Exception {
        LeveldbStateStoreTester tester = new LeveldbStateStoreTester();
        this.testRemoveAttempt(tester);
    }

    @Test(timeout=60000L)
    public void testAMTokens() throws Exception {
        LeveldbStateStoreTester tester = new LeveldbStateStoreTester();
        this.testAMRMTokenSecretManagerStateStore(tester);
    }

    @Test(timeout=60000L)
    public void testReservation() throws Exception {
        LeveldbStateStoreTester tester = new LeveldbStateStoreTester();
        this.testReservationStateStore(tester);
    }

    @Test(timeout=60000L)
    public void testCompactionCycle() throws Exception {
        final DB mockdb = (DB)Mockito.mock(DB.class);
        this.conf.setLong("yarn.resourcemanager.leveldb-state-store.compaction-interval-secs", 1L);
        this.stateStore = new LeveldbRMStateStore(){

            protected DB openDatabase() throws Exception {
                return mockdb;
            }
        };
        this.stateStore.init((Configuration)this.conf);
        this.stateStore.start();
        ((DB)Mockito.verify((Object)mockdb, (VerificationMode)Mockito.timeout((int)10000))).compactRange((byte[])Mockito.isNull(), (byte[])Mockito.isNull());
    }

    @Test
    public void testBadKeyIteration() throws Exception {
        this.stateStore = new LeveldbRMStateStore();
        this.stateStore.init((Configuration)this.conf);
        this.stateStore.start();
        DB db = this.stateStore.getDatabase();
        db.put(JniDBFactory.bytes((String)"zzz"), JniDBFactory.bytes((String)"z"));
        this.stateStore.loadState();
    }

    class LeveldbStateStoreTester
    implements RMStateStoreTestBase.RMStateStoreHelper {
        LeveldbStateStoreTester() {
        }

        @Override
        public RMStateStore getRMStateStore() throws Exception {
            if (TestLeveldbRMStateStore.this.stateStore != null) {
                TestLeveldbRMStateStore.this.stateStore.close();
            }
            TestLeveldbRMStateStore.this.stateStore = new LeveldbRMStateStore();
            TestLeveldbRMStateStore.this.stateStore.init((Configuration)TestLeveldbRMStateStore.this.conf);
            TestLeveldbRMStateStore.this.stateStore.start();
            return TestLeveldbRMStateStore.this.stateStore;
        }

        @Override
        public boolean isFinalStateValid() throws Exception {
            return TestLeveldbRMStateStore.this.stateStore.getNumEntriesInDatabase() == 6;
        }

        @Override
        public void writeVersion(Version version) throws Exception {
            TestLeveldbRMStateStore.this.stateStore.dbStoreVersion(version);
        }

        @Override
        public Version getCurrentVersion() throws Exception {
            return TestLeveldbRMStateStore.this.stateStore.getCurrentVersion();
        }

        @Override
        public boolean appExists(RMApp app) throws Exception {
            if (TestLeveldbRMStateStore.this.stateStore.isClosed()) {
                this.getRMStateStore();
            }
            return TestLeveldbRMStateStore.this.stateStore.loadRMAppState(app.getApplicationId()) != null;
        }

        @Override
        public boolean attemptExists(RMAppAttempt attempt) throws Exception {
            if (TestLeveldbRMStateStore.this.stateStore.isClosed()) {
                this.getRMStateStore();
            }
            return TestLeveldbRMStateStore.this.stateStore.loadRMAppAttemptState(attempt.getAppAttemptId()) != null;
        }
    }
}

