/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.RMHATestBase;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMHATimelineCollectors
extends RMHATestBase {
    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.confForRM1.setBoolean("yarn.timeline-service.enabled", true);
        this.confForRM2.setBoolean("yarn.timeline-service.enabled", true);
        this.confForRM1.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        this.confForRM1.setFloat("yarn.timeline-service.version", 2.0f);
        this.confForRM2.setFloat("yarn.timeline-service.version", 2.0f);
        this.confForRM2.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
    }

    @Test
    public void testRebuildCollectorDataOnFailover() throws Exception {
        this.startRMs();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm2.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.1:5678", 15121, rm2.getResourceTrackerService());
        RMApp app1 = rm1.submitApp(1024);
        String collectorAddr1 = "1.2.3.4:5";
        AppCollectorData data1 = AppCollectorData.newInstance((ApplicationId)app1.getApplicationId(), (String)collectorAddr1);
        nm1.addRegisteringCollector(app1.getApplicationId(), data1);
        String collectorAddr2 = "5.4.3.2:1";
        RMApp app2 = rm1.submitApp(1024);
        AppCollectorData data2 = AppCollectorData.newInstance((ApplicationId)app2.getApplicationId(), (String)collectorAddr2, (long)rm1.getStartTime(), (long)1L);
        nm1.addRegisteringCollector(app2.getApplicationId(), data2);
        this.explicitFailover();
        ArrayList<ApplicationId> runningApps = new ArrayList<ApplicationId>();
        runningApps.add(app1.getApplicationId());
        runningApps.add(app2.getApplicationId());
        nm1.registerNode(runningApps);
        nm2.registerNode(runningApps);
        String collectorAddr12 = "1.2.3.4:56";
        AppCollectorData data12 = AppCollectorData.newInstance((ApplicationId)app1.getApplicationId(), (String)collectorAddr12, (long)rm1.getStartTime(), (long)0L);
        nm2.addRegisteringCollector(app1.getApplicationId(), data12);
        String collectorAddr22 = "5.4.3.2:10";
        AppCollectorData data22 = AppCollectorData.newInstance((ApplicationId)app2.getApplicationId(), (String)collectorAddr22, (long)rm1.getStartTime(), (long)2L);
        nm2.addRegisteringCollector(app2.getApplicationId(), data22);
        Map results1 = nm1.nodeHeartbeat(true).getAppCollectors();
        Assert.assertEquals((Object)collectorAddr1, (Object)((AppCollectorData)results1.get(app1.getApplicationId())).getCollectorAddr());
        Assert.assertEquals((Object)collectorAddr2, (Object)((AppCollectorData)results1.get(app2.getApplicationId())).getCollectorAddr());
        Map results2 = nm2.nodeHeartbeat(true).getAppCollectors();
        Assert.assertEquals((Object)collectorAddr1, (Object)((AppCollectorData)results2.get(app1.getApplicationId())).getCollectorAddr());
        Assert.assertEquals((Object)collectorAddr22, (Object)((AppCollectorData)results2.get(app2.getApplicationId())).getCollectorAddr());
        nm1.getRegisteringCollectors().clear();
        Map results12 = nm1.nodeHeartbeat(true).getAppCollectors();
        Assert.assertEquals((Object)collectorAddr1, (Object)((AppCollectorData)results12.get(app1.getApplicationId())).getCollectorAddr());
        Assert.assertEquals((Object)collectorAddr22, (Object)((AppCollectorData)results12.get(app2.getApplicationId())).getCollectorAddr());
    }
}

