/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class ParameterizedSchedulerTestBase {
    protected static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    private static final String FS_ALLOC_FILE = new File(TEST_DIR, "test-fs-queues.xml").getAbsolutePath();
    private SchedulerType schedulerType;
    private YarnConfiguration conf = new YarnConfiguration();
    private AbstractYarnScheduler scheduler = null;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(SchedulerType.values().length);
        for (SchedulerType type : SchedulerType.values()) {
            params.add(new Object[]{type});
        }
        return params;
    }

    public YarnConfiguration getConf() {
        return this.conf;
    }

    public ParameterizedSchedulerTestBase(SchedulerType type) throws IOException {
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        this.schedulerType = type;
        switch (this.schedulerType) {
            case FAIR: {
                this.configureFairScheduler(this.conf);
                this.scheduler = new FairScheduler();
                this.conf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
                break;
            }
            case CAPACITY: {
                this.scheduler = new CapacityScheduler();
                ((CapacityScheduler)this.scheduler).setConf((Configuration)this.conf);
                this.conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
            }
        }
    }

    private void configureFairScheduler(YarnConfiguration conf) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(FS_ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queueMaxAMShareDefault>-1.0</queueMaxAMShareDefault>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("<queue name=\"root\">");
        out.println("  <schedulingPolicy>drf</schedulingPolicy>");
        out.println("  <weight>1.0</weight>");
        out.println("  <fairSharePreemptionTimeout>100</fairSharePreemptionTimeout>");
        out.println("  <minSharePreemptionTimeout>120</minSharePreemptionTimeout>");
        out.println("  <fairSharePreemptionThreshold>.5</fairSharePreemptionThreshold>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        conf.set("yarn.scheduler.fair.allocation.file", FS_ALLOC_FILE);
        conf.setLong("yarn.scheduler.fair.update-interval-ms", 10L);
    }

    public SchedulerType getSchedulerType() {
        return this.schedulerType;
    }

    public AbstractYarnScheduler getScheduler() {
        return this.scheduler;
    }

    public static enum SchedulerType {
        CAPACITY,
        FAIR;

    }
}

