// $ANTLR 3.2 Sep 23, 2009 12:02:23 /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g 2013-05-15 15:32:16

    package org.apache.cassandra.cql3;

    import java.util.ArrayList;
    import java.util.Arrays;
    import java.util.Collections;
    import java.util.EnumSet;
    import java.util.HashMap;
    import java.util.LinkedHashMap;
    import java.util.List;
    import java.util.Map;
    import java.util.Set;

    import org.apache.cassandra.auth.Permission;
    import org.apache.cassandra.auth.DataResource;
    import org.apache.cassandra.auth.IResource;
    import org.apache.cassandra.cql3.*;
    import org.apache.cassandra.cql3.statements.*;
    import org.apache.cassandra.cql3.functions.FunctionCall;
    import org.apache.cassandra.db.marshal.CollectionType;
    import org.apache.cassandra.exceptions.ConfigurationException;
    import org.apache.cassandra.exceptions.InvalidRequestException;
    import org.apache.cassandra.exceptions.SyntaxException;
    import org.apache.cassandra.utils.Pair;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class CqlParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "K_USE", "K_SELECT", "K_COUNT", "K_FROM", "K_WHERE", "K_ORDER", "K_BY", "K_LIMIT", "INTEGER", "K_ALLOW", "K_FILTERING", "K_WRITETIME", "K_TTL", "K_AND", "K_ASC", "K_DESC", "K_INSERT", "K_INTO", "K_VALUES", "K_USING", "K_TIMESTAMP", "K_UPDATE", "K_SET", "K_DELETE", "K_BEGIN", "K_UNLOGGED", "K_COUNTER", "K_BATCH", "K_APPLY", "K_CREATE", "K_KEYSPACE", "K_WITH", "K_COLUMNFAMILY", "K_PRIMARY", "K_KEY", "K_COMPACT", "K_STORAGE", "K_CLUSTERING", "K_CUSTOM", "K_INDEX", "IDENT", "K_ON", "K_ALTER", "K_TYPE", "K_ADD", "K_RENAME", "K_TO", "K_DROP", "K_TRUNCATE", "K_GRANT", "K_REVOKE", "K_LIST", "K_OF", "K_NORECURSIVE", "K_MODIFY", "K_AUTHORIZE", "K_ALL", "K_PERMISSIONS", "K_PERMISSION", "K_KEYSPACES", "K_USER", "K_SUPERUSER", "K_NOSUPERUSER", "K_USERS", "K_PASSWORD", "STRING_LITERAL", "QUOTED_NAME", "FLOAT", "BOOLEAN", "UUID", "HEXNUMBER", "K_NULL", "QMARK", "K_TOKEN", "K_IN", "K_ASCII", "K_BIGINT", "K_BLOB", "K_BOOLEAN", "K_DECIMAL", "K_DOUBLE", "K_FLOAT", "K_INET", "K_INT", "K_TEXT", "K_UUID", "K_VARCHAR", "K_VARINT", "K_TIMEUUID", "K_MAP", "S", "E", "L", "C", "T", "F", "R", "O", "M", "W", "H", "A", "N", "D", "K", "Y", "I", "U", "P", "G", "B", "X", "V", "Z", "J", "Q", "DIGIT", "LETTER", "HEX", "EXPONENT", "WS", "COMMENT", "MULTILINE_COMMENT", "';'", "'('", "')'", "','", "'\\*'", "'['", "']'", "'.'", "'}'", "':'", "'{'", "'='", "'+'", "'-'", "'<'", "'<='", "'>'", "'>='"
    };
    public static final int EXPONENT=123;
    public static final int K_PERMISSIONS=61;
    public static final int LETTER=121;
    public static final int K_INT=87;
    public static final int K_PERMISSION=62;
    public static final int K_CREATE=33;
    public static final int K_CLUSTERING=41;
    public static final int K_WRITETIME=15;
    public static final int EOF=-1;
    public static final int K_PRIMARY=37;
    public static final int K_AUTHORIZE=59;
    public static final int K_VALUES=22;
    public static final int K_USE=4;
    public static final int STRING_LITERAL=69;
    public static final int K_GRANT=53;
    public static final int K_ON=45;
    public static final int K_USING=23;
    public static final int K_ADD=48;
    public static final int K_ASC=18;
    public static final int K_CUSTOM=42;
    public static final int K_KEY=38;
    public static final int COMMENT=125;
    public static final int K_TRUNCATE=52;
    public static final int K_ORDER=9;
    public static final int HEXNUMBER=74;
    public static final int K_OF=56;
    public static final int K_ALL=60;
    public static final int D=107;
    public static final int T__139=139;
    public static final int E=95;
    public static final int T__138=138;
    public static final int F=99;
    public static final int T__137=137;
    public static final int G=113;
    public static final int T__136=136;
    public static final int K_COUNT=6;
    public static final int K_KEYSPACE=34;
    public static final int K_TYPE=47;
    public static final int A=105;
    public static final int B=114;
    public static final int C=97;
    public static final int L=96;
    public static final int M=102;
    public static final int N=106;
    public static final int O=101;
    public static final int H=104;
    public static final int I=110;
    public static final int J=118;
    public static final int K_UPDATE=25;
    public static final int K=108;
    public static final int K_FILTERING=14;
    public static final int U=111;
    public static final int T=98;
    public static final int W=103;
    public static final int K_TEXT=88;
    public static final int V=116;
    public static final int Q=119;
    public static final int P=112;
    public static final int K_COMPACT=39;
    public static final int S=94;
    public static final int R=100;
    public static final int T__141=141;
    public static final int T__142=142;
    public static final int K_TTL=16;
    public static final int T__140=140;
    public static final int Y=109;
    public static final int X=115;
    public static final int T__143=143;
    public static final int Z=117;
    public static final int T__144=144;
    public static final int K_INDEX=43;
    public static final int T__128=128;
    public static final int K_INSERT=20;
    public static final int T__127=127;
    public static final int WS=124;
    public static final int T__129=129;
    public static final int K_RENAME=49;
    public static final int K_APPLY=32;
    public static final int K_INET=86;
    public static final int K_STORAGE=40;
    public static final int K_TIMESTAMP=24;
    public static final int K_NULL=75;
    public static final int K_AND=17;
    public static final int K_DESC=19;
    public static final int T__130=130;
    public static final int K_TOKEN=77;
    public static final int QMARK=76;
    public static final int T__131=131;
    public static final int T__132=132;
    public static final int T__133=133;
    public static final int T__134=134;
    public static final int K_UUID=89;
    public static final int T__135=135;
    public static final int K_BATCH=31;
    public static final int K_ASCII=79;
    public static final int UUID=73;
    public static final int K_LIST=55;
    public static final int K_DELETE=27;
    public static final int K_TO=50;
    public static final int K_BY=10;
    public static final int FLOAT=71;
    public static final int K_VARINT=91;
    public static final int K_FLOAT=85;
    public static final int K_SUPERUSER=65;
    public static final int K_DOUBLE=84;
    public static final int K_SELECT=5;
    public static final int K_LIMIT=11;
    public static final int K_BOOLEAN=82;
    public static final int K_ALTER=46;
    public static final int K_SET=26;
    public static final int K_WHERE=8;
    public static final int QUOTED_NAME=70;
    public static final int MULTILINE_COMMENT=126;
    public static final int K_BLOB=81;
    public static final int K_UNLOGGED=29;
    public static final int BOOLEAN=72;
    public static final int HEX=122;
    public static final int K_INTO=21;
    public static final int K_PASSWORD=68;
    public static final int K_REVOKE=54;
    public static final int K_ALLOW=13;
    public static final int K_VARCHAR=90;
    public static final int IDENT=44;
    public static final int DIGIT=120;
    public static final int K_USERS=67;
    public static final int K_BEGIN=28;
    public static final int INTEGER=12;
    public static final int K_KEYSPACES=63;
    public static final int K_COUNTER=30;
    public static final int K_DECIMAL=83;
    public static final int K_WITH=35;
    public static final int K_IN=78;
    public static final int K_NORECURSIVE=57;
    public static final int K_MAP=93;
    public static final int K_FROM=7;
    public static final int K_COLUMNFAMILY=36;
    public static final int K_MODIFY=58;
    public static final int K_DROP=51;
    public static final int K_NOSUPERUSER=66;
    public static final int K_BIGINT=80;
    public static final int K_TIMEUUID=92;
    public static final int K_USER=64;

    // delegates
    // delegators


        public CqlParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public CqlParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return CqlParser.tokenNames; }
    public String getGrammarFileName() { return "/tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g"; }


        private List<String> recognitionErrors = new ArrayList<String>();
        private int currentBindMarkerIdx = -1;

        public void displayRecognitionError(String[] tokenNames, RecognitionException e)
        {
            String hdr = getErrorHeader(e);
            String msg = getErrorMessage(e, tokenNames);
            recognitionErrors.add(hdr + " " + msg);
        }

        public void addRecognitionError(String msg)
        {
            recognitionErrors.add(msg);
        }

        public List<String> getRecognitionErrors()
        {
            return recognitionErrors;
        }

        public void throwLastRecognitionError() throws SyntaxException
        {
            if (recognitionErrors.size() > 0)
                throw new SyntaxException(recognitionErrors.get((recognitionErrors.size()-1)));
        }

        public Map<String, String> convertPropertyMap(Maps.Literal map)
        {
            if (map == null || map.entries == null || map.entries.isEmpty())
                return Collections.<String, String>emptyMap();

            Map<String, String> res = new HashMap<String, String>(map.entries.size());

            for (Pair<Term.Raw, Term.Raw> entry : map.entries)
            {
                // Because the parser tries to be smart and recover on error (to
                // allow displaying more than one error I suppose), we have null
                // entries in there. Just skip those, a proper error will be thrown in the end.
                if (entry.left == null || entry.right == null)
                    break;

                if (!(entry.left instanceof Constants.Literal))
                {
                    addRecognitionError("Invalid property name: " + entry.left);
                    break;
                }
                if (!(entry.right instanceof Constants.Literal))
                {
                    addRecognitionError("Invalid property value: " + entry.right);
                    break;
                }

                res.put(((Constants.Literal)entry.left).getRawText(), ((Constants.Literal)entry.right).getRawText());
            }

            return res;
        }

        public void addRawUpdate(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key, Operation.RawUpdate update)
        {
            for (Pair<ColumnIdentifier, Operation.RawUpdate> p : operations)
            {
                if (p.left.equals(key) && !p.right.isCompatibleWith(update))
                    addRecognitionError("Multiple incompatible setting of column " + key);
            }
            operations.add(Pair.create(key, update));
        }



    // $ANTLR start "query"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:166:1: query returns [ParsedStatement stmnt] : st= cqlStatement ( ';' )* EOF ;
    public final ParsedStatement query() throws RecognitionException {
        ParsedStatement stmnt = null;

        ParsedStatement st = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:169:5: (st= cqlStatement ( ';' )* EOF )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:169:7: st= cqlStatement ( ';' )* EOF
            {
            pushFollow(FOLLOW_cqlStatement_in_query72);
            st=cqlStatement();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:169:23: ( ';' )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( (LA1_0==127) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:169:24: ';'
            	    {
            	    match(input,127,FOLLOW_127_in_query75); 

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            match(input,EOF,FOLLOW_EOF_in_query79); 
             stmnt = st; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmnt;
    }
    // $ANTLR end "query"


    // $ANTLR start "cqlStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:172:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createColumnFamilyStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropColumnFamilyStatement | st13= dropIndexStatement | st14= alterTableStatement | st15= alterKeyspaceStatement | st16= grantStatement | st17= revokeStatement | st18= listPermissionsStatement | st19= createUserStatement | st20= alterUserStatement | st21= dropUserStatement | st22= listUsersStatement );
    public final ParsedStatement cqlStatement() throws RecognitionException {
        ParsedStatement stmt = null;

        SelectStatement.RawStatement st1 = null;

        UpdateStatement st2 = null;

        UpdateStatement st3 = null;

        BatchStatement st4 = null;

        DeleteStatement st5 = null;

        UseStatement st6 = null;

        TruncateStatement st7 = null;

        CreateKeyspaceStatement st8 = null;

        CreateColumnFamilyStatement.RawStatement st9 = null;

        CreateIndexStatement st10 = null;

        DropKeyspaceStatement st11 = null;

        DropColumnFamilyStatement st12 = null;

        DropIndexStatement st13 = null;

        AlterTableStatement st14 = null;

        AlterKeyspaceStatement st15 = null;

        GrantStatement st16 = null;

        RevokeStatement st17 = null;

        ListPermissionsStatement st18 = null;

        CreateUserStatement st19 = null;

        AlterUserStatement st20 = null;

        DropUserStatement st21 = null;

        ListUsersStatement st22 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:174:5: (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createColumnFamilyStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropColumnFamilyStatement | st13= dropIndexStatement | st14= alterTableStatement | st15= alterKeyspaceStatement | st16= grantStatement | st17= revokeStatement | st18= listPermissionsStatement | st19= createUserStatement | st20= alterUserStatement | st21= dropUserStatement | st22= listUsersStatement )
            int alt2=22;
            alt2 = dfa2.predict(input);
            switch (alt2) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:174:7: st1= selectStatement
                    {
                    pushFollow(FOLLOW_selectStatement_in_cqlStatement113);
                    st1=selectStatement();

                    state._fsp--;

                     stmt = st1; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:175:7: st2= insertStatement
                    {
                    pushFollow(FOLLOW_insertStatement_in_cqlStatement138);
                    st2=insertStatement();

                    state._fsp--;

                     stmt = st2; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:176:7: st3= updateStatement
                    {
                    pushFollow(FOLLOW_updateStatement_in_cqlStatement163);
                    st3=updateStatement();

                    state._fsp--;

                     stmt = st3; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:177:7: st4= batchStatement
                    {
                    pushFollow(FOLLOW_batchStatement_in_cqlStatement188);
                    st4=batchStatement();

                    state._fsp--;

                     stmt = st4; 

                    }
                    break;
                case 5 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:178:7: st5= deleteStatement
                    {
                    pushFollow(FOLLOW_deleteStatement_in_cqlStatement214);
                    st5=deleteStatement();

                    state._fsp--;

                     stmt = st5; 

                    }
                    break;
                case 6 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:179:7: st6= useStatement
                    {
                    pushFollow(FOLLOW_useStatement_in_cqlStatement239);
                    st6=useStatement();

                    state._fsp--;

                     stmt = st6; 

                    }
                    break;
                case 7 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:180:7: st7= truncateStatement
                    {
                    pushFollow(FOLLOW_truncateStatement_in_cqlStatement267);
                    st7=truncateStatement();

                    state._fsp--;

                     stmt = st7; 

                    }
                    break;
                case 8 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:181:7: st8= createKeyspaceStatement
                    {
                    pushFollow(FOLLOW_createKeyspaceStatement_in_cqlStatement290);
                    st8=createKeyspaceStatement();

                    state._fsp--;

                     stmt = st8; 

                    }
                    break;
                case 9 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:182:7: st9= createColumnFamilyStatement
                    {
                    pushFollow(FOLLOW_createColumnFamilyStatement_in_cqlStatement307);
                    st9=createColumnFamilyStatement();

                    state._fsp--;

                     stmt = st9; 

                    }
                    break;
                case 10 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:183:7: st10= createIndexStatement
                    {
                    pushFollow(FOLLOW_createIndexStatement_in_cqlStatement319);
                    st10=createIndexStatement();

                    state._fsp--;

                     stmt = st10; 

                    }
                    break;
                case 11 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:184:7: st11= dropKeyspaceStatement
                    {
                    pushFollow(FOLLOW_dropKeyspaceStatement_in_cqlStatement338);
                    st11=dropKeyspaceStatement();

                    state._fsp--;

                     stmt = st11; 

                    }
                    break;
                case 12 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:185:7: st12= dropColumnFamilyStatement
                    {
                    pushFollow(FOLLOW_dropColumnFamilyStatement_in_cqlStatement356);
                    st12=dropColumnFamilyStatement();

                    state._fsp--;

                     stmt = st12; 

                    }
                    break;
                case 13 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:186:7: st13= dropIndexStatement
                    {
                    pushFollow(FOLLOW_dropIndexStatement_in_cqlStatement370);
                    st13=dropIndexStatement();

                    state._fsp--;

                     stmt = st13; 

                    }
                    break;
                case 14 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:187:7: st14= alterTableStatement
                    {
                    pushFollow(FOLLOW_alterTableStatement_in_cqlStatement391);
                    st14=alterTableStatement();

                    state._fsp--;

                     stmt = st14; 

                    }
                    break;
                case 15 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:188:7: st15= alterKeyspaceStatement
                    {
                    pushFollow(FOLLOW_alterKeyspaceStatement_in_cqlStatement411);
                    st15=alterKeyspaceStatement();

                    state._fsp--;

                     stmt = st15; 

                    }
                    break;
                case 16 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:189:7: st16= grantStatement
                    {
                    pushFollow(FOLLOW_grantStatement_in_cqlStatement428);
                    st16=grantStatement();

                    state._fsp--;

                     stmt = st16; 

                    }
                    break;
                case 17 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:190:7: st17= revokeStatement
                    {
                    pushFollow(FOLLOW_revokeStatement_in_cqlStatement453);
                    st17=revokeStatement();

                    state._fsp--;

                     stmt = st17; 

                    }
                    break;
                case 18 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:191:7: st18= listPermissionsStatement
                    {
                    pushFollow(FOLLOW_listPermissionsStatement_in_cqlStatement477);
                    st18=listPermissionsStatement();

                    state._fsp--;

                     stmt = st18; 

                    }
                    break;
                case 19 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:192:7: st19= createUserStatement
                    {
                    pushFollow(FOLLOW_createUserStatement_in_cqlStatement492);
                    st19=createUserStatement();

                    state._fsp--;

                     stmt = st19; 

                    }
                    break;
                case 20 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:193:7: st20= alterUserStatement
                    {
                    pushFollow(FOLLOW_alterUserStatement_in_cqlStatement512);
                    st20=alterUserStatement();

                    state._fsp--;

                     stmt = st20; 

                    }
                    break;
                case 21 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:194:7: st21= dropUserStatement
                    {
                    pushFollow(FOLLOW_dropUserStatement_in_cqlStatement533);
                    st21=dropUserStatement();

                    state._fsp--;

                     stmt = st21; 

                    }
                    break;
                case 22 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:195:7: st22= listUsersStatement
                    {
                    pushFollow(FOLLOW_listUsersStatement_in_cqlStatement555);
                    st22=listUsersStatement();

                    state._fsp--;

                     stmt = st22; 

                    }
                    break;

            }
             if (stmt != null) stmt.setBoundTerms(currentBindMarkerIdx + 1); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "cqlStatement"


    // $ANTLR start "useStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:201:1: useStatement returns [UseStatement stmt] : K_USE ks= keyspaceName ;
    public final UseStatement useStatement() throws RecognitionException {
        UseStatement stmt = null;

        String ks = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:202:5: ( K_USE ks= keyspaceName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:202:7: K_USE ks= keyspaceName
            {
            match(input,K_USE,FOLLOW_K_USE_in_useStatement589); 
            pushFollow(FOLLOW_keyspaceName_in_useStatement593);
            ks=keyspaceName();

            state._fsp--;

             stmt = new UseStatement(ks); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "useStatement"


    // $ANTLR start "selectStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:205:1: selectStatement returns [SelectStatement.RawStatement expr] : K_SELECT (sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= INTEGER )? ( K_ALLOW K_FILTERING )? ;
    public final SelectStatement.RawStatement selectStatement() throws RecognitionException {
        SelectStatement.RawStatement expr = null;

        Token rows=null;
        List<RawSelector> sclause = null;

        CFName cf = null;

        List<Relation> wclause = null;



                boolean isCount = false;
                int limit = Integer.MAX_VALUE;
                Map<ColumnIdentifier, Boolean> orderings = new LinkedHashMap<ColumnIdentifier, Boolean>();
                boolean allowFiltering = false;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:5: ( K_SELECT (sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= INTEGER )? ( K_ALLOW K_FILTERING )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:7: K_SELECT (sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= INTEGER )? ( K_ALLOW K_FILTERING )?
            {
            match(input,K_SELECT,FOLLOW_K_SELECT_in_selectStatement627); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:16: (sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ) )
            int alt3=2;
            int LA3_0 = input.LA(1);

            if ( ((LA3_0>=K_FILTERING && LA3_0<=K_TTL)||LA3_0==K_VALUES||LA3_0==K_TIMESTAMP||LA3_0==K_COUNTER||(LA3_0>=K_KEY && LA3_0<=K_CUSTOM)||LA3_0==IDENT||LA3_0==K_TYPE||LA3_0==K_LIST||(LA3_0>=K_ALL && LA3_0<=K_PASSWORD)||LA3_0==QUOTED_NAME||LA3_0==K_TOKEN||(LA3_0>=K_ASCII && LA3_0<=K_MAP)||LA3_0==131) ) {
                alt3=1;
            }
            else if ( (LA3_0==K_COUNT) ) {
                int LA3_2 = input.LA(2);

                if ( (LA3_2==128) ) {
                    alt3=2;
                }
                else if ( (LA3_2==K_FROM||LA3_2==130) ) {
                    alt3=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 3, 2, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;
            }
            switch (alt3) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:18: sclause= selectClause
                    {
                    pushFollow(FOLLOW_selectClause_in_selectStatement633);
                    sclause=selectClause();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:41: ( K_COUNT '(' sclause= selectCountClause ')' )
                    {
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:41: ( K_COUNT '(' sclause= selectCountClause ')' )
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:42: K_COUNT '(' sclause= selectCountClause ')'
                    {
                    match(input,K_COUNT,FOLLOW_K_COUNT_in_selectStatement638); 
                    match(input,128,FOLLOW_128_in_selectStatement640); 
                    pushFollow(FOLLOW_selectCountClause_in_selectStatement644);
                    sclause=selectCountClause();

                    state._fsp--;

                    match(input,129,FOLLOW_129_in_selectStatement646); 
                     isCount = true; 

                    }


                    }
                    break;

            }

            match(input,K_FROM,FOLLOW_K_FROM_in_selectStatement659); 
            pushFollow(FOLLOW_columnFamilyName_in_selectStatement663);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:220:7: ( K_WHERE wclause= whereClause )?
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==K_WHERE) ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:220:9: K_WHERE wclause= whereClause
                    {
                    match(input,K_WHERE,FOLLOW_K_WHERE_in_selectStatement673); 
                    pushFollow(FOLLOW_whereClause_in_selectStatement677);
                    wclause=whereClause();

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:7: ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )?
            int alt6=2;
            int LA6_0 = input.LA(1);

            if ( (LA6_0==K_ORDER) ) {
                alt6=1;
            }
            switch (alt6) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:9: K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )*
                    {
                    match(input,K_ORDER,FOLLOW_K_ORDER_in_selectStatement690); 
                    match(input,K_BY,FOLLOW_K_BY_in_selectStatement692); 
                    pushFollow(FOLLOW_orderByClause_in_selectStatement694);
                    orderByClause(orderings);

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:47: ( ',' orderByClause[orderings] )*
                    loop5:
                    do {
                        int alt5=2;
                        int LA5_0 = input.LA(1);

                        if ( (LA5_0==130) ) {
                            alt5=1;
                        }


                        switch (alt5) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:49: ',' orderByClause[orderings]
                    	    {
                    	    match(input,130,FOLLOW_130_in_selectStatement699); 
                    	    pushFollow(FOLLOW_orderByClause_in_selectStatement701);
                    	    orderByClause(orderings);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop5;
                        }
                    } while (true);


                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:7: ( K_LIMIT rows= INTEGER )?
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==K_LIMIT) ) {
                alt7=1;
            }
            switch (alt7) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:9: K_LIMIT rows= INTEGER
                    {
                    match(input,K_LIMIT,FOLLOW_K_LIMIT_in_selectStatement718); 
                    rows=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_selectStatement722); 
                     limit = Integer.parseInt((rows!=null?rows.getText():null)); 

                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:223:7: ( K_ALLOW K_FILTERING )?
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==K_ALLOW) ) {
                alt8=1;
            }
            switch (alt8) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:223:9: K_ALLOW K_FILTERING
                    {
                    match(input,K_ALLOW,FOLLOW_K_ALLOW_in_selectStatement737); 
                    match(input,K_FILTERING,FOLLOW_K_FILTERING_in_selectStatement739); 
                     allowFiltering = true; 

                    }
                    break;

            }


                      SelectStatement.Parameters params = new SelectStatement.Parameters(limit,
                                                                                         orderings,
                                                                                         isCount,
                                                                                         allowFiltering);
                      expr = new SelectStatement.RawStatement(cf, params, sclause, wclause);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectStatement"


    // $ANTLR start "selectClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:233:1: selectClause returns [List<RawSelector> expr] : (t1= selector ( ',' tN= selector )* | '\\*' );
    public final List<RawSelector> selectClause() throws RecognitionException {
        List<RawSelector> expr = null;

        RawSelector t1 = null;

        RawSelector tN = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:234:5: (t1= selector ( ',' tN= selector )* | '\\*' )
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==K_COUNT||(LA10_0>=K_FILTERING && LA10_0<=K_TTL)||LA10_0==K_VALUES||LA10_0==K_TIMESTAMP||LA10_0==K_COUNTER||(LA10_0>=K_KEY && LA10_0<=K_CUSTOM)||LA10_0==IDENT||LA10_0==K_TYPE||LA10_0==K_LIST||(LA10_0>=K_ALL && LA10_0<=K_PASSWORD)||LA10_0==QUOTED_NAME||LA10_0==K_TOKEN||(LA10_0>=K_ASCII && LA10_0<=K_MAP)) ) {
                alt10=1;
            }
            else if ( (LA10_0==131) ) {
                alt10=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;
            }
            switch (alt10) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:234:7: t1= selector ( ',' tN= selector )*
                    {
                    pushFollow(FOLLOW_selector_in_selectClause776);
                    t1=selector();

                    state._fsp--;

                     expr = new ArrayList<RawSelector>(); expr.add(t1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:234:76: ( ',' tN= selector )*
                    loop9:
                    do {
                        int alt9=2;
                        int LA9_0 = input.LA(1);

                        if ( (LA9_0==130) ) {
                            alt9=1;
                        }


                        switch (alt9) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:234:77: ',' tN= selector
                    	    {
                    	    match(input,130,FOLLOW_130_in_selectClause781); 
                    	    pushFollow(FOLLOW_selector_in_selectClause785);
                    	    tN=selector();

                    	    state._fsp--;

                    	     expr.add(tN); 

                    	    }
                    	    break;

                    	default :
                    	    break loop9;
                        }
                    } while (true);


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:235:7: '\\*'
                    {
                    match(input,131,FOLLOW_131_in_selectClause797); 
                     expr = Collections.<RawSelector>emptyList();

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectClause"


    // $ANTLR start "selectionFunctionArgs"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:1: selectionFunctionArgs returns [List<RawSelector> a] : ( '(' ')' | '(' s1= selector ( ',' sn= selector )* ')' );
    public final List<RawSelector> selectionFunctionArgs() throws RecognitionException {
        List<RawSelector> a = null;

        RawSelector s1 = null;

        RawSelector sn = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:239:5: ( '(' ')' | '(' s1= selector ( ',' sn= selector )* ')' )
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( (LA12_0==128) ) {
                int LA12_1 = input.LA(2);

                if ( (LA12_1==129) ) {
                    alt12=1;
                }
                else if ( (LA12_1==K_COUNT||(LA12_1>=K_FILTERING && LA12_1<=K_TTL)||LA12_1==K_VALUES||LA12_1==K_TIMESTAMP||LA12_1==K_COUNTER||(LA12_1>=K_KEY && LA12_1<=K_CUSTOM)||LA12_1==IDENT||LA12_1==K_TYPE||LA12_1==K_LIST||(LA12_1>=K_ALL && LA12_1<=K_PASSWORD)||LA12_1==QUOTED_NAME||LA12_1==K_TOKEN||(LA12_1>=K_ASCII && LA12_1<=K_MAP)) ) {
                    alt12=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 12, 1, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;
            }
            switch (alt12) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:239:7: '(' ')'
                    {
                    match(input,128,FOLLOW_128_in_selectionFunctionArgs820); 
                    match(input,129,FOLLOW_129_in_selectionFunctionArgs822); 
                     a = Collections.emptyList(); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:240:7: '(' s1= selector ( ',' sn= selector )* ')'
                    {
                    match(input,128,FOLLOW_128_in_selectionFunctionArgs832); 
                    pushFollow(FOLLOW_selector_in_selectionFunctionArgs836);
                    s1=selector();

                    state._fsp--;

                     List<RawSelector> args = new ArrayList<RawSelector>(); args.add(s1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:241:11: ( ',' sn= selector )*
                    loop11:
                    do {
                        int alt11=2;
                        int LA11_0 = input.LA(1);

                        if ( (LA11_0==130) ) {
                            alt11=1;
                        }


                        switch (alt11) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:241:13: ',' sn= selector
                    	    {
                    	    match(input,130,FOLLOW_130_in_selectionFunctionArgs852); 
                    	    pushFollow(FOLLOW_selector_in_selectionFunctionArgs856);
                    	    sn=selector();

                    	    state._fsp--;

                    	     args.add(sn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop11;
                        }
                    } while (true);

                    match(input,129,FOLLOW_129_in_selectionFunctionArgs870); 
                     a = args; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return a;
    }
    // $ANTLR end "selectionFunctionArgs"


    // $ANTLR start "selector"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:245:1: selector returns [RawSelector s] : (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs );
    public final RawSelector selector() throws RecognitionException {
        RawSelector s = null;

        ColumnIdentifier c = null;

        String f = null;

        List<RawSelector> args = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:246:5: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs )
            int alt13=4;
            alt13 = dfa13.predict(input);
            switch (alt13) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:246:7: c= cident
                    {
                    pushFollow(FOLLOW_cident_in_selector895);
                    c=cident();

                    state._fsp--;

                     s = c; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:247:7: K_WRITETIME '(' c= cident ')'
                    {
                    match(input,K_WRITETIME,FOLLOW_K_WRITETIME_in_selector938); 
                    match(input,128,FOLLOW_128_in_selector940); 
                    pushFollow(FOLLOW_cident_in_selector944);
                    c=cident();

                    state._fsp--;

                    match(input,129,FOLLOW_129_in_selector946); 
                     s = new RawSelector.WritetimeOrTTL(c, true); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:248:7: K_TTL '(' c= cident ')'
                    {
                    match(input,K_TTL,FOLLOW_K_TTL_in_selector969); 
                    match(input,128,FOLLOW_128_in_selector977); 
                    pushFollow(FOLLOW_cident_in_selector981);
                    c=cident();

                    state._fsp--;

                    match(input,129,FOLLOW_129_in_selector983); 
                     s = new RawSelector.WritetimeOrTTL(c, false); 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:249:7: f= functionName args= selectionFunctionArgs
                    {
                    pushFollow(FOLLOW_functionName_in_selector1008);
                    f=functionName();

                    state._fsp--;

                    pushFollow(FOLLOW_selectionFunctionArgs_in_selector1012);
                    args=selectionFunctionArgs();

                    state._fsp--;

                     s = new RawSelector.WithFunction(f, args); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return s;
    }
    // $ANTLR end "selector"


    // $ANTLR start "selectCountClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:252:1: selectCountClause returns [List<RawSelector> expr] : ( '\\*' | i= INTEGER );
    public final List<RawSelector> selectCountClause() throws RecognitionException {
        List<RawSelector> expr = null;

        Token i=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:253:5: ( '\\*' | i= INTEGER )
            int alt14=2;
            int LA14_0 = input.LA(1);

            if ( (LA14_0==131) ) {
                alt14=1;
            }
            else if ( (LA14_0==INTEGER) ) {
                alt14=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 14, 0, input);

                throw nvae;
            }
            switch (alt14) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:253:7: '\\*'
                    {
                    match(input,131,FOLLOW_131_in_selectCountClause1035); 
                     expr = Collections.<RawSelector>emptyList();

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:254:7: i= INTEGER
                    {
                    i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_selectCountClause1057); 
                     if (!i.getText().equals("1")) addRecognitionError("Only COUNT(1) is supported, got COUNT(" + i.getText() + ")"); expr = Collections.<RawSelector>emptyList();

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectCountClause"


    // $ANTLR start "whereClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:257:1: whereClause returns [List<Relation> clause] : relation[$clause] ( K_AND relation[$clause] )* ;
    public final List<Relation> whereClause() throws RecognitionException {
        List<Relation> clause = null;

         clause = new ArrayList<Relation>(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:259:5: ( relation[$clause] ( K_AND relation[$clause] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:259:7: relation[$clause] ( K_AND relation[$clause] )*
            {
            pushFollow(FOLLOW_relation_in_whereClause1093);
            relation(clause);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:259:25: ( K_AND relation[$clause] )*
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( (LA15_0==K_AND) ) {
                    alt15=1;
                }


                switch (alt15) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:259:26: K_AND relation[$clause]
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_whereClause1097); 
            	    pushFollow(FOLLOW_relation_in_whereClause1099);
            	    relation(clause);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop15;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return clause;
    }
    // $ANTLR end "whereClause"


    // $ANTLR start "orderByClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:262:1: orderByClause[Map<ColumnIdentifier, Boolean> orderings] : c= cident ( K_ASC | K_DESC )? ;
    public final void orderByClause(Map<ColumnIdentifier, Boolean> orderings) throws RecognitionException {
        ColumnIdentifier c = null;



                ColumnIdentifier orderBy = null;
                boolean reversed = false;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:267:5: (c= cident ( K_ASC | K_DESC )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:267:7: c= cident ( K_ASC | K_DESC )?
            {
            pushFollow(FOLLOW_cident_in_orderByClause1130);
            c=cident();

            state._fsp--;

             orderBy = c; 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:267:33: ( K_ASC | K_DESC )?
            int alt16=3;
            int LA16_0 = input.LA(1);

            if ( (LA16_0==K_ASC) ) {
                alt16=1;
            }
            else if ( (LA16_0==K_DESC) ) {
                alt16=2;
            }
            switch (alt16) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:267:34: K_ASC
                    {
                    match(input,K_ASC,FOLLOW_K_ASC_in_orderByClause1135); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:267:42: K_DESC
                    {
                    match(input,K_DESC,FOLLOW_K_DESC_in_orderByClause1139); 
                     reversed = true; 

                    }
                    break;

            }

             orderings.put(c, reversed); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "orderByClause"


    // $ANTLR start "insertStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:1: insertStatement returns [UpdateStatement expr] : K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( usingClause[attrs] )? ;
    public final UpdateStatement insertStatement() throws RecognitionException {
        UpdateStatement expr = null;

        CFName cf = null;

        ColumnIdentifier c1 = null;

        ColumnIdentifier cn = null;

        Term.Raw v1 = null;

        Term.Raw vn = null;



                Attributes attrs = new Attributes();
                List<ColumnIdentifier> columnNames  = new ArrayList<ColumnIdentifier>();
                List<Term.Raw> values = new ArrayList<Term.Raw>();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:282:5: ( K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( usingClause[attrs] )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:282:7: K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( usingClause[attrs] )?
            {
            match(input,K_INSERT,FOLLOW_K_INSERT_in_insertStatement1177); 
            match(input,K_INTO,FOLLOW_K_INTO_in_insertStatement1179); 
            pushFollow(FOLLOW_columnFamilyName_in_insertStatement1183);
            cf=columnFamilyName();

            state._fsp--;

            match(input,128,FOLLOW_128_in_insertStatement1195); 
            pushFollow(FOLLOW_cident_in_insertStatement1199);
            c1=cident();

            state._fsp--;

             columnNames.add(c1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:283:51: ( ',' cn= cident )*
            loop17:
            do {
                int alt17=2;
                int LA17_0 = input.LA(1);

                if ( (LA17_0==130) ) {
                    alt17=1;
                }


                switch (alt17) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:283:53: ',' cn= cident
            	    {
            	    match(input,130,FOLLOW_130_in_insertStatement1206); 
            	    pushFollow(FOLLOW_cident_in_insertStatement1210);
            	    cn=cident();

            	    state._fsp--;

            	     columnNames.add(cn); 

            	    }
            	    break;

            	default :
            	    break loop17;
                }
            } while (true);

            match(input,129,FOLLOW_129_in_insertStatement1217); 
            match(input,K_VALUES,FOLLOW_K_VALUES_in_insertStatement1227); 
            match(input,128,FOLLOW_128_in_insertStatement1239); 
            pushFollow(FOLLOW_term_in_insertStatement1243);
            v1=term();

            state._fsp--;

             values.add(v1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:285:43: ( ',' vn= term )*
            loop18:
            do {
                int alt18=2;
                int LA18_0 = input.LA(1);

                if ( (LA18_0==130) ) {
                    alt18=1;
                }


                switch (alt18) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:285:45: ',' vn= term
            	    {
            	    match(input,130,FOLLOW_130_in_insertStatement1249); 
            	    pushFollow(FOLLOW_term_in_insertStatement1253);
            	    vn=term();

            	    state._fsp--;

            	     values.add(vn); 

            	    }
            	    break;

            	default :
            	    break loop18;
                }
            } while (true);

            match(input,129,FOLLOW_129_in_insertStatement1260); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:286:9: ( usingClause[attrs] )?
            int alt19=2;
            int LA19_0 = input.LA(1);

            if ( (LA19_0==K_USING) ) {
                alt19=1;
            }
            switch (alt19) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:286:11: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_insertStatement1272);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }


                      expr = new UpdateStatement(cf, attrs, columnNames, values);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "insertStatement"


    // $ANTLR start "usingClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:292:1: usingClause[Attributes attrs] : K_USING usingClauseObjective[attrs] ( ( K_AND )? usingClauseObjective[attrs] )* ;
    public final void usingClause(Attributes attrs) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:5: ( K_USING usingClauseObjective[attrs] ( ( K_AND )? usingClauseObjective[attrs] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:7: K_USING usingClauseObjective[attrs] ( ( K_AND )? usingClauseObjective[attrs] )*
            {
            match(input,K_USING,FOLLOW_K_USING_in_usingClause1302); 
            pushFollow(FOLLOW_usingClauseObjective_in_usingClause1304);
            usingClauseObjective(attrs);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:43: ( ( K_AND )? usingClauseObjective[attrs] )*
            loop21:
            do {
                int alt21=2;
                int LA21_0 = input.LA(1);

                if ( ((LA21_0>=K_TTL && LA21_0<=K_AND)||LA21_0==K_TIMESTAMP) ) {
                    alt21=1;
                }


                switch (alt21) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:45: ( K_AND )? usingClauseObjective[attrs]
            	    {
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:45: ( K_AND )?
            	    int alt20=2;
            	    int LA20_0 = input.LA(1);

            	    if ( (LA20_0==K_AND) ) {
            	        alt20=1;
            	    }
            	    switch (alt20) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:45: K_AND
            	            {
            	            match(input,K_AND,FOLLOW_K_AND_in_usingClause1309); 

            	            }
            	            break;

            	    }

            	    pushFollow(FOLLOW_usingClauseObjective_in_usingClause1312);
            	    usingClauseObjective(attrs);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop21;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClause"


    // $ANTLR start "usingClauseDelete"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:296:1: usingClauseDelete[Attributes attrs] : K_USING usingClauseDeleteObjective[attrs] ( ( K_AND )? usingClauseDeleteObjective[attrs] )* ;
    public final void usingClauseDelete(Attributes attrs) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:5: ( K_USING usingClauseDeleteObjective[attrs] ( ( K_AND )? usingClauseDeleteObjective[attrs] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:7: K_USING usingClauseDeleteObjective[attrs] ( ( K_AND )? usingClauseDeleteObjective[attrs] )*
            {
            match(input,K_USING,FOLLOW_K_USING_in_usingClauseDelete1334); 
            pushFollow(FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete1336);
            usingClauseDeleteObjective(attrs);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:49: ( ( K_AND )? usingClauseDeleteObjective[attrs] )*
            loop23:
            do {
                int alt23=2;
                int LA23_0 = input.LA(1);

                if ( (LA23_0==K_AND||LA23_0==K_TIMESTAMP) ) {
                    alt23=1;
                }


                switch (alt23) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:51: ( K_AND )? usingClauseDeleteObjective[attrs]
            	    {
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:51: ( K_AND )?
            	    int alt22=2;
            	    int LA22_0 = input.LA(1);

            	    if ( (LA22_0==K_AND) ) {
            	        alt22=1;
            	    }
            	    switch (alt22) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:51: K_AND
            	            {
            	            match(input,K_AND,FOLLOW_K_AND_in_usingClauseDelete1341); 

            	            }
            	            break;

            	    }

            	    pushFollow(FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete1344);
            	    usingClauseDeleteObjective(attrs);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop23;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseDelete"


    // $ANTLR start "usingClauseDeleteObjective"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:300:1: usingClauseDeleteObjective[Attributes attrs] : K_TIMESTAMP ts= INTEGER ;
    public final void usingClauseDeleteObjective(Attributes attrs) throws RecognitionException {
        Token ts=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:5: ( K_TIMESTAMP ts= INTEGER )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:7: K_TIMESTAMP ts= INTEGER
            {
            match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseDeleteObjective1366); 
            ts=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_usingClauseDeleteObjective1370); 
             attrs.timestamp = Long.valueOf((ts!=null?ts.getText():null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseDeleteObjective"


    // $ANTLR start "usingClauseObjective"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:304:1: usingClauseObjective[Attributes attrs] : ( usingClauseDeleteObjective[attrs] | K_TTL t= INTEGER );
    public final void usingClauseObjective(Attributes attrs) throws RecognitionException {
        Token t=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:5: ( usingClauseDeleteObjective[attrs] | K_TTL t= INTEGER )
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( (LA24_0==K_TIMESTAMP) ) {
                alt24=1;
            }
            else if ( (LA24_0==K_TTL) ) {
                alt24=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 24, 0, input);

                throw nvae;
            }
            switch (alt24) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:7: usingClauseDeleteObjective[attrs]
                    {
                    pushFollow(FOLLOW_usingClauseDeleteObjective_in_usingClauseObjective1390);
                    usingClauseDeleteObjective(attrs);

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:7: K_TTL t= INTEGER
                    {
                    match(input,K_TTL,FOLLOW_K_TTL_in_usingClauseObjective1399); 
                    t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_usingClauseObjective1403); 
                     attrs.timeToLive = Integer.valueOf((t!=null?t.getText():null)); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseObjective"


    // $ANTLR start "updateStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:309:1: updateStatement returns [UpdateStatement expr] : K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ;
    public final UpdateStatement updateStatement() throws RecognitionException {
        UpdateStatement expr = null;

        CFName cf = null;

        List<Relation> wclause = null;



                Attributes attrs = new Attributes();
                List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations = new ArrayList<Pair<ColumnIdentifier, Operation.RawUpdate>>();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:320:5: ( K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:320:7: K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause
            {
            match(input,K_UPDATE,FOLLOW_K_UPDATE_in_updateStatement1437); 
            pushFollow(FOLLOW_columnFamilyName_in_updateStatement1441);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:321:7: ( usingClause[attrs] )?
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( (LA25_0==K_USING) ) {
                alt25=1;
            }
            switch (alt25) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:321:9: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_updateStatement1451);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }

            match(input,K_SET,FOLLOW_K_SET_in_updateStatement1463); 
            pushFollow(FOLLOW_columnOperation_in_updateStatement1465);
            columnOperation(operations);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:322:41: ( ',' columnOperation[operations] )*
            loop26:
            do {
                int alt26=2;
                int LA26_0 = input.LA(1);

                if ( (LA26_0==130) ) {
                    alt26=1;
                }


                switch (alt26) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:322:42: ',' columnOperation[operations]
            	    {
            	    match(input,130,FOLLOW_130_in_updateStatement1469); 
            	    pushFollow(FOLLOW_columnOperation_in_updateStatement1471);
            	    columnOperation(operations);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop26;
                }
            } while (true);

            match(input,K_WHERE,FOLLOW_K_WHERE_in_updateStatement1482); 
            pushFollow(FOLLOW_whereClause_in_updateStatement1486);
            wclause=whereClause();

            state._fsp--;


                      return new UpdateStatement(cf, operations, wclause, attrs);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "updateStatement"


    // $ANTLR start "deleteStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:329:1: deleteStatement returns [DeleteStatement expr] : K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ;
    public final DeleteStatement deleteStatement() throws RecognitionException {
        DeleteStatement expr = null;

        List<Operation.RawDeletion> dels = null;

        CFName cf = null;

        List<Relation> wclause = null;



                Attributes attrs = new Attributes();
                List<Operation.RawDeletion> columnDeletions = Collections.emptyList();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:340:5: ( K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:340:7: K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause
            {
            match(input,K_DELETE,FOLLOW_K_DELETE_in_deleteStatement1526); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:340:16: (dels= deleteSelection )?
            int alt27=2;
            int LA27_0 = input.LA(1);

            if ( (LA27_0==K_COUNT||(LA27_0>=K_FILTERING && LA27_0<=K_TTL)||LA27_0==K_VALUES||LA27_0==K_TIMESTAMP||LA27_0==K_COUNTER||(LA27_0>=K_KEY && LA27_0<=K_CUSTOM)||LA27_0==IDENT||LA27_0==K_TYPE||LA27_0==K_LIST||(LA27_0>=K_ALL && LA27_0<=K_PASSWORD)||LA27_0==QUOTED_NAME||(LA27_0>=K_ASCII && LA27_0<=K_MAP)) ) {
                alt27=1;
            }
            switch (alt27) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:340:18: dels= deleteSelection
                    {
                    pushFollow(FOLLOW_deleteSelection_in_deleteStatement1532);
                    dels=deleteSelection();

                    state._fsp--;

                     columnDeletions = dels; 

                    }
                    break;

            }

            match(input,K_FROM,FOLLOW_K_FROM_in_deleteStatement1545); 
            pushFollow(FOLLOW_columnFamilyName_in_deleteStatement1549);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:342:7: ( usingClauseDelete[attrs] )?
            int alt28=2;
            int LA28_0 = input.LA(1);

            if ( (LA28_0==K_USING) ) {
                alt28=1;
            }
            switch (alt28) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:342:9: usingClauseDelete[attrs]
                    {
                    pushFollow(FOLLOW_usingClauseDelete_in_deleteStatement1559);
                    usingClauseDelete(attrs);

                    state._fsp--;


                    }
                    break;

            }

            match(input,K_WHERE,FOLLOW_K_WHERE_in_deleteStatement1571); 
            pushFollow(FOLLOW_whereClause_in_deleteStatement1575);
            wclause=whereClause();

            state._fsp--;


                      return new DeleteStatement(cf, columnDeletions, wclause, attrs);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "deleteStatement"


    // $ANTLR start "deleteSelection"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:349:1: deleteSelection returns [List<Operation.RawDeletion> operations] : t1= deleteOp ( ',' tN= deleteOp )* ;
    public final List<Operation.RawDeletion> deleteSelection() throws RecognitionException {
        List<Operation.RawDeletion> operations = null;

        Operation.RawDeletion t1 = null;

        Operation.RawDeletion tN = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:5: (t1= deleteOp ( ',' tN= deleteOp )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:7: t1= deleteOp ( ',' tN= deleteOp )*
            {
             operations = new ArrayList<Operation.RawDeletion>(); 
            pushFollow(FOLLOW_deleteOp_in_deleteSelection1618);
            t1=deleteOp();

            state._fsp--;

             operations.add(t1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:352:11: ( ',' tN= deleteOp )*
            loop29:
            do {
                int alt29=2;
                int LA29_0 = input.LA(1);

                if ( (LA29_0==130) ) {
                    alt29=1;
                }


                switch (alt29) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:352:12: ',' tN= deleteOp
            	    {
            	    match(input,130,FOLLOW_130_in_deleteSelection1633); 
            	    pushFollow(FOLLOW_deleteOp_in_deleteSelection1637);
            	    tN=deleteOp();

            	    state._fsp--;

            	     operations.add(tN); 

            	    }
            	    break;

            	default :
            	    break loop29;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return operations;
    }
    // $ANTLR end "deleteSelection"


    // $ANTLR start "deleteOp"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:355:1: deleteOp returns [Operation.RawDeletion op] : (c= cident | c= cident '[' t= term ']' );
    public final Operation.RawDeletion deleteOp() throws RecognitionException {
        Operation.RawDeletion op = null;

        ColumnIdentifier c = null;

        Term.Raw t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:356:5: (c= cident | c= cident '[' t= term ']' )
            int alt30=2;
            alt30 = dfa30.predict(input);
            switch (alt30) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:356:7: c= cident
                    {
                    pushFollow(FOLLOW_cident_in_deleteOp1664);
                    c=cident();

                    state._fsp--;

                     op = new Operation.ColumnDeletion(c); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:357:7: c= cident '[' t= term ']'
                    {
                    pushFollow(FOLLOW_cident_in_deleteOp1691);
                    c=cident();

                    state._fsp--;

                    match(input,132,FOLLOW_132_in_deleteOp1693); 
                    pushFollow(FOLLOW_term_in_deleteOp1697);
                    t=term();

                    state._fsp--;

                    match(input,133,FOLLOW_133_in_deleteOp1699); 
                     op = new Operation.ElementDeletion(c, t); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return op;
    }
    // $ANTLR end "deleteOp"


    // $ANTLR start "batchStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:360:1: batchStatement returns [BatchStatement expr] : K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? s1= batchStatementObjective ( ';' )? (sN= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH ;
    public final BatchStatement batchStatement() throws RecognitionException {
        BatchStatement expr = null;

        ModificationStatement s1 = null;

        ModificationStatement sN = null;



                BatchStatement.Type type = BatchStatement.Type.LOGGED;
                List<ModificationStatement> statements = new ArrayList<ModificationStatement>();
                Attributes attrs = new Attributes();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:390:5: ( K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? s1= batchStatementObjective ( ';' )? (sN= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:390:7: K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? s1= batchStatementObjective ( ';' )? (sN= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH
            {
            match(input,K_BEGIN,FOLLOW_K_BEGIN_in_batchStatement1733); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:391:7: ( K_UNLOGGED | K_COUNTER )?
            int alt31=3;
            int LA31_0 = input.LA(1);

            if ( (LA31_0==K_UNLOGGED) ) {
                alt31=1;
            }
            else if ( (LA31_0==K_COUNTER) ) {
                alt31=2;
            }
            switch (alt31) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:391:9: K_UNLOGGED
                    {
                    match(input,K_UNLOGGED,FOLLOW_K_UNLOGGED_in_batchStatement1743); 
                     type = BatchStatement.Type.UNLOGGED; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:391:63: K_COUNTER
                    {
                    match(input,K_COUNTER,FOLLOW_K_COUNTER_in_batchStatement1749); 
                     type = BatchStatement.Type.COUNTER; 

                    }
                    break;

            }

            match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement1762); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:392:15: ( usingClause[attrs] )?
            int alt32=2;
            int LA32_0 = input.LA(1);

            if ( (LA32_0==K_USING) ) {
                alt32=1;
            }
            switch (alt32) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:392:17: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_batchStatement1766);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }

            pushFollow(FOLLOW_batchStatementObjective_in_batchStatement1784);
            s1=batchStatementObjective();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:393:38: ( ';' )?
            int alt33=2;
            int LA33_0 = input.LA(1);

            if ( (LA33_0==127) ) {
                alt33=1;
            }
            switch (alt33) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:393:38: ';'
                    {
                    match(input,127,FOLLOW_127_in_batchStatement1786); 

                    }
                    break;

            }

             statements.add(s1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:393:67: (sN= batchStatementObjective ( ';' )? )*
            loop35:
            do {
                int alt35=2;
                int LA35_0 = input.LA(1);

                if ( (LA35_0==K_INSERT||LA35_0==K_UPDATE||LA35_0==K_DELETE) ) {
                    alt35=1;
                }


                switch (alt35) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:393:69: sN= batchStatementObjective ( ';' )?
            	    {
            	    pushFollow(FOLLOW_batchStatementObjective_in_batchStatement1795);
            	    sN=batchStatementObjective();

            	    state._fsp--;

            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:393:96: ( ';' )?
            	    int alt34=2;
            	    int LA34_0 = input.LA(1);

            	    if ( (LA34_0==127) ) {
            	        alt34=1;
            	    }
            	    switch (alt34) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:393:96: ';'
            	            {
            	            match(input,127,FOLLOW_127_in_batchStatement1797); 

            	            }
            	            break;

            	    }

            	     statements.add(sN); 

            	    }
            	    break;

            	default :
            	    break loop35;
                }
            } while (true);

            match(input,K_APPLY,FOLLOW_K_APPLY_in_batchStatement1811); 
            match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement1813); 

                      return new BatchStatement(type, statements, attrs);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "batchStatement"


    // $ANTLR start "batchStatementObjective"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:400:1: batchStatementObjective returns [ModificationStatement statement] : (i= insertStatement | u= updateStatement | d= deleteStatement );
    public final ModificationStatement batchStatementObjective() throws RecognitionException {
        ModificationStatement statement = null;

        UpdateStatement i = null;

        UpdateStatement u = null;

        DeleteStatement d = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:401:5: (i= insertStatement | u= updateStatement | d= deleteStatement )
            int alt36=3;
            switch ( input.LA(1) ) {
            case K_INSERT:
                {
                alt36=1;
                }
                break;
            case K_UPDATE:
                {
                alt36=2;
                }
                break;
            case K_DELETE:
                {
                alt36=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 36, 0, input);

                throw nvae;
            }

            switch (alt36) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:401:7: i= insertStatement
                    {
                    pushFollow(FOLLOW_insertStatement_in_batchStatementObjective1844);
                    i=insertStatement();

                    state._fsp--;

                     statement = i; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:402:7: u= updateStatement
                    {
                    pushFollow(FOLLOW_updateStatement_in_batchStatementObjective1857);
                    u=updateStatement();

                    state._fsp--;

                     statement = u; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:403:7: d= deleteStatement
                    {
                    pushFollow(FOLLOW_deleteStatement_in_batchStatementObjective1870);
                    d=deleteStatement();

                    state._fsp--;

                     statement = d; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return statement;
    }
    // $ANTLR end "batchStatementObjective"


    // $ANTLR start "createKeyspaceStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:406:1: createKeyspaceStatement returns [CreateKeyspaceStatement expr] : K_CREATE K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] ;
    public final CreateKeyspaceStatement createKeyspaceStatement() throws RecognitionException {
        CreateKeyspaceStatement expr = null;

        String ks = null;


         KSPropDefs attrs = new KSPropDefs(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:411:5: ( K_CREATE K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:411:7: K_CREATE K_KEYSPACE ks= keyspaceName K_WITH properties[attrs]
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createKeyspaceStatement1905); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_createKeyspaceStatement1907); 
            pushFollow(FOLLOW_keyspaceName_in_createKeyspaceStatement1911);
            ks=keyspaceName();

            state._fsp--;

            match(input,K_WITH,FOLLOW_K_WITH_in_createKeyspaceStatement1919); 
            pushFollow(FOLLOW_properties_in_createKeyspaceStatement1921);
            properties(attrs);

            state._fsp--;

             expr = new CreateKeyspaceStatement(ks, attrs); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createKeyspaceStatement"


    // $ANTLR start "createColumnFamilyStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:1: createColumnFamilyStatement returns [CreateColumnFamilyStatement.RawStatement expr] : K_CREATE K_COLUMNFAMILY cf= columnFamilyName cfamDefinition[expr] ;
    public final CreateColumnFamilyStatement.RawStatement createColumnFamilyStatement() throws RecognitionException {
        CreateColumnFamilyStatement.RawStatement expr = null;

        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:423:5: ( K_CREATE K_COLUMNFAMILY cf= columnFamilyName cfamDefinition[expr] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:423:7: K_CREATE K_COLUMNFAMILY cf= columnFamilyName cfamDefinition[expr]
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createColumnFamilyStatement1947); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_createColumnFamilyStatement1949); 
            pushFollow(FOLLOW_columnFamilyName_in_createColumnFamilyStatement1953);
            cf=columnFamilyName();

            state._fsp--;

             expr = new CreateColumnFamilyStatement.RawStatement(cf); 
            pushFollow(FOLLOW_cfamDefinition_in_createColumnFamilyStatement1963);
            cfamDefinition(expr);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createColumnFamilyStatement"


    // $ANTLR start "cfamDefinition"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:427:1: cfamDefinition[CreateColumnFamilyStatement.RawStatement expr] : '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? ;
    public final void cfamDefinition(CreateColumnFamilyStatement.RawStatement expr) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:428:5: ( '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:428:7: '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
            {
            match(input,128,FOLLOW_128_in_cfamDefinition1982); 
            pushFollow(FOLLOW_cfamColumns_in_cfamDefinition1984);
            cfamColumns(expr);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:428:29: ( ',' ( cfamColumns[expr] )? )*
            loop38:
            do {
                int alt38=2;
                int LA38_0 = input.LA(1);

                if ( (LA38_0==130) ) {
                    alt38=1;
                }


                switch (alt38) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:428:31: ',' ( cfamColumns[expr] )?
            	    {
            	    match(input,130,FOLLOW_130_in_cfamDefinition1989); 
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:428:35: ( cfamColumns[expr] )?
            	    int alt37=2;
            	    int LA37_0 = input.LA(1);

            	    if ( (LA37_0==K_COUNT||(LA37_0>=K_FILTERING && LA37_0<=K_TTL)||LA37_0==K_VALUES||LA37_0==K_TIMESTAMP||LA37_0==K_COUNTER||(LA37_0>=K_PRIMARY && LA37_0<=K_CUSTOM)||LA37_0==IDENT||LA37_0==K_TYPE||LA37_0==K_LIST||(LA37_0>=K_ALL && LA37_0<=K_PASSWORD)||LA37_0==QUOTED_NAME||(LA37_0>=K_ASCII && LA37_0<=K_MAP)) ) {
            	        alt37=1;
            	    }
            	    switch (alt37) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:428:35: cfamColumns[expr]
            	            {
            	            pushFollow(FOLLOW_cfamColumns_in_cfamDefinition1991);
            	            cfamColumns(expr);

            	            state._fsp--;


            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop38;
                }
            } while (true);

            match(input,129,FOLLOW_129_in_cfamDefinition1998); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:429:7: ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
            int alt40=2;
            int LA40_0 = input.LA(1);

            if ( (LA40_0==K_WITH) ) {
                alt40=1;
            }
            switch (alt40) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:429:9: K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )*
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_cfamDefinition2008); 
                    pushFollow(FOLLOW_cfamProperty_in_cfamDefinition2010);
                    cfamProperty(expr);

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:429:35: ( K_AND cfamProperty[expr] )*
                    loop39:
                    do {
                        int alt39=2;
                        int LA39_0 = input.LA(1);

                        if ( (LA39_0==K_AND) ) {
                            alt39=1;
                        }


                        switch (alt39) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:429:37: K_AND cfamProperty[expr]
                    	    {
                    	    match(input,K_AND,FOLLOW_K_AND_in_cfamDefinition2015); 
                    	    pushFollow(FOLLOW_cfamProperty_in_cfamDefinition2017);
                    	    cfamProperty(expr);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop39;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamDefinition"


    // $ANTLR start "cfamColumns"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:432:1: cfamColumns[CreateColumnFamilyStatement.RawStatement expr] : (k= cident v= comparatorType ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= cident )* ')' );
    public final void cfamColumns(CreateColumnFamilyStatement.RawStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;

        CQL3Type v = null;

        ColumnIdentifier c = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:5: (k= cident v= comparatorType ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= cident )* ')' )
            int alt43=2;
            int LA43_0 = input.LA(1);

            if ( (LA43_0==K_COUNT||(LA43_0>=K_FILTERING && LA43_0<=K_TTL)||LA43_0==K_VALUES||LA43_0==K_TIMESTAMP||LA43_0==K_COUNTER||(LA43_0>=K_KEY && LA43_0<=K_CUSTOM)||LA43_0==IDENT||LA43_0==K_TYPE||LA43_0==K_LIST||(LA43_0>=K_ALL && LA43_0<=K_PASSWORD)||LA43_0==QUOTED_NAME||(LA43_0>=K_ASCII && LA43_0<=K_MAP)) ) {
                alt43=1;
            }
            else if ( (LA43_0==K_PRIMARY) ) {
                alt43=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 43, 0, input);

                throw nvae;
            }
            switch (alt43) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:7: k= cident v= comparatorType ( K_PRIMARY K_KEY )?
                    {
                    pushFollow(FOLLOW_cident_in_cfamColumns2043);
                    k=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_comparatorType_in_cfamColumns2047);
                    v=comparatorType();

                    state._fsp--;

                     expr.addDefinition(k, v); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:64: ( K_PRIMARY K_KEY )?
                    int alt41=2;
                    int LA41_0 = input.LA(1);

                    if ( (LA41_0==K_PRIMARY) ) {
                        alt41=1;
                    }
                    switch (alt41) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:65: K_PRIMARY K_KEY
                            {
                            match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns2052); 
                            match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns2054); 
                             expr.addKeyAliases(Collections.singletonList(k)); 

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:434:7: K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= cident )* ')'
                    {
                    match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns2066); 
                    match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns2068); 
                    match(input,128,FOLLOW_128_in_cfamColumns2070); 
                    pushFollow(FOLLOW_pkDef_in_cfamColumns2072);
                    pkDef(expr);

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:434:39: ( ',' c= cident )*
                    loop42:
                    do {
                        int alt42=2;
                        int LA42_0 = input.LA(1);

                        if ( (LA42_0==130) ) {
                            alt42=1;
                        }


                        switch (alt42) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:434:40: ',' c= cident
                    	    {
                    	    match(input,130,FOLLOW_130_in_cfamColumns2076); 
                    	    pushFollow(FOLLOW_cident_in_cfamColumns2080);
                    	    c=cident();

                    	    state._fsp--;

                    	     expr.addColumnAlias(c); 

                    	    }
                    	    break;

                    	default :
                    	    break loop42;
                        }
                    } while (true);

                    match(input,129,FOLLOW_129_in_cfamColumns2087); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamColumns"


    // $ANTLR start "pkDef"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:437:1: pkDef[CreateColumnFamilyStatement.RawStatement expr] : (k= cident | '(' k1= cident ( ',' kn= cident )* ')' );
    public final void pkDef(CreateColumnFamilyStatement.RawStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;

        ColumnIdentifier k1 = null;

        ColumnIdentifier kn = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:438:5: (k= cident | '(' k1= cident ( ',' kn= cident )* ')' )
            int alt45=2;
            int LA45_0 = input.LA(1);

            if ( (LA45_0==K_COUNT||(LA45_0>=K_FILTERING && LA45_0<=K_TTL)||LA45_0==K_VALUES||LA45_0==K_TIMESTAMP||LA45_0==K_COUNTER||(LA45_0>=K_KEY && LA45_0<=K_CUSTOM)||LA45_0==IDENT||LA45_0==K_TYPE||LA45_0==K_LIST||(LA45_0>=K_ALL && LA45_0<=K_PASSWORD)||LA45_0==QUOTED_NAME||(LA45_0>=K_ASCII && LA45_0<=K_MAP)) ) {
                alt45=1;
            }
            else if ( (LA45_0==128) ) {
                alt45=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 45, 0, input);

                throw nvae;
            }
            switch (alt45) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:438:7: k= cident
                    {
                    pushFollow(FOLLOW_cident_in_pkDef2107);
                    k=cident();

                    state._fsp--;

                     expr.addKeyAliases(Collections.singletonList(k)); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:439:7: '(' k1= cident ( ',' kn= cident )* ')'
                    {
                    match(input,128,FOLLOW_128_in_pkDef2117); 
                     List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>(); 
                    pushFollow(FOLLOW_cident_in_pkDef2123);
                    k1=cident();

                    state._fsp--;

                     l.add(k1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:439:102: ( ',' kn= cident )*
                    loop44:
                    do {
                        int alt44=2;
                        int LA44_0 = input.LA(1);

                        if ( (LA44_0==130) ) {
                            alt44=1;
                        }


                        switch (alt44) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:439:104: ',' kn= cident
                    	    {
                    	    match(input,130,FOLLOW_130_in_pkDef2129); 
                    	    pushFollow(FOLLOW_cident_in_pkDef2133);
                    	    kn=cident();

                    	    state._fsp--;

                    	     l.add(kn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop44;
                        }
                    } while (true);

                    match(input,129,FOLLOW_129_in_pkDef2140); 
                     expr.addKeyAliases(l); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "pkDef"


    // $ANTLR start "cfamProperty"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:442:1: cfamProperty[CreateColumnFamilyStatement.RawStatement expr] : ( property[expr.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')' );
    public final void cfamProperty(CreateColumnFamilyStatement.RawStatement expr) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:443:5: ( property[expr.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')' )
            int alt47=3;
            switch ( input.LA(1) ) {
            case K_COUNT:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_KEY:
            case K_STORAGE:
            case K_CUSTOM:
            case IDENT:
            case K_TYPE:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case QUOTED_NAME:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt47=1;
                }
                break;
            case K_COMPACT:
                {
                int LA47_2 = input.LA(2);

                if ( (LA47_2==K_STORAGE) ) {
                    alt47=2;
                }
                else if ( (LA47_2==138) ) {
                    alt47=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 47, 2, input);

                    throw nvae;
                }
                }
                break;
            case K_CLUSTERING:
                {
                int LA47_3 = input.LA(2);

                if ( (LA47_3==K_ORDER) ) {
                    alt47=3;
                }
                else if ( (LA47_3==138) ) {
                    alt47=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 47, 3, input);

                    throw nvae;
                }
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 47, 0, input);

                throw nvae;
            }

            switch (alt47) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:443:7: property[expr.properties]
                    {
                    pushFollow(FOLLOW_property_in_cfamProperty2160);
                    property(expr.properties);

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:444:7: K_COMPACT K_STORAGE
                    {
                    match(input,K_COMPACT,FOLLOW_K_COMPACT_in_cfamProperty2169); 
                    match(input,K_STORAGE,FOLLOW_K_STORAGE_in_cfamProperty2171); 
                     expr.setCompactStorage(); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:445:7: K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')'
                    {
                    match(input,K_CLUSTERING,FOLLOW_K_CLUSTERING_in_cfamProperty2181); 
                    match(input,K_ORDER,FOLLOW_K_ORDER_in_cfamProperty2183); 
                    match(input,K_BY,FOLLOW_K_BY_in_cfamProperty2185); 
                    match(input,128,FOLLOW_128_in_cfamProperty2187); 
                    pushFollow(FOLLOW_cfamOrdering_in_cfamProperty2189);
                    cfamOrdering(expr);

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:445:56: ( ',' cfamOrdering[expr] )*
                    loop46:
                    do {
                        int alt46=2;
                        int LA46_0 = input.LA(1);

                        if ( (LA46_0==130) ) {
                            alt46=1;
                        }


                        switch (alt46) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:445:57: ',' cfamOrdering[expr]
                    	    {
                    	    match(input,130,FOLLOW_130_in_cfamProperty2193); 
                    	    pushFollow(FOLLOW_cfamOrdering_in_cfamProperty2195);
                    	    cfamOrdering(expr);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop46;
                        }
                    } while (true);

                    match(input,129,FOLLOW_129_in_cfamProperty2200); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamProperty"


    // $ANTLR start "cfamOrdering"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:448:1: cfamOrdering[CreateColumnFamilyStatement.RawStatement expr] : k= cident ( K_ASC | K_DESC ) ;
    public final void cfamOrdering(CreateColumnFamilyStatement.RawStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;


         boolean reversed=false; 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:450:5: (k= cident ( K_ASC | K_DESC ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:450:7: k= cident ( K_ASC | K_DESC )
            {
            pushFollow(FOLLOW_cident_in_cfamOrdering2228);
            k=cident();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:450:16: ( K_ASC | K_DESC )
            int alt48=2;
            int LA48_0 = input.LA(1);

            if ( (LA48_0==K_ASC) ) {
                alt48=1;
            }
            else if ( (LA48_0==K_DESC) ) {
                alt48=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 48, 0, input);

                throw nvae;
            }
            switch (alt48) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:450:17: K_ASC
                    {
                    match(input,K_ASC,FOLLOW_K_ASC_in_cfamOrdering2231); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:450:25: K_DESC
                    {
                    match(input,K_DESC,FOLLOW_K_DESC_in_cfamOrdering2235); 
                     reversed=true;

                    }
                    break;

            }

             expr.setOrdering(k, reversed); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamOrdering"


    // $ANTLR start "createIndexStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:453:1: createIndexStatement returns [CreateIndexStatement expr] : K_CREATE ( K_CUSTOM )? K_INDEX (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= cident ')' ( K_WITH properties[props] )? ;
    public final CreateIndexStatement createIndexStatement() throws RecognitionException {
        CreateIndexStatement expr = null;

        Token idxName=null;
        CFName cf = null;

        ColumnIdentifier id = null;



                boolean isCustom = false;
                IndexPropDefs props = new IndexPropDefs();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:461:5: ( K_CREATE ( K_CUSTOM )? K_INDEX (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= cident ')' ( K_WITH properties[props] )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:461:7: K_CREATE ( K_CUSTOM )? K_INDEX (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= cident ')' ( K_WITH properties[props] )?
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createIndexStatement2273); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:461:16: ( K_CUSTOM )?
            int alt49=2;
            int LA49_0 = input.LA(1);

            if ( (LA49_0==K_CUSTOM) ) {
                alt49=1;
            }
            switch (alt49) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:461:17: K_CUSTOM
                    {
                    match(input,K_CUSTOM,FOLLOW_K_CUSTOM_in_createIndexStatement2276); 
                     isCustom = true; 

                    }
                    break;

            }

            match(input,K_INDEX,FOLLOW_K_INDEX_in_createIndexStatement2282); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:461:57: (idxName= IDENT )?
            int alt50=2;
            int LA50_0 = input.LA(1);

            if ( (LA50_0==IDENT) ) {
                alt50=1;
            }
            switch (alt50) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:461:58: idxName= IDENT
                    {
                    idxName=(Token)match(input,IDENT,FOLLOW_IDENT_in_createIndexStatement2287); 

                    }
                    break;

            }

            match(input,K_ON,FOLLOW_K_ON_in_createIndexStatement2291); 
            pushFollow(FOLLOW_columnFamilyName_in_createIndexStatement2295);
            cf=columnFamilyName();

            state._fsp--;

            match(input,128,FOLLOW_128_in_createIndexStatement2297); 
            pushFollow(FOLLOW_cident_in_createIndexStatement2301);
            id=cident();

            state._fsp--;

            match(input,129,FOLLOW_129_in_createIndexStatement2303); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:462:9: ( K_WITH properties[props] )?
            int alt51=2;
            int LA51_0 = input.LA(1);

            if ( (LA51_0==K_WITH) ) {
                alt51=1;
            }
            switch (alt51) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:462:11: K_WITH properties[props]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_createIndexStatement2315); 
                    pushFollow(FOLLOW_properties_in_createIndexStatement2317);
                    properties(props);

                    state._fsp--;


                    }
                    break;

            }

             expr = new CreateIndexStatement(cf, (idxName!=null?idxName.getText():null), id, isCustom, props); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createIndexStatement"


    // $ANTLR start "alterKeyspaceStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:466:1: alterKeyspaceStatement returns [AlterKeyspaceStatement expr] : K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] ;
    public final AlterKeyspaceStatement alterKeyspaceStatement() throws RecognitionException {
        AlterKeyspaceStatement expr = null;

        String ks = null;


         KSPropDefs attrs = new KSPropDefs(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:471:5: ( K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:471:7: K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs]
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterKeyspaceStatement2361); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement2363); 
            pushFollow(FOLLOW_keyspaceName_in_alterKeyspaceStatement2367);
            ks=keyspaceName();

            state._fsp--;

            match(input,K_WITH,FOLLOW_K_WITH_in_alterKeyspaceStatement2377); 
            pushFollow(FOLLOW_properties_in_alterKeyspaceStatement2379);
            properties(attrs);

            state._fsp--;

             expr = new AlterKeyspaceStatement(ks, attrs); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "alterKeyspaceStatement"


    // $ANTLR start "alterTableStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:476:1: alterTableStatement returns [AlterTableStatement expr] : K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) ;
    public final AlterTableStatement alterTableStatement() throws RecognitionException {
        AlterTableStatement expr = null;

        CFName cf = null;

        ColumnIdentifier id = null;

        CQL3Type v = null;

        ColumnIdentifier id1 = null;

        ColumnIdentifier toId1 = null;

        ColumnIdentifier idn = null;

        ColumnIdentifier toIdn = null;



                AlterTableStatement.Type type = null;
                CFPropDefs props = new CFPropDefs();
                Map<ColumnIdentifier, ColumnIdentifier> renames = new HashMap<ColumnIdentifier, ColumnIdentifier>();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:489:5: ( K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:489:7: K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement2415); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_alterTableStatement2417); 
            pushFollow(FOLLOW_columnFamilyName_in_alterTableStatement2421);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:490:11: ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
            int alt53=4;
            switch ( input.LA(1) ) {
            case K_ALTER:
                {
                alt53=1;
                }
                break;
            case K_ADD:
                {
                alt53=2;
                }
                break;
            case K_WITH:
                {
                alt53=3;
                }
                break;
            case K_RENAME:
                {
                alt53=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 53, 0, input);

                throw nvae;
            }

            switch (alt53) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:490:13: K_ALTER id= cident K_TYPE v= comparatorType
                    {
                    match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement2435); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement2439);
                    id=cident();

                    state._fsp--;

                    match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTableStatement2441); 
                    pushFollow(FOLLOW_comparatorType_in_alterTableStatement2445);
                    v=comparatorType();

                    state._fsp--;

                     type = AlterTableStatement.Type.ALTER; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:491:13: K_ADD id= cident v= comparatorType
                    {
                    match(input,K_ADD,FOLLOW_K_ADD_in_alterTableStatement2461); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement2467);
                    id=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_comparatorType_in_alterTableStatement2471);
                    v=comparatorType();

                    state._fsp--;

                     type = AlterTableStatement.Type.ADD; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:493:13: K_WITH properties[props]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_alterTableStatement2505); 
                    pushFollow(FOLLOW_properties_in_alterTableStatement2508);
                    properties(props);

                    state._fsp--;

                     type = AlterTableStatement.Type.OPTS; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:494:13: K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )*
                    {
                    match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTableStatement2541); 
                     type = AlterTableStatement.Type.RENAME; 
                    pushFollow(FOLLOW_cident_in_alterTableStatement2595);
                    id1=cident();

                    state._fsp--;

                    match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement2597); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement2601);
                    toId1=cident();

                    state._fsp--;

                     renames.put(id1, toId1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:496:16: ( K_AND idn= cident K_TO toIdn= cident )*
                    loop52:
                    do {
                        int alt52=2;
                        int LA52_0 = input.LA(1);

                        if ( (LA52_0==K_AND) ) {
                            alt52=1;
                        }


                        switch (alt52) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:496:18: K_AND idn= cident K_TO toIdn= cident
                    	    {
                    	    match(input,K_AND,FOLLOW_K_AND_in_alterTableStatement2622); 
                    	    pushFollow(FOLLOW_cident_in_alterTableStatement2626);
                    	    idn=cident();

                    	    state._fsp--;

                    	    match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement2628); 
                    	    pushFollow(FOLLOW_cident_in_alterTableStatement2632);
                    	    toIdn=cident();

                    	    state._fsp--;

                    	     renames.put(idn, toIdn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop52;
                        }
                    } while (true);


                    }
                    break;

            }


                    expr = new AlterTableStatement(cf, type, id, v, props, renames);
                

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "alterTableStatement"


    // $ANTLR start "dropKeyspaceStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:503:1: dropKeyspaceStatement returns [DropKeyspaceStatement ksp] : K_DROP K_KEYSPACE ks= keyspaceName ;
    public final DropKeyspaceStatement dropKeyspaceStatement() throws RecognitionException {
        DropKeyspaceStatement ksp = null;

        String ks = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:507:5: ( K_DROP K_KEYSPACE ks= keyspaceName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:507:7: K_DROP K_KEYSPACE ks= keyspaceName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropKeyspaceStatement2678); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement2680); 
            pushFollow(FOLLOW_keyspaceName_in_dropKeyspaceStatement2684);
            ks=keyspaceName();

            state._fsp--;

             ksp = new DropKeyspaceStatement(ks); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ksp;
    }
    // $ANTLR end "dropKeyspaceStatement"


    // $ANTLR start "dropColumnFamilyStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:510:1: dropColumnFamilyStatement returns [DropColumnFamilyStatement stmt] : K_DROP K_COLUMNFAMILY cf= columnFamilyName ;
    public final DropColumnFamilyStatement dropColumnFamilyStatement() throws RecognitionException {
        DropColumnFamilyStatement stmt = null;

        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:514:5: ( K_DROP K_COLUMNFAMILY cf= columnFamilyName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:514:7: K_DROP K_COLUMNFAMILY cf= columnFamilyName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropColumnFamilyStatement2709); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dropColumnFamilyStatement2711); 
            pushFollow(FOLLOW_columnFamilyName_in_dropColumnFamilyStatement2715);
            cf=columnFamilyName();

            state._fsp--;

             stmt = new DropColumnFamilyStatement(cf); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "dropColumnFamilyStatement"


    // $ANTLR start "dropIndexStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:517:1: dropIndexStatement returns [DropIndexStatement expr] : K_DROP K_INDEX index= IDENT ;
    public final DropIndexStatement dropIndexStatement() throws RecognitionException {
        DropIndexStatement expr = null;

        Token index=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:521:5: ( K_DROP K_INDEX index= IDENT )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:522:7: K_DROP K_INDEX index= IDENT
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropIndexStatement2746); 
            match(input,K_INDEX,FOLLOW_K_INDEX_in_dropIndexStatement2748); 
            index=(Token)match(input,IDENT,FOLLOW_IDENT_in_dropIndexStatement2752); 
             expr = new DropIndexStatement((index!=null?index.getText():null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "dropIndexStatement"


    // $ANTLR start "truncateStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:526:1: truncateStatement returns [TruncateStatement stmt] : K_TRUNCATE cf= columnFamilyName ;
    public final TruncateStatement truncateStatement() throws RecognitionException {
        TruncateStatement stmt = null;

        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:5: ( K_TRUNCATE cf= columnFamilyName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:7: K_TRUNCATE cf= columnFamilyName
            {
            match(input,K_TRUNCATE,FOLLOW_K_TRUNCATE_in_truncateStatement2783); 
            pushFollow(FOLLOW_columnFamilyName_in_truncateStatement2787);
            cf=columnFamilyName();

            state._fsp--;

             stmt = new TruncateStatement(cf); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "truncateStatement"


    // $ANTLR start "grantStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:533:1: grantStatement returns [GrantStatement stmt] : K_GRANT permissionOrAll K_ON resource K_TO username ;
    public final GrantStatement grantStatement() throws RecognitionException {
        GrantStatement stmt = null;

        Set<Permission> permissionOrAll1 = null;

        IResource resource2 = null;

        CqlParser.username_return username3 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:537:5: ( K_GRANT permissionOrAll K_ON resource K_TO username )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:537:7: K_GRANT permissionOrAll K_ON resource K_TO username
            {
            match(input,K_GRANT,FOLLOW_K_GRANT_in_grantStatement2812); 
            pushFollow(FOLLOW_permissionOrAll_in_grantStatement2824);
            permissionOrAll1=permissionOrAll();

            state._fsp--;

            match(input,K_ON,FOLLOW_K_ON_in_grantStatement2832); 
            pushFollow(FOLLOW_resource_in_grantStatement2844);
            resource2=resource();

            state._fsp--;

            match(input,K_TO,FOLLOW_K_TO_in_grantStatement2852); 
            pushFollow(FOLLOW_username_in_grantStatement2864);
            username3=username();

            state._fsp--;

             stmt = new GrantStatement(permissionOrAll1, resource2, (username3!=null?input.toString(username3.start,username3.stop):null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "grantStatement"


    // $ANTLR start "revokeStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:546:1: revokeStatement returns [RevokeStatement stmt] : K_REVOKE permissionOrAll K_ON resource K_FROM username ;
    public final RevokeStatement revokeStatement() throws RecognitionException {
        RevokeStatement stmt = null;

        Set<Permission> permissionOrAll4 = null;

        IResource resource5 = null;

        CqlParser.username_return username6 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:550:5: ( K_REVOKE permissionOrAll K_ON resource K_FROM username )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:550:7: K_REVOKE permissionOrAll K_ON resource K_FROM username
            {
            match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokeStatement2895); 
            pushFollow(FOLLOW_permissionOrAll_in_revokeStatement2907);
            permissionOrAll4=permissionOrAll();

            state._fsp--;

            match(input,K_ON,FOLLOW_K_ON_in_revokeStatement2915); 
            pushFollow(FOLLOW_resource_in_revokeStatement2927);
            resource5=resource();

            state._fsp--;

            match(input,K_FROM,FOLLOW_K_FROM_in_revokeStatement2935); 
            pushFollow(FOLLOW_username_in_revokeStatement2947);
            username6=username();

            state._fsp--;

             stmt = new RevokeStatement(permissionOrAll4, resource5, (username6!=null?input.toString(username6.start,username6.stop):null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "revokeStatement"


    // $ANTLR start "listPermissionsStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:559:1: listPermissionsStatement returns [ListPermissionsStatement stmt] : K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )? ;
    public final ListPermissionsStatement listPermissionsStatement() throws RecognitionException {
        ListPermissionsStatement stmt = null;

        IResource resource7 = null;

        CqlParser.username_return username8 = null;

        Set<Permission> permissionOrAll9 = null;



                IResource resource = null;
                String username = null;
                boolean recursive = true;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:565:5: ( K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:565:7: K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )?
            {
            match(input,K_LIST,FOLLOW_K_LIST_in_listPermissionsStatement2985); 
            pushFollow(FOLLOW_permissionOrAll_in_listPermissionsStatement2997);
            permissionOrAll9=permissionOrAll();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:567:7: ( K_ON resource )?
            int alt54=2;
            int LA54_0 = input.LA(1);

            if ( (LA54_0==K_ON) ) {
                alt54=1;
            }
            switch (alt54) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:567:9: K_ON resource
                    {
                    match(input,K_ON,FOLLOW_K_ON_in_listPermissionsStatement3007); 
                    pushFollow(FOLLOW_resource_in_listPermissionsStatement3009);
                    resource7=resource();

                    state._fsp--;

                     resource = resource7; 

                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:568:7: ( K_OF username )?
            int alt55=2;
            int LA55_0 = input.LA(1);

            if ( (LA55_0==K_OF) ) {
                alt55=1;
            }
            switch (alt55) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:568:9: K_OF username
                    {
                    match(input,K_OF,FOLLOW_K_OF_in_listPermissionsStatement3024); 
                    pushFollow(FOLLOW_username_in_listPermissionsStatement3026);
                    username8=username();

                    state._fsp--;

                     username = (username8!=null?input.toString(username8.start,username8.stop):null); 

                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:569:7: ( K_NORECURSIVE )?
            int alt56=2;
            int LA56_0 = input.LA(1);

            if ( (LA56_0==K_NORECURSIVE) ) {
                alt56=1;
            }
            switch (alt56) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:569:9: K_NORECURSIVE
                    {
                    match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listPermissionsStatement3041); 
                     recursive = false; 

                    }
                    break;

            }

             stmt = new ListPermissionsStatement(permissionOrAll9, resource, username, recursive); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "listPermissionsStatement"


    // $ANTLR start "permission"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:573:1: permission returns [Permission perm] : p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE ) ;
    public final Permission permission() throws RecognitionException {
        Permission perm = null;

        Token p=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:5: (p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:7: p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE )
            {
            p=(Token)input.LT(1);
            if ( input.LA(1)==K_SELECT||input.LA(1)==K_CREATE||input.LA(1)==K_ALTER||input.LA(1)==K_DROP||(input.LA(1)>=K_MODIFY && input.LA(1)<=K_AUTHORIZE) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             perm = Permission.valueOf((p!=null?p.getText():null).toUpperCase()); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return perm;
    }
    // $ANTLR end "permission"


    // $ANTLR start "permissionOrAll"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:578:1: permissionOrAll returns [Set<Permission> perms] : ( K_ALL ( K_PERMISSIONS )? | p= permission ( K_PERMISSION )? );
    public final Set<Permission> permissionOrAll() throws RecognitionException {
        Set<Permission> perms = null;

        Permission p = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:579:5: ( K_ALL ( K_PERMISSIONS )? | p= permission ( K_PERMISSION )? )
            int alt59=2;
            int LA59_0 = input.LA(1);

            if ( (LA59_0==K_ALL) ) {
                alt59=1;
            }
            else if ( (LA59_0==K_SELECT||LA59_0==K_CREATE||LA59_0==K_ALTER||LA59_0==K_DROP||(LA59_0>=K_MODIFY && LA59_0<=K_AUTHORIZE)) ) {
                alt59=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 59, 0, input);

                throw nvae;
            }
            switch (alt59) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:579:7: K_ALL ( K_PERMISSIONS )?
                    {
                    match(input,K_ALL,FOLLOW_K_ALL_in_permissionOrAll3126); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:579:13: ( K_PERMISSIONS )?
                    int alt57=2;
                    int LA57_0 = input.LA(1);

                    if ( (LA57_0==K_PERMISSIONS) ) {
                        alt57=1;
                    }
                    switch (alt57) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:579:15: K_PERMISSIONS
                            {
                            match(input,K_PERMISSIONS,FOLLOW_K_PERMISSIONS_in_permissionOrAll3130); 

                            }
                            break;

                    }

                     perms = Permission.ALL_DATA; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:580:7: p= permission ( K_PERMISSION )?
                    {
                    pushFollow(FOLLOW_permission_in_permissionOrAll3151);
                    p=permission();

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:580:20: ( K_PERMISSION )?
                    int alt58=2;
                    int LA58_0 = input.LA(1);

                    if ( (LA58_0==K_PERMISSION) ) {
                        alt58=1;
                    }
                    switch (alt58) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:580:22: K_PERMISSION
                            {
                            match(input,K_PERMISSION,FOLLOW_K_PERMISSION_in_permissionOrAll3155); 

                            }
                            break;

                    }

                     perms = EnumSet.of(p); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return perms;
    }
    // $ANTLR end "permissionOrAll"


    // $ANTLR start "resource"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:583:1: resource returns [IResource res] : r= dataResource ;
    public final IResource resource() throws RecognitionException {
        IResource res = null;

        DataResource r = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:584:5: (r= dataResource )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:584:7: r= dataResource
            {
            pushFollow(FOLLOW_dataResource_in_resource3183);
            r=dataResource();

            state._fsp--;

             res = r; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return res;
    }
    // $ANTLR end "resource"


    // $ANTLR start "dataResource"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:587:1: dataResource returns [DataResource res] : ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName );
    public final DataResource dataResource() throws RecognitionException {
        DataResource res = null;

        String ks = null;

        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:588:5: ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName )
            int alt61=3;
            switch ( input.LA(1) ) {
            case K_ALL:
                {
                int LA61_1 = input.LA(2);

                if ( (LA61_1==K_KEYSPACES) ) {
                    alt61=1;
                }
                else if ( (LA61_1==EOF||LA61_1==K_FROM||LA61_1==K_TO||(LA61_1>=K_OF && LA61_1<=K_NORECURSIVE)||LA61_1==127||LA61_1==134) ) {
                    alt61=3;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 61, 1, input);

                    throw nvae;
                }
                }
                break;
            case K_KEYSPACE:
                {
                alt61=2;
                }
                break;
            case K_COUNT:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_COLUMNFAMILY:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_CUSTOM:
            case IDENT:
            case K_TYPE:
            case K_LIST:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case QUOTED_NAME:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt61=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 61, 0, input);

                throw nvae;
            }

            switch (alt61) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:588:7: K_ALL K_KEYSPACES
                    {
                    match(input,K_ALL,FOLLOW_K_ALL_in_dataResource3206); 
                    match(input,K_KEYSPACES,FOLLOW_K_KEYSPACES_in_dataResource3208); 
                     res = DataResource.root(); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:589:7: K_KEYSPACE ks= keyspaceName
                    {
                    match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dataResource3218); 
                    pushFollow(FOLLOW_keyspaceName_in_dataResource3224);
                    ks=keyspaceName();

                    state._fsp--;

                     res = DataResource.keyspace(ks); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:7: ( K_COLUMNFAMILY )? cf= columnFamilyName
                    {
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:7: ( K_COLUMNFAMILY )?
                    int alt60=2;
                    int LA60_0 = input.LA(1);

                    if ( (LA60_0==K_COLUMNFAMILY) ) {
                        alt60=1;
                    }
                    switch (alt60) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:9: K_COLUMNFAMILY
                            {
                            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dataResource3236); 

                            }
                            break;

                    }

                    pushFollow(FOLLOW_columnFamilyName_in_dataResource3245);
                    cf=columnFamilyName();

                    state._fsp--;

                     res = DataResource.columnFamily(cf.getKeyspace(), cf.getColumnFamily()); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return res;
    }
    // $ANTLR end "dataResource"


    // $ANTLR start "createUserStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:594:1: createUserStatement returns [CreateUserStatement stmt] : K_CREATE K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
    public final CreateUserStatement createUserStatement() throws RecognitionException {
        CreateUserStatement stmt = null;

        CqlParser.username_return username10 = null;



                UserOptions opts = new UserOptions();
                boolean superuser = false;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:602:5: ( K_CREATE K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:602:7: K_CREATE K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createUserStatement3285); 
            match(input,K_USER,FOLLOW_K_USER_in_createUserStatement3287); 
            pushFollow(FOLLOW_username_in_createUserStatement3289);
            username10=username();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:603:7: ( K_WITH userOptions[opts] )?
            int alt62=2;
            int LA62_0 = input.LA(1);

            if ( (LA62_0==K_WITH) ) {
                alt62=1;
            }
            switch (alt62) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:603:9: K_WITH userOptions[opts]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_createUserStatement3299); 
                    pushFollow(FOLLOW_userOptions_in_createUserStatement3301);
                    userOptions(opts);

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:604:7: ( K_SUPERUSER | K_NOSUPERUSER )?
            int alt63=3;
            int LA63_0 = input.LA(1);

            if ( (LA63_0==K_SUPERUSER) ) {
                alt63=1;
            }
            else if ( (LA63_0==K_NOSUPERUSER) ) {
                alt63=2;
            }
            switch (alt63) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:604:9: K_SUPERUSER
                    {
                    match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_createUserStatement3315); 
                     superuser = true; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:604:45: K_NOSUPERUSER
                    {
                    match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_createUserStatement3321); 
                     superuser = false; 

                    }
                    break;

            }

             stmt = new CreateUserStatement((username10!=null?input.toString(username10.start,username10.stop):null), opts, superuser); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "createUserStatement"


    // $ANTLR start "alterUserStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:608:1: alterUserStatement returns [AlterUserStatement stmt] : K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
    public final AlterUserStatement alterUserStatement() throws RecognitionException {
        AlterUserStatement stmt = null;

        CqlParser.username_return username11 = null;



                UserOptions opts = new UserOptions();
                Boolean superuser = null;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:616:5: ( K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:616:7: K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterUserStatement3366); 
            match(input,K_USER,FOLLOW_K_USER_in_alterUserStatement3368); 
            pushFollow(FOLLOW_username_in_alterUserStatement3370);
            username11=username();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:617:7: ( K_WITH userOptions[opts] )?
            int alt64=2;
            int LA64_0 = input.LA(1);

            if ( (LA64_0==K_WITH) ) {
                alt64=1;
            }
            switch (alt64) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:617:9: K_WITH userOptions[opts]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_alterUserStatement3380); 
                    pushFollow(FOLLOW_userOptions_in_alterUserStatement3382);
                    userOptions(opts);

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:618:7: ( K_SUPERUSER | K_NOSUPERUSER )?
            int alt65=3;
            int LA65_0 = input.LA(1);

            if ( (LA65_0==K_SUPERUSER) ) {
                alt65=1;
            }
            else if ( (LA65_0==K_NOSUPERUSER) ) {
                alt65=2;
            }
            switch (alt65) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:618:9: K_SUPERUSER
                    {
                    match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_alterUserStatement3396); 
                     superuser = true; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:618:45: K_NOSUPERUSER
                    {
                    match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_alterUserStatement3402); 
                     superuser = false; 

                    }
                    break;

            }

             stmt = new AlterUserStatement((username11!=null?input.toString(username11.start,username11.stop):null), opts, superuser); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "alterUserStatement"


    // $ANTLR start "dropUserStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:622:1: dropUserStatement returns [DropUserStatement stmt] : K_DROP K_USER username ;
    public final DropUserStatement dropUserStatement() throws RecognitionException {
        DropUserStatement stmt = null;

        CqlParser.username_return username12 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:626:5: ( K_DROP K_USER username )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:626:7: K_DROP K_USER username
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropUserStatement3438); 
            match(input,K_USER,FOLLOW_K_USER_in_dropUserStatement3440); 
            pushFollow(FOLLOW_username_in_dropUserStatement3442);
            username12=username();

            state._fsp--;

             stmt = new DropUserStatement((username12!=null?input.toString(username12.start,username12.stop):null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "dropUserStatement"


    // $ANTLR start "listUsersStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:629:1: listUsersStatement returns [ListUsersStatement stmt] : K_LIST K_USERS ;
    public final ListUsersStatement listUsersStatement() throws RecognitionException {
        ListUsersStatement stmt = null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:633:5: ( K_LIST K_USERS )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:633:7: K_LIST K_USERS
            {
            match(input,K_LIST,FOLLOW_K_LIST_in_listUsersStatement3467); 
            match(input,K_USERS,FOLLOW_K_USERS_in_listUsersStatement3469); 
             stmt = new ListUsersStatement(); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "listUsersStatement"


    // $ANTLR start "userOptions"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:636:1: userOptions[UserOptions opts] : userOption[opts] ;
    public final void userOptions(UserOptions opts) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:637:5: ( userOption[opts] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:637:7: userOption[opts]
            {
            pushFollow(FOLLOW_userOption_in_userOptions3489);
            userOption(opts);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "userOptions"


    // $ANTLR start "userOption"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:640:1: userOption[UserOptions opts] : k= K_PASSWORD v= STRING_LITERAL ;
    public final void userOption(UserOptions opts) throws RecognitionException {
        Token k=null;
        Token v=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:641:5: (k= K_PASSWORD v= STRING_LITERAL )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:641:7: k= K_PASSWORD v= STRING_LITERAL
            {
            k=(Token)match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_userOption3510); 
            v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_userOption3514); 
             opts.put((k!=null?k.getText():null), (v!=null?v.getText():null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "userOption"


    // $ANTLR start "cident"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:644:1: cident returns [ColumnIdentifier id] : (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword );
    public final ColumnIdentifier cident() throws RecognitionException {
        ColumnIdentifier id = null;

        Token t=null;
        String k = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:648:5: (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword )
            int alt66=3;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt66=1;
                }
                break;
            case QUOTED_NAME:
                {
                alt66=2;
                }
                break;
            case K_COUNT:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_CUSTOM:
            case K_TYPE:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt66=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 66, 0, input);

                throw nvae;
            }

            switch (alt66) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:648:7: t= IDENT
                    {
                    t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cident3543); 
                     id = new ColumnIdentifier((t!=null?t.getText():null), false); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:649:7: t= QUOTED_NAME
                    {
                    t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cident3568); 
                     id = new ColumnIdentifier((t!=null?t.getText():null), true); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:650:7: k= unreserved_keyword
                    {
                    pushFollow(FOLLOW_unreserved_keyword_in_cident3587);
                    k=unreserved_keyword();

                    state._fsp--;

                     id = new ColumnIdentifier(k, false); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return id;
    }
    // $ANTLR end "cident"


    // $ANTLR start "keyspaceName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:654:1: keyspaceName returns [String id] : cfOrKsName[name, true] ;
    public final String keyspaceName() throws RecognitionException {
        String id = null;

         CFName name = new CFName(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:656:5: ( cfOrKsName[name, true] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:656:7: cfOrKsName[name, true]
            {
            pushFollow(FOLLOW_cfOrKsName_in_keyspaceName3620);
            cfOrKsName(name, true);

            state._fsp--;

             id = name.getKeyspace(); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return id;
    }
    // $ANTLR end "keyspaceName"


    // $ANTLR start "columnFamilyName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:659:1: columnFamilyName returns [CFName name] : ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false] ;
    public final CFName columnFamilyName() throws RecognitionException {
        CFName name = null;

         name = new CFName(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:661:5: ( ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:661:7: ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false]
            {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:661:7: ( cfOrKsName[name, true] '.' )?
            int alt67=2;
            alt67 = dfa67.predict(input);
            switch (alt67) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:661:8: cfOrKsName[name, true] '.'
                    {
                    pushFollow(FOLLOW_cfOrKsName_in_columnFamilyName3654);
                    cfOrKsName(name, true);

                    state._fsp--;

                    match(input,134,FOLLOW_134_in_columnFamilyName3657); 

                    }
                    break;

            }

            pushFollow(FOLLOW_cfOrKsName_in_columnFamilyName3661);
            cfOrKsName(name, false);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return name;
    }
    // $ANTLR end "columnFamilyName"


    // $ANTLR start "cfOrKsName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:664:1: cfOrKsName[CFName name, boolean isKs] : (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword );
    public final void cfOrKsName(CFName name, boolean isKs) throws RecognitionException {
        Token t=null;
        String k = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:5: (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword )
            int alt68=3;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt68=1;
                }
                break;
            case QUOTED_NAME:
                {
                alt68=2;
                }
                break;
            case K_COUNT:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_CUSTOM:
            case K_TYPE:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt68=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 68, 0, input);

                throw nvae;
            }

            switch (alt68) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:7: t= IDENT
                    {
                    t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cfOrKsName3682); 
                     if (isKs) name.setKeyspace((t!=null?t.getText():null), false); else name.setColumnFamily((t!=null?t.getText():null), false); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:666:7: t= QUOTED_NAME
                    {
                    t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cfOrKsName3707); 
                     if (isKs) name.setKeyspace((t!=null?t.getText():null), true); else name.setColumnFamily((t!=null?t.getText():null), true); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:667:7: k= unreserved_keyword
                    {
                    pushFollow(FOLLOW_unreserved_keyword_in_cfOrKsName3726);
                    k=unreserved_keyword();

                    state._fsp--;

                     if (isKs) name.setKeyspace(k, false); else name.setColumnFamily(k, false); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfOrKsName"


    // $ANTLR start "constant"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:1: constant returns [Constants.Literal constant] : (t= STRING_LITERAL | t= INTEGER | t= FLOAT | t= BOOLEAN | t= UUID | t= HEXNUMBER );
    public final Constants.Literal constant() throws RecognitionException {
        Constants.Literal constant = null;

        Token t=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:5: (t= STRING_LITERAL | t= INTEGER | t= FLOAT | t= BOOLEAN | t= UUID | t= HEXNUMBER )
            int alt69=6;
            switch ( input.LA(1) ) {
            case STRING_LITERAL:
                {
                alt69=1;
                }
                break;
            case INTEGER:
                {
                alt69=2;
                }
                break;
            case FLOAT:
                {
                alt69=3;
                }
                break;
            case BOOLEAN:
                {
                alt69=4;
                }
                break;
            case UUID:
                {
                alt69=5;
                }
                break;
            case HEXNUMBER:
                {
                alt69=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 69, 0, input);

                throw nvae;
            }

            switch (alt69) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:7: t= STRING_LITERAL
                    {
                    t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_constant3751); 
                     constant = Constants.Literal.string((t!=null?t.getText():null)); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:672:7: t= INTEGER
                    {
                    t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_constant3763); 
                     constant = Constants.Literal.integer((t!=null?t.getText():null)); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:673:7: t= FLOAT
                    {
                    t=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_constant3782); 
                     constant = Constants.Literal.floatingPoint((t!=null?t.getText():null)); 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:674:7: t= BOOLEAN
                    {
                    t=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_constant3803); 
                     constant = Constants.Literal.bool((t!=null?t.getText():null)); 

                    }
                    break;
                case 5 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:675:7: t= UUID
                    {
                    t=(Token)match(input,UUID,FOLLOW_UUID_in_constant3822); 
                     constant = Constants.Literal.uuid((t!=null?t.getText():null)); 

                    }
                    break;
                case 6 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:676:7: t= HEXNUMBER
                    {
                    t=(Token)match(input,HEXNUMBER,FOLLOW_HEXNUMBER_in_constant3844); 
                     constant = Constants.Literal.hex((t!=null?t.getText():null)); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return constant;
    }
    // $ANTLR end "constant"


    // $ANTLR start "set_tail"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:679:1: set_tail[List<Term.Raw> s] : ( '}' | ',' t= term set_tail[s] );
    public final void set_tail(List<Term.Raw> s) throws RecognitionException {
        Term.Raw t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:680:5: ( '}' | ',' t= term set_tail[s] )
            int alt70=2;
            int LA70_0 = input.LA(1);

            if ( (LA70_0==135) ) {
                alt70=1;
            }
            else if ( (LA70_0==130) ) {
                alt70=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 70, 0, input);

                throw nvae;
            }
            switch (alt70) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:680:7: '}'
                    {
                    match(input,135,FOLLOW_135_in_set_tail3869); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:681:7: ',' t= term set_tail[s]
                    {
                    match(input,130,FOLLOW_130_in_set_tail3877); 
                    pushFollow(FOLLOW_term_in_set_tail3881);
                    t=term();

                    state._fsp--;

                     s.add(t); 
                    pushFollow(FOLLOW_set_tail_in_set_tail3885);
                    set_tail(s);

                    state._fsp--;


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "set_tail"


    // $ANTLR start "map_tail"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:684:1: map_tail[List<Pair<Term.Raw, Term.Raw>> m] : ( '}' | ',' k= term ':' v= term map_tail[m] );
    public final void map_tail(List<Pair<Term.Raw, Term.Raw>> m) throws RecognitionException {
        Term.Raw k = null;

        Term.Raw v = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:685:5: ( '}' | ',' k= term ':' v= term map_tail[m] )
            int alt71=2;
            int LA71_0 = input.LA(1);

            if ( (LA71_0==135) ) {
                alt71=1;
            }
            else if ( (LA71_0==130) ) {
                alt71=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 71, 0, input);

                throw nvae;
            }
            switch (alt71) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:685:7: '}'
                    {
                    match(input,135,FOLLOW_135_in_map_tail3904); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:686:7: ',' k= term ':' v= term map_tail[m]
                    {
                    match(input,130,FOLLOW_130_in_map_tail3912); 
                    pushFollow(FOLLOW_term_in_map_tail3916);
                    k=term();

                    state._fsp--;

                    match(input,136,FOLLOW_136_in_map_tail3918); 
                    pushFollow(FOLLOW_term_in_map_tail3922);
                    v=term();

                    state._fsp--;

                     m.add(Pair.create(k, v)); 
                    pushFollow(FOLLOW_map_tail_in_map_tail3926);
                    map_tail(m);

                    state._fsp--;


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "map_tail"


    // $ANTLR start "map_literal"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:689:1: map_literal returns [Maps.Literal map] : ( '{' '}' | '{' k1= term ':' v1= term map_tail[m] );
    public final Maps.Literal map_literal() throws RecognitionException {
        Maps.Literal map = null;

        Term.Raw k1 = null;

        Term.Raw v1 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:690:5: ( '{' '}' | '{' k1= term ':' v1= term map_tail[m] )
            int alt72=2;
            int LA72_0 = input.LA(1);

            if ( (LA72_0==137) ) {
                int LA72_1 = input.LA(2);

                if ( (LA72_1==135) ) {
                    alt72=1;
                }
                else if ( (LA72_1==INTEGER||LA72_1==K_FILTERING||LA72_1==K_VALUES||LA72_1==K_TIMESTAMP||LA72_1==K_COUNTER||(LA72_1>=K_KEY && LA72_1<=K_CUSTOM)||LA72_1==IDENT||LA72_1==K_TYPE||LA72_1==K_LIST||(LA72_1>=K_ALL && LA72_1<=STRING_LITERAL)||(LA72_1>=FLOAT && LA72_1<=K_TOKEN)||(LA72_1>=K_ASCII && LA72_1<=K_MAP)||LA72_1==128||LA72_1==132||LA72_1==137) ) {
                    alt72=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 72, 1, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 72, 0, input);

                throw nvae;
            }
            switch (alt72) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:690:7: '{' '}'
                    {
                    match(input,137,FOLLOW_137_in_map_literal3948); 
                    match(input,135,FOLLOW_135_in_map_literal3950); 
                     map = new Maps.Literal(Collections.<Pair<Term.Raw, Term.Raw>>emptyList()); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:691:7: '{' k1= term ':' v1= term map_tail[m]
                    {
                    match(input,137,FOLLOW_137_in_map_literal3960); 
                     List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); 
                    pushFollow(FOLLOW_term_in_map_literal3976);
                    k1=term();

                    state._fsp--;

                    match(input,136,FOLLOW_136_in_map_literal3978); 
                    pushFollow(FOLLOW_term_in_map_literal3982);
                    v1=term();

                    state._fsp--;

                     m.add(Pair.create(k1, v1)); 
                    pushFollow(FOLLOW_map_tail_in_map_literal3986);
                    map_tail(m);

                    state._fsp--;

                     map = new Maps.Literal(m); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return map;
    }
    // $ANTLR end "map_literal"


    // $ANTLR start "set_or_map"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:696:1: set_or_map[Term.Raw t] returns [Term.Raw value] : ( ':' v= term map_tail[m] | set_tail[s] );
    public final Term.Raw set_or_map(Term.Raw t) throws RecognitionException {
        Term.Raw value = null;

        Term.Raw v = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:697:5: ( ':' v= term map_tail[m] | set_tail[s] )
            int alt73=2;
            int LA73_0 = input.LA(1);

            if ( (LA73_0==136) ) {
                alt73=1;
            }
            else if ( (LA73_0==130||LA73_0==135) ) {
                alt73=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 73, 0, input);

                throw nvae;
            }
            switch (alt73) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:697:7: ':' v= term map_tail[m]
                    {
                    match(input,136,FOLLOW_136_in_set_or_map4018); 
                    pushFollow(FOLLOW_term_in_set_or_map4022);
                    v=term();

                    state._fsp--;

                     List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); m.add(Pair.create(t, v)); 
                    pushFollow(FOLLOW_map_tail_in_set_or_map4026);
                    map_tail(m);

                    state._fsp--;

                     value = new Maps.Literal(m); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:698:7: set_tail[s]
                    {
                     List<Term.Raw> s = new ArrayList<Term.Raw>(); s.add(t); 
                    pushFollow(FOLLOW_set_tail_in_set_or_map4039);
                    set_tail(s);

                    state._fsp--;

                     value = new Sets.Literal(s); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "set_or_map"


    // $ANTLR start "collection_literal"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:702:1: collection_literal returns [Term.Raw value] : ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= set_or_map[t] | '{' '}' );
    public final Term.Raw collection_literal() throws RecognitionException {
        Term.Raw value = null;

        Term.Raw t1 = null;

        Term.Raw tn = null;

        Term.Raw t = null;

        Term.Raw v = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:5: ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= set_or_map[t] | '{' '}' )
            int alt76=3;
            int LA76_0 = input.LA(1);

            if ( (LA76_0==132) ) {
                alt76=1;
            }
            else if ( (LA76_0==137) ) {
                int LA76_2 = input.LA(2);

                if ( (LA76_2==135) ) {
                    alt76=3;
                }
                else if ( (LA76_2==INTEGER||LA76_2==K_FILTERING||LA76_2==K_VALUES||LA76_2==K_TIMESTAMP||LA76_2==K_COUNTER||(LA76_2>=K_KEY && LA76_2<=K_CUSTOM)||LA76_2==IDENT||LA76_2==K_TYPE||LA76_2==K_LIST||(LA76_2>=K_ALL && LA76_2<=STRING_LITERAL)||(LA76_2>=FLOAT && LA76_2<=K_TOKEN)||(LA76_2>=K_ASCII && LA76_2<=K_MAP)||LA76_2==128||LA76_2==132||LA76_2==137) ) {
                    alt76=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 76, 2, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 76, 0, input);

                throw nvae;
            }
            switch (alt76) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:7: '[' (t1= term ( ',' tn= term )* )? ']'
                    {
                    match(input,132,FOLLOW_132_in_collection_literal4064); 
                     List<Term.Raw> l = new ArrayList<Term.Raw>(); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:61: (t1= term ( ',' tn= term )* )?
                    int alt75=2;
                    int LA75_0 = input.LA(1);

                    if ( (LA75_0==INTEGER||LA75_0==K_FILTERING||LA75_0==K_VALUES||LA75_0==K_TIMESTAMP||LA75_0==K_COUNTER||(LA75_0>=K_KEY && LA75_0<=K_CUSTOM)||LA75_0==IDENT||LA75_0==K_TYPE||LA75_0==K_LIST||(LA75_0>=K_ALL && LA75_0<=STRING_LITERAL)||(LA75_0>=FLOAT && LA75_0<=K_TOKEN)||(LA75_0>=K_ASCII && LA75_0<=K_MAP)||LA75_0==128||LA75_0==132||LA75_0==137) ) {
                        alt75=1;
                    }
                    switch (alt75) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:63: t1= term ( ',' tn= term )*
                            {
                            pushFollow(FOLLOW_term_in_collection_literal4072);
                            t1=term();

                            state._fsp--;

                             l.add(t1); 
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:86: ( ',' tn= term )*
                            loop74:
                            do {
                                int alt74=2;
                                int LA74_0 = input.LA(1);

                                if ( (LA74_0==130) ) {
                                    alt74=1;
                                }


                                switch (alt74) {
                            	case 1 :
                            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:88: ',' tn= term
                            	    {
                            	    match(input,130,FOLLOW_130_in_collection_literal4078); 
                            	    pushFollow(FOLLOW_term_in_collection_literal4082);
                            	    tn=term();

                            	    state._fsp--;

                            	     l.add(tn); 

                            	    }
                            	    break;

                            	default :
                            	    break loop74;
                                }
                            } while (true);


                            }
                            break;

                    }

                    match(input,133,FOLLOW_133_in_collection_literal4092); 
                     value = new Lists.Literal(l); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:704:7: '{' t= term v= set_or_map[t]
                    {
                    match(input,137,FOLLOW_137_in_collection_literal4102); 
                    pushFollow(FOLLOW_term_in_collection_literal4106);
                    t=term();

                    state._fsp--;

                    pushFollow(FOLLOW_set_or_map_in_collection_literal4110);
                    v=set_or_map(t);

                    state._fsp--;

                     value = v; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:706:7: '{' '}'
                    {
                    match(input,137,FOLLOW_137_in_collection_literal4126); 
                    match(input,135,FOLLOW_135_in_collection_literal4128); 
                     value = new Sets.Literal(Collections.<Term.Raw>emptyList()); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "collection_literal"


    // $ANTLR start "value"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:709:1: value returns [Term.Raw value] : (c= constant | l= collection_literal | K_NULL | QMARK );
    public final Term.Raw value() throws RecognitionException {
        Term.Raw value = null;

        Constants.Literal c = null;

        Term.Raw l = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:710:5: (c= constant | l= collection_literal | K_NULL | QMARK )
            int alt77=4;
            switch ( input.LA(1) ) {
            case INTEGER:
            case STRING_LITERAL:
            case FLOAT:
            case BOOLEAN:
            case UUID:
            case HEXNUMBER:
                {
                alt77=1;
                }
                break;
            case 132:
            case 137:
                {
                alt77=2;
                }
                break;
            case K_NULL:
                {
                alt77=3;
                }
                break;
            case QMARK:
                {
                alt77=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 77, 0, input);

                throw nvae;
            }

            switch (alt77) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:710:7: c= constant
                    {
                    pushFollow(FOLLOW_constant_in_value4153);
                    c=constant();

                    state._fsp--;

                     value = c; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:711:7: l= collection_literal
                    {
                    pushFollow(FOLLOW_collection_literal_in_value4175);
                    l=collection_literal();

                    state._fsp--;

                     value = l; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:712:7: K_NULL
                    {
                    match(input,K_NULL,FOLLOW_K_NULL_in_value4185); 
                     value = Constants.NULL_LITERAL; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:713:7: QMARK
                    {
                    match(input,QMARK,FOLLOW_QMARK_in_value4209); 
                     value = new AbstractMarker.Raw(++currentBindMarkerIdx); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "value"


    // $ANTLR start "functionName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:716:1: functionName returns [String s] : (f= IDENT | u= unreserved_function_keyword | K_TOKEN );
    public final String functionName() throws RecognitionException {
        String s = null;

        Token f=null;
        String u = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:717:5: (f= IDENT | u= unreserved_function_keyword | K_TOKEN )
            int alt78=3;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt78=1;
                }
                break;
            case K_FILTERING:
            case K_VALUES:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_CUSTOM:
            case K_TYPE:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt78=2;
                }
                break;
            case K_TOKEN:
                {
                alt78=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 78, 0, input);

                throw nvae;
            }

            switch (alt78) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:717:7: f= IDENT
                    {
                    f=(Token)match(input,IDENT,FOLLOW_IDENT_in_functionName4249); 
                     s = (f!=null?f.getText():null); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:718:7: u= unreserved_function_keyword
                    {
                    pushFollow(FOLLOW_unreserved_function_keyword_in_functionName4283);
                    u=unreserved_function_keyword();

                    state._fsp--;

                     s = u; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:719:7: K_TOKEN
                    {
                    match(input,K_TOKEN,FOLLOW_K_TOKEN_in_functionName4293); 
                     s = "token"; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return s;
    }
    // $ANTLR end "functionName"


    // $ANTLR start "functionArgs"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:722:1: functionArgs returns [List<Term.Raw> a] : ( '(' ')' | '(' t1= term ( ',' tn= term )* ')' );
    public final List<Term.Raw> functionArgs() throws RecognitionException {
        List<Term.Raw> a = null;

        Term.Raw t1 = null;

        Term.Raw tn = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:723:5: ( '(' ')' | '(' t1= term ( ',' tn= term )* ')' )
            int alt80=2;
            int LA80_0 = input.LA(1);

            if ( (LA80_0==128) ) {
                int LA80_1 = input.LA(2);

                if ( (LA80_1==129) ) {
                    alt80=1;
                }
                else if ( (LA80_1==INTEGER||LA80_1==K_FILTERING||LA80_1==K_VALUES||LA80_1==K_TIMESTAMP||LA80_1==K_COUNTER||(LA80_1>=K_KEY && LA80_1<=K_CUSTOM)||LA80_1==IDENT||LA80_1==K_TYPE||LA80_1==K_LIST||(LA80_1>=K_ALL && LA80_1<=STRING_LITERAL)||(LA80_1>=FLOAT && LA80_1<=K_TOKEN)||(LA80_1>=K_ASCII && LA80_1<=K_MAP)||LA80_1==128||LA80_1==132||LA80_1==137) ) {
                    alt80=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 80, 1, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 80, 0, input);

                throw nvae;
            }
            switch (alt80) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:723:7: '(' ')'
                    {
                    match(input,128,FOLLOW_128_in_functionArgs4338); 
                    match(input,129,FOLLOW_129_in_functionArgs4340); 
                     a = Collections.emptyList(); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:724:7: '(' t1= term ( ',' tn= term )* ')'
                    {
                    match(input,128,FOLLOW_128_in_functionArgs4350); 
                    pushFollow(FOLLOW_term_in_functionArgs4354);
                    t1=term();

                    state._fsp--;

                     List<Term.Raw> args = new ArrayList<Term.Raw>(); args.add(t1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:725:11: ( ',' tn= term )*
                    loop79:
                    do {
                        int alt79=2;
                        int LA79_0 = input.LA(1);

                        if ( (LA79_0==130) ) {
                            alt79=1;
                        }


                        switch (alt79) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:725:13: ',' tn= term
                    	    {
                    	    match(input,130,FOLLOW_130_in_functionArgs4370); 
                    	    pushFollow(FOLLOW_term_in_functionArgs4374);
                    	    tn=term();

                    	    state._fsp--;

                    	     args.add(tn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop79;
                        }
                    } while (true);

                    match(input,129,FOLLOW_129_in_functionArgs4388); 
                     a = args; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return a;
    }
    // $ANTLR end "functionArgs"


    // $ANTLR start "term"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:729:1: term returns [Term.Raw term] : (v= value | f= functionName args= functionArgs | '(' c= comparatorType ')' t= term );
    public final Term.Raw term() throws RecognitionException {
        Term.Raw term = null;

        Term.Raw v = null;

        String f = null;

        List<Term.Raw> args = null;

        CQL3Type c = null;

        Term.Raw t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:730:5: (v= value | f= functionName args= functionArgs | '(' c= comparatorType ')' t= term )
            int alt81=3;
            switch ( input.LA(1) ) {
            case INTEGER:
            case STRING_LITERAL:
            case FLOAT:
            case BOOLEAN:
            case UUID:
            case HEXNUMBER:
            case K_NULL:
            case QMARK:
            case 132:
            case 137:
                {
                alt81=1;
                }
                break;
            case K_FILTERING:
            case K_VALUES:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_CUSTOM:
            case IDENT:
            case K_TYPE:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_TOKEN:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt81=2;
                }
                break;
            case 128:
                {
                alt81=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 81, 0, input);

                throw nvae;
            }

            switch (alt81) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:730:7: v= value
                    {
                    pushFollow(FOLLOW_value_in_term4413);
                    v=value();

                    state._fsp--;

                     term = v; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:731:7: f= functionName args= functionArgs
                    {
                    pushFollow(FOLLOW_functionName_in_term4450);
                    f=functionName();

                    state._fsp--;

                    pushFollow(FOLLOW_functionArgs_in_term4454);
                    args=functionArgs();

                    state._fsp--;

                     term = new FunctionCall.Raw(f, args); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:732:7: '(' c= comparatorType ')' t= term
                    {
                    match(input,128,FOLLOW_128_in_term4464); 
                    pushFollow(FOLLOW_comparatorType_in_term4468);
                    c=comparatorType();

                    state._fsp--;

                    match(input,129,FOLLOW_129_in_term4470); 
                    pushFollow(FOLLOW_term_in_term4474);
                    t=term();

                    state._fsp--;

                     term = new TypeCast(c, t); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return term;
    }
    // $ANTLR end "term"


    // $ANTLR start "columnOperation"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:735:1: columnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations] : (key= cident '=' t= term ( '+' c= cident )? | key= cident '=' c= cident sig= ( '+' | '-' ) t= term | key= cident '=' c= cident i= INTEGER | key= cident '[' k= term ']' '=' t= term );
    public final void columnOperation(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations) throws RecognitionException {
        Token sig=null;
        Token i=null;
        ColumnIdentifier key = null;

        Term.Raw t = null;

        ColumnIdentifier c = null;

        Term.Raw k = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:736:5: (key= cident '=' t= term ( '+' c= cident )? | key= cident '=' c= cident sig= ( '+' | '-' ) t= term | key= cident '=' c= cident i= INTEGER | key= cident '[' k= term ']' '=' t= term )
            int alt83=4;
            alt83 = dfa83.predict(input);
            switch (alt83) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:736:7: key= cident '=' t= term ( '+' c= cident )?
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation4497);
                    key=cident();

                    state._fsp--;

                    match(input,138,FOLLOW_138_in_columnOperation4499); 
                    pushFollow(FOLLOW_term_in_columnOperation4503);
                    t=term();

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:736:29: ( '+' c= cident )?
                    int alt82=2;
                    int LA82_0 = input.LA(1);

                    if ( (LA82_0==139) ) {
                        alt82=1;
                    }
                    switch (alt82) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:736:30: '+' c= cident
                            {
                            match(input,139,FOLLOW_139_in_columnOperation4506); 
                            pushFollow(FOLLOW_cident_in_columnOperation4510);
                            c=cident();

                            state._fsp--;


                            }
                            break;

                    }


                              if (c == null)
                              {
                                  addRawUpdate(operations, key, new Operation.SetValue(t));
                              }
                              else
                              {
                                  if (!key.equals(c))
                                      addRecognitionError("Only expressions of the form X = <value> + X are supported.");
                                  addRawUpdate(operations, key, new Operation.Prepend(t));
                              }
                          

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:749:7: key= cident '=' c= cident sig= ( '+' | '-' ) t= term
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation4531);
                    key=cident();

                    state._fsp--;

                    match(input,138,FOLLOW_138_in_columnOperation4533); 
                    pushFollow(FOLLOW_cident_in_columnOperation4537);
                    c=cident();

                    state._fsp--;

                    sig=(Token)input.LT(1);
                    if ( (input.LA(1)>=139 && input.LA(1)<=140) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    pushFollow(FOLLOW_term_in_columnOperation4551);
                    t=term();

                    state._fsp--;


                              if (!key.equals(c))
                                  addRecognitionError("Only expressions of the form X = X " + (sig!=null?sig.getText():null) + "<value> are supported.");
                              addRawUpdate(operations, key, (sig!=null?sig.getText():null).equals("+") ? new Operation.Addition(t) : new Operation.Substraction(t));
                          

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:755:7: key= cident '=' c= cident i= INTEGER
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation4569);
                    key=cident();

                    state._fsp--;

                    match(input,138,FOLLOW_138_in_columnOperation4571); 
                    pushFollow(FOLLOW_cident_in_columnOperation4575);
                    c=cident();

                    state._fsp--;

                    i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_columnOperation4579); 

                              // Note that this production *is* necessary because X = X - 3 will in fact be lexed as [ X, '=', X, INTEGER].
                              if (!key.equals(c))
                                  // We don't yet allow a '+' in front of an integer, but we could in the future really, so let's be future-proof in our error message
                                  addRecognitionError("Only expressions of the form X = X " + ((i!=null?i.getText():null).charAt(0) == '-' ? '-' : '+') + " <value> are supported.");
                              addRawUpdate(operations, key, new Operation.Addition(Constants.Literal.integer((i!=null?i.getText():null))));
                          

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:763:7: key= cident '[' k= term ']' '=' t= term
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation4597);
                    key=cident();

                    state._fsp--;

                    match(input,132,FOLLOW_132_in_columnOperation4599); 
                    pushFollow(FOLLOW_term_in_columnOperation4603);
                    k=term();

                    state._fsp--;

                    match(input,133,FOLLOW_133_in_columnOperation4605); 
                    match(input,138,FOLLOW_138_in_columnOperation4607); 
                    pushFollow(FOLLOW_term_in_columnOperation4611);
                    t=term();

                    state._fsp--;


                              addRawUpdate(operations, key, new Operation.SetElement(k, t));
                          

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "columnOperation"


    // $ANTLR start "properties"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:769:1: properties[PropertyDefinitions props] : property[props] ( K_AND property[props] )* ;
    public final void properties(PropertyDefinitions props) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:5: ( property[props] ( K_AND property[props] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:7: property[props] ( K_AND property[props] )*
            {
            pushFollow(FOLLOW_property_in_properties4637);
            property(props);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:23: ( K_AND property[props] )*
            loop84:
            do {
                int alt84=2;
                int LA84_0 = input.LA(1);

                if ( (LA84_0==K_AND) ) {
                    alt84=1;
                }


                switch (alt84) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:24: K_AND property[props]
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_properties4641); 
            	    pushFollow(FOLLOW_property_in_properties4643);
            	    property(props);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop84;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "properties"


    // $ANTLR start "property"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:773:1: property[PropertyDefinitions props] : k= cident '=' (simple= propertyValue | map= map_literal ) ;
    public final void property(PropertyDefinitions props) throws RecognitionException {
        ColumnIdentifier k = null;

        String simple = null;

        Maps.Literal map = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:774:5: (k= cident '=' (simple= propertyValue | map= map_literal ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:774:7: k= cident '=' (simple= propertyValue | map= map_literal )
            {
            pushFollow(FOLLOW_cident_in_property4666);
            k=cident();

            state._fsp--;

            match(input,138,FOLLOW_138_in_property4668); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:774:20: (simple= propertyValue | map= map_literal )
            int alt85=2;
            int LA85_0 = input.LA(1);

            if ( (LA85_0==K_COUNT||LA85_0==INTEGER||(LA85_0>=K_FILTERING && LA85_0<=K_TTL)||LA85_0==K_VALUES||LA85_0==K_TIMESTAMP||LA85_0==K_COUNTER||(LA85_0>=K_KEY && LA85_0<=K_CUSTOM)||LA85_0==K_TYPE||LA85_0==K_LIST||(LA85_0>=K_ALL && LA85_0<=STRING_LITERAL)||(LA85_0>=FLOAT && LA85_0<=HEXNUMBER)||(LA85_0>=K_ASCII && LA85_0<=K_MAP)) ) {
                alt85=1;
            }
            else if ( (LA85_0==137) ) {
                alt85=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 85, 0, input);

                throw nvae;
            }
            switch (alt85) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:774:21: simple= propertyValue
                    {
                    pushFollow(FOLLOW_propertyValue_in_property4673);
                    simple=propertyValue();

                    state._fsp--;

                     try { props.addProperty(k.toString(), simple); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:775:24: map= map_literal
                    {
                    pushFollow(FOLLOW_map_literal_in_property4702);
                    map=map_literal();

                    state._fsp--;

                     try { props.addProperty(k.toString(), convertPropertyMap(map)); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "property"


    // $ANTLR start "propertyValue"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:778:1: propertyValue returns [String str] : (c= constant | u= unreserved_keyword );
    public final String propertyValue() throws RecognitionException {
        String str = null;

        Constants.Literal c = null;

        String u = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:779:5: (c= constant | u= unreserved_keyword )
            int alt86=2;
            int LA86_0 = input.LA(1);

            if ( (LA86_0==INTEGER||LA86_0==STRING_LITERAL||(LA86_0>=FLOAT && LA86_0<=HEXNUMBER)) ) {
                alt86=1;
            }
            else if ( (LA86_0==K_COUNT||(LA86_0>=K_FILTERING && LA86_0<=K_TTL)||LA86_0==K_VALUES||LA86_0==K_TIMESTAMP||LA86_0==K_COUNTER||(LA86_0>=K_KEY && LA86_0<=K_CUSTOM)||LA86_0==K_TYPE||LA86_0==K_LIST||(LA86_0>=K_ALL && LA86_0<=K_PASSWORD)||(LA86_0>=K_ASCII && LA86_0<=K_MAP)) ) {
                alt86=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 86, 0, input);

                throw nvae;
            }
            switch (alt86) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:779:7: c= constant
                    {
                    pushFollow(FOLLOW_constant_in_propertyValue4730);
                    c=constant();

                    state._fsp--;

                     str = c.getRawText(); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:780:7: u= unreserved_keyword
                    {
                    pushFollow(FOLLOW_unreserved_keyword_in_propertyValue4752);
                    u=unreserved_keyword();

                    state._fsp--;

                     str = u; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "propertyValue"


    // $ANTLR start "relationType"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:783:1: relationType returns [Relation.Type op] : ( '=' | '<' | '<=' | '>' | '>=' );
    public final Relation.Type relationType() throws RecognitionException {
        Relation.Type op = null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:784:5: ( '=' | '<' | '<=' | '>' | '>=' )
            int alt87=5;
            switch ( input.LA(1) ) {
            case 138:
                {
                alt87=1;
                }
                break;
            case 141:
                {
                alt87=2;
                }
                break;
            case 142:
                {
                alt87=3;
                }
                break;
            case 143:
                {
                alt87=4;
                }
                break;
            case 144:
                {
                alt87=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 87, 0, input);

                throw nvae;
            }

            switch (alt87) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:784:7: '='
                    {
                    match(input,138,FOLLOW_138_in_relationType4775); 
                     op = Relation.Type.EQ; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:785:7: '<'
                    {
                    match(input,141,FOLLOW_141_in_relationType4786); 
                     op = Relation.Type.LT; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:7: '<='
                    {
                    match(input,142,FOLLOW_142_in_relationType4797); 
                     op = Relation.Type.LTE; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:787:7: '>'
                    {
                    match(input,143,FOLLOW_143_in_relationType4807); 
                     op = Relation.Type.GT; 

                    }
                    break;
                case 5 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:788:7: '>='
                    {
                    match(input,144,FOLLOW_144_in_relationType4818); 
                     op = Relation.Type.GTE; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return op;
    }
    // $ANTLR end "relationType"


    // $ANTLR start "relation"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:791:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN '(' name1= cident ( ',' namen= cident )* ')' type= relationType t= term | name= cident K_IN '(' f1= term ( ',' fN= term )* ')' );
    public final void relation(List<Relation> clauses) throws RecognitionException {
        ColumnIdentifier name = null;

        Relation.Type type = null;

        Term.Raw t = null;

        ColumnIdentifier name1 = null;

        ColumnIdentifier namen = null;

        Term.Raw f1 = null;

        Term.Raw fN = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:792:5: (name= cident type= relationType t= term | K_TOKEN '(' name1= cident ( ',' namen= cident )* ')' type= relationType t= term | name= cident K_IN '(' f1= term ( ',' fN= term )* ')' )
            int alt90=3;
            alt90 = dfa90.predict(input);
            switch (alt90) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:792:7: name= cident type= relationType t= term
                    {
                    pushFollow(FOLLOW_cident_in_relation4840);
                    name=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_relationType_in_relation4844);
                    type=relationType();

                    state._fsp--;

                    pushFollow(FOLLOW_term_in_relation4848);
                    t=term();

                    state._fsp--;

                     clauses.add(new Relation(name, type, t)); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:793:7: K_TOKEN '(' name1= cident ( ',' namen= cident )* ')' type= relationType t= term
                    {
                    match(input,K_TOKEN,FOLLOW_K_TOKEN_in_relation4858); 
                     List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>(); 
                    match(input,128,FOLLOW_128_in_relation4881); 
                    pushFollow(FOLLOW_cident_in_relation4885);
                    name1=cident();

                    state._fsp--;

                     l.add(name1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:795:46: ( ',' namen= cident )*
                    loop88:
                    do {
                        int alt88=2;
                        int LA88_0 = input.LA(1);

                        if ( (LA88_0==130) ) {
                            alt88=1;
                        }


                        switch (alt88) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:795:48: ',' namen= cident
                    	    {
                    	    match(input,130,FOLLOW_130_in_relation4891); 
                    	    pushFollow(FOLLOW_cident_in_relation4895);
                    	    namen=cident();

                    	    state._fsp--;

                    	     l.add(namen); 

                    	    }
                    	    break;

                    	default :
                    	    break loop88;
                        }
                    } while (true);

                    match(input,129,FOLLOW_129_in_relation4901); 
                    pushFollow(FOLLOW_relationType_in_relation4913);
                    type=relationType();

                    state._fsp--;

                    pushFollow(FOLLOW_term_in_relation4917);
                    t=term();

                    state._fsp--;


                                for (ColumnIdentifier id : l)
                                    clauses.add(new Relation(id, type, t, true));
                            

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:801:7: name= cident K_IN '(' f1= term ( ',' fN= term )* ')'
                    {
                    pushFollow(FOLLOW_cident_in_relation4937);
                    name=cident();

                    state._fsp--;

                    match(input,K_IN,FOLLOW_K_IN_in_relation4939); 
                     Relation rel = Relation.createInRelation(name); 
                    match(input,128,FOLLOW_128_in_relation4950); 
                    pushFollow(FOLLOW_term_in_relation4954);
                    f1=term();

                    state._fsp--;

                     rel.addInValue(f1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:802:44: ( ',' fN= term )*
                    loop89:
                    do {
                        int alt89=2;
                        int LA89_0 = input.LA(1);

                        if ( (LA89_0==130) ) {
                            alt89=1;
                        }


                        switch (alt89) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:802:45: ',' fN= term
                    	    {
                    	    match(input,130,FOLLOW_130_in_relation4959); 
                    	    pushFollow(FOLLOW_term_in_relation4963);
                    	    fN=term();

                    	    state._fsp--;

                    	     rel.addInValue(fN); 

                    	    }
                    	    break;

                    	default :
                    	    break loop89;
                        }
                    } while (true);

                    match(input,129,FOLLOW_129_in_relation4970); 
                     clauses.add(rel); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "relation"


    // $ANTLR start "comparatorType"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:805:1: comparatorType returns [CQL3Type t] : (c= native_type | c= collection_type | s= STRING_LITERAL );
    public final CQL3Type comparatorType() throws RecognitionException {
        CQL3Type t = null;

        Token s=null;
        CQL3Type c = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:806:5: (c= native_type | c= collection_type | s= STRING_LITERAL )
            int alt91=3;
            switch ( input.LA(1) ) {
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
                {
                alt91=1;
                }
                break;
            case K_SET:
            case K_LIST:
            case K_MAP:
                {
                alt91=2;
                }
                break;
            case STRING_LITERAL:
                {
                alt91=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 91, 0, input);

                throw nvae;
            }

            switch (alt91) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:806:7: c= native_type
                    {
                    pushFollow(FOLLOW_native_type_in_comparatorType4995);
                    c=native_type();

                    state._fsp--;

                     t = c; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:807:7: c= collection_type
                    {
                    pushFollow(FOLLOW_collection_type_in_comparatorType5011);
                    c=collection_type();

                    state._fsp--;

                     t = c; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:808:7: s= STRING_LITERAL
                    {
                    s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_comparatorType5023); 

                            try {
                                t = new CQL3Type.Custom((s!=null?s.getText():null));
                            } catch (SyntaxException e) {
                                addRecognitionError("Cannot parse type " + (s!=null?s.getText():null) + ": " + e.getMessage());
                            } catch (ConfigurationException e) {
                                addRecognitionError("Error setting type " + (s!=null?s.getText():null) + ": " + e.getMessage());
                            }
                          

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return t;
    }
    // $ANTLR end "comparatorType"


    // $ANTLR start "native_type"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:820:1: native_type returns [CQL3Type t] : ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_TEXT | K_TIMESTAMP | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID );
    public final CQL3Type native_type() throws RecognitionException {
        CQL3Type t = null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:821:5: ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_TEXT | K_TIMESTAMP | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID )
            int alt92=16;
            switch ( input.LA(1) ) {
            case K_ASCII:
                {
                alt92=1;
                }
                break;
            case K_BIGINT:
                {
                alt92=2;
                }
                break;
            case K_BLOB:
                {
                alt92=3;
                }
                break;
            case K_BOOLEAN:
                {
                alt92=4;
                }
                break;
            case K_COUNTER:
                {
                alt92=5;
                }
                break;
            case K_DECIMAL:
                {
                alt92=6;
                }
                break;
            case K_DOUBLE:
                {
                alt92=7;
                }
                break;
            case K_FLOAT:
                {
                alt92=8;
                }
                break;
            case K_INET:
                {
                alt92=9;
                }
                break;
            case K_INT:
                {
                alt92=10;
                }
                break;
            case K_TEXT:
                {
                alt92=11;
                }
                break;
            case K_TIMESTAMP:
                {
                alt92=12;
                }
                break;
            case K_UUID:
                {
                alt92=13;
                }
                break;
            case K_VARCHAR:
                {
                alt92=14;
                }
                break;
            case K_VARINT:
                {
                alt92=15;
                }
                break;
            case K_TIMEUUID:
                {
                alt92=16;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 92, 0, input);

                throw nvae;
            }

            switch (alt92) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:821:7: K_ASCII
                    {
                    match(input,K_ASCII,FOLLOW_K_ASCII_in_native_type5052); 
                     t = CQL3Type.Native.ASCII; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:822:7: K_BIGINT
                    {
                    match(input,K_BIGINT,FOLLOW_K_BIGINT_in_native_type5066); 
                     t = CQL3Type.Native.BIGINT; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:823:7: K_BLOB
                    {
                    match(input,K_BLOB,FOLLOW_K_BLOB_in_native_type5079); 
                     t = CQL3Type.Native.BLOB; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:824:7: K_BOOLEAN
                    {
                    match(input,K_BOOLEAN,FOLLOW_K_BOOLEAN_in_native_type5094); 
                     t = CQL3Type.Native.BOOLEAN; 

                    }
                    break;
                case 5 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:825:7: K_COUNTER
                    {
                    match(input,K_COUNTER,FOLLOW_K_COUNTER_in_native_type5106); 
                     t = CQL3Type.Native.COUNTER; 

                    }
                    break;
                case 6 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:826:7: K_DECIMAL
                    {
                    match(input,K_DECIMAL,FOLLOW_K_DECIMAL_in_native_type5118); 
                     t = CQL3Type.Native.DECIMAL; 

                    }
                    break;
                case 7 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:827:7: K_DOUBLE
                    {
                    match(input,K_DOUBLE,FOLLOW_K_DOUBLE_in_native_type5130); 
                     t = CQL3Type.Native.DOUBLE; 

                    }
                    break;
                case 8 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:828:7: K_FLOAT
                    {
                    match(input,K_FLOAT,FOLLOW_K_FLOAT_in_native_type5143); 
                     t = CQL3Type.Native.FLOAT; 

                    }
                    break;
                case 9 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:829:7: K_INET
                    {
                    match(input,K_INET,FOLLOW_K_INET_in_native_type5157); 
                     t = CQL3Type.Native.INET;

                    }
                    break;
                case 10 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:830:7: K_INT
                    {
                    match(input,K_INT,FOLLOW_K_INT_in_native_type5172); 
                     t = CQL3Type.Native.INT; 

                    }
                    break;
                case 11 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:831:7: K_TEXT
                    {
                    match(input,K_TEXT,FOLLOW_K_TEXT_in_native_type5188); 
                     t = CQL3Type.Native.TEXT; 

                    }
                    break;
                case 12 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:7: K_TIMESTAMP
                    {
                    match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_native_type5203); 
                     t = CQL3Type.Native.TIMESTAMP; 

                    }
                    break;
                case 13 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:833:7: K_UUID
                    {
                    match(input,K_UUID,FOLLOW_K_UUID_in_native_type5213); 
                     t = CQL3Type.Native.UUID; 

                    }
                    break;
                case 14 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:834:7: K_VARCHAR
                    {
                    match(input,K_VARCHAR,FOLLOW_K_VARCHAR_in_native_type5228); 
                     t = CQL3Type.Native.VARCHAR; 

                    }
                    break;
                case 15 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:835:7: K_VARINT
                    {
                    match(input,K_VARINT,FOLLOW_K_VARINT_in_native_type5240); 
                     t = CQL3Type.Native.VARINT; 

                    }
                    break;
                case 16 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:836:7: K_TIMEUUID
                    {
                    match(input,K_TIMEUUID,FOLLOW_K_TIMEUUID_in_native_type5253); 
                     t = CQL3Type.Native.TIMEUUID; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return t;
    }
    // $ANTLR end "native_type"


    // $ANTLR start "collection_type"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:1: collection_type returns [CQL3Type pt] : ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' );
    public final CQL3Type collection_type() throws RecognitionException {
        CQL3Type pt = null;

        CQL3Type t1 = null;

        CQL3Type t2 = null;

        CQL3Type t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:840:5: ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' )
            int alt93=3;
            switch ( input.LA(1) ) {
            case K_MAP:
                {
                alt93=1;
                }
                break;
            case K_LIST:
                {
                alt93=2;
                }
                break;
            case K_SET:
                {
                alt93=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 93, 0, input);

                throw nvae;
            }

            switch (alt93) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:840:7: K_MAP '<' t1= comparatorType ',' t2= comparatorType '>'
                    {
                    match(input,K_MAP,FOLLOW_K_MAP_in_collection_type5277); 
                    match(input,141,FOLLOW_141_in_collection_type5280); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type5284);
                    t1=comparatorType();

                    state._fsp--;

                    match(input,130,FOLLOW_130_in_collection_type5286); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type5290);
                    t2=comparatorType();

                    state._fsp--;

                    match(input,143,FOLLOW_143_in_collection_type5292); 
                     try {
                                // if we can't parse either t1 or t2, antlr will "recover" and we may have t1 or t2 null.
                                if (t1 != null && t2 != null)
                                    pt = CQL3Type.Collection.map(t1, t2);
                              } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:846:7: K_LIST '<' t= comparatorType '>'
                    {
                    match(input,K_LIST,FOLLOW_K_LIST_in_collection_type5310); 
                    match(input,141,FOLLOW_141_in_collection_type5312); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type5316);
                    t=comparatorType();

                    state._fsp--;

                    match(input,143,FOLLOW_143_in_collection_type5318); 
                     try { if (t != null) pt = CQL3Type.Collection.list(t); } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:848:7: K_SET '<' t= comparatorType '>'
                    {
                    match(input,K_SET,FOLLOW_K_SET_in_collection_type5336); 
                    match(input,141,FOLLOW_141_in_collection_type5339); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type5343);
                    t=comparatorType();

                    state._fsp--;

                    match(input,143,FOLLOW_143_in_collection_type5345); 
                     try { if (t != null) pt = CQL3Type.Collection.set(t); } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return pt;
    }
    // $ANTLR end "collection_type"

    public static class username_return extends ParserRuleReturnScope {
    };

    // $ANTLR start "username"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:852:1: username : ( IDENT | STRING_LITERAL );
    public final CqlParser.username_return username() throws RecognitionException {
        CqlParser.username_return retval = new CqlParser.username_return();
        retval.start = input.LT(1);

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:853:5: ( IDENT | STRING_LITERAL )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:
            {
            if ( input.LA(1)==IDENT||input.LA(1)==STRING_LITERAL ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "username"


    // $ANTLR start "unreserved_keyword"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:857:1: unreserved_keyword returns [String str] : (u= unreserved_function_keyword | k= ( K_TTL | K_COUNT | K_WRITETIME ) );
    public final String unreserved_keyword() throws RecognitionException {
        String str = null;

        Token k=null;
        String u = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:858:5: (u= unreserved_function_keyword | k= ( K_TTL | K_COUNT | K_WRITETIME ) )
            int alt94=2;
            int LA94_0 = input.LA(1);

            if ( (LA94_0==K_FILTERING||LA94_0==K_VALUES||LA94_0==K_TIMESTAMP||LA94_0==K_COUNTER||(LA94_0>=K_KEY && LA94_0<=K_CUSTOM)||LA94_0==K_TYPE||LA94_0==K_LIST||(LA94_0>=K_ALL && LA94_0<=K_PASSWORD)||(LA94_0>=K_ASCII && LA94_0<=K_MAP)) ) {
                alt94=1;
            }
            else if ( (LA94_0==K_COUNT||(LA94_0>=K_WRITETIME && LA94_0<=K_TTL)) ) {
                alt94=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 94, 0, input);

                throw nvae;
            }
            switch (alt94) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:858:7: u= unreserved_function_keyword
                    {
                    pushFollow(FOLLOW_unreserved_function_keyword_in_unreserved_keyword5403);
                    u=unreserved_function_keyword();

                    state._fsp--;

                     str = u; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:859:7: k= ( K_TTL | K_COUNT | K_WRITETIME )
                    {
                    k=(Token)input.LT(1);
                    if ( input.LA(1)==K_COUNT||(input.LA(1)>=K_WRITETIME && input.LA(1)<=K_TTL) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                     str = (k!=null?k.getText():null); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "unreserved_keyword"


    // $ANTLR start "unreserved_function_keyword"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:862:1: unreserved_function_keyword returns [String str] : (k= ( K_KEY | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_CUSTOM ) | t= native_type );
    public final String unreserved_function_keyword() throws RecognitionException {
        String str = null;

        Token k=null;
        CQL3Type t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:5: (k= ( K_KEY | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_CUSTOM ) | t= native_type )
            int alt95=2;
            int LA95_0 = input.LA(1);

            if ( (LA95_0==K_FILTERING||LA95_0==K_VALUES||(LA95_0>=K_KEY && LA95_0<=K_CUSTOM)||LA95_0==K_TYPE||LA95_0==K_LIST||(LA95_0>=K_ALL && LA95_0<=K_PASSWORD)||LA95_0==K_MAP) ) {
                alt95=1;
            }
            else if ( (LA95_0==K_TIMESTAMP||LA95_0==K_COUNTER||(LA95_0>=K_ASCII && LA95_0<=K_TIMEUUID)) ) {
                alt95=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 95, 0, input);

                throw nvae;
            }
            switch (alt95) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:7: k= ( K_KEY | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_CUSTOM )
                    {
                    k=(Token)input.LT(1);
                    if ( input.LA(1)==K_FILTERING||input.LA(1)==K_VALUES||(input.LA(1)>=K_KEY && input.LA(1)<=K_CUSTOM)||input.LA(1)==K_TYPE||input.LA(1)==K_LIST||(input.LA(1)>=K_ALL && input.LA(1)<=K_PASSWORD)||input.LA(1)==K_MAP ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                     str = (k!=null?k.getText():null); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:883:7: t= native_type
                    {
                    pushFollow(FOLLOW_native_type_in_unreserved_function_keyword5694);
                    t=native_type();

                    state._fsp--;

                     str = t.toString(); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "unreserved_function_keyword"

    // Delegated rules


    protected DFA2 dfa2 = new DFA2(this);
    protected DFA13 dfa13 = new DFA13(this);
    protected DFA30 dfa30 = new DFA30(this);
    protected DFA67 dfa67 = new DFA67(this);
    protected DFA83 dfa83 = new DFA83(this);
    protected DFA90 dfa90 = new DFA90(this);
    static final String DFA2_eotS =
        "\33\uffff";
    static final String DFA2_eofS =
        "\33\uffff";
    static final String DFA2_minS =
        "\1\4\7\uffff\3\42\2\uffff\1\5\15\uffff";
    static final String DFA2_maxS =
        "\1\67\7\uffff\3\100\2\uffff\1\103\15\uffff";
    static final String DFA2_acceptS =
        "\1\uffff\1\1\1\2\1\3\1\4\1\5\1\6\1\7\3\uffff\1\20\1\21\1\uffff\1"+
        "\10\1\11\1\23\1\12\1\13\1\14\1\15\1\25\1\16\1\17\1\24\1\26\1\22";
    static final String DFA2_specialS =
        "\33\uffff}>";
    static final String[] DFA2_transitionS = {
            "\1\6\1\1\16\uffff\1\2\4\uffff\1\3\1\uffff\1\5\1\4\4\uffff\1"+
            "\10\14\uffff\1\12\4\uffff\1\11\1\7\1\13\1\14\1\15",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\16\1\uffff\1\17\5\uffff\2\21\24\uffff\1\20",
            "\1\22\1\uffff\1\23\6\uffff\1\24\24\uffff\1\25",
            "\1\27\1\uffff\1\26\33\uffff\1\30",
            "",
            "",
            "\1\32\33\uffff\1\32\14\uffff\1\32\4\uffff\1\32\6\uffff\3\32"+
            "\6\uffff\1\31",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA2_eot = DFA.unpackEncodedString(DFA2_eotS);
    static final short[] DFA2_eof = DFA.unpackEncodedString(DFA2_eofS);
    static final char[] DFA2_min = DFA.unpackEncodedStringToUnsignedChars(DFA2_minS);
    static final char[] DFA2_max = DFA.unpackEncodedStringToUnsignedChars(DFA2_maxS);
    static final short[] DFA2_accept = DFA.unpackEncodedString(DFA2_acceptS);
    static final short[] DFA2_special = DFA.unpackEncodedString(DFA2_specialS);
    static final short[][] DFA2_transition;

    static {
        int numStates = DFA2_transitionS.length;
        DFA2_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA2_transition[i] = DFA.unpackEncodedString(DFA2_transitionS[i]);
        }
    }

    class DFA2 extends DFA {

        public DFA2(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 2;
            this.eot = DFA2_eot;
            this.eof = DFA2_eof;
            this.min = DFA2_min;
            this.max = DFA2_max;
            this.accept = DFA2_accept;
            this.special = DFA2_special;
            this.transition = DFA2_transition;
        }
        public String getDescription() {
            return "172:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createColumnFamilyStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropColumnFamilyStatement | st13= dropIndexStatement | st14= alterTableStatement | st15= alterKeyspaceStatement | st16= grantStatement | st17= revokeStatement | st18= listPermissionsStatement | st19= createUserStatement | st20= alterUserStatement | st21= dropUserStatement | st22= listUsersStatement );";
        }
    }
    static final String DFA13_eotS =
        "\31\uffff";
    static final String DFA13_eofS =
        "\31\uffff";
    static final String DFA13_minS =
        "\1\6\1\7\1\uffff\23\7\3\uffff";
    static final String DFA13_maxS =
        "\1\135\1\u0082\1\uffff\23\u0082\3\uffff";
    static final String DFA13_acceptS =
        "\2\uffff\1\1\23\uffff\1\4\1\2\1\3";
    static final String DFA13_specialS =
        "\31\uffff}>";
    static final String[] DFA13_transitionS = {
            "\1\2\7\uffff\1\3\1\24\1\25\5\uffff\1\3\1\uffff\1\17\5\uffff"+
            "\1\10\7\uffff\5\3\1\uffff\1\1\2\uffff\1\3\7\uffff\1\3\4\uffff"+
            "\11\3\1\uffff\1\2\6\uffff\1\26\1\uffff\1\4\1\5\1\6\1\7\1\11"+
            "\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22\1\23\1\3",
            "\1\2\170\uffff\1\26\2\2",
            "",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\26\2\2",
            "\1\2\170\uffff\1\27\2\2",
            "\1\2\170\uffff\1\30\2\2",
            "",
            "",
            ""
    };

    static final short[] DFA13_eot = DFA.unpackEncodedString(DFA13_eotS);
    static final short[] DFA13_eof = DFA.unpackEncodedString(DFA13_eofS);
    static final char[] DFA13_min = DFA.unpackEncodedStringToUnsignedChars(DFA13_minS);
    static final char[] DFA13_max = DFA.unpackEncodedStringToUnsignedChars(DFA13_maxS);
    static final short[] DFA13_accept = DFA.unpackEncodedString(DFA13_acceptS);
    static final short[] DFA13_special = DFA.unpackEncodedString(DFA13_specialS);
    static final short[][] DFA13_transition;

    static {
        int numStates = DFA13_transitionS.length;
        DFA13_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA13_transition[i] = DFA.unpackEncodedString(DFA13_transitionS[i]);
        }
    }

    class DFA13 extends DFA {

        public DFA13(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 13;
            this.eot = DFA13_eot;
            this.eof = DFA13_eof;
            this.min = DFA13_min;
            this.max = DFA13_max;
            this.accept = DFA13_accept;
            this.special = DFA13_special;
            this.transition = DFA13_transition;
        }
        public String getDescription() {
            return "245:1: selector returns [RawSelector s] : (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs );";
        }
    }
    static final String DFA30_eotS =
        "\27\uffff";
    static final String DFA30_eofS =
        "\27\uffff";
    static final String DFA30_minS =
        "\1\6\24\7\2\uffff";
    static final String DFA30_maxS =
        "\1\135\24\u0084\2\uffff";
    static final String DFA30_acceptS =
        "\25\uffff\1\2\1\1";
    static final String DFA30_specialS =
        "\27\uffff}>";
    static final String[] DFA30_transitionS = {
            "\1\24\7\uffff\1\3\2\24\5\uffff\1\3\1\uffff\1\17\5\uffff\1\10"+
            "\7\uffff\5\3\1\uffff\1\1\2\uffff\1\3\7\uffff\1\3\4\uffff\11"+
            "\3\1\uffff\1\2\10\uffff\1\4\1\5\1\6\1\7\1\11\1\12\1\13\1\14"+
            "\1\15\1\16\1\20\1\21\1\22\1\23\1\3",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "\1\26\172\uffff\1\26\1\uffff\1\25",
            "",
            ""
    };

    static final short[] DFA30_eot = DFA.unpackEncodedString(DFA30_eotS);
    static final short[] DFA30_eof = DFA.unpackEncodedString(DFA30_eofS);
    static final char[] DFA30_min = DFA.unpackEncodedStringToUnsignedChars(DFA30_minS);
    static final char[] DFA30_max = DFA.unpackEncodedStringToUnsignedChars(DFA30_maxS);
    static final short[] DFA30_accept = DFA.unpackEncodedString(DFA30_acceptS);
    static final short[] DFA30_special = DFA.unpackEncodedString(DFA30_specialS);
    static final short[][] DFA30_transition;

    static {
        int numStates = DFA30_transitionS.length;
        DFA30_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA30_transition[i] = DFA.unpackEncodedString(DFA30_transitionS[i]);
        }
    }

    class DFA30 extends DFA {

        public DFA30(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 30;
            this.eot = DFA30_eot;
            this.eof = DFA30_eof;
            this.min = DFA30_min;
            this.max = DFA30_max;
            this.accept = DFA30_accept;
            this.special = DFA30_special;
            this.transition = DFA30_transition;
        }
        public String getDescription() {
            return "355:1: deleteOp returns [Operation.RawDeletion op] : (c= cident | c= cident '[' t= term ']' );";
        }
    }
    static final String DFA67_eotS =
        "\27\uffff";
    static final String DFA67_eofS =
        "\1\uffff\24\25\2\uffff";
    static final String DFA67_minS =
        "\1\6\24\7\2\uffff";
    static final String DFA67_maxS =
        "\1\135\24\u0086\2\uffff";
    static final String DFA67_acceptS =
        "\25\uffff\1\2\1\1";
    static final String DFA67_specialS =
        "\27\uffff}>";
    static final String[] DFA67_transitionS = {
            "\1\24\7\uffff\1\3\2\24\5\uffff\1\3\1\uffff\1\17\5\uffff\1\10"+
            "\7\uffff\5\3\1\uffff\1\1\2\uffff\1\3\7\uffff\1\3\4\uffff\11"+
            "\3\1\uffff\1\2\10\uffff\1\4\1\5\1\6\1\7\1\11\1\12\1\13\1\14"+
            "\1\15\1\16\1\20\1\21\1\22\1\23\1\3",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "\3\25\1\uffff\1\25\1\uffff\1\25\11\uffff\1\25\2\uffff\1\25"+
            "\10\uffff\1\25\12\uffff\1\25\1\uffff\3\25\5\uffff\2\25\105\uffff"+
            "\2\25\5\uffff\1\26",
            "",
            ""
    };

    static final short[] DFA67_eot = DFA.unpackEncodedString(DFA67_eotS);
    static final short[] DFA67_eof = DFA.unpackEncodedString(DFA67_eofS);
    static final char[] DFA67_min = DFA.unpackEncodedStringToUnsignedChars(DFA67_minS);
    static final char[] DFA67_max = DFA.unpackEncodedStringToUnsignedChars(DFA67_maxS);
    static final short[] DFA67_accept = DFA.unpackEncodedString(DFA67_acceptS);
    static final short[] DFA67_special = DFA.unpackEncodedString(DFA67_specialS);
    static final short[][] DFA67_transition;

    static {
        int numStates = DFA67_transitionS.length;
        DFA67_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA67_transition[i] = DFA.unpackEncodedString(DFA67_transitionS[i]);
        }
    }

    class DFA67 extends DFA {

        public DFA67(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 67;
            this.eot = DFA67_eot;
            this.eof = DFA67_eof;
            this.min = DFA67_min;
            this.max = DFA67_max;
            this.accept = DFA67_accept;
            this.special = DFA67_special;
            this.transition = DFA67_transition;
        }
        public String getDescription() {
            return "661:7: ( cfOrKsName[name, true] '.' )?";
        }
    }
    static final String DFA83_eotS =
        "\56\uffff";
    static final String DFA83_eofS =
        "\56\uffff";
    static final String DFA83_minS =
        "\1\6\24\u0084\1\6\1\uffff\24\14\3\uffff";
    static final String DFA83_maxS =
        "\1\135\24\u008a\1\u0089\1\uffff\24\u008c\3\uffff";
    static final String DFA83_acceptS =
        "\26\uffff\1\4\24\uffff\1\1\1\3\1\2";
    static final String DFA83_specialS =
        "\56\uffff}>";
    static final String[] DFA83_transitionS = {
            "\1\24\7\uffff\1\3\2\24\5\uffff\1\3\1\uffff\1\17\5\uffff\1\10"+
            "\7\uffff\5\3\1\uffff\1\1\2\uffff\1\3\7\uffff\1\3\4\uffff\11"+
            "\3\1\uffff\1\2\10\uffff\1\4\1\5\1\6\1\7\1\11\1\12\1\13\1\14"+
            "\1\15\1\16\1\20\1\21\1\22\1\23\1\3",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\26\5\uffff\1\25",
            "\1\52\5\uffff\1\53\1\uffff\1\31\2\52\5\uffff\1\31\1\uffff\1"+
            "\45\5\uffff\1\36\7\uffff\5\31\1\uffff\1\27\2\uffff\1\31\7\uffff"+
            "\1\31\4\uffff\11\31\1\53\1\30\7\53\1\uffff\1\32\1\33\1\34\1"+
            "\35\1\37\1\40\1\41\1\42\1\43\1\44\1\46\1\47\1\50\1\51\1\31\42"+
            "\uffff\1\53\3\uffff\1\53\4\uffff\1\53",
            "",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\176\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\163\uffff\1\53\12\uffff\2\55",
            "\1\54\176\uffff\2\55",
            "",
            "",
            ""
    };

    static final short[] DFA83_eot = DFA.unpackEncodedString(DFA83_eotS);
    static final short[] DFA83_eof = DFA.unpackEncodedString(DFA83_eofS);
    static final char[] DFA83_min = DFA.unpackEncodedStringToUnsignedChars(DFA83_minS);
    static final char[] DFA83_max = DFA.unpackEncodedStringToUnsignedChars(DFA83_maxS);
    static final short[] DFA83_accept = DFA.unpackEncodedString(DFA83_acceptS);
    static final short[] DFA83_special = DFA.unpackEncodedString(DFA83_specialS);
    static final short[][] DFA83_transition;

    static {
        int numStates = DFA83_transitionS.length;
        DFA83_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA83_transition[i] = DFA.unpackEncodedString(DFA83_transitionS[i]);
        }
    }

    class DFA83 extends DFA {

        public DFA83(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 83;
            this.eot = DFA83_eot;
            this.eof = DFA83_eof;
            this.min = DFA83_min;
            this.max = DFA83_max;
            this.accept = DFA83_accept;
            this.special = DFA83_special;
            this.transition = DFA83_transition;
        }
        public String getDescription() {
            return "735:1: columnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations] : (key= cident '=' t= term ( '+' c= cident )? | key= cident '=' c= cident sig= ( '+' | '-' ) t= term | key= cident '=' c= cident i= INTEGER | key= cident '[' k= term ']' '=' t= term );";
        }
    }
    static final String DFA90_eotS =
        "\30\uffff";
    static final String DFA90_eofS =
        "\30\uffff";
    static final String DFA90_minS =
        "\1\6\24\116\3\uffff";
    static final String DFA90_maxS =
        "\1\135\24\u0090\3\uffff";
    static final String DFA90_acceptS =
        "\25\uffff\1\2\1\3\1\1";
    static final String DFA90_specialS =
        "\30\uffff}>";
    static final String[] DFA90_transitionS = {
            "\1\24\7\uffff\1\3\2\24\5\uffff\1\3\1\uffff\1\17\5\uffff\1\10"+
            "\7\uffff\5\3\1\uffff\1\1\2\uffff\1\3\7\uffff\1\3\4\uffff\11"+
            "\3\1\uffff\1\2\6\uffff\1\25\1\uffff\1\4\1\5\1\6\1\7\1\11\1\12"+
            "\1\13\1\14\1\15\1\16\1\20\1\21\1\22\1\23\1\3",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "\1\26\73\uffff\1\27\2\uffff\4\27",
            "",
            "",
            ""
    };

    static final short[] DFA90_eot = DFA.unpackEncodedString(DFA90_eotS);
    static final short[] DFA90_eof = DFA.unpackEncodedString(DFA90_eofS);
    static final char[] DFA90_min = DFA.unpackEncodedStringToUnsignedChars(DFA90_minS);
    static final char[] DFA90_max = DFA.unpackEncodedStringToUnsignedChars(DFA90_maxS);
    static final short[] DFA90_accept = DFA.unpackEncodedString(DFA90_acceptS);
    static final short[] DFA90_special = DFA.unpackEncodedString(DFA90_specialS);
    static final short[][] DFA90_transition;

    static {
        int numStates = DFA90_transitionS.length;
        DFA90_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA90_transition[i] = DFA.unpackEncodedString(DFA90_transitionS[i]);
        }
    }

    class DFA90 extends DFA {

        public DFA90(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 90;
            this.eot = DFA90_eot;
            this.eof = DFA90_eof;
            this.min = DFA90_min;
            this.max = DFA90_max;
            this.accept = DFA90_accept;
            this.special = DFA90_special;
            this.transition = DFA90_transition;
        }
        public String getDescription() {
            return "791:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN '(' name1= cident ( ',' namen= cident )* ')' type= relationType t= term | name= cident K_IN '(' f1= term ( ',' fN= term )* ')' );";
        }
    }
 

    public static final BitSet FOLLOW_cqlStatement_in_query72 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
    public static final BitSet FOLLOW_127_in_query75 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
    public static final BitSet FOLLOW_EOF_in_query79 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_selectStatement_in_cqlStatement113 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatement_in_cqlStatement138 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_cqlStatement163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_batchStatement_in_cqlStatement188 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatement_in_cqlStatement214 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_useStatement_in_cqlStatement239 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_truncateStatement_in_cqlStatement267 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createKeyspaceStatement_in_cqlStatement290 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createColumnFamilyStatement_in_cqlStatement307 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createIndexStatement_in_cqlStatement319 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropKeyspaceStatement_in_cqlStatement338 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropColumnFamilyStatement_in_cqlStatement356 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropIndexStatement_in_cqlStatement370 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterTableStatement_in_cqlStatement391 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterKeyspaceStatement_in_cqlStatement411 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_grantStatement_in_cqlStatement428 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_revokeStatement_in_cqlStatement453 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listPermissionsStatement_in_cqlStatement477 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createUserStatement_in_cqlStatement492 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterUserStatement_in_cqlStatement512 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropUserStatement_in_cqlStatement533 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listUsersStatement_in_cqlStatement555 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_USE_in_useStatement589 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_keyspaceName_in_useStatement593 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_SELECT_in_selectStatement627 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFFA05FL,0x0000000000000008L});
    public static final BitSet FOLLOW_selectClause_in_selectStatement633 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_K_COUNT_in_selectStatement638 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_128_in_selectStatement640 = new BitSet(new long[]{0x0000000000001000L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_selectCountClause_in_selectStatement644 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_129_in_selectStatement646 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_K_FROM_in_selectStatement659 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnFamilyName_in_selectStatement663 = new BitSet(new long[]{0x0000000000002B02L});
    public static final BitSet FOLLOW_K_WHERE_in_selectStatement673 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFFA05FL});
    public static final BitSet FOLLOW_whereClause_in_selectStatement677 = new BitSet(new long[]{0x0000000000002A02L});
    public static final BitSet FOLLOW_K_ORDER_in_selectStatement690 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_K_BY_in_selectStatement692 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_orderByClause_in_selectStatement694 = new BitSet(new long[]{0x0000000000002802L,0x0000000000000000L,0x0000000000000004L});
    public static final BitSet FOLLOW_130_in_selectStatement699 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_orderByClause_in_selectStatement701 = new BitSet(new long[]{0x0000000000002802L,0x0000000000000000L,0x0000000000000004L});
    public static final BitSet FOLLOW_K_LIMIT_in_selectStatement718 = new BitSet(new long[]{0x0000000000001000L});
    public static final BitSet FOLLOW_INTEGER_in_selectStatement722 = new BitSet(new long[]{0x0000000000002002L});
    public static final BitSet FOLLOW_K_ALLOW_in_selectStatement737 = new BitSet(new long[]{0x0000000000004000L});
    public static final BitSet FOLLOW_K_FILTERING_in_selectStatement739 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_selector_in_selectClause776 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000004L});
    public static final BitSet FOLLOW_130_in_selectClause781 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFFA05FL});
    public static final BitSet FOLLOW_selector_in_selectClause785 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000004L});
    public static final BitSet FOLLOW_131_in_selectClause797 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_128_in_selectionFunctionArgs820 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_129_in_selectionFunctionArgs822 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_128_in_selectionFunctionArgs832 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFFA05FL});
    public static final BitSet FOLLOW_selector_in_selectionFunctionArgs836 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_130_in_selectionFunctionArgs852 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFFA05FL});
    public static final BitSet FOLLOW_selector_in_selectionFunctionArgs856 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_129_in_selectionFunctionArgs870 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_selector895 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_WRITETIME_in_selector938 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_128_in_selector940 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_selector944 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_129_in_selector946 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TTL_in_selector969 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_128_in_selector977 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_selector981 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_129_in_selector983 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_functionName_in_selector1008 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_selectionFunctionArgs_in_selector1012 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_131_in_selectCountClause1035 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_selectCountClause1057 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_relation_in_whereClause1093 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_K_AND_in_whereClause1097 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFFA05FL});
    public static final BitSet FOLLOW_relation_in_whereClause1099 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_cident_in_orderByClause1130 = new BitSet(new long[]{0x00000000000C0002L});
    public static final BitSet FOLLOW_K_ASC_in_orderByClause1135 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DESC_in_orderByClause1139 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_INSERT_in_insertStatement1177 = new BitSet(new long[]{0x0000000000200000L});
    public static final BitSet FOLLOW_K_INTO_in_insertStatement1179 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnFamilyName_in_insertStatement1183 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_128_in_insertStatement1195 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_insertStatement1199 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_130_in_insertStatement1206 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_insertStatement1210 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_129_in_insertStatement1217 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_K_VALUES_in_insertStatement1227 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_128_in_insertStatement1239 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_insertStatement1243 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_130_in_insertStatement1249 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_insertStatement1253 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_129_in_insertStatement1260 = new BitSet(new long[]{0x0000000000800002L});
    public static final BitSet FOLLOW_usingClause_in_insertStatement1272 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_USING_in_usingClause1302 = new BitSet(new long[]{0x0000000001010000L});
    public static final BitSet FOLLOW_usingClauseObjective_in_usingClause1304 = new BitSet(new long[]{0x0000000001030002L});
    public static final BitSet FOLLOW_K_AND_in_usingClause1309 = new BitSet(new long[]{0x0000000001010000L});
    public static final BitSet FOLLOW_usingClauseObjective_in_usingClause1312 = new BitSet(new long[]{0x0000000001030002L});
    public static final BitSet FOLLOW_K_USING_in_usingClauseDelete1334 = new BitSet(new long[]{0x0000000001000000L});
    public static final BitSet FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete1336 = new BitSet(new long[]{0x0000000001020002L});
    public static final BitSet FOLLOW_K_AND_in_usingClauseDelete1341 = new BitSet(new long[]{0x0000000001000000L});
    public static final BitSet FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete1344 = new BitSet(new long[]{0x0000000001020002L});
    public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseDeleteObjective1366 = new BitSet(new long[]{0x0000000000001000L});
    public static final BitSet FOLLOW_INTEGER_in_usingClauseDeleteObjective1370 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_usingClauseDeleteObjective_in_usingClauseObjective1390 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TTL_in_usingClauseObjective1399 = new BitSet(new long[]{0x0000000000001000L});
    public static final BitSet FOLLOW_INTEGER_in_usingClauseObjective1403 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_UPDATE_in_updateStatement1437 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnFamilyName_in_updateStatement1441 = new BitSet(new long[]{0x0000000004800000L});
    public static final BitSet FOLLOW_usingClause_in_updateStatement1451 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_SET_in_updateStatement1463 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnOperation_in_updateStatement1465 = new BitSet(new long[]{0x0000000000000100L,0x0000000000000000L,0x0000000000000004L});
    public static final BitSet FOLLOW_130_in_updateStatement1469 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnOperation_in_updateStatement1471 = new BitSet(new long[]{0x0000000000000100L,0x0000000000000000L,0x0000000000000004L});
    public static final BitSet FOLLOW_K_WHERE_in_updateStatement1482 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFFA05FL});
    public static final BitSet FOLLOW_whereClause_in_updateStatement1486 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DELETE_in_deleteStatement1526 = new BitSet(new long[]{0xF08097C04141C0C0L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_deleteSelection_in_deleteStatement1532 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_K_FROM_in_deleteStatement1545 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnFamilyName_in_deleteStatement1549 = new BitSet(new long[]{0x0000000000800100L});
    public static final BitSet FOLLOW_usingClauseDelete_in_deleteStatement1559 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_K_WHERE_in_deleteStatement1571 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFFA05FL});
    public static final BitSet FOLLOW_whereClause_in_deleteStatement1575 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteOp_in_deleteSelection1618 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000004L});
    public static final BitSet FOLLOW_130_in_deleteSelection1633 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_deleteOp_in_deleteSelection1637 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000004L});
    public static final BitSet FOLLOW_cident_in_deleteOp1664 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_deleteOp1691 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_132_in_deleteOp1693 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_deleteOp1697 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_deleteOp1699 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BEGIN_in_batchStatement1733 = new BitSet(new long[]{0x00000000E0000000L});
    public static final BitSet FOLLOW_K_UNLOGGED_in_batchStatement1743 = new BitSet(new long[]{0x0000000080000000L});
    public static final BitSet FOLLOW_K_COUNTER_in_batchStatement1749 = new BitSet(new long[]{0x0000000080000000L});
    public static final BitSet FOLLOW_K_BATCH_in_batchStatement1762 = new BitSet(new long[]{0x000000000A900000L});
    public static final BitSet FOLLOW_usingClause_in_batchStatement1766 = new BitSet(new long[]{0x000000000A900000L});
    public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement1784 = new BitSet(new long[]{0x000000010A900000L,0x8000000000000000L});
    public static final BitSet FOLLOW_127_in_batchStatement1786 = new BitSet(new long[]{0x000000010A900000L});
    public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement1795 = new BitSet(new long[]{0x000000010A900000L,0x8000000000000000L});
    public static final BitSet FOLLOW_127_in_batchStatement1797 = new BitSet(new long[]{0x000000010A900000L});
    public static final BitSet FOLLOW_K_APPLY_in_batchStatement1811 = new BitSet(new long[]{0x0000000080000000L});
    public static final BitSet FOLLOW_K_BATCH_in_batchStatement1813 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatement_in_batchStatementObjective1844 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_batchStatementObjective1857 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatement_in_batchStatementObjective1870 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createKeyspaceStatement1905 = new BitSet(new long[]{0x0000000400000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_createKeyspaceStatement1907 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_keyspaceName_in_createKeyspaceStatement1911 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_K_WITH_in_createKeyspaceStatement1919 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_properties_in_createKeyspaceStatement1921 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createColumnFamilyStatement1947 = new BitSet(new long[]{0x0000001000000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_createColumnFamilyStatement1949 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnFamilyName_in_createColumnFamilyStatement1953 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_cfamDefinition_in_createColumnFamilyStatement1963 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_128_in_cfamDefinition1982 = new BitSet(new long[]{0xF08097E04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition1984 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_130_in_cfamDefinition1989 = new BitSet(new long[]{0xF08097E04141C040L,0x000000003FFF805FL,0x0000000000000006L});
    public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition1991 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_129_in_cfamDefinition1998 = new BitSet(new long[]{0x0000000800000002L});
    public static final BitSet FOLLOW_K_WITH_in_cfamDefinition2008 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition2010 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_K_AND_in_cfamDefinition2015 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition2017 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_cident_in_cfamColumns2043 = new BitSet(new long[]{0xF08087C045404000L,0x000000003FFF803FL});
    public static final BitSet FOLLOW_comparatorType_in_cfamColumns2047 = new BitSet(new long[]{0x0000002000000002L});
    public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns2052 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_K_KEY_in_cfamColumns2054 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns2066 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_K_KEY_in_cfamColumns2068 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_128_in_cfamColumns2070 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL,0x0000000000000001L});
    public static final BitSet FOLLOW_pkDef_in_cfamColumns2072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_130_in_cfamColumns2076 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_cfamColumns2080 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_129_in_cfamColumns2087 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_pkDef2107 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_128_in_pkDef2117 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_pkDef2123 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_130_in_pkDef2129 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_pkDef2133 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_129_in_pkDef2140 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_property_in_cfamProperty2160 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_COMPACT_in_cfamProperty2169 = new BitSet(new long[]{0x0000010000000000L});
    public static final BitSet FOLLOW_K_STORAGE_in_cfamProperty2171 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CLUSTERING_in_cfamProperty2181 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_K_ORDER_in_cfamProperty2183 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_K_BY_in_cfamProperty2185 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_128_in_cfamProperty2187 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty2189 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_130_in_cfamProperty2193 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty2195 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_129_in_cfamProperty2200 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_cfamOrdering2228 = new BitSet(new long[]{0x00000000000C0000L});
    public static final BitSet FOLLOW_K_ASC_in_cfamOrdering2231 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DESC_in_cfamOrdering2235 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createIndexStatement2273 = new BitSet(new long[]{0x00000C0000000000L});
    public static final BitSet FOLLOW_K_CUSTOM_in_createIndexStatement2276 = new BitSet(new long[]{0x0000080000000000L});
    public static final BitSet FOLLOW_K_INDEX_in_createIndexStatement2282 = new BitSet(new long[]{0x0000300000000000L});
    public static final BitSet FOLLOW_IDENT_in_createIndexStatement2287 = new BitSet(new long[]{0x0000200000000000L});
    public static final BitSet FOLLOW_K_ON_in_createIndexStatement2291 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnFamilyName_in_createIndexStatement2295 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_128_in_createIndexStatement2297 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_createIndexStatement2301 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_129_in_createIndexStatement2303 = new BitSet(new long[]{0x0000000800000002L});
    public static final BitSet FOLLOW_K_WITH_in_createIndexStatement2315 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_properties_in_createIndexStatement2317 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterKeyspaceStatement2361 = new BitSet(new long[]{0x0000000400000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement2363 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_keyspaceName_in_alterKeyspaceStatement2367 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_K_WITH_in_alterKeyspaceStatement2377 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_properties_in_alterKeyspaceStatement2379 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement2415 = new BitSet(new long[]{0x0000001000000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_alterTableStatement2417 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnFamilyName_in_alterTableStatement2421 = new BitSet(new long[]{0x0003400800000000L});
    public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement2435 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement2439 = new BitSet(new long[]{0x0000800000000000L});
    public static final BitSet FOLLOW_K_TYPE_in_alterTableStatement2441 = new BitSet(new long[]{0xF08087C045404000L,0x000000003FFF803FL});
    public static final BitSet FOLLOW_comparatorType_in_alterTableStatement2445 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ADD_in_alterTableStatement2461 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement2467 = new BitSet(new long[]{0xF08087C045404000L,0x000000003FFF803FL});
    public static final BitSet FOLLOW_comparatorType_in_alterTableStatement2471 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_WITH_in_alterTableStatement2505 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_properties_in_alterTableStatement2508 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_RENAME_in_alterTableStatement2541 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement2595 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_K_TO_in_alterTableStatement2597 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement2601 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_K_AND_in_alterTableStatement2622 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement2626 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_K_TO_in_alterTableStatement2628 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement2632 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_K_DROP_in_dropKeyspaceStatement2678 = new BitSet(new long[]{0x0000000400000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement2680 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_keyspaceName_in_dropKeyspaceStatement2684 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropColumnFamilyStatement2709 = new BitSet(new long[]{0x0000001000000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dropColumnFamilyStatement2711 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnFamilyName_in_dropColumnFamilyStatement2715 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropIndexStatement2746 = new BitSet(new long[]{0x0000080000000000L});
    public static final BitSet FOLLOW_K_INDEX_in_dropIndexStatement2748 = new BitSet(new long[]{0x0000100000000000L});
    public static final BitSet FOLLOW_IDENT_in_dropIndexStatement2752 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TRUNCATE_in_truncateStatement2783 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnFamilyName_in_truncateStatement2787 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_GRANT_in_grantStatement2812 = new BitSet(new long[]{0x1C08400200000020L});
    public static final BitSet FOLLOW_permissionOrAll_in_grantStatement2824 = new BitSet(new long[]{0x0000200000000000L});
    public static final BitSet FOLLOW_K_ON_in_grantStatement2832 = new BitSet(new long[]{0xF08097D44141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_resource_in_grantStatement2844 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_K_TO_in_grantStatement2852 = new BitSet(new long[]{0x0000100000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_username_in_grantStatement2864 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_REVOKE_in_revokeStatement2895 = new BitSet(new long[]{0x1C08400200000020L});
    public static final BitSet FOLLOW_permissionOrAll_in_revokeStatement2907 = new BitSet(new long[]{0x0000200000000000L});
    public static final BitSet FOLLOW_K_ON_in_revokeStatement2915 = new BitSet(new long[]{0xF08097D44141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_resource_in_revokeStatement2927 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_K_FROM_in_revokeStatement2935 = new BitSet(new long[]{0x0000100000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_username_in_revokeStatement2947 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_LIST_in_listPermissionsStatement2985 = new BitSet(new long[]{0x1C08400200000020L});
    public static final BitSet FOLLOW_permissionOrAll_in_listPermissionsStatement2997 = new BitSet(new long[]{0x0300200000000002L});
    public static final BitSet FOLLOW_K_ON_in_listPermissionsStatement3007 = new BitSet(new long[]{0xF08097D44141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_resource_in_listPermissionsStatement3009 = new BitSet(new long[]{0x0300000000000002L});
    public static final BitSet FOLLOW_K_OF_in_listPermissionsStatement3024 = new BitSet(new long[]{0x0000100000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_username_in_listPermissionsStatement3026 = new BitSet(new long[]{0x0200000000000002L});
    public static final BitSet FOLLOW_K_NORECURSIVE_in_listPermissionsStatement3041 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_permission3077 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALL_in_permissionOrAll3126 = new BitSet(new long[]{0x2000000000000002L});
    public static final BitSet FOLLOW_K_PERMISSIONS_in_permissionOrAll3130 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_permission_in_permissionOrAll3151 = new BitSet(new long[]{0x4000000000000002L});
    public static final BitSet FOLLOW_K_PERMISSION_in_permissionOrAll3155 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dataResource_in_resource3183 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALL_in_dataResource3206 = new BitSet(new long[]{0x8000000000000000L});
    public static final BitSet FOLLOW_K_KEYSPACES_in_dataResource3208 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_dataResource3218 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_keyspaceName_in_dataResource3224 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dataResource3236 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_columnFamilyName_in_dataResource3245 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createUserStatement3285 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_K_USER_in_createUserStatement3287 = new BitSet(new long[]{0x0000100000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_username_in_createUserStatement3289 = new BitSet(new long[]{0x0000000800000002L,0x0000000000000006L});
    public static final BitSet FOLLOW_K_WITH_in_createUserStatement3299 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_userOptions_in_createUserStatement3301 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000006L});
    public static final BitSet FOLLOW_K_SUPERUSER_in_createUserStatement3315 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_NOSUPERUSER_in_createUserStatement3321 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterUserStatement3366 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_K_USER_in_alterUserStatement3368 = new BitSet(new long[]{0x0000100000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_username_in_alterUserStatement3370 = new BitSet(new long[]{0x0000000800000002L,0x0000000000000006L});
    public static final BitSet FOLLOW_K_WITH_in_alterUserStatement3380 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_userOptions_in_alterUserStatement3382 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000006L});
    public static final BitSet FOLLOW_K_SUPERUSER_in_alterUserStatement3396 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_NOSUPERUSER_in_alterUserStatement3402 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropUserStatement3438 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_K_USER_in_dropUserStatement3440 = new BitSet(new long[]{0x0000100000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_username_in_dropUserStatement3442 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_LIST_in_listUsersStatement3467 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_K_USERS_in_listUsersStatement3469 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_userOption_in_userOptions3489 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_PASSWORD_in_userOption3510 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_userOption3514 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_cident3543 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_NAME_in_cident3568 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_keyword_in_cident3587 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cfOrKsName_in_keyspaceName3620 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cfOrKsName_in_columnFamilyName3654 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_134_in_columnFamilyName3657 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cfOrKsName_in_columnFamilyName3661 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_cfOrKsName3682 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_NAME_in_cfOrKsName3707 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_keyword_in_cfOrKsName3726 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_constant3751 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_constant3763 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOAT_in_constant3782 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BOOLEAN_in_constant3803 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UUID_in_constant3822 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HEXNUMBER_in_constant3844 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_135_in_set_tail3869 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_130_in_set_tail3877 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_set_tail3881 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000084L});
    public static final BitSet FOLLOW_set_tail_in_set_tail3885 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_135_in_map_tail3904 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_130_in_map_tail3912 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_map_tail3916 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_136_in_map_tail3918 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_map_tail3922 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000084L});
    public static final BitSet FOLLOW_map_tail_in_map_tail3926 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_137_in_map_literal3948 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_135_in_map_literal3950 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_137_in_map_literal3960 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_map_literal3976 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_136_in_map_literal3978 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_map_literal3982 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000084L});
    public static final BitSet FOLLOW_map_tail_in_map_literal3986 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_136_in_set_or_map4018 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_set_or_map4022 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000084L});
    public static final BitSet FOLLOW_map_tail_in_set_or_map4026 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_tail_in_set_or_map4039 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_132_in_collection_literal4064 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000231L});
    public static final BitSet FOLLOW_term_in_collection_literal4072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000024L});
    public static final BitSet FOLLOW_130_in_collection_literal4078 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_collection_literal4082 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000024L});
    public static final BitSet FOLLOW_133_in_collection_literal4092 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_137_in_collection_literal4102 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_collection_literal4106 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000184L});
    public static final BitSet FOLLOW_set_or_map_in_collection_literal4110 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_137_in_collection_literal4126 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_135_in_collection_literal4128 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_constant_in_value4153 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collection_literal_in_value4175 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_NULL_in_value4185 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QMARK_in_value4209 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_functionName4249 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_function_keyword_in_functionName4283 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TOKEN_in_functionName4293 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_128_in_functionArgs4338 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_129_in_functionArgs4340 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_128_in_functionArgs4350 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_functionArgs4354 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_130_in_functionArgs4370 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_functionArgs4374 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_129_in_functionArgs4388 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_value_in_term4413 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_functionName_in_term4450 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_functionArgs_in_term4454 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_128_in_term4464 = new BitSet(new long[]{0xF08087C045404000L,0x000000003FFF803FL});
    public static final BitSet FOLLOW_comparatorType_in_term4468 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_129_in_term4470 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_term4474 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation4497 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_138_in_columnOperation4499 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_columnOperation4503 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_139_in_columnOperation4506 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_columnOperation4510 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation4531 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_138_in_columnOperation4533 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_columnOperation4537 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001800L});
    public static final BitSet FOLLOW_set_in_columnOperation4541 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_columnOperation4551 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation4569 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_138_in_columnOperation4571 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_columnOperation4575 = new BitSet(new long[]{0x0000000000001000L});
    public static final BitSet FOLLOW_INTEGER_in_columnOperation4579 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation4597 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_132_in_columnOperation4599 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_columnOperation4603 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_columnOperation4605 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_138_in_columnOperation4607 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_columnOperation4611 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_property_in_properties4637 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_K_AND_in_properties4641 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_property_in_properties4643 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_cident_in_property4666 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_138_in_property4668 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFF87FFL,0x0000000000000200L});
    public static final BitSet FOLLOW_propertyValue_in_property4673 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_map_literal_in_property4702 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_constant_in_propertyValue4730 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_keyword_in_propertyValue4752 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_138_in_relationType4775 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_relationType4786 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_142_in_relationType4797 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_143_in_relationType4807 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_144_in_relationType4818 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_relation4840 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000001E400L});
    public static final BitSet FOLLOW_relationType_in_relation4844 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_relation4848 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TOKEN_in_relation4858 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_128_in_relation4881 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_relation4885 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_130_in_relation4891 = new BitSet(new long[]{0xF08097C04141C040L,0x000000003FFF805FL});
    public static final BitSet FOLLOW_cident_in_relation4895 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_129_in_relation4901 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x000000000001E400L});
    public static final BitSet FOLLOW_relationType_in_relation4913 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_relation4917 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_relation4937 = new BitSet(new long[]{0x0000000000000000L,0x0000000000004000L});
    public static final BitSet FOLLOW_K_IN_in_relation4939 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000001L});
    public static final BitSet FOLLOW_128_in_relation4950 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_relation4954 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_130_in_relation4959 = new BitSet(new long[]{0xF08097C04141D040L,0x000000003FFFBFFFL,0x0000000000000211L});
    public static final BitSet FOLLOW_term_in_relation4963 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000006L});
    public static final BitSet FOLLOW_129_in_relation4970 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_native_type_in_comparatorType4995 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collection_type_in_comparatorType5011 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_comparatorType5023 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ASCII_in_native_type5052 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BIGINT_in_native_type5066 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BLOB_in_native_type5079 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BOOLEAN_in_native_type5094 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_COUNTER_in_native_type5106 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DECIMAL_in_native_type5118 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DOUBLE_in_native_type5130 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_FLOAT_in_native_type5143 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_INET_in_native_type5157 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_INT_in_native_type5172 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TEXT_in_native_type5188 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TIMESTAMP_in_native_type5203 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_UUID_in_native_type5213 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_VARCHAR_in_native_type5228 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_VARINT_in_native_type5240 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TIMEUUID_in_native_type5253 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_MAP_in_collection_type5277 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_collection_type5280 = new BitSet(new long[]{0xF08087C045404000L,0x000000003FFF803FL});
    public static final BitSet FOLLOW_comparatorType_in_collection_type5284 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
    public static final BitSet FOLLOW_130_in_collection_type5286 = new BitSet(new long[]{0xF08087C045404000L,0x000000003FFF803FL});
    public static final BitSet FOLLOW_comparatorType_in_collection_type5290 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_collection_type5292 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_LIST_in_collection_type5310 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_collection_type5312 = new BitSet(new long[]{0xF08087C045404000L,0x000000003FFF803FL});
    public static final BitSet FOLLOW_comparatorType_in_collection_type5316 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_collection_type5318 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_SET_in_collection_type5336 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_collection_type5339 = new BitSet(new long[]{0xF08087C045404000L,0x000000003FFF803FL});
    public static final BitSet FOLLOW_comparatorType_in_collection_type5343 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_collection_type5345 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_username0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_function_keyword_in_unreserved_keyword5403 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_unreserved_keyword5419 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_unreserved_function_keyword5454 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_native_type_in_unreserved_function_keyword5694 = new BitSet(new long[]{0x0000000000000002L});

}