/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.turbojpeg;

import it.geosolutions.imageio.plugins.turbojpeg.TurboJpegUtilities;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.libjpegturbo.turbojpeg.TJDecompressor;

public class TurboJpegImageReader
extends ImageReader {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.turbojpeg");
    private int INITIAL_JPG_BUFFER_SIZE = 0x100000;
    private static final int DEFAULT_READ_BUFFER_SIZE = 4096;
    private int width = -1;
    private int height = -1;
    private byte[] data = null;
    private ImageInputStream iis = null;
    private static int EXTERNAL_FLAGS = -1;
    private int flags = 256;
    private int subsamp;
    private static final List<ImageTypeSpecifier> FIXEDIMGETYPES;

    public TurboJpegImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.width;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.height;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return FIXEDIMGETYPES.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        if (this.data == null) {
            throw new IllegalArgumentException("Missing data array");
        }
        BufferedImage bi = new BufferedImage(this.width, this.height, this.subsamp == 3 ? 10 : 5);
        TJDecompressor decompressor = null;
        try {
            decompressor = new TJDecompressor(this.data, this.data.length);
            decompressor.decompress(bi, this.flags);
        }
        catch (Exception e) {
            throw new IOException("Exception while decompressing:", e);
        }
        finally {
            block12: {
                if (decompressor != null) {
                    try {
                        decompressor.close();
                        decompressor = null;
                    }
                    catch (Exception ex) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block12;
                        LOGGER.fine("Exception occurred while closing the decompressor: " + ex.getLocalizedMessage());
                    }
                }
            }
        }
        return bi;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.reset();
        this.ignoreMetadata = ignoreMetadata;
        TJDecompressor decompressor = null;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting input");
        }
        if (input instanceof ImageInputStream) {
            this.iis = (ImageInputStream)input;
        }
        try {
            if (input instanceof byte[]) {
                this.data = (byte[])input;
            } else {
                if (this.iis == null) {
                    throw new NullPointerException("The provided input is null!");
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream(this.INITIAL_JPG_BUFFER_SIZE);
                byte[] buffer = new byte[4096];
                int n = 0;
                while (-1 != (n = this.iis.read(buffer))) {
                    baos.write(buffer, 0, n);
                }
                this.data = baos.toByteArray();
            }
            this.flags = EXTERNAL_FLAGS > 0 ? EXTERNAL_FLAGS : this.flags;
            decompressor = new TJDecompressor();
            decompressor.setJPEGImage(this.data, this.data.length);
            this.width = decompressor.getWidth();
            this.height = decompressor.getHeight();
            this.subsamp = decompressor.getSubsamp();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating jpegturbo decompressor: " + ex.getMessage(), ex);
        }
        finally {
            if (decompressor != null) {
                try {
                    decompressor.close();
                    decompressor = null;
                }
                catch (Exception ex) {}
            }
        }
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    @Override
    public void reset() {
        super.setInput(null, false, false);
        this.dispose();
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("ImageIndex out of bound: " + imageIndex);
        }
    }

    @Override
    public void dispose() {
        if (this.data != null) {
            this.data = null;
        }
    }

    protected static String toString(ImageReadParam param) {
        StringBuilder sb = new StringBuilder();
        if (param == null) {
            sb.append("ImageReadParam is null");
        } else {
            BufferedImage bi;
            sb.append(param.getClass().getSimpleName()).append('[');
            sb.append(" srcXsub:").append(param.getSourceXSubsampling());
            sb.append(" srcYsub:").append(param.getSourceYSubsampling());
            sb.append(" subXoff:").append(param.getSubsamplingXOffset());
            sb.append(" subYoff:").append(param.getSubsamplingYOffset());
            sb.append(" srcRegion:").append(param.getSourceRegion());
            sb.append(" destOff:").append(param.getDestinationOffset());
            ImageTypeSpecifier its = param.getDestinationType();
            if (its != null) {
                sb.append(" its:").append(its.getSampleModel());
                if (its.getSampleModel() != null) {
                    sb.append(" its.sm.datatype:").append(its.getSampleModel().getDataType());
                    sb.append(" its.sm.numbands:").append(its.getSampleModel().getNumBands());
                }
            }
            if ((bi = param.getDestination()) != null) {
                sb.append(" bi.sm:").append(bi.getSampleModel());
                if (bi.getSampleModel() != null) {
                    sb.append(" bi.sm.datatype:").append(bi.getSampleModel().getDataType());
                    sb.append(" bi.sm.numbands:").append(bi.getSampleModel().getNumBands());
                }
            }
            sb.append(']');
        }
        return sb.toString();
    }

    static {
        String flagsProp = System.getProperty("it.geosolutions.imageio.plugins.turbojpeg.flags");
        if (flagsProp != null) {
            String[] tjFlags = flagsProp.split(",");
            EXTERNAL_FLAGS = 0;
            for (String tjFlag : tjFlags) {
                EXTERNAL_FLAGS |= TurboJpegUtilities.getTurboJpegFlag(tjFlag);
            }
        }
        FIXEDIMGETYPES = Collections.unmodifiableList(Arrays.asList(ImageTypeSpecifier.createFromBufferedImageType(1), ImageTypeSpecifier.createFromBufferedImageType(2), ImageTypeSpecifier.createFromBufferedImageType(5), ImageTypeSpecifier.createFromBufferedImageType(6), ImageTypeSpecifier.createFromBufferedImageType(10)));
    }
}

