/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;

public class GenericWhitespaceCheck
extends Check {
    private int mDepth;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{172, 173};
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.mDepth = 0;
    }

    @Override
    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 172) {
            this.processStart(aAST);
            ++this.mDepth;
        } else if (aAST.getType() == 173) {
            this.processEnd(aAST);
            --this.mDepth;
        }
    }

    private void processEnd(DetailAST aAST) {
        String line = this.getLine(aAST.getLineNo() - 1);
        int before = aAST.getColumnNo() - 1;
        int after = aAST.getColumnNo() + 1;
        if (0 <= before && Character.isWhitespace(line.charAt(before)) && !Utils.whitespaceBefore(before, line)) {
            this.log(aAST.getLineNo(), before, "ws.preceded", ">");
        }
        if (after < line.length()) {
            if (1 == this.mDepth) {
                char charAfter = line.charAt(after);
                if (aAST.getParent().getType() == 163 && aAST.getParent().getParent().getType() == 59 && aAST.getParent().getParent().getParent().getType() == 27) {
                    if (Character.isWhitespace(charAfter)) {
                        this.log(aAST.getLineNo(), after, "ws.followed", ">");
                    }
                } else if (!Character.isWhitespace(charAfter) && '(' != charAfter && ')' != charAfter && ',' != charAfter && '[' != charAfter && '.' != charAfter && ':' != charAfter) {
                    this.log(aAST.getLineNo(), after, "ws.illegalFollow", ">");
                }
            } else {
                int indexOfAmp = line.indexOf(38, after);
                if (indexOfAmp != -1 && GenericWhitespaceCheck.whitespaceBetween(after, indexOfAmp, line)) {
                    if (indexOfAmp - after == 0) {
                        this.log(aAST.getLineNo(), after, "ws.notPreceded", "&");
                    } else if (indexOfAmp - after != 1) {
                        this.log(aAST.getLineNo(), after, "ws.followed", ">");
                    }
                } else if (line.charAt(after) == ' ') {
                    this.log(aAST.getLineNo(), after, "ws.followed", ">");
                }
            }
        }
    }

    private void processStart(DetailAST aAST) {
        String line = this.getLine(aAST.getLineNo() - 1);
        int before = aAST.getColumnNo() - 1;
        int after = aAST.getColumnNo() + 1;
        if (0 <= before) {
            DetailAST parent = aAST.getParent();
            DetailAST grandparent = parent.getParent();
            if (165 == parent.getType() && (8 == grandparent.getType() || 9 == grandparent.getType())) {
                if (!Character.isWhitespace(line.charAt(before))) {
                    this.log(aAST.getLineNo(), before, "ws.notPreceded", "<");
                }
            } else if (Character.isWhitespace(line.charAt(before)) && !Utils.whitespaceBefore(before, line)) {
                this.log(aAST.getLineNo(), before, "ws.preceded", "<");
            }
        }
        if (after < line.length() && Character.isWhitespace(line.charAt(after))) {
            this.log(aAST.getLineNo(), after, "ws.followed", "<");
        }
    }

    private static boolean whitespaceBetween(int aFromIndex, int aToIndex, String aLine) {
        for (int i = aFromIndex; i < aToIndex; ++i) {
            if (Character.isWhitespace(aLine.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

