/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;

public class LineWrappingHandler {
    private final IndentationCheck mIndentCheck;
    private DetailAST mFirstNode;
    private DetailAST mLastNode;
    private int mIndentLevel;

    public LineWrappingHandler(IndentationCheck aInstance, DetailAST aFirstNode) {
        this.mIndentCheck = aInstance;
        this.mFirstNode = aFirstNode;
        this.mLastNode = this.findLastNode(this.mFirstNode);
        this.mIndentLevel = this.mIndentCheck.getLineWrappingIndentation();
    }

    public DetailAST findLastNode(DetailAST aFirstNode) {
        return aFirstNode.getLastChild().getPreviousSibling();
    }

    public int getCurrentIndentation() {
        return this.mFirstNode.getColumnNo() + this.mIndentLevel;
    }

    public final DetailAST getFirstNode() {
        return this.mFirstNode;
    }

    public final DetailAST getLastNode() {
        return this.mLastNode;
    }

    public final int getIndentLevel() {
        return this.mIndentLevel;
    }

    public void checkIndentation() {
        NavigableMap<Integer, DetailAST> firstNodesOnLines = this.collectFirstNodes();
        DetailAST firstNode = (DetailAST)((Object)firstNodesOnLines.get(firstNodesOnLines.firstKey()));
        if (firstNode.getType() == 170) {
            this.checkAnnotationIndentation(firstNode, firstNodesOnLines);
        }
        firstNodesOnLines.remove(firstNodesOnLines.firstKey());
        int firstNodeIndent = this.getFirstNodeIndent(firstNode);
        int currentIndent = firstNodeIndent + this.mIndentLevel;
        for (DetailAST node : firstNodesOnLines.values()) {
            int currentType = node.getType();
            if (currentType == 73 || currentType == 77 || currentType == 29) {
                this.logWarningMessage(node, firstNodeIndent);
                continue;
            }
            if (currentType == 83) {
                DetailAST parent = node.getParent();
                if (parent.getType() != 92) continue;
                this.logWarningMessage(parent, currentIndent);
                continue;
            }
            this.logWarningMessage(node, currentIndent);
        }
    }

    private int getFirstNodeIndent(DetailAST aNode) {
        int indentLevel = aNode.getColumnNo();
        if (aNode.getType() == 83 && aNode.getParent().getType() == 92) {
            DetailAST lcurly = aNode.getParent().getPreviousSibling();
            DetailAST rcurly = lcurly.getLastChild();
            indentLevel = lcurly.getType() == 7 && rcurly.getLineNo() == aNode.getLineNo() ? rcurly.getColumnNo() : aNode.getParent().getColumnNo();
        }
        return indentLevel;
    }

    private NavigableMap<Integer, DetailAST> collectFirstNodes() {
        TreeMap<Integer, DetailAST> result = new TreeMap<Integer, DetailAST>();
        result.put(this.mFirstNode.getLineNo(), this.mFirstNode);
        DetailAST curNode = this.mFirstNode.getFirstChild();
        while (curNode != null && curNode != this.mLastNode) {
            if (curNode.getType() == 6) {
                curNode = curNode.getNextSibling();
            }
            if (curNode == null) continue;
            DetailAST firstTokenOnLine = (DetailAST)((Object)result.get(curNode.getLineNo()));
            if (firstTokenOnLine == null || firstTokenOnLine != null && firstTokenOnLine.getColumnNo() >= curNode.getColumnNo()) {
                result.put(curNode.getLineNo(), curNode);
            }
            curNode = this.getNextCurNode(curNode);
        }
        return result;
    }

    private DetailAST getNextCurNode(DetailAST aCurNode) {
        DetailAST nodeToVisit = aCurNode.getFirstChild();
        DetailAST currentNode = aCurNode;
        while (currentNode != null && nodeToVisit == null) {
            nodeToVisit = currentNode.getNextSibling();
            if (nodeToVisit != null) continue;
            currentNode = currentNode.getParent();
        }
        return nodeToVisit;
    }

    private void checkAnnotationIndentation(DetailAST aAtNode, NavigableMap<Integer, DetailAST> aFirstNodesOnLines) {
        DetailAST node;
        int currentIndent = aAtNode.getColumnNo() + this.mIndentLevel;
        int firstNodeIndent = aAtNode.getColumnNo();
        Collection values = aFirstNodesOnLines.values();
        DetailAST lastAnnotationNode = this.getLastAnnotationNode(aAtNode);
        int lastAnnotationLine = lastAnnotationNode.getLineNo();
        int lastAnnotattionColumn = lastAnnotationNode.getColumnNo();
        Iterator itr = values.iterator();
        while (itr.hasNext() && aFirstNodesOnLines.size() > 1 && ((node = (DetailAST)((Object)itr.next())).getLineNo() < lastAnnotationLine || node.getLineNo() == lastAnnotationLine && node.getColumnNo() <= lastAnnotattionColumn)) {
            DetailAST parentNode = node.getParent();
            if (node.getType() == 170 && parentNode.getParent().getType() == 5) {
                this.logWarningMessage(node, firstNodeIndent);
            } else {
                this.logWarningMessage(node, currentIndent);
            }
            itr.remove();
        }
    }

    private DetailAST getLastAnnotationNode(DetailAST aAtNode) {
        DetailAST lastAnnotation = aAtNode.getParent();
        while (lastAnnotation.getNextSibling() != null && lastAnnotation.getNextSibling().getType() == 159) {
            lastAnnotation = lastAnnotation.getNextSibling();
        }
        return lastAnnotation.getLastChild();
    }

    private void logWarningMessage(DetailAST aCurrentNode, int aCurrentIndent) {
        if (aCurrentNode.getColumnNo() < aCurrentIndent) {
            this.mIndentCheck.indentationLog(aCurrentNode.getLineNo(), "indentation.error", aCurrentNode.getText(), aCurrentNode.getColumnNo(), aCurrentIndent);
        }
    }
}

