/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;

class Guard {
    private final boolean mAllowed;
    private final String mPkgName;
    private final String mClassName;
    private final boolean mExactMatch;
    private final boolean mLocalOnly;
    private final boolean mRegExp;

    Guard(boolean aAllow, boolean aLocalOnly, String aPkgName, boolean aExactMatch, boolean aRegExp) {
        this.mAllowed = aAllow;
        this.mLocalOnly = aLocalOnly;
        this.mPkgName = aPkgName;
        this.mRegExp = aRegExp;
        this.mClassName = null;
        this.mExactMatch = aExactMatch;
    }

    Guard(boolean aAllow, boolean aLocalOnly, String aClassName, boolean aRegExp) {
        this.mAllowed = aAllow;
        this.mLocalOnly = aLocalOnly;
        this.mRegExp = aRegExp;
        this.mPkgName = null;
        this.mClassName = aClassName;
        this.mExactMatch = true;
    }

    AccessResult verifyImport(String aForImport) {
        boolean pkgMatch;
        assert (aForImport != null);
        if (this.mClassName != null) {
            boolean classMatch = this.mRegExp ? aForImport.matches(this.mClassName) : aForImport.equals(this.mClassName);
            return this.calculateResult(classMatch);
        }
        assert (this.mPkgName != null);
        if (this.mRegExp) {
            pkgMatch = aForImport.matches(this.mPkgName + "\\..*");
            if (pkgMatch && this.mExactMatch) {
                pkgMatch = !aForImport.matches(this.mPkgName + "\\..*\\..*");
            }
        } else {
            pkgMatch = aForImport.startsWith(this.mPkgName + ".");
            if (pkgMatch && this.mExactMatch) {
                pkgMatch = aForImport.indexOf(46, this.mPkgName.length() + 1) == -1;
            }
        }
        return this.calculateResult(pkgMatch);
    }

    boolean isLocalOnly() {
        return this.mLocalOnly;
    }

    private AccessResult calculateResult(boolean aMatched) {
        if (aMatched) {
            return this.mAllowed ? AccessResult.ALLOWED : AccessResult.DISALLOWED;
        }
        return AccessResult.UNKNOWN;
    }
}

