/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class SimplifyBooleanReturnCheck
extends Check {
    @Override
    public int[] getDefaultTokens() {
        return new int[]{83};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST elseLiteral = aAST.findFirstToken(92);
        if (elseLiteral == null) {
            return;
        }
        AST elseStatement = elseLiteral.getFirstChild();
        DetailAST condition = aAST.getFirstChild().getNextSibling();
        AST thenStatement = condition.getNextSibling().getNextSibling();
        if (SimplifyBooleanReturnCheck.returnsOnlyBooleanLiteral(thenStatement) && SimplifyBooleanReturnCheck.returnsOnlyBooleanLiteral(elseStatement)) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "simplify.boolreturn", new Object[0]);
        }
    }

    private static boolean returnsOnlyBooleanLiteral(AST aAST) {
        if (SimplifyBooleanReturnCheck.isBooleanLiteralReturnStatement(aAST)) {
            return true;
        }
        AST firstStmnt = aAST.getFirstChild();
        return SimplifyBooleanReturnCheck.isBooleanLiteralReturnStatement(firstStmnt);
    }

    private static boolean isBooleanLiteralReturnStatement(AST aAST) {
        if (aAST == null || aAST.getType() != 88) {
            return false;
        }
        AST expr = aAST.getFirstChild();
        if (expr == null || expr.getType() == 45) {
            return false;
        }
        AST value = expr.getFirstChild();
        return SimplifyBooleanReturnCheck.isBooleanLiteralType(value.getType());
    }

    private static boolean isBooleanLiteralType(int aTokenType) {
        boolean isTrue = aTokenType == 133;
        boolean isFalse = aTokenType == 134;
        return isTrue || isFalse;
    }
}

