/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class EqualsAvoidNullCheck
extends Check {
    private boolean mIgnoreEqualsIgnoreCase;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{27};
    }

    @Override
    public void visitToken(DetailAST aMethodCall) {
        DetailAST dot = aMethodCall.getFirstChild();
        if (dot.getType() != 59) {
            return;
        }
        DetailAST objCalledOn = dot.getFirstChild();
        if (objCalledOn.getType() == 139 || objCalledOn.getType() == 136 || objCalledOn.getType() == 59) {
            return;
        }
        DetailAST method = objCalledOn.getNextSibling();
        DetailAST expr = dot.getNextSibling().getFirstChild();
        if ("equals".equals(method.getText()) && this.containsOneArg((AST)expr) && this.containsAllSafeTokens(expr)) {
            this.log(aMethodCall.getLineNo(), aMethodCall.getColumnNo(), "equals.avoid.null", new Object[0]);
        }
        if (!this.mIgnoreEqualsIgnoreCase && "equalsIgnoreCase".equals(method.getText()) && this.containsOneArg((AST)expr) && this.containsAllSafeTokens(expr)) {
            this.log(aMethodCall.getLineNo(), aMethodCall.getColumnNo(), "equalsIgnoreCase.avoid.null", new Object[0]);
        }
    }

    private boolean containsNoArgs(AST aExpr) {
        return aExpr == null;
    }

    private boolean containsMultiArgs(AST aExpr) {
        AST comma = aExpr.getNextSibling();
        return comma != null && comma.getType() == 74;
    }

    private boolean containsOneArg(AST aExpr) {
        return !this.containsNoArgs(aExpr) && !this.containsMultiArgs(aExpr);
    }

    private boolean containsAllSafeTokens(DetailAST aExpr) {
        DetailAST arg = aExpr.getFirstChild();
        if (arg.branchContains(27)) {
            return false;
        }
        return !(arg = this.skipVariableAssign(arg)).branchContains(98) && !arg.branchContains(58);
    }

    private DetailAST skipVariableAssign(DetailAST aCurrentAST) {
        if (aCurrentAST.getType() == 80 && aCurrentAST.getFirstChild().getType() == 58) {
            return aCurrentAST.getFirstChild().getNextSibling();
        }
        return aCurrentAST;
    }

    public void setIgnoreEqualsIgnoreCase(boolean aNewValue) {
        this.mIgnoreEqualsIgnoreCase = aNewValue;
    }
}

