/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;

public class DeclarationOrderCheck
extends Check {
    private static final int STATE_STATIC_VARIABLE_DEF = 1;
    private static final int STATE_INSTANCE_VARIABLE_DEF = 2;
    private static final int STATE_CTOR_DEF = 3;
    private static final int STATE_METHOD_DEF = 4;
    private final FastStack<ScopeState> mScopeStates = FastStack.newInstance();
    private boolean mIgnoreConstructors;
    private boolean mIgnoreMethods;
    private boolean mIgnoreModifiers;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 5, 6};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        int parentType = aAST.getParent().getType();
        switch (aAST.getType()) {
            case 6: {
                this.mScopeStates.push(new ScopeState());
                break;
            }
            case 8: {
                if (parentType != 6) {
                    return;
                }
                ScopeState state = this.mScopeStates.peek();
                if (state.mScopeState > 3) {
                    if (this.mIgnoreConstructors) break;
                    this.log(aAST, "declaration.order.constructor", new Object[0]);
                    break;
                }
                state.mScopeState = 3;
                break;
            }
            case 9: {
                ScopeState state = this.mScopeStates.peek();
                if (parentType != 6) {
                    return;
                }
                if (state.mScopeState > 4) {
                    if (this.mIgnoreMethods) break;
                    this.log(aAST, "declaration.order.method", new Object[0]);
                    break;
                }
                state.mScopeState = 4;
                break;
            }
            case 5: {
                if (parentType != 10 || aAST.getParent().getParent().getType() != 6) {
                    return;
                }
                ScopeState state = this.mScopeStates.peek();
                if (aAST.findFirstToken(64) != null) {
                    if (state.mScopeState > 1) {
                        if (!this.mIgnoreModifiers || state.mScopeState > 2) {
                            this.log(aAST, "declaration.order.static", new Object[0]);
                        }
                    } else {
                        state.mScopeState = 1;
                    }
                } else if (state.mScopeState > 2) {
                    this.log(aAST, "declaration.order.instance", new Object[0]);
                } else if (state.mScopeState == 1) {
                    state.mDeclarationAccess = Scope.PUBLIC;
                    state.mScopeState = 2;
                }
                Scope access = ScopeUtils.getScopeFromMods(aAST);
                if (state.mDeclarationAccess.compareTo(access) > 0) {
                    if (this.mIgnoreModifiers) break;
                    this.log(aAST, "declaration.order.access", new Object[0]);
                    break;
                }
                state.mDeclarationAccess = access;
                break;
            }
        }
    }

    @Override
    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 6: {
                this.mScopeStates.pop();
                break;
            }
        }
    }

    public void setIgnoreConstructors(boolean aIgnoreConstructors) {
        this.mIgnoreConstructors = aIgnoreConstructors;
    }

    public void setIgnoreMethods(boolean aIgnoreMethods) {
        this.mIgnoreMethods = aIgnoreMethods;
    }

    public void setIgnoreModifiers(boolean aIgnoreModifiers) {
        this.mIgnoreModifiers = aIgnoreModifiers;
    }

    private static class ScopeState {
        private int mScopeState = 1;
        private Scope mDeclarationAccess = Scope.PUBLIC;

        private ScopeState() {
        }
    }
}

