/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MissingDeprecatedCheck
extends Check {
    private static final String DEPRECATED = "Deprecated";
    private static final String FQ_DEPRECATED = "java.lang.Deprecated";
    private static final Pattern MATCH_DEPRECATED = Utils.createPattern("@(deprecated)\\s+\\S");
    private static final Pattern MATCH_DEPRECATED_MULTILINE_START = Utils.createPattern("@(deprecated)\\s*$");
    private static final Pattern MATCH_DEPRECATED_MULTILINE_CONT = Utils.createPattern("(\\*/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 157, 154, 9, 8, 10, 155, 161};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        boolean containsJavadocTag;
        TextBlock javadoc = this.getFileContents().getJavadocBefore(aAST.getLineNo());
        boolean containsAnnotation = AnnotationUtility.containsAnnotation(aAST, DEPRECATED) || AnnotationUtility.containsAnnotation(aAST, FQ_DEPRECATED);
        if (containsAnnotation ^ (containsJavadocTag = this.containsJavadocTag(javadoc))) {
            this.log(aAST.getLineNo(), "annotation.missing.deprecated", new Object[0]);
        }
    }

    private boolean containsJavadocTag(TextBlock aJavadoc) {
        if (aJavadoc == null) {
            return false;
        }
        String[] lines = aJavadoc.getText();
        boolean found = false;
        int currentLine = aJavadoc.getStartLineNo() - 1;
        for (int i = 0; i < lines.length; ++i) {
            ++currentLine;
            String line = lines[i];
            Matcher javadocNoargMatcher = MATCH_DEPRECATED.matcher(line);
            Matcher noargMultilineStart = MATCH_DEPRECATED_MULTILINE_START.matcher(line);
            if (javadocNoargMatcher.find()) {
                if (found) {
                    this.log(currentLine, "javadoc.duplicateTag", JavadocTagInfo.DEPRECATED.getText());
                }
                found = true;
                continue;
            }
            if (!noargMultilineStart.find()) continue;
            for (int remIndex = i + 1; remIndex < lines.length; ++remIndex) {
                Matcher multilineCont = MATCH_DEPRECATED_MULTILINE_CONT.matcher(lines[remIndex]);
                if (!multilineCont.find()) continue;
                remIndex = lines.length;
                String lFin = multilineCont.group(1);
                if (!lFin.equals(NEXT_TAG) && !lFin.equals(END_JAVADOC)) {
                    if (found) {
                        this.log(currentLine, "javadoc.duplicateTag", JavadocTagInfo.DEPRECATED.getText());
                    }
                    found = true;
                    continue;
                }
                this.log(currentLine, "javadoc.missing", new Object[0]);
                if (found) {
                    this.log(currentLine, "javadoc.duplicateTag", JavadocTagInfo.DEPRECATED.getText());
                }
                found = true;
            }
        }
        return found;
    }
}

