/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Pattern;

public class TodoCommentCheck
extends Check {
    private String mFormat = "TODO:";
    private Pattern mRegexp = Pattern.compile(this.mFormat);

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    public void setFormat(String aFormat) {
        this.mFormat = aFormat;
        this.mRegexp = Pattern.compile(aFormat);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{183};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        String[] lines = aAST.getText().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!this.mRegexp.matcher(lines[i]).find()) continue;
            this.log(aAST.getLineNo() + i, "todo.match", this.mFormat);
        }
    }
}

