/*
 * Decompiled with CFR 0.152.
 */
package com.github.goldin.org.apache.tools.ant.taskdefs.optional.net;

import com.github.goldin.org.apache.tools.ant.taskdefs.optional.net.FTPClient;
import com.github.goldin.org.apache.tools.ant.taskdefs.optional.net.FTPConfigurator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.RetryHandler;
import org.apache.tools.ant.util.Retryable;
import org.apache.tools.ant.util.VectorSet;

public class FTP
extends Task {
    protected static final int SEND_FILES = 0;
    protected static final int GET_FILES = 1;
    protected static final int DEL_FILES = 2;
    protected static final int LIST_FILES = 3;
    protected static final int MK_DIR = 4;
    protected static final int CHMOD = 5;
    protected static final int RM_DIR = 6;
    protected static final int SITE_CMD = 7;
    private static final int CODE_521 = 521;
    private static final long GRANULARITY_MINUTE = 60000L;
    private static final SimpleDateFormat TIMESTAMP_LOGGING_SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final int DEFAULT_FTP_PORT = 21;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private String remotedir;
    private String server;
    private String userid;
    private String password;
    private String account;
    private File listing;
    private boolean listingFullPath = false;
    private boolean listingAppend = false;
    private boolean binary = true;
    private boolean passive = false;
    private boolean verbose = false;
    private boolean newerOnly = false;
    private long timeDiffMillis = 0L;
    private long granularityMillis = 0L;
    private boolean timeDiffAuto = false;
    private int action = 0;
    private Vector filesets = new Vector();
    private Set dirCache = new HashSet();
    private int transferred = 0;
    private String remoteFileSep = "/";
    private int port = 21;
    private boolean skipFailedTransfers = false;
    private int skipped = 0;
    private boolean ignoreNoncriticalErrors = false;
    private boolean preserveLastModified = false;
    private String chmod = null;
    private String umask = null;
    private FTPSystemType systemTypeKey = FTPSystemType.getDefault();
    private String defaultDateFormatConfig = null;
    private String recentDateFormatConfig = null;
    private LanguageCode serverLanguageCodeConfig = LanguageCode.getDefault();
    private String serverTimeZoneConfig = null;
    private String shortMonthNamesConfig = null;
    private Granularity timestampGranularity = Granularity.getDefault();
    private boolean isConfigurationSet = false;
    private int retriesAllowed = 0;
    private String siteCommand = null;
    private String initialSiteCommand = null;
    private boolean enableRemoteVerification = true;
    protected static final String[] ACTION_STRS = new String[]{"sending", "getting", "deleting", "listing", "making directory", "chmod", "removing", "site"};
    protected static final String[] COMPLETED_ACTION_STRS = new String[]{"sent", "retrieved", "deleted", "listed", "created directory", "mode changed", "removed", "site command executed"};
    protected static final String[] ACTION_TARGET_STRS = new String[]{"files", "files", "files", "files", "directory", "files", "directories", "site command"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFunctioningAsDirectory(org.apache.commons.net.ftp.FTPClient ftp, String dir, FTPFile file) {
        boolean result;
        block13: {
            result = false;
            String currentWorkingDir = null;
            if (file.isDirectory()) {
                return true;
            }
            if (file.isFile()) {
                return false;
            }
            try {
                currentWorkingDir = ftp.printWorkingDirectory();
            }
            catch (IOException ioe) {
                this.getProject().log("could not find current working directory " + dir + " while checking a symlink", 4);
            }
            if (currentWorkingDir != null) {
                try {
                    result = ftp.changeWorkingDirectory(file.getLink());
                }
                catch (IOException ioe) {
                    this.getProject().log("could not cd to " + file.getLink() + " while checking a symlink", 4);
                }
                if (result) {
                    boolean comeback = false;
                    try {
                        comeback = ftp.changeWorkingDirectory(currentWorkingDir);
                    }
                    catch (IOException ioe) {
                        this.getProject().log("could not cd back to " + dir + " while checking a symlink", 0);
                    }
                    finally {
                        if (comeback) break block13;
                        throw new BuildException("could not cd back to " + dir + " while checking a symlink");
                    }
                }
            }
        }
        return result;
    }

    private boolean isFunctioningAsFile(org.apache.commons.net.ftp.FTPClient ftp, String dir, FTPFile file) {
        if (file.isDirectory()) {
            return false;
        }
        if (file.isFile()) {
            return true;
        }
        return !this.isFunctioningAsDirectory(ftp, dir, file);
    }

    public void setRemotedir(String dir) {
        this.remotedir = dir;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAccount(String pAccount) {
        this.account = pAccount;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNewer(boolean newer) {
        this.newerOnly = newer;
    }

    public void setTimeDiffMillis(long timeDiffMillis) {
        this.timeDiffMillis = timeDiffMillis;
    }

    public void setTimeDiffAuto(boolean timeDiffAuto) {
        this.timeDiffAuto = timeDiffAuto;
    }

    public void setPreserveLastModified(boolean preserveLastModified) {
        this.preserveLastModified = preserveLastModified;
    }

    public void setDepends(boolean depends) {
        this.newerOnly = depends;
    }

    public void setSeparator(String separator) {
        this.remoteFileSep = separator;
    }

    public void setChmod(String theMode) {
        this.chmod = theMode;
    }

    public void setUmask(String theUmask) {
        this.umask = theUmask;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setAction(String action) throws BuildException {
        this.log("DEPRECATED - The setAction(String) method has been deprecated. Use setAction(FTP.Action) instead.");
        Action a = new Action();
        a.setValue(action);
        this.action = a.getAction();
    }

    public void setAction(Action action) throws BuildException {
        this.action = action.getAction();
    }

    public void setListing(File listing) {
        this.listing = listing;
    }

    public void setListingFullPath(boolean listingFullPath) {
        this.listingFullPath = listingFullPath;
    }

    public void setListingAppend(boolean listingAppend) {
        this.listingAppend = listingAppend;
    }

    public void setSkipFailedTransfers(boolean skipFailedTransfers) {
        this.skipFailedTransfers = skipFailedTransfers;
    }

    public void setIgnoreNoncriticalErrors(boolean ignoreNoncriticalErrors) {
        this.ignoreNoncriticalErrors = ignoreNoncriticalErrors;
    }

    private void configurationHasBeenSet() {
        this.isConfigurationSet = true;
    }

    public void setSystemTypeKey(FTPSystemType systemKey) {
        if (systemKey != null && !systemKey.getValue().equals("")) {
            this.systemTypeKey = systemKey;
            this.configurationHasBeenSet();
        }
    }

    public void setDefaultDateFormatConfig(String defaultDateFormat) {
        if (defaultDateFormat != null && !defaultDateFormat.equals("")) {
            this.defaultDateFormatConfig = defaultDateFormat;
            this.configurationHasBeenSet();
        }
    }

    public void setRecentDateFormatConfig(String recentDateFormat) {
        if (recentDateFormat != null && !recentDateFormat.equals("")) {
            this.recentDateFormatConfig = recentDateFormat;
            this.configurationHasBeenSet();
        }
    }

    public void setServerLanguageCodeConfig(LanguageCode serverLanguageCode) {
        if (serverLanguageCode != null && !"".equals(serverLanguageCode.getValue())) {
            this.serverLanguageCodeConfig = serverLanguageCode;
            this.configurationHasBeenSet();
        }
    }

    public void setServerTimeZoneConfig(String serverTimeZoneId) {
        if (serverTimeZoneId != null && !serverTimeZoneId.equals("")) {
            this.serverTimeZoneConfig = serverTimeZoneId;
            this.configurationHasBeenSet();
        }
    }

    public void setShortMonthNamesConfig(String shortMonthNames) {
        if (shortMonthNames != null && !shortMonthNames.equals("")) {
            this.shortMonthNamesConfig = shortMonthNames;
            this.configurationHasBeenSet();
        }
    }

    public void setRetriesAllowed(String retriesAllowed) {
        if ("FOREVER".equalsIgnoreCase(retriesAllowed)) {
            this.retriesAllowed = -1;
        } else {
            try {
                int retries = Integer.parseInt(retriesAllowed);
                if (retries < -1) {
                    throw new BuildException("Invalid value for retriesAllowed attribute: " + retriesAllowed);
                }
                this.retriesAllowed = retries;
            }
            catch (NumberFormatException px) {
                throw new BuildException("Invalid value for retriesAllowed attribute: " + retriesAllowed);
            }
        }
    }

    public String getSystemTypeKey() {
        return this.systemTypeKey.getValue();
    }

    public String getDefaultDateFormatConfig() {
        return this.defaultDateFormatConfig;
    }

    public String getRecentDateFormatConfig() {
        return this.recentDateFormatConfig;
    }

    public String getServerLanguageCodeConfig() {
        return this.serverLanguageCodeConfig.getValue();
    }

    public String getServerTimeZoneConfig() {
        return this.serverTimeZoneConfig;
    }

    public String getShortMonthNamesConfig() {
        return this.shortMonthNamesConfig;
    }

    Granularity getTimestampGranularity() {
        return this.timestampGranularity;
    }

    public void setTimestampGranularity(Granularity timestampGranularity) {
        if (null == timestampGranularity || "".equals(timestampGranularity.getValue())) {
            return;
        }
        this.timestampGranularity = timestampGranularity;
    }

    public void setSiteCommand(String siteCommand) {
        this.siteCommand = siteCommand;
    }

    public void setInitialSiteCommand(String initialCommand) {
        this.initialSiteCommand = initialCommand;
    }

    public void setEnableRemoteVerification(boolean b) {
        this.enableRemoteVerification = b;
    }

    protected void checkAttributes() throws BuildException {
        if (this.server == null) {
            throw new BuildException("server attribute must be set!");
        }
        if (this.userid == null) {
            throw new BuildException("userid attribute must be set!");
        }
        if (this.password == null) {
            throw new BuildException("password attribute must be set!");
        }
        if (this.action == 3 && this.listing == null) {
            throw new BuildException("listing attribute must be set for list action!");
        }
        if (this.action == 4 && this.remotedir == null) {
            throw new BuildException("remotedir attribute must be set for mkdir action!");
        }
        if (this.action == 5 && this.chmod == null) {
            throw new BuildException("chmod attribute must be set for chmod action!");
        }
        if (this.action == 7 && this.siteCommand == null) {
            throw new BuildException("sitecommand attribute must be set for site action!");
        }
        if (this.isConfigurationSet) {
            try {
                Class.forName("org.apache.commons.net.ftp.FTPClientConfig");
            }
            catch (ClassNotFoundException e) {
                throw new BuildException("commons-net.jar >= 1.4.0 is required for at least one of the attributes specified.");
            }
        }
    }

    protected void executeRetryable(RetryHandler h, Retryable r, String descr) throws IOException {
        h.execute(r, descr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int transferFiles(final org.apache.commons.net.ftp.FTPClient ftp, FileSet fs) throws IOException, BuildException {
        DirectoryScanner ds;
        if (this.action == 0) {
            ds = fs.getDirectoryScanner(this.getProject());
        } else {
            ds = new FTPDirectoryScanner(ftp);
            fs.setupDirectoryScanner((FileScanner)ds, this.getProject());
            ds.setFollowSymlinks(fs.isFollowSymlinks());
            ds.scan();
        }
        String[] dsfiles = null;
        dsfiles = this.action == 6 ? ds.getIncludedDirectories() : ds.getIncludedFiles();
        String dir = null;
        if (ds.getBasedir() == null && (this.action == 0 || this.action == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.action == 0 || this.action == 1) {
            dir = ds.getBasedir().getAbsolutePath();
        }
        BufferedWriter bw = null;
        try {
            if (this.action == 3) {
                File pd = this.listing.getParentFile();
                if (!pd.exists()) {
                    pd.mkdirs();
                }
                bw = new BufferedWriter(new FileWriter(this.listing, this.listingAppend));
            }
            RetryHandler h = new RetryHandler(this.retriesAllowed, (Task)this);
            if (this.action == 6) {
                for (int i = dsfiles.length - 1; i >= 0; --i) {
                    final String dsfile = dsfiles[i];
                    this.executeRetryable(h, new Retryable(){

                        public void execute() throws IOException {
                            FTP.this.rmDir(ftp, dsfile);
                        }
                    }, dsfile);
                }
            } else {
                final BufferedWriter fbw = bw;
                final String fdir = dir;
                if (this.newerOnly) {
                    this.granularityMillis = this.timestampGranularity.getMilliseconds(this.action);
                }
                for (int i = 0; i < dsfiles.length; ++i) {
                    final String dsfile = dsfiles[i];
                    this.executeRetryable(h, new Retryable(){

                        public void execute() throws IOException {
                            switch (FTP.this.action) {
                                case 0: {
                                    FTP.this.sendFile(ftp, fdir, dsfile);
                                    break;
                                }
                                case 1: {
                                    FTP.this.getFile(ftp, fdir, dsfile);
                                    break;
                                }
                                case 2: {
                                    FTP.this.delFile(ftp, dsfile);
                                    break;
                                }
                                case 3: {
                                    FTP.this.listFile(ftp, fbw, dsfile);
                                    break;
                                }
                                case 5: {
                                    FTP.this.doSiteCommand(ftp, "chmod " + FTP.this.chmod + " " + FTP.this.resolveFile(dsfile));
                                    FTP.this.transferred++;
                                    break;
                                }
                                default: {
                                    throw new BuildException("unknown ftp action " + FTP.this.action);
                                }
                            }
                        }
                    }, dsfile);
                }
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(bw);
            throw throwable;
        }
        FileUtils.close((Writer)bw);
        return dsfiles.length;
    }

    protected void transferFiles(org.apache.commons.net.ftp.FTPClient ftp) throws IOException, BuildException {
        this.transferred = 0;
        this.skipped = 0;
        if (this.filesets.size() == 0) {
            throw new BuildException("at least one fileset must be specified.");
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            if (fs == null) continue;
            this.transferFiles(ftp, fs);
        }
        this.log(this.transferred + " " + ACTION_TARGET_STRS[this.action] + " " + COMPLETED_ACTION_STRS[this.action]);
        if (this.skipped != 0) {
            this.log(this.skipped + " " + ACTION_TARGET_STRS[this.action] + " were not successfully " + COMPLETED_ACTION_STRS[this.action]);
        }
    }

    protected String resolveFile(String file) {
        return file.replace(System.getProperty("file.separator").charAt(0), this.remoteFileSep.charAt(0));
    }

    protected void createParents(org.apache.commons.net.ftp.FTPClient ftp, String filename) throws IOException, BuildException {
        File checkDir;
        String dirname;
        File dir = new File(filename);
        if (this.dirCache.contains(dir)) {
            return;
        }
        Vector<File> parents = new Vector<File>();
        while ((dirname = dir.getParent()) != null && !this.dirCache.contains(checkDir = new File(dirname))) {
            dir = checkDir;
            parents.addElement(dir);
        }
        int i = parents.size() - 1;
        if (i >= 0) {
            String cwd = ftp.printWorkingDirectory();
            String parent = dir.getParent();
            if (parent != null && !ftp.changeWorkingDirectory(this.resolveFile(parent))) {
                throw new BuildException("could not change to directory: " + ftp.getReplyString());
            }
            while (i >= 0) {
                if (!ftp.changeWorkingDirectory((dir = (File)parents.elementAt(i--)).getName())) {
                    this.log("creating remote directory " + this.resolveFile(dir.getPath()), 3);
                    if (!ftp.makeDirectory(dir.getName())) {
                        this.handleMkDirFailure(ftp);
                    }
                    if (!ftp.changeWorkingDirectory(dir.getName())) {
                        throw new BuildException("could not change to directory: " + ftp.getReplyString());
                    }
                }
                this.dirCache.add(dir);
            }
            ftp.changeWorkingDirectory(cwd);
        }
    }

    private long getTimeDiff(org.apache.commons.net.ftp.FTPClient ftp) {
        long returnValue = 0L;
        File tempFile = this.findFileName(ftp);
        try {
            FILE_UTILS.createNewFile(tempFile);
            long localTimeStamp = tempFile.lastModified();
            BufferedInputStream instream = new BufferedInputStream(new FileInputStream(tempFile));
            ftp.storeFile(tempFile.getName(), (InputStream)instream);
            instream.close();
            boolean success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
            if (success) {
                FTPFile[] ftpFiles = ftp.listFiles(tempFile.getName());
                if (ftpFiles.length == 1) {
                    long remoteTimeStamp = ftpFiles[0].getTimestamp().getTime().getTime();
                    returnValue = localTimeStamp - remoteTimeStamp;
                }
                ftp.deleteFile(ftpFiles[0].getName());
            }
            Delete mydelete = new Delete();
            mydelete.bindToOwner((Task)this);
            mydelete.setFile(tempFile.getCanonicalFile());
            mydelete.execute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        return returnValue;
    }

    private File findFileName(org.apache.commons.net.ftp.FTPClient ftp) {
        FTPFile[] theFiles = null;
        int maxIterations = 1000;
        for (int counter = 1; counter < 1000; ++counter) {
            File localFile = FILE_UTILS.createTempFile("ant" + Integer.toString(counter), ".tmp", null, false, false);
            String fileName = localFile.getName();
            boolean found = false;
            try {
                if (theFiles == null) {
                    theFiles = ftp.listFiles();
                }
                for (int counter2 = 0; counter2 < theFiles.length; ++counter2) {
                    if (theFiles[counter2] == null || !theFiles[counter2].getName().equals(fileName)) continue;
                    found = true;
                    break;
                }
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, this.getLocation());
            }
            if (found) continue;
            localFile.deleteOnExit();
            return localFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpToDate(org.apache.commons.net.ftp.FTPClient ftp, File localFile, String remoteFile) throws IOException, BuildException {
        StringBuffer msg;
        this.log("checking date for " + remoteFile, 3);
        FTPFile[] files = ftp.listFiles(remoteFile);
        if (files == null || files.length == 0) {
            if (this.action == 0) {
                this.log("Could not date test remote file: " + remoteFile + "assuming out of date.", 3);
                return false;
            }
            throw new BuildException("could not date test remote file: " + ftp.getReplyString());
        }
        long remoteTimestamp = files[0].getTimestamp().getTime().getTime();
        long localTimestamp = localFile.lastModified();
        long adjustedRemoteTimestamp = remoteTimestamp + this.timeDiffMillis + this.granularityMillis;
        SimpleDateFormat simpleDateFormat = TIMESTAMP_LOGGING_SDF;
        synchronized (simpleDateFormat) {
            msg = new StringBuffer("   [").append(TIMESTAMP_LOGGING_SDF.format(new Date(localTimestamp))).append("] local");
        }
        this.log(msg.toString(), 3);
        simpleDateFormat = TIMESTAMP_LOGGING_SDF;
        synchronized (simpleDateFormat) {
            msg = new StringBuffer("   [").append(TIMESTAMP_LOGGING_SDF.format(new Date(adjustedRemoteTimestamp))).append("] remote");
        }
        if (remoteTimestamp != adjustedRemoteTimestamp) {
            simpleDateFormat = TIMESTAMP_LOGGING_SDF;
            synchronized (simpleDateFormat) {
                msg.append(" - (raw: ").append(TIMESTAMP_LOGGING_SDF.format(new Date(remoteTimestamp))).append(")");
            }
        }
        this.log(msg.toString(), 3);
        if (this.action == 0) {
            return adjustedRemoteTimestamp >= localTimestamp;
        }
        return localTimestamp >= adjustedRemoteTimestamp;
    }

    protected void doSiteCommand(org.apache.commons.net.ftp.FTPClient ftp, String theCMD) throws IOException, BuildException {
        String[] myReply = null;
        this.log("Doing Site Command: " + theCMD, 3);
        boolean rc = ftp.sendSiteCommand(theCMD);
        if (!rc) {
            this.log("Failed to issue Site Command: " + theCMD, 1);
        } else {
            myReply = ftp.getReplyStrings();
            for (int x = 0; x < myReply.length; ++x) {
                if (myReply[x].indexOf("200") != -1) continue;
                this.log(myReply[x], 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFile(org.apache.commons.net.ftp.FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        BufferedInputStream instream;
        block8: {
            File file;
            block7: {
                instream = null;
                try {
                    file = this.getProject().resolveFile(new File(dir, filename).getPath());
                    if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block7;
                }
                catch (Throwable throwable) {
                    FileUtils.close(instream);
                    throw throwable;
                }
                FileUtils.close(instream);
                return;
            }
            if (this.verbose) {
                this.log("transferring " + file.getAbsolutePath());
            }
            instream = new BufferedInputStream(new FileInputStream(file));
            this.createParents(ftp, filename);
            ftp.storeFile(this.resolveFile(filename), (InputStream)instream);
            boolean success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
            if (!success) {
                String s = "could not put file: " + ftp.getReplyString();
                if (this.skipFailedTransfers) {
                    this.log(s, 1);
                    ++this.skipped;
                    break block8;
                }
                throw new BuildException(s);
            }
            if (this.chmod != null) {
                this.doSiteCommand(ftp, "chmod " + this.chmod + " " + this.resolveFile(filename));
            }
            this.log("File " + file.getAbsolutePath() + " copied to " + this.server, 3);
            ++this.transferred;
        }
        FileUtils.close((InputStream)instream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void delFile(org.apache.commons.net.ftp.FTPClient ftp, String filename) throws IOException, BuildException {
        if (this.verbose) {
            this.log("deleting " + filename);
        }
        if (!ftp.deleteFile(this.resolveFile(filename))) {
            String s = "could not delete file: " + ftp.getReplyString();
            if (!this.skipFailedTransfers) throw new BuildException(s);
            this.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.log("File " + filename + " deleted from " + this.server, 3);
            ++this.transferred;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rmDir(org.apache.commons.net.ftp.FTPClient ftp, String dirname) throws IOException, BuildException {
        if (this.verbose) {
            this.log("removing " + dirname);
        }
        if (!ftp.removeDirectory(this.resolveFile(dirname))) {
            String s = "could not remove directory: " + ftp.getReplyString();
            if (!this.skipFailedTransfers) throw new BuildException(s);
            this.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.log("Directory " + dirname + " removed from " + this.server, 3);
            ++this.transferred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getFile(org.apache.commons.net.ftp.FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        BufferedOutputStream outstream;
        block9: {
            File pdir;
            File file;
            block8: {
                outstream = null;
                try {
                    file = this.getProject().resolveFile(new File(dir, filename).getPath());
                    if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block8;
                }
                catch (Throwable throwable) {
                    FileUtils.close(outstream);
                    throw throwable;
                }
                FileUtils.close(outstream);
                return;
            }
            if (this.verbose) {
                this.log("transferring " + filename + " to " + file.getAbsolutePath());
            }
            if (!(pdir = file.getParentFile()).exists()) {
                pdir.mkdirs();
            }
            outstream = new BufferedOutputStream(new FileOutputStream(file));
            ftp.retrieveFile(this.resolveFile(filename), (OutputStream)outstream);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                String s = "could not get file: " + ftp.getReplyString();
                if (this.skipFailedTransfers) {
                    this.log(s, 1);
                    ++this.skipped;
                    break block9;
                }
                throw new BuildException(s);
            }
            this.log("File " + file.getAbsolutePath() + " copied from " + this.server, 3);
            ++this.transferred;
            if (!this.preserveLastModified) break block9;
            ((OutputStream)outstream).close();
            outstream = null;
            FTPFile[] remote = ftp.listFiles(this.resolveFile(filename));
            if (remote.length > 0) {
                FILE_UTILS.setFileLastModified(file, remote[0].getTimestamp().getTime().getTime());
            }
        }
        FileUtils.close((OutputStream)outstream);
    }

    public static String listSingleFile(String server, String filePath, long fileSize) {
        return String.format("ftp://%s//%s|%s", server, filePath.replaceAll("/+", "/").replaceAll("^/", ""), fileSize).replace('\\', '/');
    }

    protected void listFile(org.apache.commons.net.ftp.FTPClient ftp, BufferedWriter bw, String filename) throws IOException, BuildException {
        FTPFile[] ftpfiles;
        if (this.verbose) {
            this.log("listing " + filename);
        }
        if ((ftpfiles = ftp.listFiles(this.resolveFile(filename))) != null && ftpfiles.length > 0) {
            String path = this.listingFullPath ? FTP.listSingleFile(this.server, this.remotedir + "/" + filename, ftpfiles[0].getSize()) : ftpfiles[0].toString();
            bw.write(path);
            bw.newLine();
            ++this.transferred;
        }
    }

    protected void makeRemoteDir(org.apache.commons.net.ftp.FTPClient ftp, String dir) throws IOException, BuildException {
        String workingDirectory = ftp.printWorkingDirectory();
        if (this.verbose) {
            if (dir.indexOf("/") == 0 || workingDirectory == null) {
                this.log("Creating directory: " + dir + " in /");
            } else {
                this.log("Creating directory: " + dir + " in " + workingDirectory);
            }
        }
        if (dir.indexOf("/") == 0) {
            ftp.changeWorkingDirectory("/");
        }
        String subdir = "";
        StringTokenizer st = new StringTokenizer(dir, "/");
        while (st.hasMoreTokens()) {
            subdir = st.nextToken();
            this.log("Checking " + subdir, 4);
            if (ftp.changeWorkingDirectory(subdir)) continue;
            if (!ftp.makeDirectory(subdir)) {
                int rc = ftp.getReplyCode();
                if (!this.ignoreNoncriticalErrors || rc != 550 && rc != 553 && rc != 521) {
                    throw new BuildException("could not create directory: " + ftp.getReplyString());
                }
                if (!this.verbose) continue;
                this.log("Directory already exists");
                continue;
            }
            if (this.verbose) {
                this.log("Directory created OK");
            }
            ftp.changeWorkingDirectory(subdir);
        }
        if (workingDirectory != null) {
            ftp.changeWorkingDirectory(workingDirectory);
        }
    }

    private void handleMkDirFailure(org.apache.commons.net.ftp.FTPClient ftp) throws BuildException {
        int rc = ftp.getReplyCode();
        if (!this.ignoreNoncriticalErrors || rc != 550 && rc != 553 && rc != 521) {
            throw new BuildException("could not create directory: " + ftp.getReplyString());
        }
    }

    public void execute() throws BuildException {
        this.checkAttributes();
        FTPClient ftp = null;
        try {
            FTPClient lftp;
            RetryHandler h;
            this.log("Opening FTP connection to " + this.server, 3);
            ftp = this.verbose ? new FTPClient(this.getProject()) : new org.apache.commons.net.ftp.FTPClient();
            ftp.setDataTimeout(300000);
            if (this.isConfigurationSet) {
                ftp = FTPConfigurator.configure(ftp, this);
            }
            ftp.setRemoteVerificationEnabled(this.enableRemoteVerification);
            ftp.connect(this.server, this.port);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                throw new BuildException("FTP connection failed: " + ftp.getReplyString());
            }
            this.log("connected", 3);
            this.log("logging in to FTP server", 3);
            if (this.account != null && !ftp.login(this.userid, this.password, this.account) || this.account == null && !ftp.login(this.userid, this.password)) {
                throw new BuildException("Could not login to FTP server");
            }
            this.log("login succeeded", 3);
            if (this.binary) {
                ftp.setFileType(2);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("could not set transfer type: " + ftp.getReplyString());
                }
            } else {
                ftp.setFileType(0);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("could not set transfer type: " + ftp.getReplyString());
                }
            }
            if (this.passive) {
                this.log("entering passive mode", 3);
                ftp.enterLocalPassiveMode();
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("could not enter into passive mode: " + ftp.getReplyString());
                }
            }
            if (this.initialSiteCommand != null) {
                h = new RetryHandler(this.retriesAllowed, (Task)this);
                lftp = ftp;
                this.executeRetryable(h, new Retryable(){

                    public void execute() throws IOException {
                        FTP.this.doSiteCommand(lftp, FTP.this.initialSiteCommand);
                    }
                }, "initial site command: " + this.initialSiteCommand);
            }
            if (this.umask != null) {
                h = new RetryHandler(this.retriesAllowed, (Task)this);
                lftp = ftp;
                this.executeRetryable(h, new Retryable(){

                    public void execute() throws IOException {
                        FTP.this.doSiteCommand(lftp, "umask " + FTP.this.umask);
                    }
                }, "umask " + this.umask);
            }
            if (this.action == 4) {
                h = new RetryHandler(this.retriesAllowed, (Task)this);
                lftp = ftp;
                this.executeRetryable(h, new Retryable(){

                    public void execute() throws IOException {
                        FTP.this.makeRemoteDir(lftp, FTP.this.remotedir);
                    }
                }, this.remotedir);
            } else if (this.action == 7) {
                h = new RetryHandler(this.retriesAllowed, (Task)this);
                lftp = ftp;
                this.executeRetryable(h, new Retryable(){

                    public void execute() throws IOException {
                        FTP.this.doSiteCommand(lftp, FTP.this.siteCommand);
                    }
                }, "Site Command: " + this.siteCommand);
            } else {
                if (this.remotedir != null) {
                    this.log("changing the remote directory to " + this.remotedir, 3);
                    ftp.changeWorkingDirectory(this.remotedir);
                    if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                        throw new BuildException("could not change remote directory: " + ftp.getReplyString());
                    }
                }
                if (this.newerOnly && this.timeDiffAuto) {
                    this.timeDiffMillis = this.getTimeDiff(ftp);
                }
                this.log(ACTION_STRS[this.action] + " " + ACTION_TARGET_STRS[this.action]);
                this.transferFiles(ftp);
            }
        }
        catch (IOException ex) {
            throw new BuildException("error during FTP transfer: " + ex, (Throwable)ex);
        }
        finally {
            if (ftp != null && ftp.isConnected()) {
                try {
                    this.log("disconnecting", 3);
                    ftp.logout();
                    ftp.disconnect();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static class LanguageCode
    extends EnumeratedAttribute {
        private static final String[] VALID_LANGUAGE_CODES = LanguageCode.getValidLanguageCodes();

        private static String[] getValidLanguageCodes() {
            Collection c = FTPClientConfig.getSupportedLanguageCodes();
            String[] ret = new String[c.size() + 1];
            int i = 0;
            ret[i++] = "";
            Iterator it = c.iterator();
            while (it.hasNext()) {
                ret[i] = (String)it.next();
                ++i;
            }
            return ret;
        }

        public String[] getValues() {
            return VALID_LANGUAGE_CODES;
        }

        static final LanguageCode getDefault() {
            LanguageCode lc = new LanguageCode();
            lc.setValue("");
            return lc;
        }
    }

    public static class FTPSystemType
    extends EnumeratedAttribute {
        private static final String[] VALID_SYSTEM_TYPES = new String[]{"", "UNIX", "VMS", "WINDOWS", "OS/2", "OS/400", "MVS"};

        public String[] getValues() {
            return VALID_SYSTEM_TYPES;
        }

        static final FTPSystemType getDefault() {
            FTPSystemType ftpst = new FTPSystemType();
            ftpst.setValue("");
            return ftpst;
        }
    }

    public static class Granularity
    extends EnumeratedAttribute {
        private static final String[] VALID_GRANULARITIES = new String[]{"", "MINUTE", "NONE"};

        public String[] getValues() {
            return VALID_GRANULARITIES;
        }

        public long getMilliseconds(int action) {
            String granularityU = this.getValue().toUpperCase(Locale.ENGLISH);
            if ("".equals(granularityU) ? action == 0 : "MINUTE".equals(granularityU)) {
                return 60000L;
            }
            return 0L;
        }

        static final Granularity getDefault() {
            Granularity g = new Granularity();
            g.setValue("");
            return g;
        }
    }

    public static class Action
    extends EnumeratedAttribute {
        private static final String[] VALID_ACTIONS = new String[]{"send", "put", "recv", "get", "del", "delete", "list", "mkdir", "chmod", "rmdir", "site"};

        public String[] getValues() {
            return VALID_ACTIONS;
        }

        public int getAction() {
            String actionL = this.getValue().toLowerCase(Locale.ENGLISH);
            if (actionL.equals("send") || actionL.equals("put")) {
                return 0;
            }
            if (actionL.equals("recv") || actionL.equals("get")) {
                return 1;
            }
            if (actionL.equals("del") || actionL.equals("delete")) {
                return 2;
            }
            if (actionL.equals("list")) {
                return 3;
            }
            if (actionL.equals("chmod")) {
                return 5;
            }
            if (actionL.equals("mkdir")) {
                return 4;
            }
            if (actionL.equals("rmdir")) {
                return 6;
            }
            if (actionL.equals("site")) {
                return 7;
            }
            return 0;
        }
    }

    protected class FTPDirectoryScanner
    extends DirectoryScanner {
        protected org.apache.commons.net.ftp.FTPClient ftp = null;
        private String rootPath = null;
        private boolean remoteSystemCaseSensitive = false;
        private boolean remoteSensitivityChecked = false;
        private Map fileListMap = new HashMap();
        private Map scannedDirs = new HashMap();

        public FTPDirectoryScanner(org.apache.commons.net.ftp.FTPClient ftp) {
            this.ftp = ftp;
            this.setFollowSymlinks(false);
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new VectorSet();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new VectorSet();
            this.dirsIncluded = new VectorSet();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new VectorSet();
            try {
                String cwd = this.ftp.printWorkingDirectory();
                this.forceRemoteSensitivityCheck();
                this.checkIncludePatterns();
                this.clearCaches();
                this.ftp.changeWorkingDirectory(cwd);
            }
            catch (IOException e) {
                throw new BuildException("Unable to scan FTP server: ", (Throwable)e);
            }
        }

        private void checkIncludePatterns() {
            Hashtable<String, String> newroots = new Hashtable<String, String>();
            for (int icounter = 0; icounter < this.includes.length; ++icounter) {
                String newpattern = SelectorUtils.rtrimWildcardTokens((String)this.includes[icounter]);
                newroots.put(newpattern, this.includes[icounter]);
            }
            if (FTP.this.remotedir == null) {
                try {
                    FTP.this.remotedir = this.ftp.printWorkingDirectory();
                }
                catch (IOException e) {
                    throw new BuildException("could not read current ftp directory", FTP.this.getLocation());
                }
            }
            AntFTPRootFile baseFTPFile = new AntFTPRootFile(this.ftp, FTP.this.remotedir);
            this.rootPath = ((AntFTPFile)baseFTPFile).getAbsolutePath();
            if (newroots.containsKey("")) {
                this.scandir(this.rootPath, "", true);
            } else {
                Enumeration enum2 = newroots.keys();
                while (enum2.hasMoreElements()) {
                    String currentelement = (String)enum2.nextElement();
                    String originalpattern = (String)newroots.get(currentelement);
                    AntFTPFile myfile = new AntFTPFile(baseFTPFile, currentelement);
                    boolean isOK = true;
                    boolean traversesSymlinks = false;
                    String path = null;
                    if (myfile.exists()) {
                        this.forceRemoteSensitivityCheck();
                        if (this.remoteSensitivityChecked && this.remoteSystemCaseSensitive && this.isFollowSymlinks()) {
                            path = myfile.getFastRelativePath();
                        } else {
                            try {
                                path = myfile.getRelativePath();
                                traversesSymlinks = myfile.isTraverseSymlinks();
                            }
                            catch (IOException be) {
                                throw new BuildException((Throwable)be, FTP.this.getLocation());
                            }
                            catch (BuildException be) {
                                isOK = false;
                            }
                        }
                    } else {
                        isOK = false;
                    }
                    if (!isOK) continue;
                    currentelement = path.replace(FTP.this.remoteFileSep.charAt(0), File.separatorChar);
                    if (!this.isFollowSymlinks() && traversesSymlinks) continue;
                    if (myfile.isDirectory()) {
                        if (this.isIncluded(currentelement) && currentelement.length() > 0) {
                            this.accountForIncludedDir(currentelement, myfile, true);
                            continue;
                        }
                        if (currentelement.length() > 0 && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                            currentelement = currentelement + File.separatorChar;
                        }
                        this.scandir(myfile.getAbsolutePath(), currentelement, true);
                        continue;
                    }
                    if (this.isCaseSensitive && originalpattern.equals(currentelement)) {
                        this.accountForIncludedFile(currentelement);
                        continue;
                    }
                    if (this.isCaseSensitive || !originalpattern.equalsIgnoreCase(currentelement)) continue;
                    this.accountForIncludedFile(currentelement);
                }
            }
        }

        protected void scandir(String dir, String vpath, boolean fast) {
            if (fast && this.hasBeenScanned(vpath)) {
                return;
            }
            try {
                if (!this.ftp.changeWorkingDirectory(dir)) {
                    return;
                }
                String completePath = null;
                completePath = !vpath.equals("") ? this.rootPath + FTP.this.remoteFileSep + vpath.replace(File.separatorChar, FTP.this.remoteFileSep.charAt(0)) : this.rootPath;
                FTPFile[] newfiles = this.listFiles(completePath, false);
                if (newfiles == null) {
                    this.ftp.changeToParentDirectory();
                    return;
                }
                for (int i = 0; i < newfiles.length; ++i) {
                    FTPFile file = newfiles[i];
                    if (file == null || file.getName().equals(".") || file.getName().equals("..")) continue;
                    String name = vpath + file.getName();
                    this.scannedDirs.put(name, new FTPFileProxy(file));
                    if (FTP.this.isFunctioningAsDirectory(this.ftp, dir, file)) {
                        boolean slowScanAllowed = true;
                        if (!this.isFollowSymlinks() && file.isSymbolicLink()) {
                            this.dirsExcluded.addElement(name);
                            slowScanAllowed = false;
                        } else if (this.isIncluded(name)) {
                            this.accountForIncludedDir(name, new AntFTPFile(this.ftp, file, completePath), fast);
                        } else {
                            this.dirsNotIncluded.addElement(name);
                            if (fast && this.couldHoldIncluded(name)) {
                                this.scandir(file.getName(), name + File.separator, fast);
                            }
                        }
                        if (fast || !slowScanAllowed) continue;
                        this.scandir(file.getName(), name + File.separator, fast);
                        continue;
                    }
                    if (!this.isFollowSymlinks() && file.isSymbolicLink()) {
                        this.filesExcluded.addElement(name);
                        continue;
                    }
                    if (!FTP.this.isFunctioningAsFile(this.ftp, dir, file)) continue;
                    this.accountForIncludedFile(name);
                }
                this.ftp.changeToParentDirectory();
            }
            catch (IOException e) {
                throw new BuildException("Error while communicating with FTP server: ", (Throwable)e);
            }
        }

        private void accountForIncludedFile(String name) {
            if (!this.filesIncluded.contains(name) && !this.filesExcluded.contains(name)) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name) && this.isSelected(name, (File)this.scannedDirs.get(name))) {
                        this.filesIncluded.addElement(name);
                    } else {
                        this.filesExcluded.addElement(name);
                    }
                } else {
                    this.filesNotIncluded.addElement(name);
                }
            }
        }

        private void accountForIncludedDir(String name, AntFTPFile file, boolean fast) {
            if (!this.dirsIncluded.contains(name) && !this.dirsExcluded.contains(name)) {
                if (!this.isExcluded(name)) {
                    if (fast) {
                        if (file.isSymbolicLink()) {
                            try {
                                file.getClient().changeWorkingDirectory(file.curpwd);
                            }
                            catch (IOException ioe) {
                                throw new BuildException("could not change directory to curpwd");
                            }
                            this.scandir(file.getLink(), name + File.separator, fast);
                        } else {
                            try {
                                file.getClient().changeWorkingDirectory(file.curpwd);
                            }
                            catch (IOException ioe) {
                                throw new BuildException("could not change directory to curpwd");
                            }
                            this.scandir(file.getName(), name + File.separator, fast);
                        }
                    }
                    this.dirsIncluded.addElement(name);
                } else {
                    this.dirsExcluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        try {
                            file.getClient().changeWorkingDirectory(file.curpwd);
                        }
                        catch (IOException ioe) {
                            throw new BuildException("could not change directory to curpwd");
                        }
                        this.scandir(file.getName(), name + File.separator, fast);
                    }
                }
            }
        }

        private boolean hasBeenScanned(String vpath) {
            return this.scannedDirs.containsKey(vpath);
        }

        private void clearCaches() {
            this.fileListMap.clear();
            this.scannedDirs.clear();
        }

        public FTPFile[] listFiles(String directory, boolean changedir) {
            String currentPath = directory;
            if (changedir) {
                try {
                    boolean result = this.ftp.changeWorkingDirectory(directory);
                    if (!result) {
                        return null;
                    }
                    currentPath = this.ftp.printWorkingDirectory();
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                }
            }
            if (this.fileListMap.containsKey(currentPath)) {
                FTP.this.getProject().log("filelist map used in listing files", 4);
                return (FTPFile[])this.fileListMap.get(currentPath);
            }
            FTPFile[] result = null;
            try {
                result = this.ftp.listFiles();
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, FTP.this.getLocation());
            }
            this.fileListMap.put(currentPath, result);
            if (!this.remoteSensitivityChecked) {
                this.checkRemoteSensitivity(result, directory);
            }
            return result;
        }

        private void forceRemoteSensitivityCheck() {
            if (!this.remoteSensitivityChecked) {
                try {
                    this.checkRemoteSensitivity(this.ftp.listFiles(), this.ftp.printWorkingDirectory());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                }
            }
        }

        public FTPFile[] listFiles(String directory) {
            return this.listFiles(directory, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkRemoteSensitivity(FTPFile[] array, String directory) {
            if (array == null) {
                return;
            }
            boolean candidateFound = false;
            String target = null;
            for (int icounter = 0; icounter < array.length; ++icounter) {
                if (array[icounter] == null || !array[icounter].isDirectory() || array[icounter].getName().equals(".") || array[icounter].getName().equals("..")) continue;
                candidateFound = true;
                target = this.fiddleName(array[icounter].getName());
                FTP.this.getProject().log("will try to cd to " + target + " where a directory called " + array[icounter].getName() + " exists", 4);
                for (int pcounter = 0; pcounter < array.length; ++pcounter) {
                    if (array[pcounter] == null || pcounter == icounter || !target.equals(array[pcounter].getName())) continue;
                    candidateFound = false;
                }
                if (candidateFound) break;
            }
            if (candidateFound) {
                try {
                    FTP.this.getProject().log("testing case sensitivity, attempting to cd to " + target, 4);
                    this.remoteSystemCaseSensitive = !this.ftp.changeWorkingDirectory(target);
                }
                catch (IOException ioe) {
                    this.remoteSystemCaseSensitive = true;
                }
                finally {
                    try {
                        this.ftp.changeWorkingDirectory(directory);
                    }
                    catch (IOException ioe) {
                        throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                    }
                }
                FTP.this.getProject().log("remote system is case sensitive : " + this.remoteSystemCaseSensitive, 3);
                this.remoteSensitivityChecked = true;
            }
        }

        private String fiddleName(String origin) {
            StringBuffer result = new StringBuffer();
            for (int icounter = 0; icounter < origin.length(); ++icounter) {
                if (Character.isLowerCase(origin.charAt(icounter))) {
                    result.append(Character.toUpperCase(origin.charAt(icounter)));
                    continue;
                }
                if (Character.isUpperCase(origin.charAt(icounter))) {
                    result.append(Character.toLowerCase(origin.charAt(icounter)));
                    continue;
                }
                result.append(origin.charAt(icounter));
            }
            return result.toString();
        }

        protected class AntFTPRootFile
        extends AntFTPFile {
            private String remotedir;

            public AntFTPRootFile(org.apache.commons.net.ftp.FTPClient aclient, String remotedir) {
                super(aclient, null, remotedir);
                this.remotedir = remotedir;
                try {
                    this.getClient().changeWorkingDirectory(this.remotedir);
                    this.setCurpwd(this.getClient().printWorkingDirectory());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                }
            }

            @Override
            public String getAbsolutePath() {
                return this.getCurpwd();
            }

            @Override
            public String getRelativePath() throws BuildException, IOException {
                return "";
            }
        }

        protected class AntFTPFile {
            private org.apache.commons.net.ftp.FTPClient client;
            private String curpwd;
            private FTPFile ftpFile;
            private AntFTPFile parent = null;
            private boolean relativePathCalculated = false;
            private boolean traversesSymlinks = false;
            private String relativePath = "";

            public AntFTPFile(org.apache.commons.net.ftp.FTPClient client, FTPFile ftpFile, String curpwd) {
                this.client = client;
                this.ftpFile = ftpFile;
                this.curpwd = curpwd;
            }

            public AntFTPFile(AntFTPFile parent, String path) {
                this.parent = parent;
                this.client = parent.client;
                Vector pathElements = SelectorUtils.tokenizePath((String)path);
                try {
                    boolean result = this.client.changeWorkingDirectory(parent.getAbsolutePath());
                    if (!result) {
                        return;
                    }
                    this.curpwd = parent.getAbsolutePath();
                }
                catch (IOException ioe) {
                    throw new BuildException("could not change working dir to " + parent.curpwd);
                }
                for (int fcount = 0; fcount < pathElements.size() - 1; ++fcount) {
                    String currentPathElement = (String)pathElements.elementAt(fcount);
                    try {
                        boolean result = this.client.changeWorkingDirectory(currentPathElement);
                        if (!result && !FTPDirectoryScanner.this.isCaseSensitive() && (FTPDirectoryScanner.this.remoteSystemCaseSensitive || !FTPDirectoryScanner.this.remoteSensitivityChecked) ? (currentPathElement = this.findPathElementCaseUnsensitive(this.curpwd, currentPathElement)) == null : !result) {
                            return;
                        }
                        this.curpwd = this.curpwd + FTP.this.remoteFileSep + currentPathElement;
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new BuildException("could not change working dir to " + (String)pathElements.elementAt(fcount) + " from " + this.curpwd);
                    }
                }
                String lastpathelement = (String)pathElements.elementAt(pathElements.size() - 1);
                FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(this.curpwd);
                this.ftpFile = this.getFile(theFiles, lastpathelement);
            }

            private String findPathElementCaseUnsensitive(String parentPath, String soughtPathElement) {
                FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(parentPath, false);
                if (theFiles == null) {
                    return null;
                }
                for (int icounter = 0; icounter < theFiles.length; ++icounter) {
                    if (theFiles[icounter] == null || !theFiles[icounter].getName().equalsIgnoreCase(soughtPathElement)) continue;
                    return theFiles[icounter].getName();
                }
                return null;
            }

            public boolean exists() {
                return this.ftpFile != null;
            }

            public String getLink() {
                return this.ftpFile.getLink();
            }

            public String getName() {
                return this.ftpFile.getName();
            }

            public String getAbsolutePath() {
                return this.curpwd + FTP.this.remoteFileSep + this.ftpFile.getName();
            }

            public String getFastRelativePath() {
                String absPath = this.getAbsolutePath();
                if (absPath.indexOf(FTPDirectoryScanner.this.rootPath + FTP.this.remoteFileSep) == 0) {
                    return absPath.substring(FTPDirectoryScanner.this.rootPath.length() + FTP.this.remoteFileSep.length());
                }
                return null;
            }

            public String getRelativePath() throws IOException, BuildException {
                if (!this.relativePathCalculated) {
                    if (this.parent != null) {
                        this.traversesSymlinks = this.parent.isTraverseSymlinks();
                        this.relativePath = this.getRelativePath(this.parent.getAbsolutePath(), this.parent.getRelativePath());
                    } else {
                        this.relativePath = this.getRelativePath(FTPDirectoryScanner.this.rootPath, "");
                        this.relativePathCalculated = true;
                    }
                }
                return this.relativePath;
            }

            private String getRelativePath(String currentPath, String currentRelativePath) {
                Vector pathElements = SelectorUtils.tokenizePath((String)this.getAbsolutePath(), (String)FTP.this.remoteFileSep);
                Vector pathElements2 = SelectorUtils.tokenizePath((String)currentPath, (String)FTP.this.remoteFileSep);
                String relPath = currentRelativePath;
                for (int pcount = pathElements2.size(); pcount < pathElements.size(); ++pcount) {
                    String currentElement = (String)pathElements.elementAt(pcount);
                    FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(currentPath);
                    FTPFile theFile = null;
                    if (theFiles != null) {
                        theFile = this.getFile(theFiles, currentElement);
                    }
                    if (!relPath.equals("")) {
                        relPath = relPath + FTP.this.remoteFileSep;
                    }
                    if (theFile == null) {
                        relPath = relPath + currentElement;
                        currentPath = currentPath + FTP.this.remoteFileSep + currentElement;
                        FTP.this.log("Hidden file " + relPath + " assumed to not be a symlink.", 3);
                        continue;
                    }
                    this.traversesSymlinks = this.traversesSymlinks || theFile.isSymbolicLink();
                    relPath = relPath + theFile.getName();
                    currentPath = currentPath + FTP.this.remoteFileSep + theFile.getName();
                }
                return relPath;
            }

            public FTPFile getFile(FTPFile[] theFiles, String lastpathelement) {
                if (theFiles == null) {
                    return null;
                }
                for (int fcount = 0; fcount < theFiles.length; ++fcount) {
                    if (theFiles[fcount] == null) continue;
                    if (theFiles[fcount].getName().equals(lastpathelement)) {
                        return theFiles[fcount];
                    }
                    if (FTPDirectoryScanner.this.isCaseSensitive() || !theFiles[fcount].getName().equalsIgnoreCase(lastpathelement)) continue;
                    return theFiles[fcount];
                }
                return null;
            }

            public boolean isDirectory() {
                return this.ftpFile.isDirectory();
            }

            public boolean isSymbolicLink() {
                return this.ftpFile.isSymbolicLink();
            }

            protected org.apache.commons.net.ftp.FTPClient getClient() {
                return this.client;
            }

            protected void setCurpwd(String curpwd) {
                this.curpwd = curpwd;
            }

            public String getCurpwd() {
                return this.curpwd;
            }

            public boolean isTraverseSymlinks() throws IOException, BuildException {
                if (!this.relativePathCalculated) {
                    this.getRelativePath();
                }
                return this.traversesSymlinks;
            }

            public String toString() {
                return "AntFtpFile: " + this.curpwd + "%" + this.ftpFile;
            }
        }
    }

    protected static class FTPFileProxy
    extends File {
        private final FTPFile file;
        private final String[] parts;
        private final String name;

        public FTPFileProxy(FTPFile file) {
            super(file.getName());
            this.name = file.getName();
            this.file = file;
            this.parts = FileUtils.getPathStack((String)this.name);
        }

        public FTPFileProxy(String completePath) {
            super(completePath);
            this.file = null;
            this.name = completePath;
            this.parts = FileUtils.getPathStack((String)completePath);
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String getAbsolutePath() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.parts.length > 0 ? this.parts[this.parts.length - 1] : this.name;
        }

        @Override
        public String getParent() {
            String result = "";
            for (int i = 0; i < this.parts.length - 1; ++i) {
                result = result + File.separatorChar + this.parts[i];
            }
            return result;
        }

        @Override
        public String getPath() {
            return this.name;
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return this.file == null;
        }

        @Override
        public boolean isFile() {
            return this.file != null;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public long lastModified() {
            if (this.file != null) {
                return this.file.getTimestamp().getTimeInMillis();
            }
            return 0L;
        }

        @Override
        public long length() {
            if (this.file != null) {
                return this.file.getSize();
            }
            return 0L;
        }
    }
}

