/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.progress;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.DialogProgressMonitor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingWorker;

public abstract class ProgressMonitorSwingWorker<T, V>
extends SwingWorker<T, V> {
    private final CountDownLatch unBlock = new CountDownLatch(1);
    private final DialogProgressMonitor dialogPM;
    private boolean blocking;
    private Window blockingWindow;

    protected ProgressMonitorSwingWorker(Component parentComponent, String title) {
        this.dialogPM = new DialogProgressMonitor(parentComponent, title, Dialog.ModalityType.MODELESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final T doInBackground() throws Exception {
        T value;
        try {
            value = this.doInBackground(this.dialogPM);
        }
        finally {
            this.dialogPM.done();
            if (this.blocking) {
                this.unBlock.await();
                this.unblock();
            }
        }
        return value;
    }

    protected abstract T doInBackground(ProgressMonitor var1) throws Exception;

    public final void executeWithBlocking() {
        this.blocking = true;
        this.dialogPM.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.execute();
        this.block();
        this.blocking = false;
    }

    private void block() {
        if (this.blockingWindow == null) {
            this.blockingWindow = ProgressMonitorSwingWorker.createBlockingWindow();
            this.unBlock.countDown();
            this.blockingWindow.setVisible(true);
        }
    }

    private void unblock() {
        if (this.blockingWindow != null) {
            this.blockingWindow.dispose();
            this.blockingWindow = null;
        }
    }

    private static Window createBlockingWindow() {
        Dialog window = new Dialog((Frame)null);
        window.setUndecorated(true);
        window.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        window.setBounds(0, 0, 0, 0);
        window.setFocusableWindowState(false);
        return window;
    }
}

