/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ExtensibleObject;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.support.DefaultViewport;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureChangeEvent;
import com.bc.ceres.swing.figure.FigureChangeListener;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.FigureSelection;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.InteractionDispatcher;
import com.bc.ceres.swing.figure.Interactor;
import com.bc.ceres.swing.figure.interactions.NullInteractor;
import com.bc.ceres.swing.figure.support.DefaultFigureCollection;
import com.bc.ceres.swing.figure.support.DefaultFigureFactory;
import com.bc.ceres.swing.figure.support.DefaultFigureSelection;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.bc.ceres.swing.figure.support.FigureDeleteEdit;
import com.bc.ceres.swing.figure.support.FigureInsertEdit;
import com.bc.ceres.swing.figure.support.FigureTransferable;
import com.bc.ceres.swing.figure.support.StyleDefaults;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionContext;
import com.bc.ceres.swing.selection.support.SelectionChangeSupport;
import com.bc.ceres.swing.undo.RestorableEdit;
import com.bc.ceres.swing.undo.UndoContext;
import com.bc.ceres.swing.undo.support.DefaultUndoContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import javax.swing.JComponent;

public class DefaultFigureEditor
extends ExtensibleObject
implements FigureEditor {
    private final UndoContext undoContext;
    private Rectangle selectionRectangle;
    private Interactor interactor;
    private final JComponent editorComponent;
    private FigureCollection figureCollection;
    private final FigureSelection figureSelection;
    private final SelectionChangeSupport selectionChangeSupport;
    private final Viewport viewport;
    private FigureFactory figureFactory;
    private FigureStyle defaultLineStyle;
    private FigureStyle defaultPolygonStyle;

    public DefaultFigureEditor(JComponent editorComponent) {
        this(editorComponent, (Viewport)new DefaultViewport(true), null, new DefaultFigureCollection(), new DefaultFigureFactory());
    }

    public DefaultFigureEditor(JComponent editorComponent, Viewport viewport, UndoContext undoContext, FigureCollection figureCollection, FigureFactory figureFactory) {
        Assert.notNull((Object)editorComponent, (String)"editorComponent");
        Assert.notNull((Object)viewport, (String)"viewport");
        Assert.notNull((Object)figureCollection, (String)"figureCollection");
        this.editorComponent = editorComponent;
        this.editorComponent.setFocusable(true);
        this.viewport = viewport;
        this.interactor = NullInteractor.INSTANCE;
        InteractionDispatcher interactionDispatcher = new InteractionDispatcher(this);
        interactionDispatcher.registerListeners(this.editorComponent);
        this.undoContext = undoContext != null ? undoContext : new DefaultUndoContext(this);
        this.figureCollection = figureCollection;
        this.figureSelection = new DefaultFigureSelection();
        this.figureSelection.addChangeListener(new FigureSelectionMulticaster());
        this.selectionChangeSupport = new SelectionChangeSupport(this);
        RepaintHandler repaintHandler = new RepaintHandler();
        this.figureCollection.addChangeListener(repaintHandler);
        this.figureSelection.addChangeListener(repaintHandler);
        this.figureFactory = figureFactory;
        this.defaultLineStyle = DefaultFigureStyle.createLineStyle(new Color(255, 255, 255, 200), new BasicStroke(1.5f));
        this.defaultPolygonStyle = DefaultFigureStyle.createPolygonStyle(new Color(0, 0, 255, 200), new Color(255, 255, 255, 200), new BasicStroke(1.0f));
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editorComponent;
    }

    @Override
    public void insertFigures(boolean performInsert, Figure ... figures) {
        this.undoContext.postEdit(new FigureInsertEdit(this, performInsert, figures));
    }

    @Override
    public void deleteFigures(boolean performDelete, Figure ... figures) {
        this.undoContext.postEdit(new FigureDeleteEdit(this, performDelete, figures));
    }

    @Override
    public void changeFigure(Figure figure, Object figureMemento, String presentationName) {
        this.undoContext.postEdit(new RestorableEdit(figure, figureMemento, presentationName));
    }

    @Override
    public SelectionContext getSelectionContext() {
        return this;
    }

    @Override
    public Rectangle getSelectionRectangle() {
        return this.selectionRectangle;
    }

    @Override
    public void setSelectionRectangle(Rectangle newRect) {
        Rectangle oldRect = this.selectionRectangle;
        if (newRect == oldRect) {
            return;
        }
        Rectangle2D repaintRect = null;
        if (oldRect == null) {
            this.selectionRectangle = newRect;
            repaintRect = newRect;
        } else if (newRect == null) {
            this.selectionRectangle = newRect;
            this.getEditorComponent().repaint(oldRect);
            repaintRect = oldRect;
        } else if (!oldRect.equals(newRect)) {
            this.selectionRectangle = newRect;
            repaintRect = oldRect.createUnion(newRect);
        }
        if (repaintRect != null) {
            this.getEditorComponent().repaint((int)(repaintRect.getX() - 2.0), (int)(repaintRect.getY() - 2.0), (int)(repaintRect.getWidth() + 4.0), (int)repaintRect.getHeight() + 4);
        }
    }

    @Override
    public FigureCollection getFigureCollection() {
        return this.figureCollection;
    }

    public void setFigureCollection(FigureCollection figureCollection) {
        if (this.figureCollection != figureCollection) {
            this.figureSelection.removeAllFigures();
            this.setSelectionRectangle(null);
            this.figureCollection = figureCollection;
        }
    }

    @Override
    public FigureSelection getFigureSelection() {
        return this.figureSelection;
    }

    @Override
    public FigureFactory getFigureFactory() {
        return this.figureFactory;
    }

    public void setFigureFactory(FigureFactory figureFactory) {
        this.figureFactory = figureFactory;
    }

    @Override
    public Selection getSelection() {
        return this.figureSelection;
    }

    @Override
    public void setSelection(Selection selection) {
    }

    @Override
    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionChangeSupport.addSelectionChangeListener(listener);
    }

    @Override
    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionChangeSupport.removeSelectionChangeListener(listener);
    }

    @Override
    public SelectionChangeListener[] getSelectionChangeListeners() {
        return this.selectionChangeSupport.getSelectionChangeListeners();
    }

    @Override
    public void insert(Transferable contents) throws IOException, UnsupportedFlavorException {
        Figure[] figures = (Figure[])contents.getTransferData(FigureTransferable.FIGURES_DATA_FLAVOR);
        if (figures != null && figures.length > 0) {
            this.insertFigures(true, figures);
        }
    }

    @Override
    public boolean canDeleteSelection() {
        return !this.getFigureSelection().isEmpty();
    }

    @Override
    public void deleteSelection() {
        Figure[] figures = this.getFigureSelection().getFigures();
        if (figures.length > 0) {
            this.deleteFigures(true, figures);
        }
    }

    @Override
    public boolean canInsert(Transferable contents) {
        return contents.isDataFlavorSupported(FigureTransferable.FIGURES_DATA_FLAVOR);
    }

    @Override
    public void selectAll() {
        this.figureSelection.removeAllFigures();
        this.figureSelection.addFigures(this.getFigureCollection().getFigures());
        this.figureSelection.setSelectionStage(this.figureSelection.getMaxSelectionStage());
    }

    @Override
    public boolean canSelectAll() {
        return this.getFigureCollection().getFigureCount() > 0;
    }

    @Override
    public Interactor getInteractor() {
        return this.interactor;
    }

    @Override
    public void setInteractor(Interactor interactor) {
        if (this.interactor != interactor) {
            if (interactor != null) {
                interactor.deactivate();
            }
            this.interactor = interactor;
            if (this.interactor != null) {
                this.interactor.activate();
            }
            this.getEditorComponent().setCursor(interactor.getCursor());
        }
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    @Override
    public FigureStyle getDefaultLineStyle() {
        return this.defaultLineStyle;
    }

    public void setDefaultLineStyle(FigureStyle defaultLineStyle) {
        Assert.notNull((Object)defaultLineStyle, (String)"defaultLineStyle");
        this.defaultLineStyle = defaultLineStyle;
    }

    @Override
    public FigureStyle getDefaultPolygonStyle() {
        return this.defaultPolygonStyle;
    }

    public void setDefaultPolygonStyle(FigureStyle defaultPolygonStyle) {
        Assert.notNull((Object)defaultPolygonStyle, (String)"defaultPolygonStyle");
        this.defaultPolygonStyle = defaultPolygonStyle;
    }

    public void draw(Rendering rendering) {
        this.drawFigureCollection(rendering);
        this.drawFigureSelection(rendering);
        this.drawSelectionRectangle(rendering);
    }

    public void drawFigureCollection(Rendering rendering) {
        this.getFigureCollection().draw(rendering);
    }

    public void drawFigureSelection(Rendering rendering) {
        this.getFigureSelection().draw(rendering);
    }

    public void drawSelectionRectangle(Rendering rendering) {
        if (this.getSelectionRectangle() != null) {
            Graphics2D graphics = rendering.getGraphics();
            graphics.setPaint(StyleDefaults.SELECTION_RECT_FILL_PAINT);
            graphics.fill(this.getSelectionRectangle());
            graphics.setPaint(StyleDefaults.SELECTION_RECT_STROKE_PAINT);
            graphics.draw(this.getSelectionRectangle());
        }
    }

    private class FigureSelectionMulticaster
    implements FigureChangeListener {
        private FigureSelectionMulticaster() {
        }

        @Override
        public void figureChanged(FigureChangeEvent event) {
            if (event.getType() == FigureChangeEvent.FIGURES_ADDED || event.getType() == FigureChangeEvent.FIGURES_REMOVED) {
                DefaultFigureEditor.this.selectionChangeSupport.fireSelectionChange(DefaultFigureEditor.this, DefaultFigureEditor.this.figureSelection);
            }
        }
    }

    private class RepaintHandler
    implements FigureChangeListener {
        private RepaintHandler() {
        }

        @Override
        public void figureChanged(FigureChangeEvent event) {
            DefaultFigureEditor.this.getEditorComponent().repaint();
        }
    }
}

