/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure;

import com.bc.ceres.core.Assert;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.swing.figure.AbstractFigure;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Handle;
import com.bc.ceres.swing.figure.ShapeFigure;
import com.bc.ceres.swing.figure.support.VertexHandle;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractShapeFigure
extends AbstractFigure
implements ShapeFigure {
    private static final double SELECTION_TOLERANCE = 12.0;
    private Figure.Rank rank;

    protected AbstractShapeFigure() {
    }

    protected AbstractShapeFigure(Figure.Rank rank, FigureStyle normalStyle, FigureStyle selectedStyle) {
        super(normalStyle, selectedStyle);
        Assert.notNull((Object)((Object)rank), (String)"rank");
        this.rank = rank;
        this.setSelectable(true);
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public Figure.Rank getRank() {
        return this.rank;
    }

    protected void setRank(Figure.Rank rank) {
        this.rank = rank;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getShape().getBounds2D();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Rendering rendering) {
        Shape shape = this.getShape();
        if (shape == null) {
            return;
        }
        Viewport vp = rendering.getViewport();
        Rectangle vbounds = vp.getViewBounds();
        Rectangle2D mbounds = vp.getViewToModelTransform().createTransformedShape(vbounds).getBounds2D();
        if (!this.getBounds().intersects(mbounds)) {
            return;
        }
        Graphics2D g = rendering.getGraphics();
        AffineTransform oldTransform = g.getTransform();
        try {
            g.transform(vp.getModelToViewTransform());
            this.drawShape(rendering);
        }
        finally {
            g.setTransform(oldTransform);
        }
    }

    protected void drawShape(Rendering rendering) {
        Paint selectedStrokePaint;
        Paint strokePaint;
        Paint fillPaint;
        Viewport vp = rendering.getViewport();
        Graphics2D g = rendering.getGraphics();
        Shape shape = this.getShape();
        if (this.rank == Figure.Rank.AREA && (fillPaint = this.getNormalStyle().getFillPaint()) != null) {
            g.setPaint(fillPaint);
            g.fill(shape);
        }
        if ((strokePaint = this.getNormalStyle().getStrokePaint()) != null) {
            Stroke normalStroke = this.getNormalStyle().getStroke(1.0 / vp.getZoomFactor());
            g.setPaint(strokePaint);
            g.setStroke(normalStroke);
            g.draw(shape);
        }
        if (this.isSelected() && (selectedStrokePaint = this.getSelectedStyle().getStrokePaint()) != null) {
            Stroke selectedStroke = this.getSelectedStyle().getStroke(1.0 / vp.getZoomFactor());
            g.setStroke(selectedStroke);
            g.setPaint(selectedStrokePaint);
            g.draw(shape);
        }
    }

    @Override
    public boolean isCloseTo(Point2D point, AffineTransform m2v) {
        if (this.getRank() == Figure.Rank.AREA) {
            return this.getShape().contains(point);
        }
        try {
            Point2D viewPoint = m2v.transform(point, null);
            double x = viewPoint.getX() - 6.0;
            double y = viewPoint.getY() - 6.0;
            double w = 12.0;
            double h = 12.0;
            Rectangle2D.Double aDouble = new Rectangle2D.Double(x, y, w, h);
            Rectangle2D rectangle2D = m2v.createInverse().createTransformedShape(aDouble).getBounds2D();
            return this.getShape().intersects(rectangle2D);
        }
        catch (NoninvertibleTransformException e) {
            return false;
        }
    }

    @Override
    public void scale(Point2D refPoint, double sx, double sy) {
        double x0 = refPoint.getX();
        double y0 = refPoint.getY();
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        Path2D.Double path = new Path2D.Double(pathIterator.getWindingRule());
        double[] seg = new double[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(seg);
            if (type == 0) {
                seg[0] = x0 + (seg[0] - x0) * sx;
                seg[1] = y0 + (seg[1] - y0) * sy;
                path.moveTo(seg[0], seg[1]);
            } else if (type == 1) {
                seg[0] = x0 + (seg[0] - x0) * sx;
                seg[1] = y0 + (seg[1] - y0) * sy;
                path.lineTo(seg[0], seg[1]);
            } else if (type == 2) {
                seg[0] = x0 + (seg[0] - x0) * sx;
                seg[1] = y0 + (seg[1] - y0) * sy;
                seg[2] = x0 + (seg[2] - x0) * sx;
                seg[3] = y0 + (seg[3] - y0) * sy;
                path.quadTo(seg[0], seg[1], seg[2], seg[3]);
            } else if (type == 3) {
                seg[0] = x0 + (seg[0] - x0) * sx;
                seg[1] = y0 + (seg[1] - y0) * sy;
                seg[2] = x0 + (seg[2] - x0) * sx;
                seg[3] = y0 + (seg[3] - y0) * sy;
                seg[4] = x0 + (seg[4] - x0) * sx;
                seg[5] = y0 + (seg[5] - y0) * sy;
                path.curveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
            } else if (type == 4) {
                path.closePath();
            }
            pathIterator.next();
        }
        this.setShape(path);
    }

    @Override
    public void move(double dx, double dy) {
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        Path2D.Double path = new Path2D.Double(pathIterator.getWindingRule());
        double[] seg = new double[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(seg);
            if (type == 0) {
                seg[0] = seg[0] + dx;
                seg[1] = seg[1] + dy;
                path.moveTo(seg[0], seg[1]);
            } else if (type == 1) {
                seg[0] = seg[0] + dx;
                seg[1] = seg[1] + dy;
                path.lineTo(seg[0], seg[1]);
            } else if (type == 2) {
                seg[0] = seg[0] + dx;
                seg[1] = seg[1] + dy;
                seg[2] = seg[2] + dx;
                seg[3] = seg[3] + dy;
                path.quadTo(seg[0], seg[1], seg[2], seg[3]);
            } else if (type == 3) {
                seg[0] = seg[0] + dx;
                seg[1] = seg[1] + dy;
                seg[2] = seg[2] + dx;
                seg[3] = seg[3] + dy;
                seg[4] = seg[4] + dx;
                seg[5] = seg[5] + dy;
                path.curveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
            } else if (type == 4) {
                path.closePath();
            }
            pathIterator.next();
        }
        this.setShape(path);
    }

    @Override
    public void rotate(Point2D point, double theta) {
        AffineTransform transform = new AffineTransform();
        transform.rotate(theta, point.getX(), point.getY());
        PathIterator pathIterator = this.getShape().getPathIterator(transform);
        Path2D.Double path = new Path2D.Double(pathIterator.getWindingRule());
        double[] seg = new double[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(seg);
            if (type == 0) {
                path.moveTo(seg[0], seg[1]);
            } else if (type == 1) {
                path.lineTo(seg[0], seg[1]);
            } else if (type == 2) {
                path.quadTo(seg[0], seg[1], seg[2], seg[3]);
            } else if (type == 3) {
                path.curveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
            } else if (type == 4) {
                path.closePath();
            }
            pathIterator.next();
        }
        this.setShape(path);
    }

    @Override
    public double[] getSegment(int index) {
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        int i = 0;
        while (!pathIterator.isDone()) {
            if (i == index) {
                double[] seg = new double[6];
                pathIterator.currentSegment(seg);
                return seg;
            }
            pathIterator.next();
            ++i;
        }
        return null;
    }

    @Override
    public void setSegment(int index, double[] newSeg) {
        Path2D.Double path = new Path2D.Double();
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        double[] changedSeg = new double[6];
        Arrays.fill(changedSeg, Double.NaN);
        double[] seg0 = new double[6];
        int i = 0;
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(seg0);
            double[] seg = seg0;
            if (i == index) {
                changedSeg = (double[])seg.clone();
                seg = newSeg;
            }
            if (type == 0) {
                path.moveTo(seg[0], seg[1]);
            } else if (type == 1) {
                if (seg[0] == changedSeg[0] && seg[1] == changedSeg[1]) {
                    path.lineTo(newSeg[0], newSeg[1]);
                } else {
                    path.lineTo(seg[0], seg[1]);
                }
            } else if (type == 2) {
                path.quadTo(seg[0], seg[1], seg[2], seg[3]);
            } else if (type == 3) {
                path.curveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
            } else if (type == 4) {
                path.closePath();
            }
            pathIterator.next();
            ++i;
        }
        this.setShape(path);
    }

    @Override
    public void addSegment(int index, double[] segment) {
        Path2D.Double path = new Path2D.Double();
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        double[] seg = new double[6];
        int i = 0;
        boolean moveToSeen = false;
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(seg);
            if (i == index) {
                if (i == 0) {
                    path.moveTo(segment[0], segment[1]);
                    moveToSeen = true;
                } else {
                    path.lineTo(segment[0], segment[1]);
                }
            }
            if (type == 0) {
                if (moveToSeen) {
                    path.lineTo(seg[0], seg[1]);
                } else {
                    path.moveTo(seg[0], seg[1]);
                }
                moveToSeen = true;
            } else if (type == 1) {
                path.lineTo(seg[0], seg[1]);
            } else if (type == 2) {
                path.quadTo(seg[0], seg[1], seg[2], seg[3]);
            } else if (type == 3) {
                path.curveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
            } else if (type == 4) {
                path.closePath();
            }
            pathIterator.next();
            ++i;
        }
        this.setShape(path);
    }

    @Override
    public void removeSegment(int index) {
        Path2D.Double path = new Path2D.Double();
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        double[] seg = new double[6];
        int i = 0;
        boolean moveToSeen = false;
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(seg);
            if (i != index) {
                if (type == 0) {
                    moveToSeen = true;
                    path.moveTo(seg[0], seg[1]);
                } else if (type == 1) {
                    if (moveToSeen) {
                        path.lineTo(seg[0], seg[1]);
                    } else {
                        path.moveTo(seg[0], seg[1]);
                    }
                } else if (type == 2) {
                    if (moveToSeen) {
                        path.quadTo(seg[0], seg[1], seg[2], seg[3]);
                    } else {
                        path.moveTo(seg[0], seg[1]);
                    }
                } else if (type == 3) {
                    if (moveToSeen) {
                        path.curveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
                    } else {
                        path.moveTo(seg[0], seg[1]);
                    }
                } else if (type == 4) {
                    path.closePath();
                }
            }
            pathIterator.next();
            ++i;
        }
        this.setShape(path);
    }

    @Override
    public Object createMemento() {
        return this.getShape();
    }

    @Override
    public void setMemento(Object memento) {
        this.setShape((Shape)memento);
    }

    @Override
    public int getMaxSelectionStage() {
        return 4;
    }

    @Override
    public Handle[] createHandles(int selectionStage) {
        if (selectionStage == 2) {
            return this.createVertexHandles();
        }
        if (selectionStage == 3) {
            return this.createScaleHandles(0.0);
        }
        if (selectionStage == 4) {
            Handle[] vertexHandles = this.createVertexHandles();
            Handle[] scaleHandles = this.createScaleHandles(8.0);
            ArrayList<Handle> handles = new ArrayList<Handle>(vertexHandles.length + scaleHandles.length);
            handles.addAll(Arrays.asList(vertexHandles));
            handles.addAll(Arrays.asList(scaleHandles));
            return handles.toArray(new Handle[handles.size()]);
        }
        return NO_HANDLES;
    }

    private Handle[] createVertexHandles() {
        FigureStyle handleStyle = this.getHandleStyle();
        FigureStyle selectedHandleStyle = this.getSelectedHandleStyle();
        ArrayList<VertexHandle> handleList = new ArrayList<VertexHandle>();
        PathIterator pathIterator = this.getShape().getPathIterator(null);
        double[] firstSeg = new double[6];
        Arrays.fill(firstSeg, Double.NaN);
        int segmentIndex = 0;
        while (!pathIterator.isDone()) {
            boolean isEqualToFirst;
            double[] seg = new double[6];
            int type = pathIterator.currentSegment(seg);
            boolean bl = isEqualToFirst = seg[0] == firstSeg[0] && seg[1] == firstSeg[1];
            if (type != 4 && !isEqualToFirst) {
                handleList.add(new VertexHandle(this, segmentIndex, handleStyle, selectedHandleStyle));
            }
            if (segmentIndex == 0) {
                firstSeg = seg;
            }
            pathIterator.next();
            ++segmentIndex;
        }
        return handleList.toArray(new Handle[handleList.size()]);
    }
}

