/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TreeCellExtender {
    public final JTree tree;
    private JWindow cellExtender;
    private int offset;
    private int row;
    private boolean active;
    private final MouseHandler mouseHandler;

    public static TreeCellExtender equip(JTree tree) {
        TreeCellExtender extender = new TreeCellExtender(tree);
        extender.setActive(true);
        return extender;
    }

    public TreeCellExtender(JTree tree) {
        this.tree = tree;
        this.unsetRow();
        this.mouseHandler = new MouseHandler();
        this.active = false;
    }

    public JTree getTree() {
        return this.tree;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean oldValue = this.active;
        if (oldValue) {
            this.tree.removeMouseListener(this.mouseHandler);
            this.tree.removeMouseMotionListener(this.mouseHandler);
            this.disposeCellExtender();
            this.unsetRow();
        }
        this.active = active;
        if (this.active) {
            this.tree.addMouseListener(this.mouseHandler);
            this.tree.addMouseMotionListener(this.mouseHandler);
            this.hideCellExtender();
            this.unsetRow();
        }
    }

    private void showOrHideCellExtender(Point point) {
        int wh;
        int ww;
        int wy;
        boolean cellExtenderVisible;
        int oldRow = this.row;
        this.row = this.tree.getRowForLocation(point.x, point.y);
        if (this.row == oldRow) {
            return;
        }
        this.hideCellExtender();
        if (this.row < 0) {
            return;
        }
        TreePath path = this.tree.getPathForRow(this.row);
        if (path == null) {
            return;
        }
        Rectangle rowRect = this.tree.getPathBounds(path);
        if (rowRect == null) {
            return;
        }
        Rectangle viewRect = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewRect() : this.tree.getBounds();
        int rx1 = rowRect.x;
        int ry1 = rowRect.y;
        int rx2 = rowRect.x + rowRect.width - 1;
        int ry2 = rowRect.y + rowRect.height - 1;
        int vy1 = viewRect.y;
        int vx2 = viewRect.x + viewRect.width - 1;
        int vy2 = viewRect.y + viewRect.height - 1;
        boolean bl = cellExtenderVisible = rx2 > vx2 && ry1 >= vy1 && ry2 <= vy2;
        if (!cellExtenderVisible) {
            return;
        }
        this.offset = vx2 - rx1;
        int wx = rx1 < vx2 ? vx2 : rx1;
        Rectangle windowRect = new Rectangle(wx, wy = rowRect.y - 1, ww = rx2 - wx + 2, wh = rowRect.height + 2);
        if (windowRect.isEmpty()) {
            return;
        }
        this.showCellExtender(windowRect);
    }

    private void showCellExtender(Rectangle windowRect) {
        Rectangle screenBounds = TreeCellExtender.convertToScreen(this.tree, windowRect);
        if (this.cellExtender == null) {
            this.cellExtender = new JWindow(SwingUtilities.getWindowAncestor(this.tree));
            this.cellExtender.getContentPane().add((Component)new CellExtenderPanel(), "Center");
        }
        this.cellExtender.setBounds(screenBounds);
        this.cellExtender.setVisible(true);
    }

    private void hideCellExtender() {
        if (this.cellExtender != null) {
            this.cellExtender.setVisible(false);
        }
    }

    private void disposeCellExtender() {
        if (this.cellExtender != null) {
            this.cellExtender.dispose();
            this.cellExtender = null;
        }
    }

    private void unsetRow() {
        this.row = -1;
    }

    private static Rectangle convertToScreen(Component c, Rectangle r) {
        Point p = new Point(r.getLocation());
        SwingUtilities.convertPointToScreen(p, c);
        return new Rectangle(p.x, p.y, r.width, r.height);
    }

    private static class CellExtenderBorder
    extends AbstractBorder {
        private CellExtenderBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 0, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 0;
            insets.bottom = 1;
            insets.right = 1;
            insets.top = 1;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x1, int y1, int width, int height) {
            int x2 = x1 + width - 1;
            int y2 = y1 + height - 1;
            Color color = g.getColor();
            g.setColor(Color.DARK_GRAY);
            g.drawLine(x1, y1, x2, y1);
            g.drawLine(x1, y2, x2, y2);
            g.drawLine(x2, y1, x2, y2);
            g.setColor(color);
        }
    }

    private class CellExtenderPanel
    extends JPanel {
        public CellExtenderPanel() {
            this.setBorder(new CellExtenderBorder());
            this.setBackground(TreeCellExtender.this.tree.getBackground());
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width <= 0 || height <= 0) {
                return;
            }
            TreePath path = TreeCellExtender.this.tree.getPathForRow(TreeCellExtender.this.row);
            if (path == null) {
                return;
            }
            Rectangle bounds = this.getBounds();
            Color color = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setColor(color);
            TreeCellRenderer renderer = TreeCellExtender.this.tree.getCellRenderer();
            Component rendererComponent = renderer.getTreeCellRendererComponent(TreeCellExtender.this.tree, path.getLastPathComponent(), TreeCellExtender.this.tree.isPathSelected(path), TreeCellExtender.this.tree.isExpanded(path), true, TreeCellExtender.this.row, false);
            rendererComponent.setSize(1024, height);
            Graphics g2 = g.create(0, 0, width, height);
            g2.translate(-TreeCellExtender.this.offset, 0);
            rendererComponent.paint(g2);
            g2.dispose();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private Point point;

        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point point = e.getPoint();
            if (!point.equals(this.point)) {
                this.point = point;
                TreeCellExtender.this.showOrHideCellExtender(this.point);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TreeCellExtender.this.hideCellExtender();
            TreeCellExtender.this.unsetRow();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getPoint().equals(this.point)) {
                TreeCellExtender.this.hideCellExtender();
                TreeCellExtender.this.unsetRow();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getPoint().equals(this.point)) {
                TreeCellExtender.this.disposeCellExtender();
                TreeCellExtender.this.unsetRow();
            }
        }
    }
}

