/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.util.Iterator;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.Reader;
import org.yaml.snakeyaml.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    protected final BaseConstructor constructor;
    protected Resolver resolver;
    private boolean attached = false;

    public Loader(BaseConstructor constructor) {
        this.constructor = constructor;
    }

    public Loader() {
        this(new Constructor());
    }

    public Object load(java.io.Reader io) {
        Composer composer = new Composer(new ParserImpl(new Reader(io)), this.resolver);
        this.constructor.setComposer(composer);
        return this.constructor.getSingleData();
    }

    public Iterable<Object> loadAll(java.io.Reader yaml) {
        Composer composer = new Composer(new ParserImpl(new Reader(yaml)), this.resolver);
        this.constructor.setComposer(composer);
        Iterator<Object> result = new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return Loader.this.constructor.checkData();
            }

            @Override
            public Object next() {
                return Loader.this.constructor.getData();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new YamlIterable(result);
    }

    public Node compose(java.io.Reader yaml) {
        Composer composer = new Composer(new ParserImpl(new Reader(yaml)), this.resolver);
        this.constructor.setComposer(composer);
        return composer.getSingleNode();
    }

    public Iterable<Node> composeAll(java.io.Reader yaml) {
        final Composer composer = new Composer(new ParserImpl(new Reader(yaml)), this.resolver);
        this.constructor.setComposer(composer);
        Iterator<Node> result = new Iterator<Node>(){

            @Override
            public boolean hasNext() {
                return composer.checkNode();
            }

            @Override
            public Node next() {
                return composer.getNode();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new NodeIterable(result);
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    void setAttached() {
        if (this.attached) {
            throw new YAMLException("Loader cannot be shared.");
        }
        this.attached = true;
    }

    public Iterable<Event> parse(java.io.Reader yaml) {
        final ParserImpl parser = new ParserImpl(new Reader(yaml));
        Iterator<Event> result = new Iterator<Event>(){

            @Override
            public boolean hasNext() {
                return parser.peekEvent() != null;
            }

            @Override
            public Event next() {
                return parser.getEvent();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new EventIterable(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventIterable
    implements Iterable<Event> {
        private Iterator<Event> iterator;

        public EventIterable(Iterator<Event> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<Event> iterator() {
            return this.iterator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class YamlIterable
    implements Iterable<Object> {
        private Iterator<Object> iterator;

        public YamlIterable(Iterator<Object> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.iterator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeIterable
    implements Iterable<Node> {
        private Iterator<Node> iterator;

        public NodeIterable(Iterator<Node> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<Node> iterator() {
            return this.iterator;
        }
    }
}

