/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.saliency;

import java.util.Arrays;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.AverageBoxFilter;
import org.openimaj.image.processing.convolution.FConvolution;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.image.saliency.SaliencyMapGenerator;

@Reference(type=ReferenceType.Inproceedings, author={"Luo, Yiwen", "Tang, Xiaoou"}, title="Photo and Video Quality Evaluation: Focusing on the Subject", year="2008", booktitle="Proceedings of the 10th European Conference on Computer Vision: Part III", pages={"386", "", "399"}, url="http://dx.doi.org/10.1007/978-3-540-88690-7_29", publisher="Springer-Verlag", series="ECCV '08", customData={"isbn", "978-3-540-88689-1", "location", "Marseille, France", "numpages", "14", "doi", "10.1007/978-3-540-88690-7_29", "acmid", "1478204", "address", "Berlin, Heidelberg"})
public class DepthOfFieldEstimator
implements SaliencyMapGenerator<FImage> {
    private static FConvolution DX_FILTER = new FConvolution((float[][])new float[][]{{1.0f, -1.0f}});
    private static FConvolution DY_FILTER = new FConvolution((float[][])new float[][]{{1.0f}, {-1.0f}});
    protected int maxKernelSize = 50;
    protected int kernelSizeStep = 1;
    protected int nbins = 41;
    protected int windowSize = 3;
    protected float[][] xHistograms;
    protected float[][] yHistograms;
    private FImage map;

    public DepthOfFieldEstimator(int maxKernelSize, int kernelSizeStep, int nbins, int windowSize) {
        this.maxKernelSize = maxKernelSize;
        this.kernelSizeStep = kernelSizeStep;
        this.nbins = nbins;
        this.windowSize = windowSize;
        this.xHistograms = new float[maxKernelSize / kernelSizeStep][nbins];
        this.yHistograms = new float[maxKernelSize / kernelSizeStep][nbins];
    }

    public DepthOfFieldEstimator() {
        this.xHistograms = new float[this.maxKernelSize / this.kernelSizeStep][this.nbins];
        this.yHistograms = new float[this.maxKernelSize / this.kernelSizeStep][this.nbins];
    }

    protected void clearHistograms() {
        for (float[] h : this.xHistograms) {
            Arrays.fill(h, 0.0f);
        }
        for (float[] h : this.yHistograms) {
            Arrays.fill(h, 0.0f);
        }
    }

    public void analyseImage(FImage image) {
        this.clearHistograms();
        for (int i = 0; i < this.maxKernelSize; i += this.kernelSizeStep) {
            FImage blurred = (FImage)image.process((SinglebandImageProcessor)new AverageBoxFilter(i + 1, i + 1));
            FImage dx = (FImage)blurred.process((SinglebandImageProcessor)DX_FILTER);
            FImage dy = (FImage)blurred.process((SinglebandImageProcessor)DY_FILTER);
            this.makeLogHistogram(this.xHistograms[i], dx);
            this.makeLogHistogram(this.yHistograms[i], dy);
        }
        FImage dx = (FImage)image.process((SinglebandImageProcessor)DX_FILTER);
        FImage dy = (FImage)image.process((SinglebandImageProcessor)DY_FILTER);
        this.map = new FImage(image.width, image.height);
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                if (x == 0 || y == 0 || x == image.width - 1 || y == image.height - 1) {
                    this.map.pixels[y][x] = this.maxKernelSize;
                    continue;
                }
                int bestModel = 0;
                double bestLL = this.calculatedLogLikelihood(x, y, dx, dy, 0);
                for (int i = 1; i < this.maxKernelSize; i += this.kernelSizeStep) {
                    double newLL = this.calculatedLogLikelihood(x, y, dx, dy, i);
                    if (!(newLL > bestLL)) continue;
                    bestLL = newLL;
                    bestModel = i;
                }
                this.map.pixels[y][x] = bestModel;
            }
        }
    }

    private double calculatedLogLikelihood(int x, int y, FImage dx, FImage dy, int level) {
        int border = this.windowSize / 2;
        double LL = 0.0;
        for (int j = y - border; j <= y + border; ++j) {
            for (int i = x - border; i <= x + border; ++i) {
                float vy;
                int by;
                float vx = (dx.pixels[j][i] + 1.0f) / 2.0f;
                int bx = (int)(vx * (float)this.nbins);
                if (bx >= this.nbins) {
                    --bx;
                }
                if ((by = (int)((vy = (dy.pixels[j][i] + 1.0f) / 2.0f) * (float)this.nbins)) >= this.nbins) {
                    --by;
                }
                LL += (double)(this.xHistograms[level][bx] + this.yHistograms[level][by]);
            }
        }
        return LL;
    }

    private void makeLogHistogram(float[] h, FImage im) {
        int sum = 0;
        for (int y = 0; y < im.height; ++y) {
            for (int x = 0; x < im.width; ++x) {
                float v = (im.pixels[y][x] + 1.0f) / 2.0f;
                int bin = (int)(v * (float)this.nbins);
                if (bin >= this.nbins) {
                    // empty if block
                }
                int n = --bin;
                h[n] = h[n] + 1.0f;
                ++sum;
            }
        }
        for (int i = 0; i < this.nbins; ++i) {
            if (h[i] == 0.0f) {
                h[i] = 1.0E-8f;
            }
            h[i] = (float)Math.log((double)h[i] / (double)sum);
        }
    }

    @Override
    public FImage getSaliencyMap() {
        return this.map;
    }
}

