/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.pixel;

import org.openimaj.image.MBFImage;
import org.openimaj.image.model.pixel.MBFPixelClassificationModel;
import org.openimaj.image.pixel.statistics.HistogramModel;

public class HistogramPixelModel
extends MBFPixelClassificationModel {
    private static final long serialVersionUID = 1L;
    public HistogramModel model;

    public HistogramPixelModel(int ... nbins) {
        super(nbins.length);
        this.model = new HistogramModel(nbins);
    }

    @Override
    protected float classifyPixel(Float[] pix) {
        int bin = 0;
        for (int i = 0; i < this.ndims; ++i) {
            int b = (int)(pix[i].floatValue() * (float)this.model.histogram.nbins[i]);
            if (b >= this.model.histogram.nbins[i]) {
                b = this.model.histogram.nbins[i] - 1;
            }
            int f = 1;
            for (int j = 0; j < i; ++j) {
                f *= this.model.histogram.nbins[j];
            }
            bin += f * b;
        }
        return (float)((double[])this.model.histogram.values)[bin];
    }

    public String toString() {
        return this.model.toString();
    }

    @Override
    public HistogramPixelModel clone() {
        HistogramPixelModel newmodel = new HistogramPixelModel(new int[0]);
        newmodel.model = this.model.clone();
        newmodel.ndims = this.ndims;
        return newmodel;
    }

    public void learnModel(MBFImage ... images) {
        this.model.estimateModel(images);
    }
}

